;; "¡Plotland!"
(ns plotland.core
  (:require [clojure.string :as s]
            [incanter
             [core :as incanter]
             [charts :as charts]]))

;; convenience functions for plotting
(defn vector-from-file
  [path]
  (let [s (slurp path)]
    (map #(Integer. (re-find #"\d+" %)) (s/split s #"\s"))))

;; TODO make n-column version
(defn split-2-column
  "useful for grouping columnar text into individual sequences"
  [seq]
  (let [ps (->> seq
                (partition 2)
                reverse)]
    [(map first ps)
     (map second ps)]))

;; Incanter plotting macro wrappers to facilitate composability
(defn xy-plot [x y]
  (charts/xy-plot x y))

(defn scatter-plot [x y]
  (charts/scatter-plot x y))

(defn plot-uniform
  "incanter plot front-end
  plots a sequence of numbers with the given plot function `fun`,
  while providing uniform x values [0..(count seq)]
  and assigning the values in `seq` to the y axis.
  sets the y-range of the plot to the min and max values of `seq`"
  [fun seq]
  (incanter/view
   (doto (fun (range 0 (count seq)) seq)
     (charts/set-y-range
      (apply min seq) (apply max seq)))))

(defn plot-variable
  "incanter plot front-end
  plots two sequences of numbers with the given plot function `fun`,
  where `xseq` provides values for the x-axis
  and `yseq` provides values for the y-axis.
  sets the range of the plot to the min and max values of the provided sequences."
  [fun xseq yseq]
  (incanter/view
   (doto (fun xseq yseq)
     (charts/set-x-range
      (apply min xseq) (apply max xseq))
     (charts/set-y-range
      (apply min yseq) (apply max yseq)))))

(defn plot-seq [seq] (plot-uniform xy-plot seq))
(defn scatter-seq [seq] (plot-uniform scatter-plot seq))
(defn plot-xy [xseq yseq] (plot-variable xy-plot xseq yseq))
