(ns dos-installer.shell-script
  (:require [clojure.java.io :as io]
            [dos-installer.utils.files :as utils.files]))

(def base-executable-sh "copy-executable.sh")

(def base-installer-sh "copy-installer.sh")

(defn copy-executable-content
  []
  (-> base-executable-sh
      io/resource
      slurp))

(defn copy-installer-content
  []
  (-> base-installer-sh
      io/resource
      slurp))

(defn build-copy-executable-sh
  [user-dir]
  (->> (copy-executable-content)
       (utils.files/paste! user-dir base-executable-sh)))

(defn build-copy-installer-sh
  [user-dir]
  (->> (copy-installer-content)
       (utils.files/paste! user-dir base-installer-sh)))
