(ns dos-installer.utils.deps
  (:require [clojure.string :as string]
            [clojure.edn :as edn]))

(defn edn
  []
  (edn/read-string (slurp "deps.edn")))

(defn executable
  [deps]
  (-> deps
      (get-in [:aliases :dos-installer :args])
      (select-keys [:application :executable])))

(defn installer
  [deps]
  (-> deps
      (get-in [:aliases :dos-installer :args])
      (select-keys [:application :installer])))

(defn jarfile
  [deps-exec]
  (get-in deps-exec [:executable :jarfile]))

(defn jarname
  [deps-exec]
  (second (string/split (jarfile deps-exec) #"/")))

(defn executable-name
  [deps-exec]
  (str (get-in deps-exec [:application :name]) ".exe"))

(defn app-name
  [deps]
  (get-in deps [:application :name]))

(defn installer-name
  [deps]
  (str (app-name deps) "-installer.exe"))

(defn app-version
  [deps]
  (get-in deps [:application :version]))

(defn app-publisher
  [deps]
  (get-in deps [:application :publisher]))

(defn app-id
  [app-name]
  (-> app-name hash str))

(defn clear-resources-dos?
  [deps]
  (get-in deps [:aliases :dos-installer :clear-resources-dos?]))
