(ns dos-installer.utils.files
  (:require [clojure.java.io :as io]))

(def resources-folder "/resources-dos")

(defn install-message
  []
  (println "DOS-INSTALLER will create a folder called resources-dos/"))

(defn delete-recursively
  [fname]
  (doseq [f (reverse (file-seq fname))]
    (io/delete-file f)))

(defn clean-resources-dos
  [user-dir]
  (let [resources-dos (io/file (str user-dir resources-folder))]
    (when (.exists resources-dos)
      (delete-recursively resources-dos)
      (io/make-parents resources-dos))))

(defn paste!
  [user-dir filename file-content]
  (let [filepath (str user-dir resources-folder "/" filename)]
    (io/make-parents (io/file filepath))
    (spit filepath file-content)))
