(ns lilac.core
  (:require [org.httpkit.server :as http]
            [taoensso.timbre :as tlog]
            [lilac.util :as util]))

(defn srv [name port file]
  {:name name :port port :app (util/app file)})

(defn run [srv]
  (http/run-server ((:app srv)) {:port (:port srv)})
  (tlog/info (format "service %s start at : %d" (:name srv) (:port srv))))

