(ns lotus.file
  (:require [clojure.xml :as x]
            [lotus.util :as u]))

(defn- trans-xml "translate xml to list" 
  [resource]
   (list 
     (name (:tag resource)) 
     (map #(trans-xml %) (:content resource)) 
     (:dump (:attrs resource))))


(defn load-xml "load resource tree from xml file"
  [file]
  (let [loaded (x/parse file)
        resource (trans-xml (first (:content loaded)))
        prefix (:prefix (:attrs loaded))]
    (u/parse resource prefix)))



