(ns peach.core
  (:require [org.httpkit.server :as http]
            [taoensso.timbre :as log]
            [peach.util :as pu]))

(defn srv [name port file]
  {:name name :port port :app (pu/app file)})

(defn run [srv]
  (http/run-server ((:app srv)) {:port (:port srv)})
  (log/info (format "%s service start at : %d" (:name srv) (:port srv))))



