(ns peach.util
  (:require [clojure.string :refer [split]])
  (:import java.net.URI)
  (:import (redis.clients.jedis Jedis JedisPool JedisPoolConfig)))

(defn uri_ [url]
  (URI. url))

(defn host [uri]
  (.getHost uri))

(defn port [uri]
  (.getPort uri))

(defn addr [uri]
  (list (host uri) (port uri)))
(defn auth [uri]
  (when-let [a# (.getUserInfo uri)]
    (split a# #":")))

(defn user [uri]
  (when-let [u# (.getUserInfo uri)]
     (first (split u# #":"))))

(defn pass [uri]
  (when-let [u# (.getUserInfo uri)]  
    (last (split u# #":"))))

(defn conf 
  ([] (conf 5000))
  ([tout] (list (JedisPoolConfig.) tout)))

(defn pool [conf host port tout pass]
  (JedisPool. conf host port tout pass))

(defn exec [p f]
   (f (.getResource p)))
    
