(ns peony.conv
  (:import [clojure.lang IPersistentMap Keyword]
           [java.util List Map Set]
           [com.mongodb DBObject BasicDBObject BasicDBList]
            org.bson.types.ObjectId))

(defn oid []
  (ObjectId.))

(defprotocol Clojure->ObjectId (^ObjectId c2o [o]))
(extend-protocol Clojure->ObjectId
  nil (c2o [o] (ObjectId.))
  String (c2o [o] (ObjectId. o)))



(defprotocol ObjectId->Clojure (o2c [o]))
(extend-protocol ObjectId->Clojure
  ObjectId (o2c [o] (.toString o)))


(defprotocol Clojure->Mongo (^DBObject c2m [o]))
(extend-protocol Clojure->Mongo
  IPersistentMap
          (c2m [o] 
            (let [d (BasicDBObject.)]
              (doseq [[k v] o] (.put d (c2m k) (c2m v)))
               d))
  Keyword (c2m [^Keyword o] (.getName o))
  List    (c2m [^List    o] (map c2m o))
  Set     (c2m [^Set     o] (map c2m o))
  String  (c2m [^String  o] o)
  Object  (c2m [o] o)
  nil     (c2m [o] o))


(defprotocol Mongo->Clojure (m2c [o]))
(extend-protocol Mongo->Clojure
    nil    (m2c [o] o)
    Object (m2c [o] o)
    List   (m2c [^List o] (vec (map m2c o)))
  
    ObjectId (m2c [^ObjectId o] (.toString o))

    BasicDBList
    (m2c [^BasicDBList o] (vec (map m2c o)))

    DBObject
    (m2c [^DBObject o]
      (reduce 
        (fn [m k] (assoc m (keyword k) (m2c (.get o k)))) {} (.keySet o)))) 
