(ns poppy.core
  (:require [org.httpkit.client :as http]
            [clojure.data.json  :as json]
            [clojure.string     :as cstr]))

(def HOST "http://api.wangxiaoyu.net:7474/db/data")
(def USER "neo4j")
(def PASS "770804wxy")

(defn connect [host auth]
  (let [resp# @(http/get host {:basic-auth auth})
        body# (json/read-str (:body resp#) :key-fn keyword)
        cyph# (:cypher body#)]
    {:auth auth :cyph cyph#}))

(defn cypher [con qry prm]
  (let [body# (json/write-str {:query qry :params prm})
        host# (:cyph con)
        opti# {:body body# :basic-auth (:auth con)} 
        resp# @(http/post host# opti#)]
    (json/read-str (:body resp#) :key-fn keyword)))

(defn query [qry prm]
  (let [con# (connect HOST [USER PASS])
        res# (cypher con# qry prm)]
    res#))

(defn make-props [node]
  (str "{" (cstr/join "," (map #(format "%s:{%s}" % %) (map #(name %) (keys node)))) "}"))

(defn make-labels [labels]
  (cstr/join " " (map #(str ":" %) labels)))

(defn make-result [query]
  (let [res# (first (first (:data query)))]
    (merge (:metadata res#) (:data res#))))

(defn make-result-vector [query]
  (let [res# (:data query)]
    (map #(merge (:metadata (first %)) (:data (first %))) res#)))

(defn create-node [node labels]
  (make-result (query (format "CREATE (n%s {props}) RETURN n" (make-labels labels)) {:props node})))

(defn merge-node [node labels]
  (make-result (query (format "MERGE (n%s %s) RETURN n" (make-labels labels) (make-props node)) node)))

(defn query-node [node labels]
  (make-result-vector (query (format "MATCH (n%s %s) RETURN n" (make-labels labels) (make-props node)) node)))

(defn match-node [id labels]
  (make-result-vector (query (format "MATCH (n%s) WHERE id(n)=%d RETURN n" (make-labels labels) id) {})))




(defn count-node [node labels]
  (count (query-node node labels)))

(defn exist-node? [node labels]
  (not (= 0 (count-node node labels))))

(defn modify-node [node labels]
  ())

(defn delete-node [node labels]
  (make-result (query (format "MATCH (n%s %s) OPTIONAL MATCH (n)-[r]-() DELETE r,n" (make-labels labels) (make-props node)) node)))

(defn delete-node-by-id [id]
  (make-result (query (format "MATCH (n) WHERE id(n)=%d OPTIONAL MATCH (n)-[r]-() DELETE r,n" id) {})))


(defn create-relationship-1 [i1 i2 r p]
  (make-result (query (format "MATCH (n1) WHERE id(n1)=%d
                  MATCH (n2) WHERE id(n2)=%d
                  WITH n1,n2
                  CREATE (n1)-[r:%s {p}]->(n2)
                  RETURN r" i1 i2 r) {:p p}))) 

(defn create-relationship-2 [i1 i2 r1 r2 p1 p2]
  (query (format "MATCH (n1) WHERE id(n1)=%d
                  MATCH (n2) WHERE id(n2)=%d
                  WITH n1,n2
                  CREATE (n1)-[r1:%s {p1}]->(n2)
                  CREATE (n2)-[r2:%s {p2}]->(n1)
                  RETURN r1,r2" i1 i2 r1 r2) {:p1 p1 :p2 p2})) 

(defn merge-relationship-1 [i1 i2 r p]
  (make-result (query (format "MATCH (n1) WHERE id(n1)=%d
                  MATCH (n2) WHERE id(n2)=%d
                  WITH n1,n2
                  MERGE (n1)-[r:%s %s]->(n2)
                  RETURN r" i1 i2 r (make-props p)) p))) 

(defn merge-relationship-2 [i1 i2 r1 r2 p1 p2]
  (query (format "MATCH (n1) WHERE id(n1)=%d
                  MATCH (n2) WHERE id(n2)=%d
                  WITH n1,n2
                  MERGE (n1)-[r1:%s %s]->(n2)
                  MERGE (n2)-[r2:%s %s]->(n1)
                  RETURN r1,r2" i1 i2 r1 (make-props p1) r2 (make-props p2)) (merge p1 p2))) 


(defn delete-relationship-by-id [id]
  (make-result (query (format "MATCH ()-[r]-() WHERE id(r)=%d DELETE r" id) {})))

(defn delete-relationship-by-id-2 [id1 id2 r]
  (make-result (query (format "MATCH (n) WHERE id(n)=%d MATCH (m) WHERE id(m)=%d OPTIONAL MATCH (n)-[r%s]->(m) DELETE r" id1 id2 r) {})))

(defn del-r-of-1 
  ([id] (del-r-of-1 id ""))
  ([id r] (query (format "MATCH (n) WHERE id(n)=%d OPTIONAL MATCH (n)-[r%s]->() DELETE r" id r) {})))

(defn del-r-in-2
  ([id1 id2] (del-r id1 id2 ""))
  ([id1 id2 r] (make-result (query (format "MATCH (n) WHERE id(n)=%d MATCH (m) WHERE id(m)=%d OPTIONAL MATCH (n)-[r%s]->(m) DELETE r" id1 id2 r) {}))))

(defn add-r-in-2 [id1 id2 r]
  (create-relationship-1 id1 id2 r {}))



;;;;;;;;;;;;;;;;;;;;
(defn merge-and-connect-to-id [node labels r to]
  (make-result (query (format "MATCH (to) WHERE id(to)=%d 
                               MERGE (fr%s %s)
                               MERGE (fr)-[r:%s]->(to)
                               RETURN fr" to (make-labels labels) (make-props node) r) node)))

(defn merge-and-connect-fr-id  [node labels r fr]
  (make-result (query (format "MATCH (fr) WHERE id(fr)=%d 
                               MERGE (to%s %s)
                               MERGE (fr)-[r:%s]->(to)
                               RETURN to" fr (make-labels labels) (make-props node) r) node)))

(defn create-and-connect-to-id [node labels r to]
  (make-result (query (format "MATCH (to) WHERE id(to)=%d 
                               CREATE (fr%s %s)
                               MERGE (fr)-[r:%s]->(to)
                               RETURN fr" to (make-labels labels) (make-props node) r) node)))

(defn create-and-connect-fr-id [node labels r fr]
  (make-result (query (format "MATCH (fr) WHERE id(fr)=%d 
                               CREATE (to%s %s)
                               MERGE (fr)-[r:%s]->(to)
                               RETURN to" fr (make-labels labels) (make-props node) r) node)))
;;;;;;;;;;;;;;;;;;;;

