(ns poppy.core
  (:require [poppy.util :as pu]))

(def ^:dynamic *con* {})

(def HEADERS {"content-type" "application/json" "user-agent" "wangxiaoyu/poppy 0.0.1"})

(defn open [uri]
  (let [auth (pu/auth uri)
        opt {:http-auth {:basic-auth auth} :option {:headers HEADERS}}}
        body (:body (pu/GET uri opt))]
    {:auth auth :cypher (:cypher body)}))

(defn query [qry prm]
  (let [uri  (:cypher *con*)
        aut (:auth *con*)
        opt  {:basic-auth aut :body (pu/encode {:query qry :params prm})}
        ret (pu/tran (:body (pu/POST uri opt)))]
    ret))

(defmacro with-con [con & cmd]
  `(do
     (let [con# ~con]
       (binding [*con* con#]
         ~@cmd))))

(defmacro with-uri [uri & cmd]
  `(do 
      (with-con (open ~uri) ~@cmd)))

