(ns poppy.util 
  (:require [clj-http.client :as http]
            [cheshire.core :as json]))

(defn success? [status] (<= 200 status 299))
(defn failed? [status] (not (success? status)))

;;(defn missing? [status] (= status 404))
;;(defn conflict? [status] (= status 409))
;;(defn redirect? [status] (<= 300 status 399))
;;(defn client-error? [status] (<= 400 status 499))
;;(defn server-error? [status] (<= 500 status 599))

(defn decode [body] 
  (json/decode body true))
(defn encode [body]
  (json/encode body))

(defn auth [uri]
  (let [[user pass] (http/parse-user-info (:user-info (http/parse-url uri)))]
    [user pass]))

(defn GET [uri opt]
  (let [{:keys [status body]} (http/get uri opt)]
    {:status status :body (decode body)}))

(defn POST [uri opt]
  (let [{:keys [status body]} (http/post uri opt)]
    {:status status :body (decode body)}))

(defn keywordlize [m]
  (into {} (for [[k v] m] [(keyword k) v])))

(defn tran [body]
  (if-let [{:keys [columns data]} body]
    (map (fn [r] (keywordlize (zipmap columns r))) data))) 

(defn p2s [props] 
  (str "{" (cstr/join "," (map #(format "%s:{%s}" % %) (map #(name %) (keys props)))) "}"))

(defn l2s [labels]
  (cstr/join " " (map #(str ":" %) labels)))
