(ns jax.patcher.test
  "Patcher DSL test utils"
  (:require [jax.patcher :as patcher]))

(defmacro wrap-genid
  "Wraps the body with a deterministic redef of patcher/genid"
  [& body]
  `(let [i# (atom 0)]
     (with-redefs [patcher/genid (fn []
                                   (let [x# (deref i#)]
                                     (swap! i# inc)
                                     (str "jaxid" x#)))]
       ~@body)))
