(ns jax.patcher.test
  "Patcher DSL test utils"
  (:require [jax.patcher :as patcher])
  (:import (java.util.concurrent.atomic AtomicInteger)))

(defmacro wrap-genid
  "Wraps the body with a deterministic redef of jax.patcher/genid"
  [& body]
  `(let [i# (AtomicInteger.)]
     (with-redefs [patcher/genid (fn [] (str "jaxid" (.getAndIncrement i#)))]
       ~@body)))
