(ns jax.lang.max
  (:refer-clojure :exclude [* / > + float int seq next <= key - cycle flush
                            >= when send delay < print comment ==])
  (:require [jax.patcher :as patcher]
            [jax.lang.proto :as jax.proto]
            [clojure.core.protocols :as clojure.proto])
  (:import (clojure.lang IFn Keyword IMeta)
           (java.net URI)
           (java.awt Desktop)
           (java.util Map List)))

(defn- -invoke
  [this name args & inlets]
  (let [inlets      (map #(some-> % jax.proto/inlet) inlets)
        inlet-refs  (map #(some-> % jax.proto/reference) inlets)
        inlet-nodes (->> inlets (mapcat identity) (filter identity) (vec))
        args        (some-> args jax.proto/arguments)
        obj         (patcher/object :object name :args args :inlets inlet-refs)
        nodes       (patcher/->nodes (conj inlet-nodes obj))]
    (with-meta
     (-> (apply patcher/object-set nodes)
         (patcher/validate-obj-set))
     (meta this))))

;; A Max object can have up to 10 inlets
(deftype MaxFn [name meta]
  clojure.proto/Datafiable
  (datafy [_] meta)

  IMeta
  (meta [_] meta)

  jax.proto/IJaxFn
  (open-docs [_]
    (.browse (Desktop/getDesktop) (URI. (str "https://docs.cycling74.com" (:href meta)))))

  IFn
  (applyTo [this seq]
    (apply -invoke this name seq))

  (invoke [_]
    (with-meta (patcher/object :object name) meta))

  (invoke [this args]
    (-invoke this name args))

  (invoke [this args inlet0]
    (-invoke this name args inlet0))

  (invoke [this args inlet0 inlet1]
    (-invoke this name args inlet0 inlet1))

  (invoke [this args inlet0 inlet1 inlet2]
    (-invoke this name args inlet0 inlet1 inlet2))

  (invoke [this args inlet0 inlet1 inlet2 inlet3]
    (-invoke this name args inlet0 inlet1 inlet2 inlet3))

  (invoke [this args inlet0 inlet1 inlet2 inlet3 inlet4]
    (-invoke this name args inlet0 inlet1 inlet2 inlet3 inlet4))

  (invoke [this args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5]
    (-invoke this name args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5))

  (invoke [this args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6]
    (-invoke this name args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6))

  (invoke [this args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7]
    (-invoke this name args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7))

  (invoke [this args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8]
    (-invoke this name args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8))

  (invoke [this args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9]
    (-invoke this name args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9))

  (invoke [this args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]
    (-invoke this name args inlet0 inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10)))

(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "float can store and output any given floating-point number."} float (MaxFn. "float" {:alias "float", :doc "float can store and output any given floating-point number.", :href "/max8/refpages/float", :obj-name "float"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Shifts all bit values to the right. This has the effect of dividing a number by a power of two, but is less expensive in computer resources."} >> (MaxFn. ">>" {:alias "shiftright", :doc "Shifts all bit values to the right. This has the effect of dividing a number by a power of two, but is less expensive in computer resources.", :href "/max8/refpages/shiftright", :obj-name ">>"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} table (MaxFn. "table" {:alias "table", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/table", :obj-name "table"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The menubar object provides control over the menu bar. It allows your patch to put up its own menus, and add items to standard File and Edit menus. When a menu "} menubar (MaxFn. "menubar" {:alias "menubar", :doc "The menubar object provides control over the menu bar. It allows your patch to put up its own menus, and add items to standard File and Edit menus. When a menu ", :href "/max8/refpages/menubar", :obj-name "menubar"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Switches the right inlet between two output pathways."} gswitch2 (MaxFn. "gswitch2" {:alias "gswitch2", :doc "Switches the right inlet between two output pathways.", :href "/max8/refpages/gswitch2", :obj-name "gswitch2"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares one number to another and outputs a 1 if the two numbers are both non-zero or a 0 if either number is 0."} && (MaxFn. "&&" {:alias "logand", :doc "Compares one number to another and outputs a 1 if the two numbers are both non-zero or a 0 if either number is 0.", :href "/max8/refpages/logand", :obj-name "&&"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Accepts a numeric stream and outputs and outputs ASCII characters. Options arguments provide for forced-length messages."} spell (MaxFn. "spell" {:alias "spell", :doc "Accepts a numeric stream and outputs and outputs ASCII characters. Options arguments provide for forced-length messages.", :href "/max8/refpages/spell", :obj-name "spell"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "message displays and sends any given message with the capability to handle specified arguments."} message (MaxFn. "message" {:alias "message", :doc "message displays and sends any given message with the capability to handle specified arguments.", :href "/max8/refpages/message", :obj-name "message"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "int can store and output any given integer number."} int (MaxFn. "int" {:alias "int", :doc "int can store and output any given integer number.", :href "/max8/refpages/int", :obj-name "int"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "seq is a sequencer of raw MIDI bytes. You can control the speed of playback (only at the time you start it), read and write from files, and record from live MID"} seq (MaxFn. "seq" {:alias "seq", :doc "seq is a sequencer of raw MIDI bytes. You can control the speed of playback (only at the time you start it), read and write from files, and record from live MID", :href "/max8/refpages/seq", :obj-name "seq"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares two values to see if one value is not equal to a second. Outputs a 1 if the number is not equal to the comparison-number or 0 if it is equal to it."} != (MaxFn. "!=" {:alias "notequals", :doc "Compares two values to see if one value is not equal to a second. Outputs a 1 if the number is not equal to the comparison-number or 0 if it is equal to it.", :href "/max8/refpages/notequals", :obj-name "!="}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides a user interface control containing a group of cells in a grid. Cell states can either be on/off or incremental steps. This object is especially useful"} matrixctrl (MaxFn. "matrixctrl" {:alias "matrixctrl", :doc "Provides a user interface control containing a group of cells in a grid. Cell states can either be on/off or incremental steps. This object is especially useful", :href "/max8/refpages/matrixctrl", :obj-name "matrixctrl"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "View and modify client object data, and store or recall presets."} pattrstorage (MaxFn. "pattrstorage" {:alias "pattrstorage", :doc "View and modify client object data, and store or recall presets.", :href "/max8/refpages/pattrstorage", :obj-name "pattrstorage"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Starts and stops the passage of time for objects linked to a transport. If given a name, the transport object will control a time context of the given name, oth"} transport (MaxFn. "transport" {:alias "transport", :doc "Starts and stops the passage of time for objects linked to a transport. If given a name, the transport object will control a time context of the given name, oth", :href "/max8/refpages/transport", :obj-name "transport"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} colorpicker (MaxFn. "colorpicker" {:alias "colorpicker", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/colorpicker", :obj-name "colorpicker"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The jweb object uses the cross-platform Chromium Embedded Framework (CEF) to view renderable data in a Max box."} jweb (MaxFn. "jweb" {:alias "jweb", :doc "The jweb object uses the cross-platform Chromium Embedded Framework (CEF) to view renderable data in a Max box.", :href "/max8/refpages/jweb", :obj-name "jweb"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "When you mouse over a hint, you'll see a message appear on the screen below the area defined by the hint. The hint object has a number of messages you can use t"} hint (MaxFn. "hint" {:alias "hint", :doc "When you mouse over a hint, you'll see a message appear on the screen below the area defined by the hint. The hint object has a number of messages you can use t", :href "/max8/refpages/hint", :obj-name "hint"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "tosymbol accepts any message, number, or list, and converts it into a single symbol. The symbol has a maximum length of 2048 characters."} tosymbol (MaxFn. "tosymbol" {:alias "tosymbol", :doc "tosymbol accepts any message, number, or list, and converts it into a single symbol. The symbol has a maximum length of 2048 characters.", :href "/max8/refpages/tosymbol", :obj-name "tosymbol"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Acquires and outputs comprehensive information regarding note-on and note-off events. Information includes note counts, event details and time between note even"} borax (MaxFn. "borax" {:alias "borax", :doc "Acquires and outputs comprehensive information regarding note-on and note-off events. Information includes note counts, event details and time between note even", :href "/max8/refpages/borax", :obj-name "borax"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Watch a specific file and reports a bang whenever that file is altered."} filewatch (MaxFn. "filewatch" {:alias "filewatch", :doc "Watch a specific file and reports a bang whenever that file is altered.", :href "/max8/refpages/filewatch", :obj-name "filewatch"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs random numbers within the range between 0 and 1 less than the argument specified."} random (MaxFn. "random" {:alias "random", :doc "Outputs random numbers within the range between 0 and 1 less than the argument specified.", :href "/max8/refpages/random", :obj-name "random"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the cosh object to calculate and output the hyperbolic cosine of any given number."} cosh (MaxFn. "cosh" {:alias "cosh", :doc "Use the cosh object to calculate and output the hyperbolic cosine of any given number.", :href "/max8/refpages/cosh", :obj-name "cosh"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Filters an input value logarithmically between changes. It's particularly useful for envelope following and lowpass filtering to smooth a stream of continuous d"} slide (MaxFn. "slide" {:alias "slide", :doc "Filters an input value logarithmically between changes. It's particularly useful for envelope following and lowpass filtering to smooth a stream of continuous d", :href "/max8/refpages/slide", :obj-name "slide"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs all of the file names in a given folder. This can be especially useful for loading a umenu."} folder (MaxFn. "folder" {:alias "folder", :doc "Outputs all of the file names in a given folder. This can be especially useful for loading a umenu.", :href "/max8/refpages/folder", :obj-name "folder"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Exposes the Javascript language and some Max specific extensions. The js object can be instantiated with a javascript filename or with numerical arguments to sp"} js (MaxFn. "js" {:alias "js", :doc "Exposes the Javascript language and some Max specific extensions. The js object can be instantiated with a javascript filename or with numerical arguments to sp", :href "/max8/refpages/js", :obj-name "js"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} xnotein (MaxFn. "xnotein" {:alias "xnotein", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/xnotein", :obj-name "xnotein"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs a specified number of bang messages quickly. uzi is designed for rapid-fire output of a large number of bang messages."} uzi (MaxFn. "uzi" {:alias "uzi", :doc "Outputs a specified number of bang messages quickly. uzi is designed for rapid-fire output of a large number of bang messages.", :href "/max8/refpages/uzi", :obj-name "uzi"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts a polar-coordinate pair consisting of distance and angle values into a cartesian-coordinate pair consisting of real and imaginary values."} poltocar (MaxFn. "poltocar" {:alias "poltocar", :doc "Converts a polar-coordinate pair consisting of distance and angle values into a cartesian-coordinate pair consisting of real and imaginary values.", :href "/max8/refpages/poltocar", :obj-name "poltocar"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The tab can be used to create multiple button and multiple column displays and interfaces."} tab (MaxFn. "tab" {:alias "tab", :doc "The tab can be used to create multiple button and multiple column displays and interfaces.", :href "/max8/refpages/tab", :obj-name "tab"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Transmits MIDI continuous controller values to a MIDI device."} ctlout (MaxFn. "ctlout" {:alias "ctlout", :doc "Transmits MIDI continuous controller values to a MIDI device.", :href "/max8/refpages/ctlout", :obj-name "ctlout"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts a file name or path to an absolute path. If the file is not found, the symbol notfound is output."} absolutepath (MaxFn. "absolutepath" {:alias "absolutepath", :doc "Converts a file name or path to an absolute path. If the file is not found, the symbol notfound is output.", :href "/max8/refpages/absolutepath", :obj-name "absolutepath"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Evaluate an expression using a C-like language. Variables and operators are used to create output values."} expr (MaxFn. "expr" {:alias "expr", :doc "Evaluate an expression using a C-like language. Variables and operators are used to create output values.", :href "/max8/refpages/expr", :obj-name "expr"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Multiplies two numbers together, and outputs the result upon receiving input in the left inlet."} * (MaxFn. "*" {:alias "times", :doc "Multiplies two numbers together, and outputs the result upon receiving input in the left inlet.", :href "/max8/refpages/times", :obj-name "*"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides a user interface for option selection. There are two modes of operation: radio button and checkbox."} radiogroup (MaxFn. "radiogroup" {:alias "radiogroup", :doc "Provides a user interface for option selection. There are two modes of operation: radio button and checkbox.", :href "/max8/refpages/radiogroup", :obj-name "radiogroup"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Sends a bang out its left outlet when an incoming message is not part of the same Max \"event\" as a previous message. (An \"event\" is a mouse click, key press, MI"} next (MaxFn. "next" {:alias "next", :doc "Sends a bang out its left outlet when an incoming message is not part of the same Max \"event\" as a previous message. (An \"event\" is a mouse click, key press, MI", :href "/max8/refpages/next", :obj-name "next"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs incoming data after something has been received in all inlets."} buddy (MaxFn. "buddy" {:alias "buddy", :doc "Outputs incoming data after something has been received in all inlets.", :href "/max8/refpages/buddy", :obj-name "buddy"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "% takes two numbers, divides one by the other and outputs the remainder of the division."} % (MaxFn. "%" {:alias "modulo", :doc "% takes two numbers, divides one by the other and outputs the remainder of the division.", :href "/max8/refpages/modulo", :obj-name "%"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Creating buttons, switches, knobs, and other controls using images from a picture file for its appearance."} pictctrl (MaxFn. "pictctrl" {:alias "pictctrl", :doc "Creating buttons, switches, knobs, and other controls using images from a picture file for its appearance.", :href "/max8/refpages/pictctrl", :obj-name "pictctrl"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} gate (MaxFn. "gate" {:alias "gate", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/gate", :obj-name "gate"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Reports how many times a number pair has been received."} anal (MaxFn. "anal" {:alias "anal", :doc "Reports how many times a number pair has been received.", :href "/max8/refpages/anal", :obj-name "anal"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "preset can store and recall the parameters of any specified user interface objects at the click of a mouse. It can also be used as a user interface link to a na"} preset (MaxFn. "preset" {:alias "preset", :doc "preset can store and recall the parameters of any specified user interface objects at the click of a mouse. It can also be used as a user interface link to a na", :href "/max8/refpages/preset", :obj-name "preset"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares two values to see if one value is less than or equal to a second. Outputs a 1 if the number is less than or equal to the comparison-number or 0 if it i"} <= (MaxFn. "<=" {:alias "lessthaneq", :doc "Compares two values to see if one value is less than or equal to a second. Outputs a 1 if the number is less than or equal to the comparison-number or 0 if it i", :href "/max8/refpages/lessthaneq", :obj-name "<="}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the filterdesign object to create a dictionary containing a specification for a filter that can be realized by several other objects including the cascade~ "} filterdesign (MaxFn. "filterdesign" {:alias "filterdesign", :doc "Use the filterdesign object to create a dictionary containing a specification for a filter that can be realized by several other objects including the cascade~ ", :href "/max8/refpages/filterdesign", :obj-name "filterdesign"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} polyout (MaxFn. "polyout" {:alias "polyout", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/polyout", :obj-name "polyout"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Receives MIDI system exclusive messages from a MIDI input device. It takes an optional argument for port selection. If a MIDI system exclusive message is receiv"} sysexin (MaxFn. "sysexin" {:alias "sysexin", :doc "Receives MIDI system exclusive messages from a MIDI input device. It takes an optional argument for port selection. If a MIDI system exclusive message is receiv", :href "/max8/refpages/sysexin", :obj-name "sysexin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides polyphonic voice-allocation by allocating data to different individual voices."} poly (MaxFn. "poly" {:alias "poly", :doc "Provides polyphonic voice-allocation by allocating data to different individual voices.", :href "/max8/refpages/poly", :obj-name "poly"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Separates raw MIDI bytes into standard message types. This object works particularly well formatting the output of the midiin and seq objects."} midiparse (MaxFn. "midiparse" {:alias "midiparse", :doc "Separates raw MIDI bytes into standard message types. This object works particularly well formatting the output of the midiin and seq objects.", :href "/max8/refpages/midiparse", :obj-name "midiparse"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Sends a bang whenever the patcher window within which it resides is closed."} closebang (MaxFn. "closebang" {:alias "closebang", :doc "Sends a bang whenever the patcher window within which it resides is closed.", :href "/max8/refpages/closebang", :obj-name "closebang"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Defers the output of all messages sent through it to the lower priority main thread. This is most applicable when using Overdrive mode."} defer (MaxFn. "defer" {:alias "defer", :doc "Defers the output of all messages sent through it to the lower priority main thread. This is most applicable when using Overdrive mode.", :href "/max8/refpages/defer", :obj-name "defer"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs the current count of bang message constrained to a specified range. Can be set to count up, down, or up-then-down."} counter (MaxFn. "counter" {:alias "counter", :doc "Outputs the current count of bang message constrained to a specified range. Can be set to count up, down, or up-then-down.", :href "/max8/refpages/counter", :obj-name "counter"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} fpic (MaxFn. "fpic" {:alias "fpic", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/fpic", :obj-name "fpic"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts from any of the fixed or relative Max time values to any other fixed or relative time value."} translate (MaxFn. "translate" {:alias "translate", :doc "Converts from any of the fixed or relative Max time values to any other fixed or relative time value.", :href "/max8/refpages/translate", :obj-name "translate"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Routes messages or selects new message routing destinations according to the messages it receives. You can also use the pattrforward object to route messages di"} pattrforward (MaxFn. "pattrforward" {:alias "pattrforward", :doc "Routes messages or selects new message routing destinations according to the messages it receives. You can also use the pattrforward object to route messages di", :href "/max8/refpages/pattrforward", :obj-name "pattrforward"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Stores its own data, or binds to another object to share its contents with other pattr-based objects (such as pattrstorage). Can be used for data routing or pre"} pattr (MaxFn. "pattr" {:alias "pattr", :doc "Stores its own data, or binds to another object to share its contents with other pattr-based objects (such as pattrstorage). Can be used for data routing or pre", :href "/max8/refpages/pattr", :obj-name "pattr"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} numkey (MaxFn. "numkey" {:alias "numkey", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/numkey", :obj-name "numkey"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Prepends any input messages with a stored message."} prepend (MaxFn. "prepend" {:alias "prepend", :doc "Prepends any input messages with a stored message.", :href "/max8/refpages/prepend", :obj-name "prepend"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} serial (MaxFn. "serial" {:alias "serial", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/serial", :obj-name "serial"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Store two ints as an x, y pair, and access them by x value. When a pair is retrieved, it is deleted from the collection."} offer (MaxFn. "offer" {:alias "offer", :doc "Store two ints as an x, y pair, and access them by x value. When a pair is retrieved, it is deleted from the collection.", :href "/max8/refpages/offer", :obj-name "offer"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Combine items into an output list. The arguments determine the list format and types of the list elements. The number of inlets is based on the number of argume"} pack (MaxFn. "pack" {:alias "pack", :doc "Combine items into an output list. The arguments determine the list format and types of the list elements. The number of inlets is based on the number of argume", :href "/max8/refpages/pack", :obj-name "pack"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The scale object maps an input range of float or integer values to an output range. The output range can be larger or smaller than the input range, can be inver"} scale (MaxFn. "scale" {:alias "scale", :doc "The scale object maps an input range of float or integer values to an output range. The output range can be larger or smaller than the input range, can be inver", :href "/max8/refpages/scale", :obj-name "scale"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs random numbers and keeps track of each number that has been generated. When all numbers up to the maximum (set via an argument or the right inlet) have "} urn (MaxFn. "urn" {:alias "urn", :doc "Outputs random numbers and keeps track of each number that has been generated. When all numbers up to the maximum (set via an argument or the right inlet) have ", :href "/max8/refpages/urn", :obj-name "urn"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Performs a bit-by-bit OR of two numbers (expressed in binary for the task). Outputs a number composed of all those bits which are 1 in either of the two numbers"} | (MaxFn. "|" {:alias "bitor", :doc "Performs a bit-by-bit OR of two numbers (expressed in binary for the task). Outputs a number composed of all those bits which are 1 in either of the two numbers", :href "/max8/refpages/bitor", :obj-name "|"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Uses the common C-language \"printf\" function inside Max. You can combine symbols, organize lists of numbers, or format messages or menu items. For complete docu"} sprintf (MaxFn. "sprintf" {:alias "sprintf", :doc "Uses the common C-language \"printf\" function inside Max. You can combine symbols, organize lists of numbers, or format messages or menu items. For complete docu", :href "/max8/refpages/sprintf", :obj-name "sprintf"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Synchronizes and outputs a set of inputs when any input is received. It can also be set with a time interval value (in milliseconds) to wait before sending its "} bondo (MaxFn. "bondo" {:alias "bondo", :doc "Synchronizes and outputs a set of inputs when any input is received. It can also be set with a time interval value (in milliseconds) to wait before sending its ", :href "/max8/refpages/bondo", :obj-name "bondo"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} freebang (MaxFn. "freebang" {:alias "freebang", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/freebang", :obj-name "freebang"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Collects items into a list if they appear within a certain specifiable amount of time. Each time an item arrives, the time is reset."} thresh (MaxFn. "thresh" {:alias "thresh", :doc "Collects items into a list if they appear within a certain specifiable amount of time. Each time an item arrives, the time is reset.", :href "/max8/refpages/thresh", :obj-name "thresh"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Increment or Decrement a value. When connected to a number box, Click the upper half of the object to increment, click the lower half to decrement."} incdec (MaxFn. "incdec" {:alias "incdec", :doc "Increment or Decrement a value. When connected to a number box, Click the upper half of the object to increment, click the lower half to decrement.", :href "/max8/refpages/incdec", :obj-name "incdec"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Displays a dialog box with a selection of appearance modes. In Default mode, the dialog object permits entry of a symbol (as text) and sends it out the outlet w"} dialog (MaxFn. "dialog" {:alias "dialog", :doc "Displays a dialog box with a selection of appearance modes. In Default mode, the dialog object permits entry of a symbol (as text) and sends it out the outlet w", :href "/max8/refpages/dialog", :obj-name "dialog"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} clip (MaxFn. "clip" {:alias "clip", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/clip", :obj-name "clip"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the atan2 object to calculate and output the arc-tangent of any two given numbers where the left input is the y value and the right input is the x value."} atan2 (MaxFn. "atan2" {:alias "atan2", :doc "Use the atan2 object to calculate and output the arc-tangent of any two given numbers where the left input is the y value and the right input is the x value.", :href "/max8/refpages/atan2", :obj-name "atan2"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Performs mathematical calculations using C language-style mathematical operations. Operates on inputs that are lists rather than collections of single values."} vexpr (MaxFn. "vexpr" {:alias "vexpr", :doc "Performs mathematical calculations using C language-style mathematical operations. Operates on inputs that are lists rather than collections of single values.", :href "/max8/refpages/vexpr", :obj-name "vexpr"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Calculates the mean (average) of all the numbers it has received and outputs it."} mean (MaxFn. "mean" {:alias "mean", :doc "Calculates the mean (average) of all the numbers it has received and outputs it.", :href "/max8/refpages/mean", :obj-name "mean"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Limit the throughput speed of incoming messages to a fixed time limit. The time can be specified in milliseconds or using a tempo-relative interval."} speedlim (MaxFn. "speedlim" {:alias "speedlim", :doc "Limit the throughput speed of incoming messages to a fixed time limit. The time can be specified in milliseconds or using a tempo-relative interval.", :href "/max8/refpages/speedlim", :obj-name "speedlim"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts a decibel value to its corresponding linear amplitude."} dbtoa (MaxFn. "dbtoa" {:alias "dbtoa", :doc "Converts a decibel value to its corresponding linear amplitude.", :href "/max8/refpages/dbtoa", :obj-name "dbtoa"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "send will transmit given messages to receive objects which are named by the same argument and will allow you to send any kind of message between Patcher windows"} send (MaxFn. "send" {:alias "send", :doc "send will transmit given messages to receive objects which are named by the same argument and will allow you to send any kind of message between Patcher windows", :href "/max8/refpages/send", :obj-name "send"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Divides two numbers (according to the specified divisor assignment), and then outputs the result."} / (MaxFn. "/" {:alias "div", :doc "Divides two numbers (according to the specified divisor assignment), and then outputs the result.", :href "/max8/refpages/div", :obj-name "/"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs a list of system fonts and, optionally, their system identification numbers. Optionally filters the list by font-family."} fontlist (MaxFn. "fontlist" {:alias "fontlist", :doc "Outputs a list of system fonts and, optionally, their system identification numbers. Optionally filters the list by font-family.", :href "/max8/refpages/fontlist", :obj-name "fontlist"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Performs a \"drunken\" walk by outputting random numbers within a specified step range."} drunk (MaxFn. "drunk" {:alias "drunk", :doc "Performs a \"drunken\" walk by outputting random numbers within a specified step range.", :href "/max8/refpages/drunk", :obj-name "drunk"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.print object to post the content of a dictionary to the Max Console. For more control over how the printing is formatted, use dict.iter and print."} dict.print (MaxFn. "dict.print" {:alias "dict.print", :doc "Use the dict.print object to post the content of a dictionary to the Max Console. For more control over how the printing is formatted, use dict.iter and print.", :href "/max8/refpages/dict.print", :obj-name "dict.print"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} gestalt (MaxFn. "gestalt" {:alias "gestalt", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/gestalt", :obj-name "gestalt"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Causes multiple objects within a patcher to be automatically included in the pattr system. Note: you should use only one instance of an autopattr object per lev"} autopattr (MaxFn. "autopattr" {:alias "autopattr", :doc "Causes multiple objects within a patcher to be automatically included in the pattr system. Note: you should use only one instance of an autopattr object per lev", :href "/max8/refpages/autopattr", :obj-name "autopattr"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides hierarchical switching. The right inlet is the master disable switch, while the middle inlet is a submaster enable. The left inlet can turn on a single"} decode (MaxFn. "decode" {:alias "decode", :doc "Provides hierarchical switching. The right inlet is the master disable switch, while the middle inlet is a submaster enable. The left inlet can turn on a single", :href "/max8/refpages/decode", :obj-name "decode"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs random 1 and 0 messages. The output sequence depends on the seed value to determine the sequence of values."} decide (MaxFn. "decide" {:alias "decide", :doc "Outputs random 1 and 0 messages. The output sequence depends on the seed value to determine the sequence of values.", :href "/max8/refpages/decide", :obj-name "decide"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.iter object to send all key-value pairs out from a dictionary as a series of standard Max list messages."} dict.iter (MaxFn. "dict.iter" {:alias "dict.iter", :doc "Use the dict.iter object to send all key-value pairs out from a dictionary as a series of standard Max list messages.", :href "/max8/refpages/dict.iter", :obj-name "dict.iter"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Analyzes a raw MIDI stream (from midiin or seq), counting the number of note-ons received for each note and MIDI channel. When it is sent a bang, MIDI note-off "} midiflush (MaxFn. "midiflush" {:alias "midiflush", :doc "Analyzes a raw MIDI stream (from midiin or seq), counting the number of note-ons received for each note and MIDI channel. When it is sent a bang, MIDI note-off ", :href "/max8/refpages/midiflush", :obj-name "midiflush"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Removes path information from a complete file path. strippath also tells you whether the resulting filename is in the search path or not."} strippath (MaxFn. "strippath" {:alias "strippath", :doc "Removes path information from a complete file path. strippath also tells you whether the resulting filename is in the search path or not.", :href "/max8/refpages/strippath", :obj-name "strippath"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs incoming values to outlets in bucket-brigade fashion. bucket acts as an n-stage shift register which can shift its contents from outlet to outlet in eit"} bucket (MaxFn. "bucket" {:alias "bucket", :doc "Outputs incoming values to outlets in bucket-brigade fashion. bucket acts as an n-stage shift register which can shift its contents from outlet to outlet in eit", :href "/max8/refpages/bucket", :obj-name "bucket"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} - (MaxFn. "-" {:alias "minus", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/minus", :obj-name "-"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Tracks and outputs the key-codes, ASCII values, and modifier-key values of key presses on the computer keyboard."} key (MaxFn. "key" {:alias "key", :doc "Tracks and outputs the key-codes, ASCII values, and modifier-key values of key presses on the computer keyboard.", :href "/max8/refpages/key", :obj-name "key"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Listens to a specified MIDI port and output the raw MIDI data received."} midiin (MaxFn. "midiin" {:alias "midiin", :doc "Listens to a specified MIDI port and output the raw MIDI data received.", :href "/max8/refpages/midiin", :obj-name "midiin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Plays a movie in a user-interface object within the patcher window."} imovie (MaxFn. "imovie" {:alias "imovie", :doc "Plays a movie in a user-interface object within the patcher window.", :href "/max8/refpages/imovie", :obj-name "imovie"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Transmits messages over a network using the User Datagram Protocol (UDP)."} udpsend (MaxFn. "udpsend" {:alias "udpsend", :doc "Transmits messages over a network using the User Datagram Protocol (UDP).", :href "/max8/refpages/udpsend", :obj-name "udpsend"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Reports Mac OS suspend/resume events. The behavior is emulated on Windows."} suspend (MaxFn. "suspend" {:alias "suspend", :doc "Reports Mac OS suspend/resume events. The behavior is emulated on Windows.", :href "/max8/refpages/suspend", :obj-name "suspend"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Display, input, and output floating-point numbers in a number box."} flonum (MaxFn. "flonum" {:alias "flonum", :doc "Display, input, and output floating-point numbers in a number box.", :href "/max8/refpages/flonum", :obj-name "flonum"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Stores and manages a collection of numbers. You can add to or delete an integer from a bag as report its contents. bag with any argument maintains multiple entr"} bag (MaxFn. "bag" {:alias "bag", :doc "Stores and manages a collection of numbers. You can add to or delete an integer from a bag as report its contents. bag with any argument maintains multiple entr", :href "/max8/refpages/bag", :obj-name "bag"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Set a value range from the lowest to highest value."} rslider (MaxFn. "rslider" {:alias "rslider", :doc "Set a value range from the lowest to highest value.", :href "/max8/refpages/rslider", :obj-name "rslider"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides button status and cursor position information about the mouse/cursor when the cursor is positioned within a Max patcher window. The mouse button is sam"} mousestate (MaxFn. "mousestate" {:alias "mousestate", :doc "Provides button status and cursor position information about the mouse/cursor when the cursor is positioned within a Max patcher window. The mouse button is sam", :href "/max8/refpages/mousestate", :obj-name "mousestate"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Creates a table of weighted numeric transitions. A bang message causes the weighting, and a potential transition, to be calculated."} prob (MaxFn. "prob" {:alias "prob", :doc "Creates a table of weighted numeric transitions. A bang message causes the weighting, and a potential transition, to be calculated.", :href "/max8/refpages/prob", :obj-name "prob"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Each incoming number is sent to the next outlet, wrapping around to the first outlet after the last has been reached."} cycle (MaxFn. "cycle" {:alias "cycle", :doc "Each incoming number is sent to the next outlet, wrapping around to the first outlet after the last has been reached.", :href "/max8/refpages/cycle", :obj-name "cycle"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "fromsymbol will take the individual characters in a symbol and convert them from a symbol back to numbers/messages."} fromsymbol (MaxFn. "fromsymbol" {:alias "fromsymbol", :doc "fromsymbol will take the individual characters in a symbol and convert them from a symbol back to numbers/messages.", :href "/max8/refpages/fromsymbol", :obj-name "fromsymbol"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Stores a value (int or float), then adds or multiplies into it. If the argument is an integer, the multiplication is done in floating-point then converted to in"} accum (MaxFn. "accum" {:alias "accum", :doc "Stores a value (int or float), then adds or multiplies into it. If the argument is an integer, the multiplication is done in floating-point then converted to in", :href "/max8/refpages/accum", :obj-name "accum"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs bang messages out of each outlet (in right-to-left order) when it receives any input. The number of outlets is determined by an argument."} bangbang (MaxFn. "bangbang" {:alias "bangbang", :doc "Outputs bang messages out of each outlet (in right-to-left order) when it receives any input. The number of outlets is determined by an argument.", :href "/max8/refpages/bangbang", :obj-name "bangbang"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Tries to match a message's first argument to the route object's own arguments. The rightmost outlet passes any message that matched no other choice, so you may "} route (MaxFn. "route" {:alias "route", :doc "Tries to match a message's first argument to the route object's own arguments. The rightmost outlet passes any message that matched no other choice, so you may ", :href "/max8/refpages/route", :obj-name "route"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.pack object to create a dictionary and set its values using dedicated inlets."} dict.pack (MaxFn. "dict.pack" {:alias "dict.pack", :doc "Use the dict.pack object to create a dictionary and set its values using dedicated inlets.", :href "/max8/refpages/dict.pack", :obj-name "dict.pack"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Accesses a precise value from the system timer. This allows for timing calculations with very high resolution."} cpuclock (MaxFn. "cpuclock" {:alias "cpuclock", :doc "Accesses a precise value from the system timer. This allows for timing calculations with very high resolution.", :href "/max8/refpages/cpuclock", :obj-name "cpuclock"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Watches an input stream for any numbers which are greater than its most recently set maximum. If the input value is less than or equal to the maximum, the maxim"} maximum (MaxFn. "maximum" {:alias "maximum", :doc "Watches an input stream for any numbers which are greater than its most recently set maximum. If the input value is less than or equal to the maximum, the maxim", :href "/max8/refpages/maximum", :obj-name "maximum"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs a bang when the clock reaches a specific time. The clock has to be moving forward in order for the bang to be output."} timepoint (MaxFn. "timepoint" {:alias "timepoint", :doc "Outputs a bang when the clock reaches a specific time. The clock has to be moving forward in order for the bang to be output.", :href "/max8/refpages/timepoint", :obj-name "timepoint"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Listens for and reports Max errors as message output. This will allow for error management in cases where it is not appropriate to display the Max window."} error (MaxFn. "error" {:alias "error", :doc "Listens for and reports Max errors as message output. This will allow for error management in cases where it is not appropriate to display the Max window.", :href "/max8/refpages/error", :obj-name "error"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Centralizes communication with all pattr objects in a patcher."} pattrhub (MaxFn. "pattrhub" {:alias "pattrhub", :doc "Centralizes communication with all pattr objects in a patcher.", :href "/max8/refpages/pattrhub", :obj-name "pattrhub"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Raises the base value (set in the left inlet) to the power of the exponent (set in the right inlet)."} pow (MaxFn. "pow" {:alias "pow", :doc "Raises the base value (set in the left inlet) to the power of the exponent (set in the right inlet).", :href "/max8/refpages/pow", :obj-name "pow"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.slice object to split a dictionary into two dictionaries. The first dictionary will be created from a set of keys you provide, sent to the left out"} dict.slice (MaxFn. "dict.slice" {:alias "dict.slice", :doc "Use the dict.slice object to split a dictionary into two dictionaries. The first dictionary will be created from a set of keys you provide, sent to the left out", :href "/max8/refpages/dict.slice", :obj-name "dict.slice"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputss note-off messages for any held note-ons. flush keeps track of all note-ons passed through it, and produces note-off messages for any held notes when it"} flush (MaxFn. "flush" {:alias "flush", :doc "Outputss note-off messages for any held note-ons. flush keeps track of all note-ons passed through it, and produces note-off messages for any held notes when it", :href "/max8/refpages/flush", :obj-name "flush"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Watches an input stream for any numbers which are less than its most recently set minimum. If the input value is greater than or equal to the minimum, the minim"} minimum (MaxFn. "minimum" {:alias "minimum", :doc "Watches an input stream for any numbers which are less than its most recently set minimum. If the input value is greater than or equal to the minimum, the minim", :href "/max8/refpages/minimum", :obj-name "minimum"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Show up as an outlet at the bottom of an object box when the patcher is used inside another patcher (as an object or a subpatch). Messages received by the outle"} outlet (MaxFn. "outlet" {:alias "outlet", :doc "Show up as an outlet at the bottom of an object box when the patcher is used inside another patcher (as an object or a subpatch). Messages received by the outle", :href "/max8/refpages/outlet", :obj-name "outlet"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Sends a bang when a number rises above a certain specified value."} past (MaxFn. "past" {:alias "past", :doc "Sends a bang when a number rises above a certain specified value.", :href "/max8/refpages/past", :obj-name "past"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Formats messages which occupy both bytes of the MIDI pitch bend message. xbendout2 allows you to send the pitch bend data as two bytes from 0-127."} xbendout (MaxFn. "xbendout" {:alias "xbendout", :doc "Formats messages which occupy both bytes of the MIDI pitch bend message. xbendout2 allows you to send the pitch bend data as two bytes from 0-127.", :href "/max8/refpages/xbendout", :obj-name "xbendout"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares an input value to the stored value and, if it's smaller it sends the input to the output and sets it as the new trough."} trough (MaxFn. "trough" {:alias "trough", :doc "Compares an input value to the stored value and, if it's smaller it sends the input to the output and sets it as the new trough.", :href "/max8/refpages/trough", :obj-name "trough"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Serves as a remote control for patcher/subpatcher windows and functions."} pcontrol (MaxFn. "pcontrol" {:alias "pcontrol", :doc "Serves as a remote control for patcher/subpatcher windows and functions.", :href "/max8/refpages/pcontrol", :obj-name "pcontrol"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Resembles a sliding potentiometer, outputting numbers restricted to a specified range, offset by a specified number, and multiplied by a specified number."} slider (MaxFn. "slider" {:alias "slider", :doc "Resembles a sliding potentiometer, outputting numbers restricted to a specified range, offset by a specified number, and multiplied by a specified number.", :href "/max8/refpages/slider", :obj-name "slider"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Execute Java classes as Max objects. The Java classes must be specially written for Max, but work identically within the JVM (Java Virtual Machine) on both Wind"} mxj (MaxFn. "mxj" {:alias "mxj", :doc "Execute Java classes as Max objects. The Java classes must be specially written for Max, but work identically within the JVM (Java Virtual Machine) on both Wind", :href "/max8/refpages/mxj", :obj-name "mxj"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The pvar object lets you build user interfaces in one part of your patcher that are associated with the \"process\" part in another part of the patcher. Unlike th"} pvar (MaxFn. "pvar" {:alias "pvar", :doc "The pvar object lets you build user interfaces in one part of your patcher that are associated with the \"process\" part in another part of the patcher. Unlike th", :href "/max8/refpages/pvar", :obj-name "pvar"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Swaps the values of its inlets, preserving right-to-left ordering. The first outlet type is determined by its argument. The second outlet's type is always a flo"} fswap (MaxFn. "fswap" {:alias "fswap", :doc "Swaps the values of its inlets, preserving right-to-left ordering. The first outlet type is determined by its argument. The second outlet's type is always a flo", :href "/max8/refpages/fswap", :obj-name "fswap"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Stores, manages, and recalls pairs of numbers."} funbuff (MaxFn. "funbuff" {:alias "funbuff", :doc "Stores, manages, and recalls pairs of numbers.", :href "/max8/refpages/funbuff", :obj-name "funbuff"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the atan object to calculate and output the arc-tangent of any given number."} atan (MaxFn. "atan" {:alias "atan", :doc "Use the atan object to calculate and output the arc-tangent of any given number.", :href "/max8/refpages/atan", :obj-name "atan"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Transmits MIDI aftertouch values to a MIDI device."} touchout (MaxFn. "touchout" {:alias "touchout", :doc "Transmits MIDI aftertouch values to a MIDI device.", :href "/max8/refpages/touchout", :obj-name "touchout"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the acosh object to calculate and output the hyperbolic arc-cosine of any given number."} acosh (MaxFn. "acosh" {:alias "acosh", :doc "Use the acosh object to calculate and output the hyperbolic arc-cosine of any given number.", :href "/max8/refpages/acosh", :obj-name "acosh"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The jstrigger object is similar to the trigger object, except that typed-in arguments within parentheses are passed to the Javascript evaluator. For more inform"} jstrigger (MaxFn. "jstrigger" {:alias "jstrigger", :doc "The jstrigger object is similar to the trigger object, except that typed-in arguments within parentheses are passed to the Javascript evaluator. For more inform", :href "/max8/refpages/jstrigger", :obj-name "jstrigger"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Combines numbers when they are received close together. quickthresh is a faster, low-latency alternative to thresh that is optimized for chord detection."} quickthresh (MaxFn. "quickthresh" {:alias "quickthresh", :doc "Combines numbers when they are received close together. quickthresh is a faster, low-latency alternative to thresh that is optimized for chord detection.", :href "/max8/refpages/quickthresh", :obj-name "quickthresh"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Receives its input from a MIDI note-on or note-off message sent by a MIDI input device."} notein (MaxFn. "notein" {:alias "notein", :doc "Receives its input from a MIDI note-on or note-off message sent by a MIDI input device.", :href "/max8/refpages/notein", :obj-name "notein"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts any given linear amplitude value to its corresponding decibel value."} atodb (MaxFn. "atodb" {:alias "atodb", :doc "Converts any given linear amplitude value to its corresponding decibel value.", :href "/max8/refpages/atodb", :obj-name "atodb"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs the elements of an incoming list in the format: [index] [element] for each element of the list."} listfunnel (MaxFn. "listfunnel" {:alias "listfunnel", :doc "Outputs the elements of an incoming list in the format: [index] [element] for each element of the list.", :href "/max8/refpages/listfunnel", :obj-name "listfunnel"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs a message automatically when the file is opened, or when the patch is part of another file that is opened."} loadmess (MaxFn. "loadmess" {:alias "loadmess", :doc "Outputs a message automatically when the file is opened, or when the patch is part of another file that is opened.", :href "/max8/refpages/loadmess", :obj-name "loadmess"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The deferlow object places all incoming messages at the tail of the low priority queue. This is unlike the defer object, however, which places high priority mes"} deferlow (MaxFn. "deferlow" {:alias "deferlow", :doc "The deferlow object places all incoming messages at the tail of the low priority queue. This is unlike the defer object, however, which places high priority mes", :href "/max8/refpages/deferlow", :obj-name "deferlow"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Accepts, as arguments, a list of numbers which are sent out sequentially. In addition, you may use one or more \"expr\"-style statements, which start with the wor"} sxformat (MaxFn. "sxformat" {:alias "sxformat", :doc "Accepts, as arguments, a list of numbers which are sent out sequentially. In addition, you may use one or more \"expr\"-style statements, which start with the wor", :href "/max8/refpages/sxformat", :obj-name "sxformat"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Relays messages to other objects remotely. Unlike the send object, the destination receive object of forward can be changed with each message."} forward (MaxFn. "forward" {:alias "forward", :doc "Relays messages to other objects remotely. Unlike the send object, the destination receive object of forward can be changed with each message.", :href "/max8/refpages/forward", :obj-name "forward"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict object to create named dictionaries, clone existing dictionaries, and query existing dictionaries to access their data."} dict (MaxFn. "dict" {:alias "dict", :doc "Use the dict object to create named dictionaries, clone existing dictionaries, and query existing dictionaries to access their data.", :href "/max8/refpages/dict", :obj-name "dict"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the sin object to calculate and output the sine of any given number."} sin (MaxFn. "sin" {:alias "sin", :doc "Use the sin object to calculate and output the sine of any given number.", :href "/max8/refpages/sin", :obj-name "sin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.strip object to remove the specified keys from a dictionary and return their values through an outlet. Following this operation, the dictionary wil"} dict.strip (MaxFn. "dict.strip" {:alias "dict.strip", :doc "Use the dict.strip object to remove the specified keys from a dictionary and return their values through an outlet. Following this operation, the dictionary wil", :href "/max8/refpages/dict.strip", :obj-name "dict.strip"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "grab can send a message and extract the result from the receiving object. Note: The grab object cannot be used to communicate from a send to a receive between M"} grab (MaxFn. "grab" {:alias "grab", :doc "grab can send a message and extract the result from the receiving object. Note: The grab object cannot be used to communicate from a send to a receive between M", :href "/max8/refpages/grab", :obj-name "grab"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Plays a movie in a separate window. All movie playback control is managed by messages to the object."} movie (MaxFn. "movie" {:alias "movie", :doc "Plays a movie in a separate window. All movie playback control is managed by messages to the object.", :href "/max8/refpages/movie", :obj-name "movie"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.join object to merge the content of two dictionaries together into a single dictionary."} dict.join (MaxFn. "dict.join" {:alias "dict.join", :doc "Use the dict.join object to merge the content of two dictionaries together into a single dictionary.", :href "/max8/refpages/dict.join", :obj-name "dict.join"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Shares data with other value objects of the same name. If you send a message (number, list, or anything else) to one value object, it is set for all value objec"} value (MaxFn. "value" {:alias "value", :doc "Shares data with other value objects of the same name. If you send a message (number, list, or anything else) to one value object, it is set for all value objec", :href "/max8/refpages/value", :obj-name "value"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Evaluates input according to a conditional statement specified in an if-then-else form."} if (MaxFn. "if" {:alias "if", :doc "Evaluates input according to a conditional statement specified in an if-then-else form.", :href "/max8/refpages/if", :obj-name "if"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Control a local Node.js process from Max. Messages preceded by script control the lifecycle of the Node script (start to start, stop to stop). Other messages wi"} node.script (MaxFn. "node.script" {:alias "node.script", :doc "Control a local Node.js process from Max. Messages preceded by script control the lifecycle of the Node script (start to start, stop to stop). Other messages wi", :href "/max8/refpages/node.script", :obj-name "node.script"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Only pass note-on messages: those having any velocity above 0."} stripnote (MaxFn. "stripnote" {:alias "stripnote", :doc "Only pass note-on messages: those having any velocity above 0.", :href "/max8/refpages/stripnote", :obj-name "stripnote"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Transmits raw MIDI data to a specified port."} midiout (MaxFn. "midiout" {:alias "midiout", :doc "Transmits raw MIDI data to a specified port.", :href "/max8/refpages/midiout", :obj-name "midiout"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} atoi (MaxFn. "atoi" {:alias "atoi", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/atoi", :obj-name "atoi"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Stores a collection of timed or untimed \"cues\" in the form of messages which can be sent either out its outlet or remotely to various receive objects in your pa"} qlist (MaxFn. "qlist" {:alias "qlist", :doc "Stores a collection of timed or untimed \"cues\" in the form of messages which can be sent either out its outlet or remotely to various receive objects in your pa", :href "/max8/refpages/qlist", :obj-name "qlist"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The clocker object is a metronome that reports the time elapsed since it was started. This object uses the Max time format syntax, so the interval that the cloc"} clocker (MaxFn. "clocker" {:alias "clocker", :doc "The clocker object is a metronome that reports the time elapsed since it was started. This object uses the Max time format syntax, so the interval that the cloc", :href "/max8/refpages/clocker", :obj-name "clocker"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} regexp (MaxFn. "regexp" {:alias "regexp", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/regexp", :obj-name "regexp"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "filein reads a file of binary data and outputs the data at various points in the file given the appropriate input."} filein (MaxFn. "filein" {:alias "filein", :doc "filein reads a file of binary data and outputs the data at various points in the file given the appropriate input.", :href "/max8/refpages/filein", :obj-name "filein"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Abstracts the contents of a patcher or subpatcher for use in other patchers, displaying only those visual elements which are desired. The number of inlets and o"} bpatcher (MaxFn. "bpatcher" {:alias "bpatcher", :doc "Abstracts the contents of a patcher or subpatcher for use in other patchers, displaying only those visual elements which are desired. The number of inlets and o", :href "/max8/refpages/bpatcher", :obj-name "bpatcher"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Output the value from a specific controller number and MIDI channel."} ctlin (MaxFn. "ctlin" {:alias "ctlin", :doc "Output the value from a specific controller number and MIDI channel.", :href "/max8/refpages/ctlin", :obj-name "ctlin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} switch (MaxFn. "switch" {:alias "switch", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/switch", :obj-name "switch"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Selectively outputs a bang in response to any input which matches its arguments and will output non-matching messages out its right-most outlet."} select (MaxFn. "select" {:alias "select", :doc "Selectively outputs a bang in response to any input which matches its arguments and will output non-matching messages out its right-most outlet.", :href "/max8/refpages/select", :obj-name "select"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs a series of messages which will set up a pop-up menu to a list of MIDI output devices when a bang is received. A number in midiinfo 's right inlet creat"} midiinfo (MaxFn. "midiinfo" {:alias "midiinfo", :doc "Outputs a series of messages which will set up a pop-up menu to a list of MIDI output devices when a bang is received. A number in midiinfo 's right inlet creat", :href "/max8/refpages/midiinfo", :obj-name "midiinfo"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Scales number from one range to another with an exponential curve. Both the input and output ranges are expressed as single arguments representing the maximum v"} linedrive (MaxFn. "linedrive" {:alias "linedrive", :doc "Scales number from one range to another with an exponential curve. Both the input and output ranges are expressed as single arguments representing the maximum v", :href "/max8/refpages/linedrive", :obj-name "linedrive"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Performs several kinds of list processing functions. You set the function with an argument, and can change the function performed with the mode message. The beh"} zl (MaxFn. "zl" {:alias "zl", :doc "Performs several kinds of list processing functions. You set the function with an argument, and can change the function performed with the mode message. The beh", :href "/max8/refpages/zl", :obj-name "zl"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides storage, viewing and editing of two-dimensional data. The format is similar to the \"grid\" display tools found in many other development environments. T"} jit.cellblock (MaxFn. "jit.cellblock" {:alias "jit.cellblock", :doc "Provides storage, viewing and editing of two-dimensional data. The format is similar to the \"grid\" display tools found in many other development environments. T", :href "/max8/refpages/jit.cellblock", :obj-name "jit.cellblock"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides input from human interface peripherals (i.e. Trackpad, Keyboard, and others)."} hi (MaxFn. "hi" {:alias "hi", :doc "Provides input from human interface peripherals (i.e. Trackpad, Keyboard, and others).", :href "/max8/refpages/hi", :obj-name "hi"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Collects and formats incoming messages as text to be output as lines of text."} text (MaxFn. "text" {:alias "text", :doc "Collects and formats incoming messages as text to be output as lines of text.", :href "/max8/refpages/text", :obj-name "text"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Check if input can fall within a specified range. If it falls within that range, it sends the number out the left outlet and if it does not, then it sends the n"} split (MaxFn. "split" {:alias "split", :doc "Check if input can fall within a specified range. If it falls within that range, it sends the number out the left outlet and if it does not, then it sends the n", :href "/max8/refpages/split", :obj-name "split"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} filedate (MaxFn. "filedate" {:alias "filedate", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/filedate", :obj-name "filedate"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs pitch bend values received from a MIDI device. The MIDI port and channel can be chosen with messages or by double-clicking on the object."} bendin (MaxFn. "bendin" {:alias "bendin", :doc "Outputs pitch bend values received from a MIDI device. The MIDI port and channel can be chosen with messages or by double-clicking on the object.", :href "/max8/refpages/bendin", :obj-name "bendin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Holds any notes with velocities of 0 until instructed to release them. This provides for sustain pedal-like behavior when working with incoming MIDI notes."} sustain (MaxFn. "sustain" {:alias "sustain", :doc "Holds any notes with velocities of 0 until instructed to release them. This provides for sustain pedal-like behavior when working with incoming MIDI notes.", :href "/max8/refpages/sustain", :obj-name "sustain"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts a stream or list of up to 256 integers into a symbol."} itoa (MaxFn. "itoa" {:alias "itoa", :doc "Converts a stream or list of up to 256 integers into a symbol.", :href "/max8/refpages/itoa", :obj-name "itoa"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Separates a list's elements by group, and send each group of items out a separate outlet."} unjoin (MaxFn. "unjoin" {:alias "unjoin", :doc "Separates a list's elements by group, and send each group of items out a separate outlet.", :href "/max8/refpages/unjoin", :obj-name "unjoin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Displays, inputs, and outputs integer numbers."} number (MaxFn. "number" {:alias "number", :doc "Displays, inputs, and outputs integer numbers.", :href "/max8/refpages/number", :obj-name "number"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides visual display of the table contents in your patcher window."} itable (MaxFn. "itable" {:alias "itable", :doc "Provides visual display of the table contents in your patcher window.", :href "/max8/refpages/itable", :obj-name "itable"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Delays numbers, lists of numbers or symbols. pipe uses the Max time format syntax, so the delay interval can be either fixed or tempo-relative."} pipe (MaxFn. "pipe" {:alias "pipe", :doc "Delays numbers, lists of numbers or symbols. pipe uses the Max time format syntax, so the delay interval can be either fixed or tempo-relative.", :href "/max8/refpages/pipe", :obj-name "pipe"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares two values to see if one value is greater than or equal to a second. Outputs a 1 if the number is greater than or equal to the comparison-number or 0 i"} >= (MaxFn. ">=" {:alias "greaterthaneq", :doc "Compares two values to see if one value is greater than or equal to a second. Outputs a 1 if the number is greater than or equal to the comparison-number or 0 i", :href "/max8/refpages/greaterthaneq", :obj-name ">="}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Tries to match a message's first argument to the route object's own arguments. Unlike the route object, routepass does not strip off the matched portion of the "} routepass (MaxFn. "routepass" {:alias "routepass", :doc "Tries to match a message's first argument to the route object's own arguments. Unlike the route object, routepass does not strip off the matched portion of the ", :href "/max8/refpages/routepass", :obj-name "routepass"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs a bang automatically when the file is opened or when the patch is part of another file that is opened."} loadbang (MaxFn. "loadbang" {:alias "loadbang", :doc "Outputs a bang automatically when the file is opened or when the patch is part of another file that is opened.", :href "/max8/refpages/loadbang", :obj-name "loadbang"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Polls and reports the state of the keyboard's modifier keys."} modifiers (MaxFn. "modifiers" {:alias "modifiers", :doc "Polls and reports the state of the keyboard's modifier keys.", :href "/max8/refpages/modifiers", :obj-name "modifiers"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Calculates and outputs the square-root of any given number."} sqrt (MaxFn. "sqrt" {:alias "sqrt", :doc "Calculates and outputs the square-root of any given number.", :href "/max8/refpages/sqrt", :obj-name "sqrt"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Produces metronomic output controllable in beats per minute, and with specifiable whole-note divisions."} tempo (MaxFn. "tempo" {:alias "tempo", :doc "Produces metronomic output controllable in beats per minute, and with specifiable whole-note divisions.", :href "/max8/refpages/tempo", :obj-name "tempo"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Numbers received in the inlets are used as data for MIDI messages. The data is formatted into a complete MIDI message (with the status byte determined by the in"} midiformat (MaxFn. "midiformat" {:alias "midiformat", :doc "Numbers received in the inlets are used as data for MIDI messages. The data is formatted into a complete MIDI message (with the status byte determined by the in", :href "/max8/refpages/midiformat", :obj-name "midiformat"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.view object to view the contents of a dictionary."} dict.view (MaxFn. "dict.view" {:alias "dict.view", :doc "Use the dict.view object to view the contents of a dictionary.", :href "/max8/refpages/dict.view", :obj-name "dict.view"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Performs a bit-by-bit AND of two numbers as expressed in binary. Outputs a number composed of all those bits which are 1 in both of the two numbers."} & (MaxFn. "&" {:alias "bitand", :doc "Performs a bit-by-bit AND of two numbers as expressed in binary. Outputs a number composed of all those bits which are 1 in both of the two numbers.", :href "/max8/refpages/bitand", :obj-name "&"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs the current time of a transport in ticks and bars/beats/units."} when (MaxFn. "when" {:alias "when", :doc "Outputs the current time of a transport in ticks and bars/beats/units.", :href "/max8/refpages/when", :obj-name "when"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the tan object to calculate and output the tangent of any given number."} tan (MaxFn. "tan" {:alias "tan", :doc "Use the tan object to calculate and output the tangent of any given number.", :href "/max8/refpages/tan", :obj-name "tan"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.deserialize object to create a dictionary from text passed in using Max's dictionary syntax or JSON. Alternatively, compressed forms of either form"} dict.deserialize (MaxFn. "dict.deserialize" {:alias "dict.deserialize", :doc "Use the dict.deserialize object to create a dictionary from text passed in using Max's dictionary syntax or JSON. Alternatively, compressed forms of either form", :href "/max8/refpages/dict.deserialize", :obj-name "dict.deserialize"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the cos object to calculate and output the cosine of any given number."} cos (MaxFn. "cos" {:alias "cos", :doc "Use the cos object to calculate and output the cosine of any given number.", :href "/max8/refpages/cos", :obj-name "cos"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Draw or store a set of x, y points as floating-point numbers. The output the entire function is useful as an input for line~. You can also get an interpolated y"} function (MaxFn. "function" {:alias "function", :doc "Draw or store a set of x, y points as floating-point numbers. The output the entire function is useful as an input for line~. You can also get an interpolated y", :href "/max8/refpages/function", :obj-name "function"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.route object to compare two dictionaries. If the dictionary received at the left inlet meets the specifications set by the dictionary at the right "} dict.route (MaxFn. "dict.route" {:alias "dict.route", :doc "Use the dict.route object to compare two dictionaries. If the dictionary received at the left inlet meets the specifications set by the dictionary at the right ", :href "/max8/refpages/dict.route", :obj-name "dict.route"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Records and outputs histogram data of the numbers it receives."} histo (MaxFn. "histo" {:alias "histo", :doc "Records and outputs histogram data of the numbers it receives.", :href "/max8/refpages/histo", :obj-name "histo"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} polyin (MaxFn. "polyin" {:alias "polyin", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/polyin", :obj-name "polyin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Generates a linear ramp driven by incoming bang messages. It takes a list of breakpoint segments (and the number of events to span) and outputs a smooth ramp be"} bline (MaxFn. "bline" {:alias "bline", :doc "Generates a linear ramp driven by incoming bang messages. It takes a list of breakpoint segments (and the number of events to span) and outputs a smooth ramp be", :href "/max8/refpages/bline", :obj-name "bline"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Generate ramps and line segments from one value to another within a specified amount of time."} line (MaxFn. "line" {:alias "line", :doc "Generate ramps and line segments from one value to another within a specified amount of time.", :href "/max8/refpages/line", :obj-name "line"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The standalone object lets you set options for creating a standalone application from a Max patch, and is used in conjunction with the Build Application/Collect"} standalone (MaxFn. "standalone" {:alias "standalone", :doc "The standalone object lets you set options for creating a standalone application from a Max patch, and is used in conjunction with the Build Application/Collect", :href "/max8/refpages/standalone", :obj-name "standalone"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Allows for the storage, organization, editing, and retrieval of different messages."} coll (MaxFn. "coll" {:alias "coll", :doc "Allows for the storage, organization, editing, and retrieval of different messages.", :href "/max8/refpages/coll", :obj-name "coll"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Displays nodes in a 2-dimensional space, and calculates the distance from a node points."} nodes (MaxFn. "nodes" {:alias "nodes", :doc "Displays nodes in a 2-dimensional space, and calculates the distance from a node points.", :href "/max8/refpages/nodes", :obj-name "nodes"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs a MIDI note-on message paired with a velocity value followed by a note-off message after a specified amount of time. This allows for generative MIDI out"} makenote (MaxFn. "makenote" {:alias "makenote", :doc "Outputs a MIDI note-on message paired with a velocity value followed by a note-off message after a specified amount of time. This allows for generative MIDI out", :href "/max8/refpages/makenote", :obj-name "makenote"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Matches messages to its own arguments; whenever it finds a match, will make the appropriate substitution."} substitute (MaxFn. "substitute" {:alias "substitute", :doc "Matches messages to its own arguments; whenever it finds a match, will make the appropriate substitution.", :href "/max8/refpages/substitute", :obj-name "substitute"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} textbutton (MaxFn. "textbutton" {:alias "textbutton", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/textbutton", :obj-name "textbutton"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Allows a bang in the left inlet to pass through ONLY if a bang has been received in the right inlet. After that, a bang in the left inlet will not get through a"} onebang (MaxFn. "onebang" {:alias "onebang", :doc "Allows a bang in the left inlet to pass through ONLY if a bang has been received in the right inlet. After that, a bang in the left inlet will not get through a", :href "/max8/refpages/onebang", :obj-name "onebang"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides access to the Max search path, and allows modification to the search path used by a patch."} filepath (MaxFn. "filepath" {:alias "filepath", :doc "Provides access to the Max search path, and allows modification to the search path used by a patch.", :href "/max8/refpages/filepath", :obj-name "filepath"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Holds a bang for a specified amount of time before sending it to the next object. This object uses the Max time format syntax, so the delay time (which is norma"} delay (MaxFn. "delay" {:alias "delay", :doc "Holds a bang for a specified amount of time before sending it to the next object. This object uses the Max time format syntax, so the delay time (which is norma", :href "/max8/refpages/delay", :obj-name "delay"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Output bangs for 0-to-1 transitions out the left outlet, and bangs the right outlet for 1-to-0 transitions. Outlets alternate output when bangs are received."} togedge (MaxFn. "togedge" {:alias "togedge", :doc "Output bangs for 0-to-1 transitions out the left outlet, and bangs the right outlet for 1-to-0 transitions. Outlets alternate output when bangs are received.", :href "/max8/refpages/togedge", :obj-name "togedge"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Allows messages to pass only when the mouse button is up (un-clicked)."} mousefilter (MaxFn. "mousefilter" {:alias "mousefilter", :doc "Allows messages to pass only when the mouse button is up (un-clicked).", :href "/max8/refpages/mousefilter", :obj-name "mousefilter"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "When clicked, toggle outputs a 0 when turned off and a 1 when turned on. When giving input, a non-zero number will turn it on, a 0 will turn it off, and a bang "} toggle (MaxFn. "toggle" {:alias "toggle", :doc "When clicked, toggle outputs a 0 when turned off and a 1 when turned on. When giving input, a non-zero number will turn it on, a 0 will turn it off, and a bang ", :href "/max8/refpages/toggle", :obj-name "toggle"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares two values to see if one value is less than a second. Outputs a 1 if the number is less than the comparison-number or 0 if it is equal to or greater th"} < (MaxFn. "<" {:alias "lessthan", :doc "Compares two values to see if one value is less than a second. Outputs a 1 if the number is less than the comparison-number or 0 if it is equal to or greater th", :href "/max8/refpages/lessthan", :obj-name "<"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Displays data as either an array of sliders or a scrolling display. When configured as sliders, the values are set (and output) as numeric lists. When configure"} multislider (MaxFn. "multislider" {:alias "multislider", :doc "Displays data as either an array of sliders or a scrolling display. When configured as sliders, the values are set (and output) as numeric lists. When configure", :href "/max8/refpages/multislider", :obj-name "multislider"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Sends a input message to all instances of the same class of object in a patcher. The order in which the messages arrive is not defined."} universal (MaxFn. "universal" {:alias "universal", :doc "Sends a input message to all instances of the same class of object in a patcher. The order in which the messages arrive is not defined.", :href "/max8/refpages/universal", :obj-name "universal"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Receives messages transmitted over a network using the User Datagram Protocol (UDP)."} udpreceive (MaxFn. "udpreceive" {:alias "udpreceive", :doc "Receives messages transmitted over a network using the User Datagram Protocol (UDP).", :href "/max8/refpages/udpreceive", :obj-name "udpreceive"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The vdp object works with serially-controlled videodisk players (remember them?) that are compatible with the Pioneer 4200 or 8000 standard. Each command receiv"} vdp (MaxFn. "vdp" {:alias "vdp", :doc "The vdp object works with serially-controlled videodisk players (remember them?) that are compatible with the Pioneer 4200 or 8000 standard. Each command receiv", :href "/max8/refpages/vdp", :obj-name "vdp"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Transmits note-on and note-off messages to a MIDI device."} noteout (MaxFn. "noteout" {:alias "noteout", :doc "Transmits note-on and note-off messages to a MIDI device.", :href "/max8/refpages/noteout", :obj-name "noteout"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts paths between the older colon style formats and the current slash style. It can also be used to conform paths to either absolute, relative, boot volume"} conformpath (MaxFn. "conformpath" {:alias "conformpath", :doc "Converts paths between the older colon style formats and the current slash style. It can also be used to conform paths to either absolute, relative, boot volume", :href "/max8/refpages/conformpath", :obj-name "conformpath"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "A slider control that uses pictures in external files for its appearance. It uses two pictures--one for the \"knob\" and one for the background over which the kno"} pictslider (MaxFn. "pictslider" {:alias "pictslider", :doc "A slider control that uses pictures in external files for its appearance. It uses two pictures--one for the \"knob\" and one for the background over which the kno", :href "/max8/refpages/pictslider", :obj-name "pictslider"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Shifts all bit values to the left. This has the effect of multiplying a number by a power of two, but is less expensive in computer time."} << (MaxFn. "<<" {:alias "shiftleft", :doc "Shifts all bit values to the left. This has the effect of multiplying a number by a power of two, but is less expensive in computer time.", :href "/max8/refpages/shiftleft", :obj-name "<<"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides a user interface within a patcher which can collect typed-in text from the computer-keyboard."} textedit (MaxFn. "textedit" {:alias "textedit", :doc "Provides a user interface within a patcher which can collect typed-in text from the computer-keyboard.", :href "/max8/refpages/textedit", :obj-name "textedit"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs the absolute (non-negative) value of any given number. Floats will be output only if the argument to abs is a float."} abs (MaxFn. "abs" {:alias "abs", :doc "Outputs the absolute (non-negative) value of any given number. Floats will be output only if the argument to abs is a float.", :href "/max8/refpages/abs", :obj-name "abs"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Allows the creation of alternatives to the standard millisecond clock. This includes several modes of timing that change timing activities. Each setclock is ass"} setclock (MaxFn. "setclock" {:alias "setclock", :doc "Allows the creation of alternatives to the standard millisecond clock. This includes several modes of timing that change timing activities. Each setclock is ass", :href "/max8/refpages/setclock", :obj-name "setclock"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The pak object (pronounced \"pock\") offers much of the functionality of pack, but outputs the entire list whenever input is received in any inlet."} pak (MaxFn. "pak" {:alias "pak", :doc "The pak object (pronounced \"pock\") offers much of the functionality of pack, but outputs the entire list whenever input is received in any inlet.", :href "/max8/refpages/pak", :obj-name "pak"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Watches an incoming stream of ints, floats, symbols, lists, or messages, and outputs the stream after it has met the specification of its arguments."} match (MaxFn. "match" {:alias "match", :doc "Watches an incoming stream of ints, floats, symbols, lists, or messages, and outputs the stream after it has met the specification of its arguments.", :href "/max8/refpages/match", :obj-name "match"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "dropfile defines a region for dragging and dropping files into and then outputs the filepath and filetype upon file input."} dropfile (MaxFn. "dropfile" {:alias "dropfile", :doc "dropfile defines a region for dragging and dropping files into and then outputs the filepath and filetype upon file input.", :href "/max8/refpages/dropfile", :obj-name "dropfile"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Creates a transparant click-able region that can be placed over graphics or other objects. Produces a bang message when clicked."} ubutton (MaxFn. "ubutton" {:alias "ubutton", :doc "Creates a transparant click-able region that can be placed over graphics or other objects. Produces a bang message when clicked.", :href "/max8/refpages/ubutton", :obj-name "ubutton"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Maps an input range of values and to an output range of values. Similar to scale, but clips values to the ranges, and does not allow inverted scaling."} zmap (MaxFn. "zmap" {:alias "zmap", :doc "Maps an input range of values and to an output range of values. Similar to scale, but clips values to the ranges, and does not allow inverted scaling.", :href "/max8/refpages/zmap", :obj-name "zmap"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides 2-dimensional selection and display of colors, representing hue along the horizontal axis and lightness along the vertical axis. A third color dimensio"} swatch (MaxFn. "swatch" {:alias "swatch", :doc "Provides 2-dimensional selection and display of colors, representing hue along the horizontal axis and lightness along the vertical axis. A third color dimensio", :href "/max8/refpages/swatch", :obj-name "swatch"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Set the background color of the patcher window. The bgcolor object's functionality is equivalent to a brgb message sent to thispatcher."} bgcolor (MaxFn. "bgcolor" {:alias "bgcolor", :doc "Set the background color of the patcher window. The bgcolor object's functionality is equivalent to a brgb message sent to thispatcher.", :href "/max8/refpages/bgcolor", :obj-name "bgcolor"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The pattrmarker object associates a patcher with a global name, which can be used when looking up named objects. This permits, among other conveniences, name lo"} pattrmarker (MaxFn. "pattrmarker" {:alias "pattrmarker", :doc "The pattrmarker object associates a patcher with a global name, which can be used when looking up named objects. This permits, among other conveniences, name lo", :href "/max8/refpages/pattrmarker", :obj-name "pattrmarker"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "append will add arguments to the end of any message you input."} append (MaxFn. "append" {:alias "append", :doc "append will add arguments to the end of any message you input.", :href "/max8/refpages/append", :obj-name "append"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Takes separate untyped items and combines them into an output list."} join (MaxFn. "join" {:alias "join", :doc "Takes separate untyped items and combines them into an output list.", :href "/max8/refpages/join", :obj-name "join"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the opendialog object to select a file of a specific type or folder from a standard dialog window. To choose a folder, use the \"fold\" type. opendialog repor"} opendialog (MaxFn. "opendialog" {:alias "opendialog", :doc "Use the opendialog object to select a file of a specific type or folder from a standard dialog window. To choose a folder, use the \"fold\" type. opendialog repor", :href "/max8/refpages/opendialog", :obj-name "opendialog"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides score playback managed using Max messages. The score may be loaded from a MIDI file, or generated using Max functions. The score is not limited to MIDI"} detonate (MaxFn. "detonate" {:alias "detonate", :doc "Provides score playback managed using Max messages. The score may be loaded from a MIDI file, or generated using Max functions. The score is not limited to MIDI", :href "/max8/refpages/detonate", :obj-name "detonate"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Receive messages from outside the patcher wherever it is embedded. Each inlet object in a patcher will show up as an inlet at the top of an object box when the "} inlet (MaxFn. "inlet" {:alias "inlet", :doc "Receive messages from outside the patcher wherever it is embedded. Each inlet object in a patcher will show up as an inlet at the top of an object box when the ", :href "/max8/refpages/inlet", :obj-name "inlet"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Retrieves patcher arguments and parses attribute style arguments. \"normal\" arguments are sent out the left outlet (first), and attribute style arguments are sen"} patcherargs (MaxFn. "patcherargs" {:alias "patcherargs", :doc "Retrieves patcher arguments and parses attribute style arguments. \"normal\" arguments are sent out the left outlet (first), and attribute style arguments are sen", :href "/max8/refpages/patcherargs", :obj-name "patcherargs"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} router (MaxFn. "router" {:alias "router", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/router", :obj-name "router"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "print will print any input into the Max Console for debugging, messaging, or analysis purposes. Selecting \"Show Output\" from the Object Action Menu opens the si"} print (MaxFn. "print" {:alias "print", :doc "print will print any input into the Max Console for debugging, messaging, or analysis purposes. Selecting \"Show Output\" from the Object Action Menu opens the si", :href "/max8/refpages/print", :obj-name "print"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Reports the current date, time, or the number of 1/60th-second ticks since startup."} date (MaxFn. "date" {:alias "date", :doc "Reports the current date, time, or the number of 1/60th-second ticks since startup.", :href "/max8/refpages/date", :obj-name "date"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Interacts with movie, imovie, sfplay~ or jit.movie to control the playback, position and looping of the media"} playbar (MaxFn. "playbar" {:alias "playbar", :doc "Interacts with movie, imovie, sfplay~ or jit.movie to control the playback, position and looping of the media", :href "/max8/refpages/playbar", :obj-name "playbar"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Stores items in the order they are received for viewing, editing, and saving."} capture (MaxFn. "capture" {:alias "capture", :doc "Stores items in the order they are received for viewing, editing, and saving.", :href "/max8/refpages/capture", :obj-name "capture"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Tracks and outputs the key-codes, ASCII values, and modifier-key values of key releases on the computer keyboard."} keyup (MaxFn. "keyup" {:alias "keyup", :doc "Tracks and outputs the key-codes, ASCII values, and modifier-key values of key releases on the computer keyboard.", :href "/max8/refpages/keyup", :obj-name "keyup"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares a number to a previous peak-value and, if larger, it is sent out the output while the new peak-value is set to that number."} peak (MaxFn. "peak" {:alias "peak", :doc "Compares a number to a previous peak-value and, if larger, it is sent out the output while the new peak-value is set to that number.", :href "/max8/refpages/peak", :obj-name "peak"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} lcd (MaxFn. "lcd" {:alias "lcd", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/lcd", :obj-name "lcd"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Performs MIDI-note-number to frequency conversion. Frequency is reported in as a float in Hertz (Hz)."} mtof (MaxFn. "mtof" {:alias "mtof", :doc "Performs MIDI-note-number to frequency conversion. Frequency is reported in as a float in Hertz (Hz).", :href "/max8/refpages/mtof", :obj-name "mtof"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Allows modification of a patcher window with Max messages."} thispatcher (MaxFn. "thispatcher" {:alias "thispatcher", :doc "Allows modification of a patcher window with Max messages.", :href "/max8/refpages/thispatcher", :obj-name "thispatcher"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs bang messages at a set interval. Similar to metro, qmetro will drop output if the processing queue is overloaded."} qmetro (MaxFn. "qmetro" {:alias "qmetro", :doc "Outputs bang messages at a set interval. Similar to metro, qmetro will drop output if the processing queue is overloaded.", :href "/max8/refpages/qmetro", :obj-name "qmetro"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "follow records pitches, or you can give it a MIDI file, in which case it looks at the file's note-ons and ignores other events. When it is \"following\" it output"} follow (MaxFn. "follow" {:alias "follow", :doc "follow records pitches, or you can give it a MIDI file, in which case it looks at the file's note-ons and ignores other events. When it is \"following\" it output", :href "/max8/refpages/follow", :obj-name "follow"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The panel object lets you create colored panels for use in creating user interfaces. The panel can be a variety of shapes, including circles, triangles, arrows,"} panel (MaxFn. "panel" {:alias "panel", :doc "The panel object lets you create colored panels for use in creating user interfaces. The panel can be a variety of shapes, including circles, triangles, arrows,", :href "/max8/refpages/panel", :obj-name "panel"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the atanh object to calculate and output the hyperbolic arc-tangent of any given number."} atanh (MaxFn. "atanh" {:alias "atanh", :doc "Use the atanh object to calculate and output the hyperbolic arc-tangent of any given number.", :href "/max8/refpages/atanh", :obj-name "atanh"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "nslider or \"Note Slider\" is a musical-notation-based integer value slider."} nslider (MaxFn. "nslider" {:alias "nslider", :doc "nslider or \"Note Slider\" is a musical-notation-based integer value slider.", :href "/max8/refpages/nslider", :obj-name "nslider"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Displays text as a pop-up menu. Selections can be made manually, or set incoming numbers. Outputs both selection number and selection text."} umenu (MaxFn. "umenu" {:alias "umenu", :doc "Displays text as a pop-up menu. Selections can be made manually, or set incoming numbers. Outputs both selection number and selection text.", :href "/max8/refpages/umenu", :obj-name "umenu"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs and displays note and velocity information using an on-screen keyboard."} kslider (MaxFn. "kslider" {:alias "kslider", :doc "Outputs and displays note and velocity information using an on-screen keyboard.", :href "/max8/refpages/kslider", :obj-name "kslider"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Receives and outputs MIDI real time messages transmitted from a specified MIDI input device."} rtin (MaxFn. "rtin" {:alias "rtin", :doc "Receives and outputs MIDI real time messages transmitted from a specified MIDI input device.", :href "/max8/refpages/rtin", :obj-name "rtin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "active will output a 1 when the Patcher window becomes active (i.e., it is the front-most window and its title bar is highlighted), and output a 0 when the Patc"} active (MaxFn. "active" {:alias "active", :doc "active will output a 1 when the Patcher window becomes active (i.e., it is the front-most window and its title bar is highlighted), and output a 0 when the Patc", :href "/max8/refpages/active", :obj-name "active"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "midiselect receives raw MIDI bytes and separates the input stream. MIDI data to be selected for output is set using object attributes. There is a separate data "} midiselect (MaxFn. "midiselect" {:alias "midiselect", :doc "midiselect receives raw MIDI bytes and separates the input stream. MIDI data to be selected for output is set using object attributes. There is a separate data ", :href "/max8/refpages/midiselect", :obj-name "midiselect"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} gswitch (MaxFn. "gswitch" {:alias "gswitch", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/gswitch", :obj-name "gswitch"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Unpacks and outputs list contents one element at a time."} iter (MaxFn. "iter" {:alias "iter", :doc "Unpacks and outputs list contents one element at a time.", :href "/max8/refpages/iter", :obj-name "iter"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "comment displays text which is typed into it in order to serve as a label or explanatory text."} comment (MaxFn. "comment" {:alias "comment", :doc "comment displays text which is typed into it in order to serve as a label or explanatory text.", :href "/max8/refpages/comment", :obj-name "comment"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Sends out the scripting names of any object over which the cursor is hovering."} hover (MaxFn. "hover" {:alias "hover", :doc "Sends out the scripting names of any object over which the cursor is hovering.", :href "/max8/refpages/hover", :obj-name "hover"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Acts as a metronome which outputs bang s at a regular, specified interval. This object uses the Max time format syntax, so the interval that the metro object us"} metro (MaxFn. "metro" {:alias "metro", :doc "Acts as a metronome which outputs bang s at a regular, specified interval. This object uses the Max time format syntax, so the interval that the metro object us", :href "/max8/refpages/metro", :obj-name "metro"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the sinh object to calculate and output the hyperbolic sine of any given number."} sinh (MaxFn. "sinh" {:alias "sinh", :doc "Use the sinh object to calculate and output the hyperbolic sine of any given number.", :href "/max8/refpages/sinh", :obj-name "sinh"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts a cartesian-coordinate pair consisting of real and imaginary values into a polar-coordinate pair consisting of distance and angle values."} cartopol (MaxFn. "cartopol" {:alias "cartopol", :doc "Converts a cartesian-coordinate pair consisting of real and imaginary values into a polar-coordinate pair consisting of distance and angle values.", :href "/max8/refpages/cartopol", :obj-name "cartopol"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Combines a list of items into a single symbol. It works similar to pack and sprintf. The behavior can be modified with attributes that provide number padding an"} combine (MaxFn. "combine" {:alias "combine", :doc "Combines a list of items into a single symbol. It works similar to pack and sprintf. The behavior can be modified with attributes that provide number padding an", :href "/max8/refpages/combine", :obj-name "combine"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the asinh object to calculate and output the hyperbolic arc-sine of any given number."} asinh (MaxFn. "asinh" {:alias "asinh", :doc "Use the asinh object to calculate and output the hyperbolic arc-sine of any given number.", :href "/max8/refpages/asinh", :obj-name "asinh"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares one number to another and outputs a 1 if the either number is non-zero or a 0 if both number are 0."} || (MaxFn. "||" {:alias "logor", :doc "Compares one number to another and outputs a 1 if the either number is non-zero or a 0 if both number are 0.", :href "/max8/refpages/logor", :obj-name "||"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Subtracts the input from a specified value The !- object functions just like the - object, but the inlets' functions are reversed."} !- (MaxFn. "!-" {:alias "rminus", :doc "Subtracts the input from a specified value The !- object functions just like the - object, but the inlets' functions are reversed.", :href "/max8/refpages/rminus", :obj-name "!-"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} pgmout (MaxFn. "pgmout" {:alias "pgmout", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/pgmout", :obj-name "pgmout"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs any input received in order from right to left and formatted according to the object-argument specified."} trigger (MaxFn. "trigger" {:alias "trigger", :doc "Outputs any input received in order from right to left and formatted according to the object-argument specified.", :href "/max8/refpages/trigger", :obj-name "trigger"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Calculates and outputs an integer multiple of any given number."} round (MaxFn. "round" {:alias "round", :doc "Calculates and outputs an integer multiple of any given number.", :href "/max8/refpages/round", :obj-name "round"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Breaks a list into its elements, and sends each item out a separate outlet."} unpack (MaxFn. "unpack" {:alias "unpack", :doc "Breaks a list into its elements, and sends each item out a separate outlet.", :href "/max8/refpages/unpack", :obj-name "unpack"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Opens a file dialog for selection or entry of a filename to write. savedialog takes a list of one or more file types and allows you to save a file and choose a "} savedialog (MaxFn. "savedialog" {:alias "savedialog", :doc "Opens a file dialog for selection or entry of a filename to write. savedialog takes a list of one or more file types and allows you to save a file and choose a ", :href "/max8/refpages/savedialog", :obj-name "savedialog"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the filterdetail object to produce details from a filter specification provided as input. The filter specification may be generated by the filterdesign obje"} filterdetail (MaxFn. "filterdetail" {:alias "filterdetail", :doc "Use the filterdetail object to produce details from a filter specification provided as input. The filter specification may be generated by the filterdesign obje", :href "/max8/refpages/filterdetail", :obj-name "filterdetail"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Slows down throughput of messages. Limiting is based on a minimum amount of time between passed message."} qlim (MaxFn. "qlim" {:alias "qlim", :doc "Slows down throughput of messages. Limiting is based on a minimum amount of time between passed message.", :href "/max8/refpages/qlim", :obj-name "qlim"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Identifies the inlet of incoming data. It can be used to store values into a table or coll based on their source, or used to set a destination with an object su"} funnel (MaxFn. "funnel" {:alias "funnel", :doc "Identifies the inlet of incoming data. It can be used to store values into a table or coll based on their source, or used to set a destination with an object su", :href "/max8/refpages/funnel", :obj-name "funnel"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares two values to see if one value is equal to a second. Outputs a 1 if the number is equal to the comparison-number or 0 if it is not."} == (MaxFn. "==" {:alias "equals", :doc "Compares two values to see if one value is equal to a second. Outputs a 1 if the number is equal to the comparison-number or 0 if it is not.", :href "/max8/refpages/equals", :obj-name "=="}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Creates patches within patches."} patcher (MaxFn. "patcher" {:alias "patcher", :doc "Creates patches within patches.", :href "/max8/refpages/patcher", :obj-name "patcher"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs from MIDI aftertouch (channel pressure) messages received from a MIDI input device."} touchin (MaxFn. "touchin" {:alias "touchin", :doc "Outputs from MIDI aftertouch (channel pressure) messages received from a MIDI input device.", :href "/max8/refpages/touchin", :obj-name "touchin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} xnoteout (MaxFn. "xnoteout" {:alias "xnoteout", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/xnoteout", :obj-name "xnoteout"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Outputs numbers according to its degree of rotation. dial can be set with a certain range, offset, multiplier, as well as numerous visual settings."} dial (MaxFn. "dial" {:alias "dial", :doc "Outputs numbers according to its degree of rotation. dial can be set with a certain range, offset, multiplier, as well as numerous visual settings.", :href "/max8/refpages/dial", :obj-name "dial"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the asin object to calculate and output the arc-sine of any given number."} asin (MaxFn. "asin" {:alias "asin", :doc "Use the asin object to calculate and output the arc-sine of any given number.", :href "/max8/refpages/asin", :obj-name "asin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Acts as a 14-bit pitch bend filter/processor and xbendin2 serves as a 2-byte pitch bend filter/processor."} xbendin (MaxFn. "xbendin" {:alias "xbendin", :doc "Acts as a 14-bit pitch bend filter/processor and xbendin2 serves as a 2-byte pitch bend filter/processor.", :href "/max8/refpages/xbendin", :obj-name "xbendin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} + (MaxFn. "+" {:alias "plus", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/plus", :obj-name "+"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides a user interface to query attribute values from an object. You can also retrieve a list of all available attributes for the attached object."} getattr (MaxFn. "getattr" {:alias "getattr", :doc "Provides a user interface to query attribute values from an object. You can also retrieve a list of all available attributes for the attached object.", :href "/max8/refpages/getattr", :obj-name "getattr"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Receives and outputs messages from send objects sharing the same name. This allows you to send any kind of message between Patcher windows or within a window wi"} receive (MaxFn. "receive" {:alias "receive", :doc "Receives and outputs messages from send objects sharing the same name. This allows you to send any kind of message between Patcher windows or within a window wi", :href "/max8/refpages/receive", :obj-name "receive"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Accepts lists as input, where the first number is taken as the outlet number, and one or more values that follow are sent out that outlet and those to its right"} spray (MaxFn. "spray" {:alias "spray", :doc "Accepts lists as input, where the first number is taken as the outlet number, and one or more values that follow are sent out that outlet and those to its right", :href "/max8/refpages/spray", :obj-name "spray"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the tanh object to calculate and output the hyperbolic tangent of any given number."} tanh (MaxFn. "tanh" {:alias "tanh", :doc "Use the tanh object to calculate and output the hyperbolic tangent of any given number.", :href "/max8/refpages/tanh", :obj-name "tanh"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use attrui object to inspect the attribute values of the object(s) it is connected to."} attrui (MaxFn. "attrui" {:alias "attrui", :doc "Use attrui object to inspect the attribute values of the object(s) it is connected to.", :href "/max8/refpages/attrui", :obj-name "attrui"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} pgmin (MaxFn. "pgmin" {:alias "pgmin", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/pgmin", :obj-name "pgmin"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Transmits MIDI pitchbend values to a MIDI device."} bendout (MaxFn. "bendout" {:alias "bendout", :doc "Transmits MIDI pitchbend values to a MIDI device.", :href "/max8/refpages/bendout", :obj-name "bendout"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online"} led (MaxFn. "led" {:alias "led", :doc "Cycling '74 Max Online Documentation. Browse and search the Max MSP Documentation and Reference online", :href "/max8/refpages/led", :obj-name "led"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Creates a value that is shared between objects, but only within a single patcher. Unlike the value object, pv objects that share the same name only share the sa"} pv (MaxFn. "pv" {:alias "pv", :doc "Creates a value that is shared between objects, but only within a single patcher. Unlike the value object, pv objects that share the same name only share the sa", :href "/max8/refpages/pv", :obj-name "pv"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Provides an environment to make user interface elements using Javascript. This provides all of the programming tools available in the js object, but also expose"} jsui (MaxFn. "jsui" {:alias "jsui", :doc "Provides an environment to make user interface elements using Javascript. This provides all of the programming tools available in the js object, but also expose", :href "/max8/refpages/jsui", :obj-name "jsui"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The chooser object is similar to the umenu object, but it displays a scrolling list of selectable items rather than a pop-up menu."} chooser (MaxFn. "chooser" {:alias "chooser", :doc "The chooser object is similar to the umenu object, but it displays a scrolling list of selectable items rather than a pop-up menu.", :href "/max8/refpages/chooser", :obj-name "chooser"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Output a number only if it is different from the stored number and will reset the stored number to that differing input number. Alternate modes of operation als"} change (MaxFn. "change" {:alias "change", :doc "Output a number only if it is different from the stored number and will reset the stored number to that differing input number. Alternate modes of operation als", :href "/max8/refpages/change", :obj-name "change"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts frequency, given in Hertz, to a MIDI pitch or note number (0-127)."} ftom (MaxFn. "ftom" {:alias "ftom", :doc "Converts frequency, given in Hertz, to a MIDI pitch or note number (0-127).", :href "/max8/refpages/ftom", :obj-name "ftom"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "button blinks when you send it any message, and it sends out a bang when you click on it."} button (MaxFn. "button" {:alias "button", :doc "button blinks when you send it any message, and it sends out a bang when you click on it.", :href "/max8/refpages/button", :obj-name "button"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "timer starts keeping time when a bang is sent to the left inlet. The right outlet can report elapsed time in milliseconds or one of the Max time format options,"} timer (MaxFn. "timer" {:alias "timer", :doc "timer starts keeping time when a bang is sent to the left inlet. The right outlet can report elapsed time in milliseconds or one of the Max time format options,", :href "/max8/refpages/timer", :obj-name "timer"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Converts an absolute path to one that is relative to the Max application folder."} relativepath (MaxFn. "relativepath" {:alias "relativepath", :doc "Converts an absolute path to one that is relative to the Max application folder.", :href "/max8/refpages/relativepath", :obj-name "relativepath"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.unpack object to return the values of specified keys through dedicated outlets."} dict.unpack (MaxFn. "dict.unpack" {:alias "dict.unpack", :doc "Use the dict.unpack object to return the values of specified keys through dedicated outlets.", :href "/max8/refpages/dict.unpack", :obj-name "dict.unpack"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Divides a number by the incoming value. Functions like the / object, but the inlets' functions are reversed."} rdiv (MaxFn. "!/" {:alias "rdiv", :doc "Divides a number by the incoming value. Functions like the / object, but the inlets' functions are reversed.", :href "/max8/refpages/rdiv", :obj-name "!/"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Reports the resolution to which the computer's monitor is currently set."} screensize (MaxFn. "screensize" {:alias "screensize", :doc "Reports the resolution to which the computer's monitor is currently set.", :href "/max8/refpages/screensize", :obj-name "screensize"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the acos object to calculate and output the arc-cosine of any given number."} acos (MaxFn. "acos" {:alias "acos", :doc "Use the acos object to calculate and output the arc-cosine of any given number.", :href "/max8/refpages/acos", :obj-name "acos"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.serialize object to output a serialized form of the contents of dictionary in text format. The text may be Dictionary Syntax, JSON, or Base64-compr"} dict.serialize (MaxFn. "dict.serialize" {:alias "dict.serialize", :doc "Use the dict.serialize object to output a serialized form of the contents of dictionary in text format. The text may be Dictionary Syntax, JSON, or Base64-compr", :href "/max8/refpages/dict.serialize", :obj-name "dict.serialize"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Compares two values to see if one value is greater than a second. Outputs a 1 if the number is greater than the comparison-number or 0 if it is less than or equ"} > (MaxFn. ">" {:alias "greaterthan", :doc "Compares two values to see if one value is greater than a second. Outputs a 1 if the number is greater than the comparison-number or 0 if it is less than or equ", :href "/max8/refpages/greaterthan", :obj-name ">"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Records messages and provides sequenced playback."} mtr (MaxFn. "mtr" {:alias "mtr", :doc "Records messages and provides sequenced playback.", :href "/max8/refpages/mtr", :obj-name "mtr"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Swaps the values of its inlets, preserving right-to-left ordering. The first outlet type is determined by its argument. The second outlet's type is always an in"} swap (MaxFn. "swap" {:alias "swap", :doc "Swaps the values of its inlets, preserving right-to-left ordering. The first outlet type is determined by its argument. The second outlet's type is always an in", :href "/max8/refpages/swap", :obj-name "swap"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the dict.group object to build up a dictionary by sending key-value pairs as lists. The key-value pairs will be collected into the dictionary until a 'bang'"} dict.group (MaxFn. "dict.group" {:alias "dict.group", :doc "Use the dict.group object to build up a dictionary by sending key-value pairs as lists. The key-value pairs will be collected into the dictionary until a 'bang'", :href "/max8/refpages/dict.group", :obj-name "dict.group"}))
;; MSP
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The plugout~ object sends its output to the Live application as part of a Max for Live Audio device or Instrument."} plugout- (MaxFn. "plugout~" {:alias "plugout~", :doc "The plugout~ object sends its output to the Live application as part of a Max for Live Audio device or Instrument.", :href "/max8/refpages/plugout~", :obj-name "plugout~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "framedelta~ computes a running phase deviation by subtracting values in each position of its previously received signal vector from the current signal vector. W"} framedelta- (MaxFn. "framedelta~" {:alias "framedelta~", :doc "framedelta~ computes a running phase deviation by subtracting values in each position of its previously received signal vector from the current signal vector. W", :href "/max8/refpages/framedelta~", :obj-name "framedelta~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "freqshift~ is a time-domain frequency shifter (also known as a single-sideband ring modulator)."} freqshift- (MaxFn. "freqshift~" {:alias "freqshift~", :doc "freqshift~ is a time-domain frequency shifter (also known as a single-sideband ring modulator).", :href "/max8/refpages/freqshift~", :obj-name "freqshift~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the rect~ object to generate an anti-aliased rectangle wave."} rect- (MaxFn. "rect~" {:alias "rect~", :doc "Use the rect~ object to generate an anti-aliased rectangle wave.", :href "/max8/refpages/rect~", :obj-name "rect~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "phasewrap~ takes any input signal and wrap it between π and -π values."} phasewrap- (MaxFn. "phasewrap~" {:alias "phasewrap~", :doc "phasewrap~ takes any input signal and wrap it between π and -π values.", :href "/max8/refpages/phasewrap~", :obj-name "phasewrap~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the edge~ to detect zero to non-zero (and vice versa) signal transitions and report a bang out of one of its two outlets according to which direction the tr"} edge- (MaxFn. "edge~" {:alias "edge~", :doc "Use the edge~ to detect zero to non-zero (and vice versa) signal transitions and report a bang out of one of its two outlets according to which direction the tr", :href "/max8/refpages/edge~", :obj-name "edge~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the log~ object to output a signal composed of the logarithms of its input values. You can specify the logarithmic base."} log- (MaxFn. "log~" {:alias "log~", :doc "Use the log~ object to output a signal composed of the logarithms of its input values. You can specify the logarithmic base.", :href "/max8/refpages/log~", :obj-name "log~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the line~ object to generate a signal ramp or envelope. It uses the Max time format syntax; envelope times can be either single valued fixed or tempo-relati"} line- (MaxFn. "line~" {:alias "line~", :doc "Use the line~ object to generate a signal ramp or envelope. It uses the Max time format syntax; envelope times can be either single valued fixed or tempo-relati", :href "/max8/refpages/line~", :obj-name "line~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "sync~ outputs a 0-1 ramp, like phasor~. The frequency of the ramp can be specified in beats per minute (BPM), or by sending sync~ a tempo reference via tap temp"} sync- (MaxFn. "sync~" {:alias "sync~", :doc "sync~ outputs a 0-1 ramp, like phasor~. The frequency of the ramp can be specified in beats per minute (BPM), or by sending sync~ a tempo reference via tap temp", :href "/max8/refpages/sync~", :obj-name "sync~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "omx.comp~ is a fully-featured signal compressor with limiting, gating, sidechain, and dual-band options."} omx.comp- (MaxFn. "omx.comp~" {:alias "omx.comp~", :doc "omx.comp~ is a fully-featured signal compressor with limiting, gating, sidechain, and dual-band options.", :href "/max8/refpages/omx.comp~", :obj-name "omx.comp~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "kink~ takes phasor~ values and distorts them according to a slope factor. If the input times the slope is less than 0.5, that value is output. Otherwise, a comp"} kink- (MaxFn. "kink~" {:alias "kink~", :doc "kink~ takes phasor~ values and distorts them according to a slope factor. If the input times the slope is less than 0.5, that value is output. Otherwise, a comp", :href "/max8/refpages/kink~", :obj-name "kink~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "sfinfo~ gives you the number of channels, sample size, sampling rate, sampletype, filename, and duration of a soundfile."} sfinfo- (MaxFn. "sfinfo~" {:alias "sfinfo~", :doc "sfinfo~ gives you the number of channels, sample size, sampling rate, sampletype, filename, and duration of a soundfile.", :href "/max8/refpages/sfinfo~", :obj-name "sfinfo~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "*~ is a signal multiplier-operator that outputs a signal which is the multiplication between two signals."} *- (MaxFn. "times~" {:alias "times~", :doc "*~ is a signal multiplier-operator that outputs a signal which is the multiplication between two signals.", :href "/max8/refpages/times~", :obj-name "*~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the levelmeter~ when you need a signal level-meter with ballistics. The meter~ object provides metering in a simpler and more compact form."} levelmeter- (MaxFn. "levelmeter~" {:alias "levelmeter~", :doc "Use the levelmeter~ when you need a signal level-meter with ballistics. The meter~ object provides metering in a simpler and more compact form.", :href "/max8/refpages/levelmeter~", :obj-name "levelmeter~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "triangle~ is a triangle/ramp wavetable with signal input to change phase offset of the peak value. The default lo/hi points are -1. and 1., but may be changed u"} triangle- (MaxFn. "triangle~" {:alias "triangle~", :doc "triangle~ is a triangle/ramp wavetable with signal input to change phase offset of the peak value. The default lo/hi points are -1. and 1., but may be changed u", :href "/max8/refpages/triangle~", :obj-name "triangle~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the sfrecord~ object to record and save MSP output as an audio file."} sfrecord- (MaxFn. "sfrecord~" {:alias "sfrecord~", :doc "Use the sfrecord~ object to record and save MSP output as an audio file.", :href "/max8/refpages/sfrecord~", :obj-name "sfrecord~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc ">=~ outputs a 1 signal when the left input is greater-than or equal-to the right input and a 0 when it is less-than the right input. The right input can be a si"} >=- (MaxFn. ">=~" {:alias "greaterthaneq~", :doc ">=~ outputs a 1 signal when the left input is greater-than or equal-to the right input and a 0 when it is less-than the right input. The right input can be a si", :href "/max8/refpages/greaterthaneq~", :obj-name ">=~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the number~ object to display signal values or generate them."} number- (MaxFn. "number~" {:alias "number~", :doc "Use the number~ object to display signal values or generate them.", :href "/max8/refpages/number~", :obj-name "number~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the curve~ object to produce a signal that goes from an initial to target value over a specified time. It is similar to the line~ object, it produces non-li"} curve- (MaxFn. "curve~" {:alias "curve~", :doc "Use the curve~ object to produce a signal that goes from an initial to target value over a specified time. It is similar to the line~ object, it produces non-li", :href "/max8/refpages/curve~", :obj-name "curve~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "ftom~ performs signal-rate frequency (Hz) to MIDI(note-value) conversion."} ftom- (MaxFn. "ftom~" {:alias "ftom~", :doc "ftom~ performs signal-rate frequency (Hz) to MIDI(note-value) conversion.", :href "/max8/refpages/ftom~", :obj-name "ftom~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the sfplay~ object to play audio files from disk. Supported formats include AIFF, WAVE, MP3, M4A, NeXT/SUN(.au), and Raw Data."} sfplay- (MaxFn. "sfplay~" {:alias "sfplay~", :doc "Use the sfplay~ object to play audio files from disk. Supported formats include AIFF, WAVE, MP3, M4A, NeXT/SUN(.au), and Raw Data.", :href "/max8/refpages/sfplay~", :obj-name "sfplay~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "pass~ is used above any outlet object that will handle a signal. When the audio in the subpatch is enabled, the pass~ object will pass its input to its output. "} pass- (MaxFn. "pass~" {:alias "pass~", :doc "pass~ is used above any outlet object that will handle a signal. When the audio in the subpatch is enabled, the pass~ object will pass its input to its output. ", :href "/max8/refpages/pass~", :obj-name "pass~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The plugsync~ object provides information about the current state of Ableton Live host applicaiton."} plugsync- (MaxFn. "plugsync~" {:alias "plugsync~", :doc "The plugsync~ object provides information about the current state of Ableton Live host applicaiton.", :href "/max8/refpages/plugsync~", :obj-name "plugsync~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The fftout~ object provides an signal output to a pfft~ object."} fftout- (MaxFn. "fftout~" {:alias "fftout~", :doc "The fftout~ object provides an signal output to a pfft~ object.", :href "/max8/refpages/fftout~", :obj-name "fftout~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "maximum~ outputs a signal which is the maximum of two input signals."} maximum- (MaxFn. "maximum~" {:alias "maximum~", :doc "maximum~ outputs a signal which is the maximum of two input signals.", :href "/max8/refpages/maximum~", :obj-name "maximum~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "lookup~ allows you to use a table of samples (buffer~ object) to do waveshaping on a signal, in which the Y values of an input signal are used as X values to lo"} lookup- (MaxFn. "lookup~" {:alias "lookup~", :doc "lookup~ allows you to use a table of samples (buffer~ object) to do waveshaping on a signal, in which the Y values of an input signal are used as X values to lo", :href "/max8/refpages/lookup~", :obj-name "lookup~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "trapezoid~ is a trapezoidal wavetable with signal inputs to change ramp up/down phase position. The default lo/hi points are 0. and 1., but may be changed using"} trapezoid- (MaxFn. "trapezoid~" {:alias "trapezoid~", :doc "trapezoid~ is a trapezoidal wavetable with signal inputs to change ramp up/down phase position. The default lo/hi points are 0. and 1., but may be changed using", :href "/max8/refpages/trapezoid~", :obj-name "trapezoid~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "poke~ allows you to write samples into a buffer~ at sample locations specified by a signal."} poke- (MaxFn. "poke~" {:alias "poke~", :doc "poke~ allows you to write samples into a buffer~ at sample locations specified by a signal.", :href "/max8/refpages/poke~", :obj-name "poke~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the tanh~ object to calculate and output a signal that is the hyperbolic tangent function of each sample of the input signal."} tanh- (MaxFn. "tanh~" {:alias "tanh~", :doc "Use the tanh~ object to calculate and output a signal that is the hyperbolic tangent function of each sample of the input signal.", :href "/max8/refpages/tanh~", :obj-name "tanh~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the -~ object to perform signal subtraction (to output a signal which is the difference between two signals)."} -- (MaxFn. "minus~" {:alias "minus~", :doc "Use the -~ object to perform signal subtraction (to output a signal which is the difference between two signals).", :href "/max8/refpages/minus~", :obj-name "-~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "fft~ performs a Fast Fourier transform on any incoming signal and outputs the real and imaginary parts of that transform as well as a synchronization signal."} fft- (MaxFn. "fft~" {:alias "fft~", :doc "fft~ performs a Fast Fourier transform on any incoming signal and outputs the real and imaginary parts of that transform as well as a synchronization signal.", :href "/max8/refpages/fft~", :obj-name "fft~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the acosh~ object to calculate and output a signal that is the hyperbolic arc-cosine function of each sample of the input signal."} acosh- (MaxFn. "acosh~" {:alias "acosh~", :doc "Use the acosh~ object to calculate and output a signal that is the hyperbolic arc-cosine function of each sample of the input signal.", :href "/max8/refpages/acosh~", :obj-name "acosh~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the atan~ object to calculate and output a signal that is the arc-tangent function of each sample of the input signal."} atan- (MaxFn. "atan~" {:alias "atan~", :doc "Use the atan~ object to calculate and output a signal that is the arc-tangent function of each sample of the input signal.", :href "/max8/refpages/atan~", :obj-name "atan~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the sampstoms~ object to convert an incoming signal carrying a time value in samples and output a signal which converts that number of samples to a number o"} sampstoms- (MaxFn. "sampstoms~" {:alias "sampstoms~", :doc "Use the sampstoms~ object to convert an incoming signal carrying a time value in samples and output a signal which converts that number of samples to a number o", :href "/max8/refpages/sampstoms~", :obj-name "sampstoms~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the adsr~ object when you need a sample-accurate Attack-Decay-Sustain-Release signal envelope which can be controlled by signals. In some situations, a comb"} adsr- (MaxFn. "adsr~" {:alias "adsr~", :doc "Use the adsr~ object when you need a sample-accurate Attack-Decay-Sustain-Release signal envelope which can be controlled by signals. In some situations, a comb", :href "/max8/refpages/adsr~", :obj-name "adsr~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "==~ outputs a 1 signal when the left input is equal to the right input and a 0 when it is not equal to the right input. The right input can be a signal or a flo"} ==- (MaxFn. "==~" {:alias "equals~", :doc "==~ outputs a 1 signal when the left input is equal to the right input and a 0 when it is not equal to the right input. The right input can be a signal or a flo", :href "/max8/refpages/equals~", :obj-name "==~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The pfft~ object is designed to simplify spectral audio processing using the Fast Fourier Transform (FFT). In addition to performing the FFT and the Inverse Fas"} pfft- (MaxFn. "pfft~" {:alias "pfft~", :doc "The pfft~ object is designed to simplify spectral audio processing using the Fast Fourier Transform (FFT). In addition to performing the FFT and the Inverse Fas", :href "/max8/refpages/pfft~", :obj-name "pfft~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The fbinshift~ object implements a frequency-domain frequency shifter that can be used inside a patch loaded by a pfft~ object."} fbinshift- (MaxFn. "fbinshift~" {:alias "fbinshift~", :doc "The fbinshift~ object implements a frequency-domain frequency shifter that can be used inside a patch loaded by a pfft~ object.", :href "/max8/refpages/fbinshift~", :obj-name "fbinshift~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "!=~ outputs a 1 signal when the left input is not-equal to the right input and a 0 when it is equal to the right input. The right input can be a signal or a flo"} !=- (MaxFn. "!=~" {:alias "notequals~", :doc "!=~ outputs a 1 signal when the left input is not-equal to the right input and a 0 when it is equal to the right input. The right input can be a signal or a flo", :href "/max8/refpages/notequals~", :obj-name "!=~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "chucker~ takes a specified amount of audio data, stores the data in an internal buffer, divides the buffered data into equal sections, and allows the sections t"} chucker- (MaxFn. "chucker~" {:alias "chucker~", :doc "chucker~ takes a specified amount of audio data, stores the data in an internal buffer, divides the buffered data into equal sections, and allows the sections t", :href "/max8/refpages/chucker~", :obj-name "chucker~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The rate~ object accepts an input signal from a phasor~ and time scales it by a multiplier received as a float in its right inlet. Numbers less than 1 create se"} rate- (MaxFn. "rate~" {:alias "rate~", :doc "The rate~ object accepts an input signal from a phasor~ and time scales it by a multiplier received as a float in its right inlet. Numbers less than 1 create se", :href "/max8/refpages/rate~", :obj-name "rate~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "hilbert~ is a 6th order hilbert transformer with a minimum of error."} hilbert- (MaxFn. "hilbert~" {:alias "hilbert~", :doc "hilbert~ is a 6th order hilbert transformer with a minimum of error.", :href "/max8/refpages/hilbert~", :obj-name "hilbert~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the adstatus object to control Max audio settings."} adstatus (MaxFn. "adstatus" {:alias "adstatus", :doc "Use the adstatus object to control Max audio settings.", :href "/max8/refpages/adstatus", :obj-name "adstatus"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The fzero~ object estimates the fundamental frequency of an an incoming, monophonic audio signal. It performs multiple layers of wavelet transforms on an incomi"} fzero- (MaxFn. "fzero~" {:alias "fzero~", :doc "The fzero~ object estimates the fundamental frequency of an an incoming, monophonic audio signal. It performs multiple layers of wavelet transforms on an incomi", :href "/max8/refpages/fzero~", :obj-name "fzero~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The fftin~ object provides an signal input to a patcher loaded by a pfft~ object."} fftin- (MaxFn. "fftin~" {:alias "fftin~", :doc "The fftin~ object provides an signal input to a patcher loaded by a pfft~ object.", :href "/max8/refpages/fftin~", :obj-name "fftin~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the selector~ object to choose between one of several input signals (or none). The selector~ is similar to the Max switch object but for signals, however if"} selector- (MaxFn. "selector~" {:alias "selector~", :doc "Use the selector~ object to choose between one of several input signals (or none). The selector~ is similar to the Max switch object but for signals, however if", :href "/max8/refpages/selector~", :obj-name "selector~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the average~ to perform bipolar, absolute, or rms averaging on any input signal."} average- (MaxFn. "average~" {:alias "average~", :doc "Use the average~ to perform bipolar, absolute, or rms averaging on any input signal.", :href "/max8/refpages/average~", :obj-name "average~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The adc~ (\"analog-to-digital converter\") object outputs one or more signals (one per outlet) with audio from hardware input devices."} adc- (MaxFn. "adc~" {:alias "adc~", :doc "The adc~ (\"analog-to-digital converter\") object outputs one or more signals (one per outlet) with audio from hardware input devices.", :href "/max8/refpages/adc~", :obj-name "adc~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "spike~ reports intervals of zero to non-zero transitions."} spike- (MaxFn. "spike~" {:alias "spike~", :doc "spike~ reports intervals of zero to non-zero transitions.", :href "/max8/refpages/spike~", :obj-name "spike~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The overdrive~ object uses a waveshaping function to distort audio signals. It amplifies signals, limiting the maximum value of the signal to +/- 1. Values outs"} overdrive- (MaxFn. "overdrive~" {:alias "overdrive~", :doc "The overdrive~ object uses a waveshaping function to distort audio signals. It amplifies signals, limiting the maximum value of the signal to +/- 1. Values outs", :href "/max8/refpages/overdrive~", :obj-name "overdrive~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "techno~ is a signal-based step-sequencer that facilitates sample-accurate timing of events."} techno- (MaxFn. "techno~" {:alias "techno~", :doc "techno~ is a signal-based step-sequencer that facilitates sample-accurate timing of events.", :href "/max8/refpages/techno~", :obj-name "techno~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "pow~ raises the base value (set in the right inlet) to the power of the exponent (set in the left inlet). Either inlet can receive a signal, float or int."} pow- (MaxFn. "pow~" {:alias "pow~", :doc "pow~ raises the base value (set in the right inlet) to the power of the exponent (set in the left inlet). Either inlet can receive a signal, float or int.", :href "/max8/refpages/pow~", :obj-name "pow~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the acosh~ object to take two given x and y values and output a signal which is their arc-tangent function, calculated as follows: Arc-tangent (y/x)"} atan2- (MaxFn. "atan2~" {:alias "atan2~", :doc "Use the acosh~ object to take two given x and y values and output a signal which is their arc-tangent function, calculated as follows: Arc-tangent (y/x)", :href "/max8/refpages/atan2~", :obj-name "atan2~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "hostphasor~ outputs an audio-rate sawtooth wave that is sample-synchronized to the beat of the ReWire host sequencer. The waveform can be fed to other audio obj"} hostphasor- (MaxFn. "hostphasor~" {:alias "hostphasor~", :doc "hostphasor~ outputs an audio-rate sawtooth wave that is sample-synchronized to the beat of the ReWire host sequencer. The waveform can be fed to other audio obj", :href "/max8/refpages/hostphasor~", :obj-name "hostphasor~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "trunc~ converts signals with values such as 1.75 to 1.0. Negative values are modified so that -1.75 becomes -1.0. This object is very simple but computationally"} trunc- (MaxFn. "trunc~" {:alias "trunc~", :doc "trunc~ converts signals with values such as 1.75 to 1.0. Negative values are modified so that -1.75 becomes -1.0. This object is very simple but computationally", :href "/max8/refpages/trunc~", :obj-name "trunc~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the buffer~ object as a buffer of memory in which samples are stored to be saved, edited, or referenced."} buffer- (MaxFn. "buffer~" {:alias "buffer~", :doc "Use the buffer~ object as a buffer of memory in which samples are stored to be saved, edited, or referenced.", :href "/max8/refpages/buffer~", :obj-name "buffer~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The dac~ (\"digital-to-analog converter\") object sends its signal inputs to audio hardware. Double-click on a dac~ to open the Audio Status window to configure a"} dac- (MaxFn. "dac~" {:alias "dac~", :doc "The dac~ (\"digital-to-analog converter\") object sends its signal inputs to audio hardware. Double-click on a dac~ to open the Audio Status window to configure a", :href "/max8/refpages/dac~", :obj-name "dac~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the adoutput~ object to record the current audio output or to feed it back into your patcher. The output of adoutput~ is delayed by one signal vector with r"} adoutput- (MaxFn. "adoutput~" {:alias "adoutput~", :doc "Use the adoutput~ object to record the current audio output or to feed it back into your patcher. The output of adoutput~ is delayed by one signal vector with r", :href "/max8/refpages/adoutput~", :obj-name "adoutput~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the filtergraph~ object to generate filter coefficients for the biquad~ or cascade~ objects with a graphical interface."} filtergraph- (MaxFn. "filtergraph~" {:alias "filtergraph~", :doc "Use the filtergraph~ object to generate filter coefficients for the biquad~ or cascade~ objects with a graphical interface.", :href "/max8/refpages/filtergraph~", :obj-name "filtergraph~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use sah~ to capture (\"sample\") and continually output (\"hold\") the value of an input signal whenever another \"control\" signal rises above a specified threshold "} sah- (MaxFn. "sah~" {:alias "sah~", :doc "Use sah~ to capture (\"sample\") and continually output (\"hold\") the value of an input signal whenever another \"control\" signal rises above a specified threshold ", :href "/max8/refpages/sah~", :obj-name "sah~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "sinx~ is a real sine function whose input expects values between 0 and 2π (similar to cosx~ but unlike cos~ which is designed to work with phasor~ 's output fro"} sinx- (MaxFn. "sinx~" {:alias "sinx~", :doc "sinx~ is a real sine function whose input expects values between 0 and 2π (similar to cosx~ but unlike cos~ which is designed to work with phasor~ 's output fro", :href "/max8/refpages/sinx~", :obj-name "sinx~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The mxj~ object (and its Max equivalent mxj) instantiate specially-written Java classes and acts as a Max-level peer object, passing data that originates in Max"} mxj- (MaxFn. "mxj~" {:alias "mxj~", :doc "The mxj~ object (and its Max equivalent mxj) instantiate specially-written Java classes and acts as a Max-level peer object, passing data that originates in Max", :href "/max8/refpages/mxj~", :obj-name "mxj~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the play~ object as a playback interface for a buffer~. that plays back samples based on an offset within the buffer. It is typically used with the line~ ob"} play- (MaxFn. "play~" {:alias "play~", :doc "Use the play~ object as a playback interface for a buffer~. that plays back samples based on an offset within the buffer. It is typically used with the line~ ob", :href "/max8/refpages/play~", :obj-name "play~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the meter~ object to monitor any signal in the range -1 and 1 (other signals should be scaled first)."} meter- (MaxFn. "meter~" {:alias "meter~", :doc "Use the meter~ object to monitor any signal in the range -1 and 1 (other signals should be scaled first).", :href "/max8/refpages/meter~", :obj-name "meter~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The teeth~ object implements a comb filter, in which a slightly delayed version of a signal is added to itself, causing phase cancellations and a spectrum that "} teeth- (MaxFn. "teeth~" {:alias "teeth~", :doc "The teeth~ object implements a comb filter, in which a slightly delayed version of a signal is added to itself, causing phase cancellations and a spectrum that ", :href "/max8/refpages/teeth~", :obj-name "teeth~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The outlet of a tapin~ object must be connected to the left inlet of tapout~ in order for the delay line to function. The tapout~ object has one or more inlets "} tapout- (MaxFn. "tapout~" {:alias "tapout~", :doc "The outlet of a tapin~ object must be connected to the left inlet of tapout~ in order for the delay line to function. The tapout~ object has one or more inlets ", :href "/max8/refpages/tapout~", :obj-name "tapout~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the clip~ to constrain input signals between two specified values."} clip- (MaxFn. "clip~" {:alias "clip~", :doc "Use the clip~ to constrain input signals between two specified values.", :href "/max8/refpages/clip~", :obj-name "clip~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the capture object to collect signal values for signal debugging or investigation. To record signal values, use the record~ or sfrecord~ object."} capture- (MaxFn. "capture~" {:alias "capture~", :doc "Use the capture object to collect signal values for signal debugging or investigation. To record signal values, use the record~ or sfrecord~ object.", :href "/max8/refpages/capture~", :obj-name "capture~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the phasor~ object to generate sawtooth waves suitable for sample-accurate control and timing tasks. For smoother sounding sawtooth generation, use the band"} phasor- (MaxFn. "phasor~" {:alias "phasor~", :doc "Use the phasor~ object to generate sawtooth waves suitable for sample-accurate control and timing tasks. For smoother sounding sawtooth generation, use the band", :href "/max8/refpages/phasor~", :obj-name "phasor~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The seq~ object is an event sequencer that is driven by a signal input. seq~ can be used to create looping sequences of control data that are synchronized to a "} seq- (MaxFn. "seq~" {:alias "seq~", :doc "The seq~ object is an event sequencer that is driven by a signal input. seq~ can be used to create looping sequences of control data that are synchronized to a ", :href "/max8/refpages/seq~", :obj-name "seq~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The onepole~ object implements the simplest of IIR filters, providing a 6dB per octave attenuation. This filter is very efficient and useful for gently rolling "} onepole- (MaxFn. "onepole~" {:alias "onepole~", :doc "The onepole~ object implements the simplest of IIR filters, providing a 6dB per octave attenuation. This filter is very efficient and useful for gently rolling ", :href "/max8/refpages/onepole~", :obj-name "onepole~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the sinh~ object to calculate and output a signal that is the hyperbolic sine function of each sample of the input signal."} sinh- (MaxFn. "sinh~" {:alias "sinh~", :doc "Use the sinh~ object to calculate and output a signal that is the hyperbolic sine function of each sample of the input signal.", :href "/max8/refpages/sinh~", :obj-name "sinh~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "polybuffer~ lets you operate with a group of buffer~ objects. Each buffer~ will be named after polybuffer~ first argument and an index (aka for a polybuffer~ to"} polybuffer- (MaxFn. "polybuffer~" {:alias "polybuffer~", :doc "polybuffer~ lets you operate with a group of buffer~ objects. Each buffer~ will be named after polybuffer~ first argument and an index (aka for a polybuffer~ to", :href "/max8/refpages/polybuffer~", :obj-name "polybuffer~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the cos~ object to calculate and output a signal that is the cosine function of each sample of the input signal."} cos- (MaxFn. "cos~" {:alias "cos~", :doc "Use the cos~ object to calculate and output a signal that is the cosine function of each sample of the input signal.", :href "/max8/refpages/cos~", :obj-name "cos~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "tri~ generates a triangle wave whose component frequencies are resistant to aliasing."} tri- (MaxFn. "tri~" {:alias "tri~", :doc "tri~ generates a triangle wave whose component frequencies are resistant to aliasing.", :href "/max8/refpages/tri~", :obj-name "tri~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the vst~ object to load a real-time VST, VST3 or Audio Unit plug-in and use its audio processing in MSP. When vst~ is instantiated as mcs.vst~, the plug-in'"} vst- (MaxFn. "vst~" {:alias "vst~", :doc "Use the vst~ object to load a real-time VST, VST3 or Audio Unit plug-in and use its audio processing in MSP. When vst~ is instantiated as mcs.vst~, the plug-in'", :href "/max8/refpages/vst~", :obj-name "vst~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use zigzag~ to generate multisegment linear ramps. This object is similar to line~, but retains information about the ramp after it has been output, and allows "} zigzag- (MaxFn. "zigzag~" {:alias "zigzag~", :doc "Use zigzag~ to generate multisegment linear ramps. This object is similar to line~, but retains information about the ramp after it has been output, and allows ", :href "/max8/refpages/zigzag~", :obj-name "zigzag~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The !-~ object functions just like the -~ object, but the inlet order is reversed."} !-- (MaxFn. "!-~" {:alias "rminus~", :doc "The !-~ object functions just like the -~ object, but the inlet order is reversed.", :href "/max8/refpages/rminus~", :obj-name "!-~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the bitxor~ object to perform a bitwise \"exclusive or\" operation on two incoming floating-point signals as either raw 32-bit data or as integer values. The "} bitxor- (MaxFn. "bitxor~" {:alias "bitxor~", :doc "Use the bitxor~ object to perform a bitwise \"exclusive or\" operation on two incoming floating-point signals as either raw 32-bit data or as integer values. The ", :href "/max8/refpages/bitxor~", :obj-name "bitxor~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "train~ generates a pulse signal whose period is specifiable in terms of milliseconds (see <~ for a method of making a pulse wave at a specified frequency). It a"} train- (MaxFn. "train~" {:alias "train~", :doc "train~ generates a pulse signal whose period is specifiable in terms of milliseconds (see <~ for a method of making a pulse wave at a specified frequency). It a", :href "/max8/refpages/train~", :obj-name "train~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Divides a number by the incoming value. Functions like the / object, but the inlets' functions are reversed."} !- (MaxFn. "!/~" {:alias "rdiv", :doc "Divides a number by the incoming value. Functions like the / object, but the inlets' functions are reversed.", :href "/max8/refpages/rdiv", :obj-name "!/~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the scope~ object to visualize and audio signal using an oscilloscope-style display."} scope- (MaxFn. "scope~" {:alias "scope~", :doc "Use the scope~ object to visualize and audio signal using an oscilloscope-style display.", :href "/max8/refpages/scope~", :obj-name "scope~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "<=~ outputs a 1 signal when the left input is less-than or equal-to the right input and a 0 when it is less-than the right input. The right input can be a signa"} <=- (MaxFn. "<=~" {:alias "lessthaneq~", :doc "<=~ outputs a 1 signal when the left input is less-than or equal-to the right input and a 0 when it is less-than the right input. The right input can be a signa", :href "/max8/refpages/lessthaneq~", :obj-name "<=~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the bitnot~ object to perform a bitwise inversion on an incoming floating-point signal as either raw 32-bit data or as an integer value. All bit values of 1"} bitnot- (MaxFn. "bitnot~" {:alias "bitnot~", :doc "Use the bitnot~ object to perform a bitwise inversion on an incoming floating-point signal as either raw 32-bit data or as an integer value. All bit values of 1", :href "/max8/refpages/bitnot~", :obj-name "bitnot~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the waveform~ object to view or edit the contents of a buffer~."} waveform- (MaxFn. "waveform~" {:alias "waveform~", :doc "Use the waveform~ object to view or edit the contents of a buffer~.", :href "/max8/refpages/waveform~", :obj-name "waveform~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "!=~ outputs a 1 signal when the left input is not-equal to the right input and a 0 when it is equal to the right input. The right input can be a signal or a flo"} notequals- (MaxFn. "notequals~" {:alias "notequals~", :doc "!=~ outputs a 1 signal when the left input is not-equal to the right input and a 0 when it is equal to the right input. The right input can be a signal or a flo", :href "/max8/refpages/notequals~", :obj-name "notequals~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the snapshot~ object to convert a signal value into a float message when a bang is received or according to a specified interval. The interval can be set to"} snapshot- (MaxFn. "snapshot~" {:alias "snapshot~", :doc "Use the snapshot~ object to convert a signal value into a float message when a bang is received or according to a specified interval. The interval can be set to", :href "/max8/refpages/snapshot~", :obj-name "snapshot~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the acos~ object to calculate and output a signal that is the arc-cosine function of each sample of the input signal."} acos- (MaxFn. "acos~" {:alias "acos~", :doc "Use the acos~ object to calculate and output a signal that is the arc-cosine function of each sample of the input signal.", :href "/max8/refpages/acos~", :obj-name "acos~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "pink~ generates pink noise, as distinguished from white noise (which the MSP object noise~ generates). White noise has constant spectral power per hertz of band"} pink- (MaxFn. "pink~" {:alias "pink~", :doc "pink~ generates pink noise, as distinguished from white noise (which the MSP object noise~ generates). White noise has constant spectral power per hertz of band", :href "/max8/refpages/pink~", :obj-name "pink~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "ezdac~ works as a user interface version of the dac~ object. It appears as a button which can be clicked with the mouse to turn audio on or off."} ezdac- (MaxFn. "ezdac~" {:alias "ezdac~", :doc "ezdac~ works as a user interface version of the dac~ object. It appears as a button which can be clicked with the mouse to turn audio on or off.", :href "/max8/refpages/ezdac~", :obj-name "ezdac~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the in~ object inside a patcher loaded by the poly~ object to create a patcher signal inlet."} in- (MaxFn. "in~" {:alias "in~", :doc "Use the in~ object inside a patcher loaded by the poly~ object to create a patcher signal inlet.", :href "/max8/refpages/in~", :obj-name "in~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the abs~ object to take any given signal and output only the absolute (non-negative) translation of that signal (i.e. a rectified waveform). All negative va"} abs- (MaxFn. "abs~" {:alias "abs~", :doc "Use the abs~ object to take any given signal and output only the absolute (non-negative) translation of that signal (i.e. a rectified waveform). All negative va", :href "/max8/refpages/abs~", :obj-name "abs~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the cosx~ object to calculate and output a signal that is the cosine function of each sample of the input signal. The cosx~ object is a true π based functio"} cosx- (MaxFn. "cosx~" {:alias "cosx~", :doc "Use the cosx~ object to calculate and output a signal that is the cosine function of each sample of the input signal. The cosx~ object is a true π based functio", :href "/max8/refpages/cosx~", :obj-name "cosx~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the info~ object to report the information in a file read into a buffer~ object in response to a bang. If the information is not present, it will be 0. info"} info- (MaxFn. "info~" {:alias "info~", :doc "Use the info~ object to report the information in a file read into a buffer~ object in response to a bang. If the information is not present, it will be 0. info", :href "/max8/refpages/info~", :obj-name "info~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use buffir~ object when you need a finite impulse response (FIR) filter that convolves an input signal with samples from an input buffer."} buffir- (MaxFn. "buffir~" {:alias "buffir~", :doc "Use buffir~ object when you need a finite impulse response (FIR) filter that convolves an input signal with samples from an input buffer.", :href "/max8/refpages/buffir~", :obj-name "buffir~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the avg~ object to keep track of the average (absolute) amplitude of the input signal received over a specified time interval."} avg- (MaxFn. "avg~" {:alias "avg~", :doc "Use the avg~ object to keep track of the average (absolute) amplitude of the input signal received over a specified time interval.", :href "/max8/refpages/avg~", :obj-name "avg~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the cross~ object as a pair of symmetrical low+high pass 3rd order filters with lowpass and highpass outlets you can use separately or in combination to for"} cross- (MaxFn. "cross~" {:alias "cross~", :doc "Use the cross~ object as a pair of symmetrical low+high pass 3rd order filters with lowpass and highpass outlets you can use separately or in combination to for", :href "/max8/refpages/cross~", :obj-name "cross~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "frameaccum~ computes a running phase by keeping a sum of the values in each position of its incoming signal vectors. When used inside a pfft~ object, it can kee"} frameaccum- (MaxFn. "frameaccum~" {:alias "frameaccum~", :doc "frameaccum~ computes a running phase by keeping a sum of the values in each position of its incoming signal vectors. When used inside a pfft~ object, it can kee", :href "/max8/refpages/frameaccum~", :obj-name "frameaccum~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "gain~ is a slider that scales signals. It can also make a smooth transition as you move from one value of the slider to the next."} gain- (MaxFn. "gain~" {:alias "gain~", :doc "gain~ is a slider that scales signals. It can also make a smooth transition as you move from one value of the slider to the next.", :href "/max8/refpages/gain~", :obj-name "gain~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "ezadc~ works as a user interface version of the adc~ object. It appears as a button which can be clicked with the mouse to turn audio on or off."} ezadc- (MaxFn. "ezadc~" {:alias "ezadc~", :doc "ezadc~ works as a user interface version of the adc~ object. It appears as a button which can be clicked with the mouse to turn audio on or off.", :href "/max8/refpages/ezadc~", :obj-name "ezadc~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "normalize~ performs real-time normalization of its input by multiplying each input sample value by a scaling factor - computed as the maximum output value (sent"} normalize- (MaxFn. "normalize~" {:alias "normalize~", :doc "normalize~ performs real-time normalization of its input by multiplying each input sample value by a scaling factor - computed as the maximum output value (sent", :href "/max8/refpages/normalize~", :obj-name "normalize~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "deltaclip~ limits the change between samples in an incoming signal. It is similar to the clip~ object, but it limits amplitude changes with respect to slope rat"} deltaclip- (MaxFn. "deltaclip~" {:alias "deltaclip~", :doc "deltaclip~ limits the change between samples in an incoming signal. It is similar to the clip~ object, but it limits amplitude changes with respect to slope rat", :href "/max8/refpages/deltaclip~", :obj-name "deltaclip~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the receive~ object to grab signals put out by send~ objects and outputs them out its signal outlet."} receive- (MaxFn. "receive~" {:alias "receive~", :doc "Use the receive~ object to grab signals put out by send~ objects and outputs them out its signal outlet.", :href "/max8/refpages/receive~", :obj-name "receive~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the cartopol~ object to convert signal values representing cartesian coordinates to a signal composed of polar coordinates."} cartopol- (MaxFn. "cartopol~" {:alias "cartopol~", :doc "Use the cartopol~ object to convert signal values representing cartesian coordinates to a signal composed of polar coordinates.", :href "/max8/refpages/cartopol~", :obj-name "cartopol~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "%~ is a signal remainder operator. If signals are connected to both inlets, the left signal is divided by the right signal, and the remainder is output. If a si"} %- (MaxFn. "%~" {:alias "modulo~", :doc "%~ is a signal remainder operator. If signals are connected to both inlets, the left signal is divided by the right signal, and the remainder is output. If a si", :href "/max8/refpages/modulo~", :obj-name "%~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "2d.wave~ is similar to wave~, but with an additional axis. A given ms range of an audio file will be divided into n rows. Y phase input will determine which row"} twod-wave- (MaxFn. "2d.wave~" {:alias "2d.wave~", :doc "2d.wave~ is similar to wave~, but with an additional axis. A given ms range of an audio file will be divided into n rows. Y phase input will determine which row", :href "/max8/refpages/2d.wave~", :obj-name "2d.wave~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "fftinfo~ gets info about the fft frames in a patcher loaded by a pfft~. It reports the information when sent a bang or whenever DSP is turned on via a dac~ (fft"} fftinfo- (MaxFn. "fftinfo~" {:alias "fftinfo~", :doc "fftinfo~ gets info about the fft frames in a patcher loaded by a pfft~. It reports the information when sent a bang or whenever DSP is turned on via a dac~ (fft", :href "/max8/refpages/fftinfo~", :obj-name "fftinfo~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "ifft~ performs an Inverse FFT (inverse fast Fourier transform) on an input signal."} ifft- (MaxFn. "ifft~" {:alias "ifft~", :doc "ifft~ performs an Inverse FFT (inverse fast Fourier transform) on an input signal.", :href "/max8/refpages/ifft~", :obj-name "ifft~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The gen~ object turns an embedded Gen patcher into signal processing routines of optimized native machine code. The Gen patcher can be built from a wide set of "} gen- (MaxFn. "gen~" {:alias "gen~", :doc "The gen~ object turns an embedded Gen patcher into signal processing routines of optimized native machine code. The Gen patcher can be built from a wide set of ", :href "/max8/refpages/gen~", :obj-name "gen~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc ">~ outputs a 1 signal when the left input is greater-than the right input and a 0 when it is less-than or equal-to the right input. The right input can be a sig"} >- (MaxFn. ">~" {:alias "greaterthan~", :doc ">~ outputs a 1 signal when the left input is greater-than the right input and a 0 when it is less-than or equal-to the right input. The right input can be a sig", :href "/max8/refpages/greaterthan~", :obj-name ">~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the poly~ to encapsulate a patcher inside an object box, to specify the patcher filename and the number of instances you want to load as arguments to the po"} poly- (MaxFn. "poly~" {:alias "poly~", :doc "Use the poly~ to encapsulate a patcher inside an object box, to specify the patcher filename and the number of instances you want to load as arguments to the po", :href "/max8/refpages/poly~", :obj-name "poly~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The gizmo~ object implements a frequency-domain pitch shifter. It works by analyzing the frequency bins of an FFT'd signal, finding the peaks in the spectrum, a"} gizmo- (MaxFn. "gizmo~" {:alias "gizmo~", :doc "The gizmo~ object implements a frequency-domain pitch shifter. It works by analyzing the frequency bins of an FFT'd signal, finding the peaks in the spectrum, a", :href "/max8/refpages/gizmo~", :obj-name "gizmo~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the cycle~ object to generate a periodic waveform. The default waveform is one cycle of a cosine wave. You can also use the wave~ object, which offers addit"} cycle- (MaxFn. "cycle~" {:alias "cycle~", :doc "Use the cycle~ object to generate a periodic waveform. The default waveform is one cycle of a cosine wave. You can also use the wave~ object, which offers addit", :href "/max8/refpages/cycle~", :obj-name "cycle~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the comb~ object to apply the classic comb filtering effect to an audio input. The comb~ object mixes the current input sample with earlier input and/or out"} comb- (MaxFn. "comb~" {:alias "comb~", :doc "Use the comb~ object to apply the classic comb filtering effect to an audio input. The comb~ object mixes the current input sample with earlier input and/or out", :href "/max8/refpages/comb~", :obj-name "comb~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the vectral~ object to filter frame-based signal data such as the output of the fft~ object."} vectral- (MaxFn. "vectral~" {:alias "vectral~", :doc "Use the vectral~ object to filter frame-based signal data such as the output of the fft~ object.", :href "/max8/refpages/vectral~", :obj-name "vectral~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the count~ object count samples elapsed and thus drive processes tightly synchronized to the sample rate. It outputs a signal increasing by 1 for each sampl"} count- (MaxFn. "count~" {:alias "count~", :doc "Use the count~ object count samples elapsed and thus drive processes tightly synchronized to the sample rate. It outputs a signal increasing by 1 for each sampl", :href "/max8/refpages/count~", :obj-name "count~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "degrade~ takes any given signal and reduces the sampling rate and bit-depth as specified/desired."} degrade- (MaxFn. "degrade~" {:alias "degrade~", :doc "degrade~ takes any given signal and reduces the sampling rate and bit-depth as specified/desired.", :href "/max8/refpages/degrade~", :obj-name "degrade~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the atodb~ to convert a signal representing a linear amplitude value to a deciBel equivalent."} atodb- (MaxFn. "atodb~" {:alias "atodb~", :doc "Use the atodb~ to convert a signal representing a linear amplitude value to a deciBel equivalent.", :href "/max8/refpages/atodb~", :obj-name "atodb~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the allpass~ object to filter an input with an allpass filter. The allpass filter has a flat magnitude response but a complex phase response, typically dela"} allpass- (MaxFn. "allpass~" {:alias "allpass~", :doc "Use the allpass~ object to filter an input with an allpass filter. The allpass filter has a flat magnitude response but a complex phase response, typically dela", :href "/max8/refpages/allpass~", :obj-name "allpass~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "sqrt~ will output a signal which is the square-root function of the input signal."} sqrt- (MaxFn. "sqrt~" {:alias "sqrt~", :doc "sqrt~ will output a signal which is the square-root function of the input signal.", :href "/max8/refpages/sqrt~", :obj-name "sqrt~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "wave~ reads from a portion of a buffer~ to produce a repeating waveform, given a signal input that goes between 0 and 1 (for example, using a phasor~) to define"} wave- (MaxFn. "wave~" {:alias "wave~", :doc "wave~ reads from a portion of a buffer~ to produce a repeating waveform, given a signal input that goes between 0 and 1 (for example, using a phasor~) to define", :href "/max8/refpages/wave~", :obj-name "wave~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the atanh~ object to calculate and output a signal that is the hyperbolic arc-tangent function of each sample of the input signal."} atanh- (MaxFn. "atanh~" {:alias "atanh~", :doc "Use the atanh~ object to calculate and output a signal that is the hyperbolic arc-tangent function of each sample of the input signal.", :href "/max8/refpages/atanh~", :obj-name "atanh~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "atodb~ takes any given signal representing a deciBel amplitude value and outputs a signal which is a linear amplitude conversion of the input."} dbtoa- (MaxFn. "dbtoa~" {:alias "dbtoa~", :doc "atodb~ takes any given signal representing a deciBel amplitude value and outputs a signal which is a linear amplitude conversion of the input.", :href "/max8/refpages/dbtoa~", :obj-name "dbtoa~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The fffb~ object implements a bank of bandpass filter objects, each of which is similar to the reson~ filter object. An input signal is applied to all filters, "} fffb- (MaxFn. "fffb~" {:alias "fffb~", :doc "The fffb~ object implements a bank of bandpass filter objects, each of which is similar to the reson~ filter object. An input signal is applied to all filters, ", :href "/max8/refpages/fffb~", :obj-name "fffb~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "ioscbank~ is an interpolated oscillator bank with signal inputs to set oscillator frequency and magnitude."} ioscbank- (MaxFn. "ioscbank~" {:alias "ioscbank~", :doc "ioscbank~ is an interpolated oscillator bank with signal inputs to set oscillator frequency and magnitude.", :href "/max8/refpages/ioscbank~", :obj-name "ioscbank~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the saw~ object to generate an anti-aliased sawtooth wave."} saw- (MaxFn. "saw~" {:alias "saw~", :doc "Use the saw~ object to generate an anti-aliased sawtooth wave.", :href "/max8/refpages/saw~", :obj-name "saw~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the slide~ object for envelope following and lowpass filtering."} slide- (MaxFn. "slide~" {:alias "slide~", :doc "Use the slide~ object for envelope following and lowpass filtering.", :href "/max8/refpages/slide~", :obj-name "slide~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "biquad~ implements a two-pole, two-zero filter using the following equation: y[n] = a0 * x[n] + a1 * x[n-1] + a2 * x[n-2] - b1 * y[n-1] - b2 * y[n-2] You can sp"} biquad- (MaxFn. "biquad~" {:alias "biquad~", :doc "biquad~ implements a two-pole, two-zero filter using the following equation: y[n] = a0 * x[n] + a1 * x[n-1] + a2 * x[n-2] - b1 * y[n-1] - b2 * y[n-2] You can sp", :href "/max8/refpages/biquad~", :obj-name "biquad~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The plugin~ object receives its input from the Live application as part of a Max for Live audio device."} plugin- (MaxFn. "plugin~" {:alias "plugin~", :doc "The plugin~ object receives its input from the Live application as part of a Max for Live audio device.", :href "/max8/refpages/plugin~", :obj-name "plugin~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "out defines a message outlet for a patcher loaded by poly~ or pfft~."} out (MaxFn. "out" {:alias "out", :doc "out defines a message outlet for a patcher loaded by poly~ or pfft~.", :href "/max8/refpages/out", :obj-name "out"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the cosh~ object to calculate and output a signal that is the hyperbolic cosine function of each sample of the input signal."} cosh- (MaxFn. "cosh~" {:alias "cosh~", :doc "Use the cosh~ object to calculate and output a signal that is the hyperbolic cosine function of each sample of the input signal.", :href "/max8/refpages/cosh~", :obj-name "cosh~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "poltocar~ will take any given signal as a polar coordinate and output the cartesian conversion of that signal."} poltocar- (MaxFn. "poltocar~" {:alias "poltocar~", :doc "poltocar~ will take any given signal as a polar coordinate and output the cartesian conversion of that signal.", :href "/max8/refpages/poltocar~", :obj-name "poltocar~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the bitor~ object to perform a bitwise \"or\" on two incoming floating-point signals as either raw 32-bit data or as integer values. The bits of both incoming"} bitor- (MaxFn. "bitor~" {:alias "bitor~", :doc "Use the bitor~ object to perform a bitwise \"or\" on two incoming floating-point signals as either raw 32-bit data or as integer values. The bits of both incoming", :href "/max8/refpages/bitor~", :obj-name "bitor~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The svf~ object is an implementation of a state-variable filter algorithm described in Hal Chamberlin's book, \"Musical Applications of Microprocessors.\" A uniqu"} svf- (MaxFn. "svf~" {:alias "svf~", :doc "The svf~ object is an implementation of a state-variable filter algorithm described in Hal Chamberlin's book, \"Musical Applications of Microprocessors.\" A uniqu", :href "/max8/refpages/svf~", :obj-name "svf~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the rand~ object to generate a signal consisting of random values between -1 and 1 generated at a frequency specified by its input. It interpolates linearly"} rand- (MaxFn. "rand~" {:alias "rand~", :doc "Use the rand~ object to generate a signal consisting of random values between -1 and 1 generated at a frequency specified by its input. It interpolates linearly", :href "/max8/refpages/rand~", :obj-name "rand~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use gate~ to route an input signal at the second inlet to one of several outlets, or to no outlet at all. When there is only one outlet (the default case), it a"} gate- (MaxFn. "gate~" {:alias "gate~", :doc "Use gate~ to route an input signal at the second inlet to one of several outlets, or to no outlet at all. When there is only one outlet (the default case), it a", :href "/max8/refpages/gate~", :obj-name "gate~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "When you choose the ad_rewire driver in the Audio Status window, the hostcontrol~ object lets you send commands to the ReWire host to start and stop the transpo"} hostcontrol- (MaxFn. "hostcontrol~" {:alias "hostcontrol~", :doc "When you choose the ad_rewire driver in the Audio Status window, the hostcontrol~ object lets you send commands to the ReWire host to start and stop the transpo", :href "/max8/refpages/hostcontrol~", :obj-name "hostcontrol~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the +~ object to add two signals together, or to add an offset value to a signal."} +- (MaxFn. "+~" {:alias "plus~", :doc "Use the +~ object to add two signals together, or to add an offset value to a signal.", :href "/max8/refpages/plus~", :obj-name "+~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the reson~ object when you need a resonant bandpass filter."} reson- (MaxFn. "reson~" {:alias "reson~", :doc "Use the reson~ object when you need a resonant bandpass filter.", :href "/max8/refpages/reson~", :obj-name "reson~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the round~ object to round a signal input to an integer multiple."} round- (MaxFn. "round~" {:alias "round~", :doc "Use the round~ object to round a signal input to an integer multiple.", :href "/max8/refpages/round~", :obj-name "round~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "oscbank~ is a non-interpolating oscillator bank with signal inputs to set oscillator frequency and magnitude."} oscbank- (MaxFn. "oscbank~" {:alias "oscbank~", :doc "oscbank~ is a non-interpolating oscillator bank with signal inputs to set oscillator frequency and magnitude.", :href "/max8/refpages/oscbank~", :obj-name "oscbank~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "minmax~ computes the minimum and maximum values of an input signal and outputs signals which are the maximum signal and the minimum signal as well as outputs of"} minmax- (MaxFn. "minmax~" {:alias "minmax~", :doc "minmax~ computes the minimum and maximum values of an input signal and outputs signals which are the maximum signal and the minimum signal as well as outputs of", :href "/max8/refpages/minmax~", :obj-name "minmax~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the bitshift~ object to perform bitwise operations on a floating point signal as bits or as an integer."} bitshift- (MaxFn. "bitshift~" {:alias "bitshift~", :doc "Use the bitshift~ object to perform bitwise operations on a floating point signal as bits or as an integer.", :href "/max8/refpages/bitshift~", :obj-name "bitshift~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the pong~ object to either fold or wrap its input within the range of a low value and a high value."} pong- (MaxFn. "pong~" {:alias "pong~", :doc "Use the pong~ object to either fold or wrap its input within the range of a low value and a high value.", :href "/max8/refpages/pong~", :obj-name "pong~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the peakamp~ object to monitor an incoming signal and reports the absolute value of the peak amplitude of the signal it has received since the last time it "} peakamp- (MaxFn. "peakamp~" {:alias "peakamp~", :doc "Use the peakamp~ object to monitor an incoming signal and reports the absolute value of the peak amplitude of the signal it has received since the last time it ", :href "/max8/refpages/peakamp~", :obj-name "peakamp~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the out~ object inside a patcher loaded by the poly~ object to create a patcher signal outlet."} out- (MaxFn. "out~" {:alias "out~", :doc "Use the out~ object inside a patcher loaded by the poly~ object to create a patcher signal outlet.", :href "/max8/refpages/out~", :obj-name "out~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the sig~ object to convert regular numbers into audio signals."} sig- (MaxFn. "sig~" {:alias "sig~", :doc "Use the sig~ object to convert regular numbers into audio signals.", :href "/max8/refpages/sig~", :obj-name "sig~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the mstosamps~ object to convert an incoming signal carrying a millisecond value and output a signal which converts those millisecond values to a number of "} mstosamps- (MaxFn. "mstosamps~" {:alias "mstosamps~", :doc "Use the mstosamps~ object to convert an incoming signal carrying a millisecond value and output a signal which converts those millisecond values to a number of ", :href "/max8/refpages/mstosamps~", :obj-name "mstosamps~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "downsamp~ samples and holds a signal received in the left inlet at a rate set by an argument to the object of the value received in the right inlet, expressed i"} downsamp- (MaxFn. "downsamp~" {:alias "downsamp~", :doc "downsamp~ samples and holds a signal received in the left inlet at a rate set by an argument to the object of the value received in the right inlet, expressed i", :href "/max8/refpages/downsamp~", :obj-name "downsamp~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the change object to monitor increase, decrease, or no change in a signal value."} change- (MaxFn. "change~" {:alias "change~", :doc "Use the change object to monitor increase, decrease, or no change in a signal value.", :href "/max8/refpages/change~", :obj-name "change~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "+=~ adds all the values it receives. The result can grow very large, very fast."} +=- (MaxFn. "+=~" {:alias "plusequals~", :doc "+=~ adds all the values it receives. The result can grow very large, very fast.", :href "/max8/refpages/plusequals~", :obj-name "+=~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the asinh~ object to calculate and output a signal that is the hyperbolic arc-sine function of each sample of the input signal."} asinh- (MaxFn. "asinh~" {:alias "asinh~", :doc "Use the asinh~ object to calculate and output a signal that is the hyperbolic arc-sine function of each sample of the input signal.", :href "/max8/refpages/asinh~", :obj-name "asinh~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the thispoly~ object to control poly~ voice allocation and muting. When placed inside a patcher loaded by the poly~ object, it sends and receives messages f"} thispoly- (MaxFn. "thispoly~" {:alias "thispoly~", :doc "Use the thispoly~ object to control poly~ voice allocation and muting. When placed inside a patcher loaded by the poly~ object, it sends and receives messages f", :href "/max8/refpages/thispoly~", :obj-name "thispoly~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "tapin~ receives a signal in and copies into a delay line. Using tapout~ objects, you can read from the delay line at various delay times. You must connect the o"} tapin- (MaxFn. "tapin~" {:alias "tapin~", :doc "tapin~ receives a signal in and copies into a delay line. Using tapout~ objects, you can read from the delay line at various delay times. You must connect the o", :href "/max8/refpages/tapin~", :obj-name "tapin~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "<~ outputs a 1 signal when the left input is less-than the right input and a 0 when it is greater-than or equal-to the right input. The right input can be a sig"} <- (MaxFn. "<~" {:alias "lessthan~", :doc "<~ outputs a 1 signal when the left input is less-than the right input and a 0 when it is greater-than or equal-to the right input. The right input can be a sig", :href "/max8/refpages/lessthan~", :obj-name "<~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the tanx~ object to calculate and output a signal that is the tangent function of each sample of the input signal. The tanx~ object is a true π based functi"} tanx- (MaxFn. "tanx~" {:alias "tanx~", :doc "Use the tanx~ object to calculate and output a signal that is the tangent function of each sample of the input signal. The tanx~ object is a true π based functi", :href "/max8/refpages/tanx~", :obj-name "tanx~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "omx.4band~ delivers the signal-processing power of Octimax in a 4-band compressor."} omx-4band- (MaxFn. "omx.4band~" {:alias "omx.4band~", :doc "omx.4band~ delivers the signal-processing power of Octimax in a 4-band compressor.", :href "/max8/refpages/omx.4band~", :obj-name "omx.4band~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The filtercoeff~ object is a signal-rate filter coefficient calculator for the biquad~ object. It calculates the filter coefficients from three higher-level par"} filtercoeff- (MaxFn. "filtercoeff~" {:alias "filtercoeff~", :doc "The filtercoeff~ object is a signal-rate filter coefficient calculator for the biquad~ object. It calculates the filter coefficients from three higher-level par", :href "/max8/refpages/filtercoeff~", :obj-name "filtercoeff~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The rewire~ object allows MSP to function as a ReWire mixer."} rewire- (MaxFn. "rewire~" {:alias "rewire~", :doc "The rewire~ object allows MSP to function as a ReWire mixer.", :href "/max8/refpages/rewire~", :obj-name "rewire~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "dspstate~ can be used for calculations that require the sampling rate of current DSP processing block size. You can also use the leftmost outlet to trigger some"} dspstate- (MaxFn. "dspstate~" {:alias "dspstate~", :doc "dspstate~ can be used for calculations that require the sampling rate of current DSP processing block size. You can also use the leftmost outlet to trigger some", :href "/max8/refpages/dspstate~", :obj-name "dspstate~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the cascade~ to filter an input signal using a series of biquad filters."} cascade- (MaxFn. "cascade~" {:alias "cascade~", :doc "Use the cascade~ to filter an input signal using a series of biquad filters.", :href "/max8/refpages/cascade~", :obj-name "cascade~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The plugphasor~ object outputs an audio-rate sawtooth wave that is sample-synchronized to the beat of the Ableton Live sequencer. The waveform can be fed to oth"} plugphasor- (MaxFn. "plugphasor~" {:alias "plugphasor~", :doc "The plugphasor~ object outputs an audio-rate sawtooth wave that is sample-synchronized to the beat of the Ableton Live sequencer. The waveform can be fed to oth", :href "/max8/refpages/plugphasor~", :obj-name "plugphasor~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The phaseshift~ object is a 2nd-order allpass filter."} phaseshift- (MaxFn. "phaseshift~" {:alias "phaseshift~", :doc "The phaseshift~ object is a 2nd-order allpass filter.", :href "/max8/refpages/phaseshift~", :obj-name "phaseshift~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the mtof~ object to perform signal-rate MIDI-to-Frequency conversion."} mtof- (MaxFn. "mtof~" {:alias "mtof~", :doc "Use the mtof~ object to perform signal-rate MIDI-to-Frequency conversion.", :href "/max8/refpages/mtof~", :obj-name "mtof~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "dsptime~ reports the time in milliseconds since the audio was last turned on when triggered by a bang."} dsptime- (MaxFn. "dsptime~" {:alias "dsptime~", :doc "dsptime~ reports the time in milliseconds since the audio was last turned on when triggered by a bang.", :href "/max8/refpages/dsptime~", :obj-name "dsptime~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the /~ object is to multiply a signal coming into the left inlet by the reciprocal of either the initial argument or an int or float received in the right i"} div- (MaxFn. "/~" {:alias "div~", :doc "Use the /~ object is to multiply a signal coming into the left inlet by the reciprocal of either the initial argument or an int or float received in the right i", :href "/max8/refpages/div~", :obj-name "/~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Note: plug-in building for hosts other than Ableton Live is no longer supported. For more information to help you make the transition to creating plug-ins in Ma"} plugsend- (MaxFn. "plugsend~" {:alias "plugsend~", :doc "Note: plug-in building for hosts other than Ableton Live is no longer supported. For more information to help you make the transition to creating plug-ins in Ma", :href "/max8/refpages/plugsend~", :obj-name "plugsend~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "mute~ provides an easy way to disable only the signal objects in a subpatcher. (An alternative is to use pcontrol, but this disables all objects (i.e. MIDI) and"} mute- (MaxFn. "mute~" {:alias "mute~", :doc "mute~ provides an easy way to disable only the signal objects in a subpatcher. (An alternative is to use pcontrol, but this disables all objects (i.e. MIDI) and", :href "/max8/refpages/mute~", :obj-name "mute~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the click~ to create and output an impulse which can be used as an impulse-trigger."} click- (MaxFn. "click~" {:alias "click~", :doc "Use the click~ to create and output an impulse which can be used as an impulse-trigger.", :href "/max8/refpages/click~", :obj-name "click~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use index~ to read from a buffer~ object at a signal-driven sample index with no interpolation on the output."} index- (MaxFn. "index~" {:alias "index~", :doc "Use index~ to read from a buffer~ object at a signal-driven sample index with no interpolation on the output.", :href "/max8/refpages/index~", :obj-name "index~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the bitand~ object to perform a bitwise intersection (a bitwise \"and\") on two incoming floating-point signals as either raw 32-bit data or as integer values"} bitand- (MaxFn. "bitand~" {:alias "bitand~", :doc "Use the bitand~ object to perform a bitwise intersection (a bitwise \"and\") on two incoming floating-point signals as either raw 32-bit data or as integer values", :href "/max8/refpages/bitand~", :obj-name "bitand~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "spectroscope~ serves as a visual spectrogram or sonogram interface for the analysis of signals."} spectroscope- (MaxFn. "spectroscope~" {:alias "spectroscope~", :doc "spectroscope~ serves as a visual spectrogram or sonogram interface for the analysis of signals.", :href "/max8/refpages/spectroscope~", :obj-name "spectroscope~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the noise~ object to generate a signal consisting of uniformly distributed random white-noise with values between -1.0 and 1.0."} noise- (MaxFn. "noise~" {:alias "noise~", :doc "Use the noise~ object to generate a signal consisting of uniformly distributed random white-noise with values between -1.0 and 1.0.", :href "/max8/refpages/noise~", :obj-name "noise~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the thresh~ object to detect signals which exceed a specified level."} thresh- (MaxFn. "thresh~" {:alias "thresh~", :doc "Use the thresh~ object to detect signals which exceed a specified level.", :href "/max8/refpages/thresh~", :obj-name "thresh~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The send~ object lets you send a signal to another patcher window or to another location within the same patcher window without using a patch cord."} send- (MaxFn. "send~" {:alias "send~", :doc "The send~ object lets you send a signal to another patcher window or to another location within the same patcher window without using a patch cord.", :href "/max8/refpages/send~", :obj-name "send~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "sflist~ stores a list of preloaded cues for sound files that can be accessed by multiple sfplay~ objects. Each sflist~ object has a unique name that sfplay~ obj"} sflist- (MaxFn. "sflist~" {:alias "sflist~", :doc "sflist~ stores a list of preloaded cues for sound files that can be accessed by multiple sfplay~ objects. Each sflist~ object has a unique name that sfplay~ obj", :href "/max8/refpages/sflist~", :obj-name "sflist~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "omx.5band~ delivers the signal-processing power of Octimax in a 5-band compressor."} omx-5band- (MaxFn. "omx.5band~" {:alias "omx.5band~", :doc "omx.5band~ delivers the signal-processing power of Octimax in a 5-band compressor.", :href "/max8/refpages/omx.5band~", :obj-name "omx.5band~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Smooths an incoming signal across n samples. Each time an incoming value changes, it begins a linear ramp to reach this value."} rampsmooth- (MaxFn. "rampsmooth~" {:alias "rampsmooth~", :doc "Smooths an incoming signal across n samples. Each time an incoming value changes, it begins a linear ramp to reach this value.", :href "/max8/refpages/rampsmooth~", :obj-name "rampsmooth~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The groove~ object is a variable-rate, looping, sample-playback object which references the audio information stored in a buffer~ object having the same name. W"} groove- (MaxFn. "groove~" {:alias "groove~", :doc "The groove~ object is a variable-rate, looping, sample-playback object which references the audio information stored in a buffer~ object having the same name. W", :href "/max8/refpages/groove~", :obj-name "groove~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the plot~ object to graph sets of data as points across a domain. The source of the data to be visualized may be a Max list, an MSP buffer~, or an audio sig"} plot- (MaxFn. "plot~" {:alias "plot~", :doc "Use the plot~ object to graph sets of data as points across a domain. The source of the data to be visualized may be a Max list, an MSP buffer~, or an audio sig", :href "/max8/refpages/plot~", :obj-name "plot~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "delta~ outputs a signal which represents the differences between each incoming sample value in the input signal."} delta- (MaxFn. "delta~" {:alias "delta~", :doc "delta~ outputs a signal which represents the differences between each incoming sample value in the input signal.", :href "/max8/refpages/delta~", :obj-name "delta~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Note: plug-in building for hosts other than Ableton Live is no longer supported. For more information to help you make the transition to creating plug-ins in Ma"} plugreceive- (MaxFn. "plugreceive~" {:alias "plugreceive~", :doc "Note: plug-in building for hosts other than Ableton Live is no longer supported. For more information to help you make the transition to creating plug-ins in Ma", :href "/max8/refpages/plugreceive~", :obj-name "plugreceive~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The hostsync~ object provides information about the current state of the ReWire host."} hostsync- (MaxFn. "hostsync~" {:alias "hostsync~", :doc "The hostsync~ object provides information about the current state of the ReWire host.", :href "/max8/refpages/hostsync~", :obj-name "hostsync~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use peek~ to read and write sample values to a named buffer~. Unlike related objects index~ and poke~, values and indices are specified as Max messages, and the"} peek- (MaxFn. "peek~" {:alias "peek~", :doc "Use peek~ to read and write sample values to a named buffer~. Unlike related objects index~ and poke~, values and indices are specified as Max messages, and the", :href "/max8/refpages/peek~", :obj-name "peek~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "zerox~ functions as a zero-crossing counter or transient detector."} zerox- (MaxFn. "zerox~" {:alias "zerox~", :doc "zerox~ functions as a zero-crossing counter or transient detector.", :href "/max8/refpages/zerox~", :obj-name "zerox~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The stutter~ object keeps a history of its signal input (left inlet). Upon receiving an int (left inlet), it copies that number of the most recently received sa"} stutter- (MaxFn. "stutter~" {:alias "stutter~", :doc "The stutter~ object keeps a history of its signal input (left inlet). Upon receiving an int (left inlet), it copies that number of the most recently received sa", :href "/max8/refpages/stutter~", :obj-name "stutter~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the asin~ object to calculate and output a signal that is the arc-sine function of each sample of the input signal."} asin- (MaxFn. "asin~" {:alias "asin~", :doc "Use the asin~ object to calculate and output a signal that is the arc-sine function of each sample of the input signal.", :href "/max8/refpages/asin~", :obj-name "asin~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "matrix~ is an array of signal connectors and mixers (adders). It can have any number of inlets and outlets. Signals entering at each inlet can be routed to one "} matrix- (MaxFn. "matrix~" {:alias "matrix~", :doc "matrix~ is an array of signal connectors and mixers (adders). It can have any number of inlets and outlets. Signals entering at each inlet can be routed to one ", :href "/max8/refpages/matrix~", :obj-name "matrix~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "record~ records a signal into a buffer~ object. You can record up to 4 channels by specifying the optional argument. Recording stops when the buffer~ is filled."} record- (MaxFn. "record~" {:alias "record~", :doc "record~ records a signal into a buffer~ object. You can record up to 4 channels by specifying the optional argument. Recording stops when the buffer~ is filled.", :href "/max8/refpages/record~", :obj-name "record~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "omx.peaklim~ is a peak-limiter which allows for the specified control of signal amplitude."} omx-peaklim- (MaxFn. "omx.peaklim~" {:alias "omx.peaklim~", :doc "omx.peaklim~ is a peak-limiter which allows for the specified control of signal amplitude.", :href "/max8/refpages/omx.peaklim~", :obj-name "omx.peaklim~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "minimum~ outputs a signal which is the minimum of two input signals."} minimum- (MaxFn. "minimum~" {:alias "minimum~", :doc "minimum~ outputs a signal which is the minimum of two input signals.", :href "/max8/refpages/minimum~", :obj-name "minimum~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "The zplane~ object provides a way to graph filter poles and zeros in the Z-plane for display. Use the zplane~ object in conjunction with the filtergraph~ object"} zplane- (MaxFn. "zplane~" {:alias "zplane~", :doc "The zplane~ object provides a way to graph filter poles and zeros in the Z-plane for display. Use the zplane~ object in conjunction with the filtergraph~ object", :href "/max8/refpages/zplane~", :obj-name "zplane~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "lores~ implements an inexpensive lowpass with an adjustment that lets you add a specified resonance. The middle inlet sets a kind of cutoff frequency, but the s"} lores- (MaxFn. "lores~" {:alias "lores~", :doc "lores~ implements an inexpensive lowpass with an adjustment that lets you add a specified resonance. The middle inlet sets a kind of cutoff frequency, but the s", :href "/max8/refpages/lores~", :obj-name "lores~"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "in defines a message inlet for a patcher loaded by poly~ or pfft~."} in (MaxFn. "in" {:alias "in", :doc "in defines a message inlet for a patcher loaded by poly~ or pfft~.", :href "/max8/refpages/in", :obj-name "in"}))
(def ^{:arglists '([args] [args inlet1] [args inlet1 inlet2] [args inlet1 inlet2 inlet3] [args inlet1 inlet2 inlet3 inlet4] [args inlet1 inlet2 inlet3 inlet4 inlet5] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9] [args inlet1 inlet2 inlet3 inlet4 inlet5 inlet6 inlet7 inlet8 inlet9 inlet10]), :doc "Use the delay~ object to delay a signal by a certain amount of time. The delay time can be specified in samples (determined by the sampling rate), or using the "} delay- (MaxFn. "delay~" {:alias "delay~", :doc "Use the delay~ object to delay a signal by a certain amount of time. The delay time can be specified in samples (determined by the sampling rate), or using the ", :href "/max8/refpages/delay~", :obj-name "delay~"}))

(extend-protocol jax.proto/IJaxLang
  Boolean
  (arguments [this] [(if this 1 0)])
  (inlet [this] [(number (if this 1 0))])

  Double
  (arguments [this] [this])
  (inlet [this] [(number this)])

  Short
  (arguments [this] [this])
  (inlet [this] [(number this)])

  Integer
  (arguments [this] [this])
  (inlet [this] [(number this)])

  Long
  (arguments [this] [this])
  (inlet [this] [(number this)])

  ^long
  (arguments [this] [this])
  (inlet [this] [(number this)])

  String
  (arguments [this] [this])
  (inlet [this] [(message this)])

  Keyword
  (arguments [this] [(patcher/route this)])
  (reference [this] [(patcher/route this)])
  (inlet [this] [(patcher/route this)])

  Object
  (arguments [this]
    (throw (ex-info (str "Invalid argument: " (pr-str this))
                    {:type :jax/syntax-error :argument this})))
  (inlet [this]
    (throw (ex-info (str "Invalid inlet: " (pr-str this))
                    {:type :jax/syntax-error :inlet this})))
  (reference [this]
    (throw (ex-info (str "Invalid reference: " (pr-str this))
                    {:type :jax/syntax-error :reference this})))

  Map
  (arguments [this]
    (if (patcher/route? this)
      [this]
      (throw (ex-info (str "Invalid argument: " (pr-str this))
                      {:type :jax/syntax-error :argument this}))))

  (inlet [this]
    [this])

  (reference [this]
    (cond
      (patcher/route? this)
      [this]

      (patcher/object-set? this)
      [(patcher/ref this (get (meta this) :outlet 0))]

      (patcher/object? this)
      [(patcher/ref this (get (meta this) :outlet 0))]

      :else (throw (ex-info (str "Invalid reference " (pr-str this))
                            {:type :jax/syntax-error :reference this}))))

  List
  (arguments [this] (mapcat jax.proto/arguments this))
  (reference [this] (mapcat jax.proto/reference this))
  (inlet [this] (map jax.proto/inlet this)))