(ns jax.patcher.test
  "Patcher DSL test utils"
  (:require [jax.patcher :as patcher])
  (:import (java.util.concurrent.atomic AtomicInteger)))

(defn genid
  [i]
  (fn
    ([]
     (str "jaxid" (.getAndIncrement i)))
    ([_]
     (str "jaxid" (.getAndIncrement i)))))

(defmacro wrap-genid
  "Wraps the body with a deterministic redef of jax.patcher/genid"
  [& body]
  `(let [i# (AtomicInteger.)]
     (with-redefs [patcher/genid (genid i#)]
       ~@body)))