(ns jax.impl.meta
  (:require [jax.impl.patch :as patch]
            [jax.impl.system :as system])
  (:import (com.cycling74.max MaxSystem)))

(def version
  "1.0.0")

(defn system
  "Returns a map of metadata about Jax"
  []
  {:default-path (try (MaxSystem/getDefaultPath)
                      (catch Throwable _ nil))
   :classpath    (try (into (set (MaxSystem/getClassPath))
                            (patch/classpath))
                      (catch Throwable _ nil))
   :max/version  (try (MaxSystem/getMaxVersion)
                      (catch Throwable _ nil))
   :jax/version  version
   :jax/running? (patch/running?)
   :nrepl-port   (system/nrepl-port)
   :jetty-port   (system/jetty-port)
   :docs         "https://tscrowley.dev/jax"
   :github       "https://github.com/wavejumper"
   :macos?       (try (MaxSystem/isOsMacOsX)
                      (catch Throwable _ nil))
   :windows?     (try (MaxSystem/isOsWindows)
                      (catch Throwable _ nil))
   :search-path  (try (set (MaxSystem/getSearchPath))
                      (catch Throwable _ nil))
   :time         (try (MaxSystem/sysTimerGetTime)
                      (catch Throwable _ nil))
   :runtime?     (try (MaxSystem/isRuntime)
                      (catch Throwable _ nil))
   :standalone?  (try (MaxSystem/isStandAlone)
                      (catch Throwable _ nil))})