(ns jax.impl.nrepl
  (:require [clojure.java.io :as io]
            [nrepl.server :as nrepl]
            [nrepl.transport :as transport]
            [clojure.tools.logging :as log]))

(defn jax-greeting
  [transport]
  (transport/send transport {:out (str (slurp (io/resource "splash.txt")) "\n")}))

(defn server []
  (let [server (nrepl/start-server :greeting-fn jax-greeting)]
    (log/info "nREPL server started on port" (:port server))
    server))