(ns jax.impl.serdes
  (:import (com.cycling74.max Atom)
           (java.util List)
           (clojure.lang Keyword)))

(defprotocol Serializer
  (serialize [this]))

(defprotocol Deserializer
  (deserialize [this]))

(extend-protocol Deserializer
  ;; TODO: is there a better way than this???!!!
  (type (into-array Atom []))
  (deserialize [this]
    (into [] (map deserialize) this))

  Atom
  (deserialize [this]
    (cond
      (.isFloat this)
      (.toFloat this)

      (.isInt this)
      (.toInt this)

      (.isString this)
      (.toString this)

      :else this))

  nil
  (deserialize [this]
    this)

  Object
  (deserialize [this]
    this))

(extend-protocol Serializer
  Double
  (serialize [this]
    (Atom/newAtom this))

  Float
  (serialize [this]
    (Atom/newAtom this))

  Integer
  (serialize [this]
    (Atom/newAtom this))

  String
  (serialize [this]
    (Atom/newAtom this))

  Short
  (serialize [this]
    (Atom/newAtom this))

  ^long
  (serialize [this]
             (Atom/newAtom this))

  Keyword
  (serialize [this]
    (Atom/newAtom (name this)))

  List
  (serialize [this]
    (into-array Atom (map serialize this)))

  Boolean
  (serialize [this]
    (Atom/newAtom this))

  nil
  (serialize [_])

  Object
  (serialize [this]
   ;; fall back to reflection
    (Atom/newAtom this)))