(ns jax.msp
  (:refer-clojure :exclude [load])
  (:require [clojure.core.protocols :as p])
  (:import (com.cycling74.msp AudioFileBuffer)))

(extend-protocol p/Datafiable
  AudioFileBuffer
  (datafy [this]
    {:channels         (.getChannels this)
     :frame-length     (.getFrameLength this)
     :length-ms        (.getLengthMs this)
     :sample-rate      (.getSampleRate this)
     :sample-size-bits (.getSampleSizeInBits this)
     :big-endian?      (.isBigEndian this)}))

(defn describe-buffer
  [buf]
  (p/datafy buf))

(defn buffer
  "Returns the audio samples loaded off of disk deinterleaved by channel into a 2 dimensional floating point array."
  [buf]
  (.buf buf))

(defn load
  "Load an audio file into memory. The data is translated from the native file format into the the floating point format used by msp."
  [file]
  (AudioFileBuffer. file))