(ns jax.prelude
  (:require [potemkin :as potemkin]
            [jax.impl.runtime]
            [jax.impl.system :as system]
            [jax.patcher]
            [jax.examples]
            [jax.lang.proto]
            [clojure.spec.alpha :as s]
            [expound.alpha :as expound]))

(s/check-asserts true)

(try
  (set! s/*explain-out* expound/printer)
  (catch Throwable _))

(potemkin/import-vars
 [jax.impl.runtime
  eval! eval-midi-effect! clear route! capture capture-signal inlet outlet defroute
  bang delay-inst event-loop event-handler load-patch new-patch close-patch restart-patch
  definst]

 [jax.impl.system
  nrepl-port jetty-port]

 [jax.patcher
  route instrument midi-effect parameters]

 [jax.examples
  sin-osc]

 [jax.lang.proto
  open-docs])

(defn web-ui []
  (format "http://localhost:%s/index.html" (system/jetty-port)))