goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__43631 = arguments.length;
switch (G__43631) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43665 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43665 = (function (f,blockable,meta43666){
this.f = f;
this.blockable = blockable;
this.meta43666 = meta43666;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43665.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43667,meta43666__$1){
var self__ = this;
var _43667__$1 = this;
return (new cljs.core.async.t_cljs$core$async43665(self__.f,self__.blockable,meta43666__$1));
}));

(cljs.core.async.t_cljs$core$async43665.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43667){
var self__ = this;
var _43667__$1 = this;
return self__.meta43666;
}));

(cljs.core.async.t_cljs$core$async43665.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43665.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43665.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async43665.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async43665.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta43666","meta43666",-844426236,null)], null);
}));

(cljs.core.async.t_cljs$core$async43665.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43665.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43665");

(cljs.core.async.t_cljs$core$async43665.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43665");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43665.
 */
cljs.core.async.__GT_t_cljs$core$async43665 = (function cljs$core$async$__GT_t_cljs$core$async43665(f__$1,blockable__$1,meta43666){
return (new cljs.core.async.t_cljs$core$async43665(f__$1,blockable__$1,meta43666));
});

}

return (new cljs.core.async.t_cljs$core$async43665(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__43714 = arguments.length;
switch (G__43714) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__43726 = arguments.length;
switch (G__43726) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__43728 = arguments.length;
switch (G__43728) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_46382 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46382) : fn1.call(null,val_46382));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46382) : fn1.call(null,val_46382));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__43738 = arguments.length;
switch (G__43738) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___46387 = n;
var x_46388 = (0);
while(true){
if((x_46388 < n__4613__auto___46387)){
(a[x_46388] = x_46388);

var G__46389 = (x_46388 + (1));
x_46388 = G__46389;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43757 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43757 = (function (flag,meta43758){
this.flag = flag;
this.meta43758 = meta43758;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43757.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43759,meta43758__$1){
var self__ = this;
var _43759__$1 = this;
return (new cljs.core.async.t_cljs$core$async43757(self__.flag,meta43758__$1));
}));

(cljs.core.async.t_cljs$core$async43757.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43759){
var self__ = this;
var _43759__$1 = this;
return self__.meta43758;
}));

(cljs.core.async.t_cljs$core$async43757.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43757.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async43757.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43757.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async43757.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta43758","meta43758",-1999195382,null)], null);
}));

(cljs.core.async.t_cljs$core$async43757.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43757.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43757");

(cljs.core.async.t_cljs$core$async43757.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43757");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43757.
 */
cljs.core.async.__GT_t_cljs$core$async43757 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async43757(flag__$1,meta43758){
return (new cljs.core.async.t_cljs$core$async43757(flag__$1,meta43758));
});

}

return (new cljs.core.async.t_cljs$core$async43757(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43776 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43776 = (function (flag,cb,meta43777){
this.flag = flag;
this.cb = cb;
this.meta43777 = meta43777;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43776.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43778,meta43777__$1){
var self__ = this;
var _43778__$1 = this;
return (new cljs.core.async.t_cljs$core$async43776(self__.flag,self__.cb,meta43777__$1));
}));

(cljs.core.async.t_cljs$core$async43776.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43778){
var self__ = this;
var _43778__$1 = this;
return self__.meta43777;
}));

(cljs.core.async.t_cljs$core$async43776.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43776.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async43776.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43776.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async43776.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta43777","meta43777",596112394,null)], null);
}));

(cljs.core.async.t_cljs$core$async43776.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43776.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43776");

(cljs.core.async.t_cljs$core$async43776.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43776");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43776.
 */
cljs.core.async.__GT_t_cljs$core$async43776 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async43776(flag__$1,cb__$1,meta43777){
return (new cljs.core.async.t_cljs$core$async43776(flag__$1,cb__$1,meta43777));
});

}

return (new cljs.core.async.t_cljs$core$async43776(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43808_SHARP_){
var G__43812 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43808_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__43812) : fret.call(null,G__43812));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43809_SHARP_){
var G__43813 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43809_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__43813) : fret.call(null,G__43813));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__46416 = (i + (1));
i = G__46416;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46419 = arguments.length;
var i__4737__auto___46420 = (0);
while(true){
if((i__4737__auto___46420 < len__4736__auto___46419)){
args__4742__auto__.push((arguments[i__4737__auto___46420]));

var G__46423 = (i__4737__auto___46420 + (1));
i__4737__auto___46420 = G__46423;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__43826){
var map__43829 = p__43826;
var map__43829__$1 = (((((!((map__43829 == null))))?(((((map__43829.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43829.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43829):map__43829);
var opts = map__43829__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq43819){
var G__43820 = cljs.core.first(seq43819);
var seq43819__$1 = cljs.core.next(seq43819);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43820,seq43819__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__43839 = arguments.length;
switch (G__43839) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__43544__auto___46427 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_43965){
var state_val_43970 = (state_43965[(1)]);
if((state_val_43970 === (7))){
var inst_43955 = (state_43965[(2)]);
var state_43965__$1 = state_43965;
var statearr_43985_46428 = state_43965__$1;
(statearr_43985_46428[(2)] = inst_43955);

(statearr_43985_46428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (1))){
var state_43965__$1 = state_43965;
var statearr_43986_46429 = state_43965__$1;
(statearr_43986_46429[(2)] = null);

(statearr_43986_46429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (4))){
var inst_43853 = (state_43965[(7)]);
var inst_43853__$1 = (state_43965[(2)]);
var inst_43917 = (inst_43853__$1 == null);
var state_43965__$1 = (function (){var statearr_43987 = state_43965;
(statearr_43987[(7)] = inst_43853__$1);

return statearr_43987;
})();
if(cljs.core.truth_(inst_43917)){
var statearr_43988_46430 = state_43965__$1;
(statearr_43988_46430[(1)] = (5));

} else {
var statearr_43989_46431 = state_43965__$1;
(statearr_43989_46431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (13))){
var state_43965__$1 = state_43965;
var statearr_43990_46432 = state_43965__$1;
(statearr_43990_46432[(2)] = null);

(statearr_43990_46432[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (6))){
var inst_43853 = (state_43965[(7)]);
var state_43965__$1 = state_43965;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43965__$1,(11),to,inst_43853);
} else {
if((state_val_43970 === (3))){
var inst_43957 = (state_43965[(2)]);
var state_43965__$1 = state_43965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43965__$1,inst_43957);
} else {
if((state_val_43970 === (12))){
var state_43965__$1 = state_43965;
var statearr_43991_46433 = state_43965__$1;
(statearr_43991_46433[(2)] = null);

(statearr_43991_46433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (2))){
var state_43965__$1 = state_43965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43965__$1,(4),from);
} else {
if((state_val_43970 === (11))){
var inst_43948 = (state_43965[(2)]);
var state_43965__$1 = state_43965;
if(cljs.core.truth_(inst_43948)){
var statearr_43992_46434 = state_43965__$1;
(statearr_43992_46434[(1)] = (12));

} else {
var statearr_43993_46435 = state_43965__$1;
(statearr_43993_46435[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (9))){
var state_43965__$1 = state_43965;
var statearr_43997_46438 = state_43965__$1;
(statearr_43997_46438[(2)] = null);

(statearr_43997_46438[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (5))){
var state_43965__$1 = state_43965;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43998_46441 = state_43965__$1;
(statearr_43998_46441[(1)] = (8));

} else {
var statearr_43999_46442 = state_43965__$1;
(statearr_43999_46442[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (14))){
var inst_43953 = (state_43965[(2)]);
var state_43965__$1 = state_43965;
var statearr_44000_46445 = state_43965__$1;
(statearr_44000_46445[(2)] = inst_43953);

(statearr_44000_46445[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (10))){
var inst_43943 = (state_43965[(2)]);
var state_43965__$1 = state_43965;
var statearr_44001_46446 = state_43965__$1;
(statearr_44001_46446[(2)] = inst_43943);

(statearr_44001_46446[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43970 === (8))){
var inst_43925 = cljs.core.async.close_BANG_(to);
var state_43965__$1 = state_43965;
var statearr_44002_46447 = state_43965__$1;
(statearr_44002_46447[(2)] = inst_43925);

(statearr_44002_46447[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_44004 = [null,null,null,null,null,null,null,null];
(statearr_44004[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_44004[(1)] = (1));

return statearr_44004;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_43965){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_43965);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44005){var ex__43301__auto__ = e44005;
var statearr_44008_46450 = state_43965;
(statearr_44008_46450[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_43965[(4)]))){
var statearr_44010_46451 = state_43965;
(statearr_44010_46451[(1)] = cljs.core.first((state_43965[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46452 = state_43965;
state_43965 = G__46452;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_43965){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_43965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_44033 = f__43545__auto__();
(statearr_44033[(6)] = c__43544__auto___46427);

return statearr_44033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__44056){
var vec__44061 = p__44056;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44061,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44061,(1),null);
var job = vec__44061;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__43544__auto___46457 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_44072){
var state_val_44073 = (state_44072[(1)]);
if((state_val_44073 === (1))){
var state_44072__$1 = state_44072;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44072__$1,(2),res,v);
} else {
if((state_val_44073 === (2))){
var inst_44065 = (state_44072[(2)]);
var inst_44066 = cljs.core.async.close_BANG_(res);
var state_44072__$1 = (function (){var statearr_44089 = state_44072;
(statearr_44089[(7)] = inst_44065);

return statearr_44089;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44072__$1,inst_44066);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0 = (function (){
var statearr_44094 = [null,null,null,null,null,null,null,null];
(statearr_44094[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__);

(statearr_44094[(1)] = (1));

return statearr_44094;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1 = (function (state_44072){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44072);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44098){var ex__43301__auto__ = e44098;
var statearr_44100_46460 = state_44072;
(statearr_44100_46460[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44072[(4)]))){
var statearr_44104_46461 = state_44072;
(statearr_44104_46461[(1)] = cljs.core.first((state_44072[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46462 = state_44072;
state_44072 = G__46462;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = function(state_44072){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1.call(this,state_44072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_44107 = f__43545__auto__();
(statearr_44107[(6)] = c__43544__auto___46457);

return statearr_44107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__44110){
var vec__44111 = p__44110;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44111,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44111,(1),null);
var job = vec__44111;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___46463 = n;
var __46464 = (0);
while(true){
if((__46464 < n__4613__auto___46463)){
var G__44115_46465 = type;
var G__44115_46466__$1 = (((G__44115_46465 instanceof cljs.core.Keyword))?G__44115_46465.fqn:null);
switch (G__44115_46466__$1) {
case "compute":
var c__43544__auto___46468 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46464,c__43544__auto___46468,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async){
return (function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = ((function (__46464,c__43544__auto___46468,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async){
return (function (state_44128){
var state_val_44129 = (state_44128[(1)]);
if((state_val_44129 === (1))){
var state_44128__$1 = state_44128;
var statearr_44136_46469 = state_44128__$1;
(statearr_44136_46469[(2)] = null);

(statearr_44136_46469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44129 === (2))){
var state_44128__$1 = state_44128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44128__$1,(4),jobs);
} else {
if((state_val_44129 === (3))){
var inst_44126 = (state_44128[(2)]);
var state_44128__$1 = state_44128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44128__$1,inst_44126);
} else {
if((state_val_44129 === (4))){
var inst_44118 = (state_44128[(2)]);
var inst_44119 = process(inst_44118);
var state_44128__$1 = state_44128;
if(cljs.core.truth_(inst_44119)){
var statearr_44137_46471 = state_44128__$1;
(statearr_44137_46471[(1)] = (5));

} else {
var statearr_44138_46472 = state_44128__$1;
(statearr_44138_46472[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44129 === (5))){
var state_44128__$1 = state_44128;
var statearr_44139_46473 = state_44128__$1;
(statearr_44139_46473[(2)] = null);

(statearr_44139_46473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44129 === (6))){
var state_44128__$1 = state_44128;
var statearr_44141_46474 = state_44128__$1;
(statearr_44141_46474[(2)] = null);

(statearr_44141_46474[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44129 === (7))){
var inst_44124 = (state_44128[(2)]);
var state_44128__$1 = state_44128;
var statearr_44150_46476 = state_44128__$1;
(statearr_44150_46476[(2)] = inst_44124);

(statearr_44150_46476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46464,c__43544__auto___46468,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async))
;
return ((function (__46464,switch__43297__auto__,c__43544__auto___46468,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0 = (function (){
var statearr_44151 = [null,null,null,null,null,null,null];
(statearr_44151[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__);

(statearr_44151[(1)] = (1));

return statearr_44151;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1 = (function (state_44128){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44128);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44152){var ex__43301__auto__ = e44152;
var statearr_44153_46478 = state_44128;
(statearr_44153_46478[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44128[(4)]))){
var statearr_44154_46479 = state_44128;
(statearr_44154_46479[(1)] = cljs.core.first((state_44128[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46486 = state_44128;
state_44128 = G__46486;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = function(state_44128){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1.call(this,state_44128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__;
})()
;})(__46464,switch__43297__auto__,c__43544__auto___46468,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async))
})();
var state__43546__auto__ = (function (){var statearr_44156 = f__43545__auto__();
(statearr_44156[(6)] = c__43544__auto___46468);

return statearr_44156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
});})(__46464,c__43544__auto___46468,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async))
);


break;
case "async":
var c__43544__auto___46488 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46464,c__43544__auto___46488,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async){
return (function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = ((function (__46464,c__43544__auto___46488,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async){
return (function (state_44170){
var state_val_44171 = (state_44170[(1)]);
if((state_val_44171 === (1))){
var state_44170__$1 = state_44170;
var statearr_44174_46490 = state_44170__$1;
(statearr_44174_46490[(2)] = null);

(statearr_44174_46490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44171 === (2))){
var state_44170__$1 = state_44170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44170__$1,(4),jobs);
} else {
if((state_val_44171 === (3))){
var inst_44168 = (state_44170[(2)]);
var state_44170__$1 = state_44170;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44170__$1,inst_44168);
} else {
if((state_val_44171 === (4))){
var inst_44160 = (state_44170[(2)]);
var inst_44161 = async(inst_44160);
var state_44170__$1 = state_44170;
if(cljs.core.truth_(inst_44161)){
var statearr_44175_46491 = state_44170__$1;
(statearr_44175_46491[(1)] = (5));

} else {
var statearr_44176_46492 = state_44170__$1;
(statearr_44176_46492[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44171 === (5))){
var state_44170__$1 = state_44170;
var statearr_44177_46494 = state_44170__$1;
(statearr_44177_46494[(2)] = null);

(statearr_44177_46494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44171 === (6))){
var state_44170__$1 = state_44170;
var statearr_44184_46496 = state_44170__$1;
(statearr_44184_46496[(2)] = null);

(statearr_44184_46496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44171 === (7))){
var inst_44166 = (state_44170[(2)]);
var state_44170__$1 = state_44170;
var statearr_44185_46497 = state_44170__$1;
(statearr_44185_46497[(2)] = inst_44166);

(statearr_44185_46497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46464,c__43544__auto___46488,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async))
;
return ((function (__46464,switch__43297__auto__,c__43544__auto___46488,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0 = (function (){
var statearr_44186 = [null,null,null,null,null,null,null];
(statearr_44186[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__);

(statearr_44186[(1)] = (1));

return statearr_44186;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1 = (function (state_44170){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44170);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44187){var ex__43301__auto__ = e44187;
var statearr_44188_46498 = state_44170;
(statearr_44188_46498[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44170[(4)]))){
var statearr_44189_46499 = state_44170;
(statearr_44189_46499[(1)] = cljs.core.first((state_44170[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46505 = state_44170;
state_44170 = G__46505;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = function(state_44170){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1.call(this,state_44170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__;
})()
;})(__46464,switch__43297__auto__,c__43544__auto___46488,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async))
})();
var state__43546__auto__ = (function (){var statearr_44190 = f__43545__auto__();
(statearr_44190[(6)] = c__43544__auto___46488);

return statearr_44190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
});})(__46464,c__43544__auto___46488,G__44115_46465,G__44115_46466__$1,n__4613__auto___46463,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44115_46466__$1)].join('')));

}

var G__46507 = (__46464 + (1));
__46464 = G__46507;
continue;
} else {
}
break;
}

var c__43544__auto___46508 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_44214){
var state_val_44215 = (state_44214[(1)]);
if((state_val_44215 === (7))){
var inst_44210 = (state_44214[(2)]);
var state_44214__$1 = state_44214;
var statearr_44225_46510 = state_44214__$1;
(statearr_44225_46510[(2)] = inst_44210);

(statearr_44225_46510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44215 === (1))){
var state_44214__$1 = state_44214;
var statearr_44226_46511 = state_44214__$1;
(statearr_44226_46511[(2)] = null);

(statearr_44226_46511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44215 === (4))){
var inst_44193 = (state_44214[(7)]);
var inst_44193__$1 = (state_44214[(2)]);
var inst_44194 = (inst_44193__$1 == null);
var state_44214__$1 = (function (){var statearr_44227 = state_44214;
(statearr_44227[(7)] = inst_44193__$1);

return statearr_44227;
})();
if(cljs.core.truth_(inst_44194)){
var statearr_44228_46512 = state_44214__$1;
(statearr_44228_46512[(1)] = (5));

} else {
var statearr_44229_46513 = state_44214__$1;
(statearr_44229_46513[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44215 === (6))){
var inst_44199 = (state_44214[(8)]);
var inst_44193 = (state_44214[(7)]);
var inst_44199__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44202 = [inst_44193,inst_44199__$1];
var inst_44203 = (new cljs.core.PersistentVector(null,2,(5),inst_44201,inst_44202,null));
var state_44214__$1 = (function (){var statearr_44231 = state_44214;
(statearr_44231[(8)] = inst_44199__$1);

return statearr_44231;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44214__$1,(8),jobs,inst_44203);
} else {
if((state_val_44215 === (3))){
var inst_44212 = (state_44214[(2)]);
var state_44214__$1 = state_44214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44214__$1,inst_44212);
} else {
if((state_val_44215 === (2))){
var state_44214__$1 = state_44214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44214__$1,(4),from);
} else {
if((state_val_44215 === (9))){
var inst_44207 = (state_44214[(2)]);
var state_44214__$1 = (function (){var statearr_44232 = state_44214;
(statearr_44232[(9)] = inst_44207);

return statearr_44232;
})();
var statearr_44234_46516 = state_44214__$1;
(statearr_44234_46516[(2)] = null);

(statearr_44234_46516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44215 === (5))){
var inst_44196 = cljs.core.async.close_BANG_(jobs);
var state_44214__$1 = state_44214;
var statearr_44237_46517 = state_44214__$1;
(statearr_44237_46517[(2)] = inst_44196);

(statearr_44237_46517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44215 === (8))){
var inst_44199 = (state_44214[(8)]);
var inst_44205 = (state_44214[(2)]);
var state_44214__$1 = (function (){var statearr_44241 = state_44214;
(statearr_44241[(10)] = inst_44205);

return statearr_44241;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44214__$1,(9),results,inst_44199);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0 = (function (){
var statearr_44243 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44243[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__);

(statearr_44243[(1)] = (1));

return statearr_44243;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1 = (function (state_44214){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44214);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44244){var ex__43301__auto__ = e44244;
var statearr_44245_46518 = state_44214;
(statearr_44245_46518[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44214[(4)]))){
var statearr_44246_46519 = state_44214;
(statearr_44246_46519[(1)] = cljs.core.first((state_44214[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46521 = state_44214;
state_44214 = G__46521;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = function(state_44214){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1.call(this,state_44214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_44247 = f__43545__auto__();
(statearr_44247[(6)] = c__43544__auto___46508);

return statearr_44247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


var c__43544__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_44292){
var state_val_44293 = (state_44292[(1)]);
if((state_val_44293 === (7))){
var inst_44287 = (state_44292[(2)]);
var state_44292__$1 = state_44292;
var statearr_44295_46524 = state_44292__$1;
(statearr_44295_46524[(2)] = inst_44287);

(statearr_44295_46524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (20))){
var state_44292__$1 = state_44292;
var statearr_44296_46525 = state_44292__$1;
(statearr_44296_46525[(2)] = null);

(statearr_44296_46525[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (1))){
var state_44292__$1 = state_44292;
var statearr_44301_46526 = state_44292__$1;
(statearr_44301_46526[(2)] = null);

(statearr_44301_46526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (4))){
var inst_44250 = (state_44292[(7)]);
var inst_44250__$1 = (state_44292[(2)]);
var inst_44252 = (inst_44250__$1 == null);
var state_44292__$1 = (function (){var statearr_44303 = state_44292;
(statearr_44303[(7)] = inst_44250__$1);

return statearr_44303;
})();
if(cljs.core.truth_(inst_44252)){
var statearr_44304_46527 = state_44292__$1;
(statearr_44304_46527[(1)] = (5));

} else {
var statearr_44305_46528 = state_44292__$1;
(statearr_44305_46528[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (15))){
var inst_44267 = (state_44292[(8)]);
var state_44292__$1 = state_44292;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44292__$1,(18),to,inst_44267);
} else {
if((state_val_44293 === (21))){
var inst_44282 = (state_44292[(2)]);
var state_44292__$1 = state_44292;
var statearr_44310_46530 = state_44292__$1;
(statearr_44310_46530[(2)] = inst_44282);

(statearr_44310_46530[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (13))){
var inst_44284 = (state_44292[(2)]);
var state_44292__$1 = (function (){var statearr_44311 = state_44292;
(statearr_44311[(9)] = inst_44284);

return statearr_44311;
})();
var statearr_44312_46531 = state_44292__$1;
(statearr_44312_46531[(2)] = null);

(statearr_44312_46531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (6))){
var inst_44250 = (state_44292[(7)]);
var state_44292__$1 = state_44292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44292__$1,(11),inst_44250);
} else {
if((state_val_44293 === (17))){
var inst_44276 = (state_44292[(2)]);
var state_44292__$1 = state_44292;
if(cljs.core.truth_(inst_44276)){
var statearr_44313_46532 = state_44292__$1;
(statearr_44313_46532[(1)] = (19));

} else {
var statearr_44314_46533 = state_44292__$1;
(statearr_44314_46533[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (3))){
var inst_44289 = (state_44292[(2)]);
var state_44292__$1 = state_44292;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44292__$1,inst_44289);
} else {
if((state_val_44293 === (12))){
var inst_44264 = (state_44292[(10)]);
var state_44292__$1 = state_44292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44292__$1,(14),inst_44264);
} else {
if((state_val_44293 === (2))){
var state_44292__$1 = state_44292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44292__$1,(4),results);
} else {
if((state_val_44293 === (19))){
var state_44292__$1 = state_44292;
var statearr_44316_46534 = state_44292__$1;
(statearr_44316_46534[(2)] = null);

(statearr_44316_46534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (11))){
var inst_44264 = (state_44292[(2)]);
var state_44292__$1 = (function (){var statearr_44319 = state_44292;
(statearr_44319[(10)] = inst_44264);

return statearr_44319;
})();
var statearr_44320_46539 = state_44292__$1;
(statearr_44320_46539[(2)] = null);

(statearr_44320_46539[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (9))){
var state_44292__$1 = state_44292;
var statearr_44322_46540 = state_44292__$1;
(statearr_44322_46540[(2)] = null);

(statearr_44322_46540[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (5))){
var state_44292__$1 = state_44292;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44325_46541 = state_44292__$1;
(statearr_44325_46541[(1)] = (8));

} else {
var statearr_44326_46542 = state_44292__$1;
(statearr_44326_46542[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (14))){
var inst_44267 = (state_44292[(8)]);
var inst_44267__$1 = (state_44292[(2)]);
var inst_44268 = (inst_44267__$1 == null);
var inst_44269 = cljs.core.not(inst_44268);
var state_44292__$1 = (function (){var statearr_44327 = state_44292;
(statearr_44327[(8)] = inst_44267__$1);

return statearr_44327;
})();
if(inst_44269){
var statearr_44328_46543 = state_44292__$1;
(statearr_44328_46543[(1)] = (15));

} else {
var statearr_44329_46545 = state_44292__$1;
(statearr_44329_46545[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (16))){
var state_44292__$1 = state_44292;
var statearr_44334_46546 = state_44292__$1;
(statearr_44334_46546[(2)] = false);

(statearr_44334_46546[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (10))){
var inst_44261 = (state_44292[(2)]);
var state_44292__$1 = state_44292;
var statearr_44335_46547 = state_44292__$1;
(statearr_44335_46547[(2)] = inst_44261);

(statearr_44335_46547[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (18))){
var inst_44272 = (state_44292[(2)]);
var state_44292__$1 = state_44292;
var statearr_44337_46548 = state_44292__$1;
(statearr_44337_46548[(2)] = inst_44272);

(statearr_44337_46548[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44293 === (8))){
var inst_44255 = cljs.core.async.close_BANG_(to);
var state_44292__$1 = state_44292;
var statearr_44339_46549 = state_44292__$1;
(statearr_44339_46549[(2)] = inst_44255);

(statearr_44339_46549[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0 = (function (){
var statearr_44341 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44341[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__);

(statearr_44341[(1)] = (1));

return statearr_44341;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1 = (function (state_44292){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44292);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44342){var ex__43301__auto__ = e44342;
var statearr_44343_46552 = state_44292;
(statearr_44343_46552[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44292[(4)]))){
var statearr_44344_46553 = state_44292;
(statearr_44344_46553[(1)] = cljs.core.first((state_44292[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46554 = state_44292;
state_44292 = G__46554;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__ = function(state_44292){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1.call(this,state_44292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_44345 = f__43545__auto__();
(statearr_44345[(6)] = c__43544__auto__);

return statearr_44345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));

return c__43544__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44349 = arguments.length;
switch (G__44349) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44355 = arguments.length;
switch (G__44355) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44363 = arguments.length;
switch (G__44363) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__43544__auto___46577 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_44397){
var state_val_44398 = (state_44397[(1)]);
if((state_val_44398 === (7))){
var inst_44393 = (state_44397[(2)]);
var state_44397__$1 = state_44397;
var statearr_44402_46578 = state_44397__$1;
(statearr_44402_46578[(2)] = inst_44393);

(statearr_44402_46578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (1))){
var state_44397__$1 = state_44397;
var statearr_44403_46582 = state_44397__$1;
(statearr_44403_46582[(2)] = null);

(statearr_44403_46582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (4))){
var inst_44374 = (state_44397[(7)]);
var inst_44374__$1 = (state_44397[(2)]);
var inst_44375 = (inst_44374__$1 == null);
var state_44397__$1 = (function (){var statearr_44408 = state_44397;
(statearr_44408[(7)] = inst_44374__$1);

return statearr_44408;
})();
if(cljs.core.truth_(inst_44375)){
var statearr_44409_46592 = state_44397__$1;
(statearr_44409_46592[(1)] = (5));

} else {
var statearr_44410_46593 = state_44397__$1;
(statearr_44410_46593[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (13))){
var state_44397__$1 = state_44397;
var statearr_44414_46594 = state_44397__$1;
(statearr_44414_46594[(2)] = null);

(statearr_44414_46594[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (6))){
var inst_44374 = (state_44397[(7)]);
var inst_44380 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_44374) : p.call(null,inst_44374));
var state_44397__$1 = state_44397;
if(cljs.core.truth_(inst_44380)){
var statearr_44415_46601 = state_44397__$1;
(statearr_44415_46601[(1)] = (9));

} else {
var statearr_44416_46603 = state_44397__$1;
(statearr_44416_46603[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (3))){
var inst_44395 = (state_44397[(2)]);
var state_44397__$1 = state_44397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44397__$1,inst_44395);
} else {
if((state_val_44398 === (12))){
var state_44397__$1 = state_44397;
var statearr_44417_46606 = state_44397__$1;
(statearr_44417_46606[(2)] = null);

(statearr_44417_46606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (2))){
var state_44397__$1 = state_44397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44397__$1,(4),ch);
} else {
if((state_val_44398 === (11))){
var inst_44374 = (state_44397[(7)]);
var inst_44384 = (state_44397[(2)]);
var state_44397__$1 = state_44397;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44397__$1,(8),inst_44384,inst_44374);
} else {
if((state_val_44398 === (9))){
var state_44397__$1 = state_44397;
var statearr_44418_46616 = state_44397__$1;
(statearr_44418_46616[(2)] = tc);

(statearr_44418_46616[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (5))){
var inst_44377 = cljs.core.async.close_BANG_(tc);
var inst_44378 = cljs.core.async.close_BANG_(fc);
var state_44397__$1 = (function (){var statearr_44419 = state_44397;
(statearr_44419[(8)] = inst_44377);

return statearr_44419;
})();
var statearr_44420_46621 = state_44397__$1;
(statearr_44420_46621[(2)] = inst_44378);

(statearr_44420_46621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (14))){
var inst_44391 = (state_44397[(2)]);
var state_44397__$1 = state_44397;
var statearr_44421_46624 = state_44397__$1;
(statearr_44421_46624[(2)] = inst_44391);

(statearr_44421_46624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (10))){
var state_44397__$1 = state_44397;
var statearr_44422_46633 = state_44397__$1;
(statearr_44422_46633[(2)] = fc);

(statearr_44422_46633[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44398 === (8))){
var inst_44386 = (state_44397[(2)]);
var state_44397__$1 = state_44397;
if(cljs.core.truth_(inst_44386)){
var statearr_44423_46635 = state_44397__$1;
(statearr_44423_46635[(1)] = (12));

} else {
var statearr_44424_46636 = state_44397__$1;
(statearr_44424_46636[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_44425 = [null,null,null,null,null,null,null,null,null];
(statearr_44425[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_44425[(1)] = (1));

return statearr_44425;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_44397){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44397);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44426){var ex__43301__auto__ = e44426;
var statearr_44427_46642 = state_44397;
(statearr_44427_46642[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44397[(4)]))){
var statearr_44428_46643 = state_44397;
(statearr_44428_46643[(1)] = cljs.core.first((state_44397[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46644 = state_44397;
state_44397 = G__46644;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_44397){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_44397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_44429 = f__43545__auto__();
(statearr_44429[(6)] = c__43544__auto___46577);

return statearr_44429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__43544__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_44451){
var state_val_44452 = (state_44451[(1)]);
if((state_val_44452 === (7))){
var inst_44447 = (state_44451[(2)]);
var state_44451__$1 = state_44451;
var statearr_44462_46651 = state_44451__$1;
(statearr_44462_46651[(2)] = inst_44447);

(statearr_44462_46651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44452 === (1))){
var inst_44430 = init;
var inst_44431 = inst_44430;
var state_44451__$1 = (function (){var statearr_44467 = state_44451;
(statearr_44467[(7)] = inst_44431);

return statearr_44467;
})();
var statearr_44468_46656 = state_44451__$1;
(statearr_44468_46656[(2)] = null);

(statearr_44468_46656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44452 === (4))){
var inst_44434 = (state_44451[(8)]);
var inst_44434__$1 = (state_44451[(2)]);
var inst_44435 = (inst_44434__$1 == null);
var state_44451__$1 = (function (){var statearr_44469 = state_44451;
(statearr_44469[(8)] = inst_44434__$1);

return statearr_44469;
})();
if(cljs.core.truth_(inst_44435)){
var statearr_44470_46658 = state_44451__$1;
(statearr_44470_46658[(1)] = (5));

} else {
var statearr_44471_46659 = state_44451__$1;
(statearr_44471_46659[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44452 === (6))){
var inst_44438 = (state_44451[(9)]);
var inst_44434 = (state_44451[(8)]);
var inst_44431 = (state_44451[(7)]);
var inst_44438__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_44431,inst_44434) : f.call(null,inst_44431,inst_44434));
var inst_44439 = cljs.core.reduced_QMARK_(inst_44438__$1);
var state_44451__$1 = (function (){var statearr_44472 = state_44451;
(statearr_44472[(9)] = inst_44438__$1);

return statearr_44472;
})();
if(inst_44439){
var statearr_44473_46660 = state_44451__$1;
(statearr_44473_46660[(1)] = (8));

} else {
var statearr_44474_46662 = state_44451__$1;
(statearr_44474_46662[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44452 === (3))){
var inst_44449 = (state_44451[(2)]);
var state_44451__$1 = state_44451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44451__$1,inst_44449);
} else {
if((state_val_44452 === (2))){
var state_44451__$1 = state_44451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44451__$1,(4),ch);
} else {
if((state_val_44452 === (9))){
var inst_44438 = (state_44451[(9)]);
var inst_44431 = inst_44438;
var state_44451__$1 = (function (){var statearr_44475 = state_44451;
(statearr_44475[(7)] = inst_44431);

return statearr_44475;
})();
var statearr_44476_46666 = state_44451__$1;
(statearr_44476_46666[(2)] = null);

(statearr_44476_46666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44452 === (5))){
var inst_44431 = (state_44451[(7)]);
var state_44451__$1 = state_44451;
var statearr_44477_46667 = state_44451__$1;
(statearr_44477_46667[(2)] = inst_44431);

(statearr_44477_46667[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44452 === (10))){
var inst_44445 = (state_44451[(2)]);
var state_44451__$1 = state_44451;
var statearr_44478_46668 = state_44451__$1;
(statearr_44478_46668[(2)] = inst_44445);

(statearr_44478_46668[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44452 === (8))){
var inst_44438 = (state_44451[(9)]);
var inst_44441 = cljs.core.deref(inst_44438);
var state_44451__$1 = state_44451;
var statearr_44479_46671 = state_44451__$1;
(statearr_44479_46671[(2)] = inst_44441);

(statearr_44479_46671[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__43298__auto__ = null;
var cljs$core$async$reduce_$_state_machine__43298__auto____0 = (function (){
var statearr_44480 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44480[(0)] = cljs$core$async$reduce_$_state_machine__43298__auto__);

(statearr_44480[(1)] = (1));

return statearr_44480;
});
var cljs$core$async$reduce_$_state_machine__43298__auto____1 = (function (state_44451){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44451);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44481){var ex__43301__auto__ = e44481;
var statearr_44482_46672 = state_44451;
(statearr_44482_46672[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44451[(4)]))){
var statearr_44484_46677 = state_44451;
(statearr_44484_46677[(1)] = cljs.core.first((state_44451[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46679 = state_44451;
state_44451 = G__46679;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__43298__auto__ = function(state_44451){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__43298__auto____1.call(this,state_44451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__43298__auto____0;
cljs$core$async$reduce_$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__43298__auto____1;
return cljs$core$async$reduce_$_state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_44488 = f__43545__auto__();
(statearr_44488[(6)] = c__43544__auto__);

return statearr_44488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));

return c__43544__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__43544__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_44494){
var state_val_44495 = (state_44494[(1)]);
if((state_val_44495 === (1))){
var inst_44489 = cljs.core.async.reduce(f__$1,init,ch);
var state_44494__$1 = state_44494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44494__$1,(2),inst_44489);
} else {
if((state_val_44495 === (2))){
var inst_44491 = (state_44494[(2)]);
var inst_44492 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_44491) : f__$1.call(null,inst_44491));
var state_44494__$1 = state_44494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44494__$1,inst_44492);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__43298__auto__ = null;
var cljs$core$async$transduce_$_state_machine__43298__auto____0 = (function (){
var statearr_44497 = [null,null,null,null,null,null,null];
(statearr_44497[(0)] = cljs$core$async$transduce_$_state_machine__43298__auto__);

(statearr_44497[(1)] = (1));

return statearr_44497;
});
var cljs$core$async$transduce_$_state_machine__43298__auto____1 = (function (state_44494){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44494);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44498){var ex__43301__auto__ = e44498;
var statearr_44499_46694 = state_44494;
(statearr_44499_46694[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44494[(4)]))){
var statearr_44509_46695 = state_44494;
(statearr_44509_46695[(1)] = cljs.core.first((state_44494[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46700 = state_44494;
state_44494 = G__46700;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__43298__auto__ = function(state_44494){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__43298__auto____1.call(this,state_44494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__43298__auto____0;
cljs$core$async$transduce_$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__43298__auto____1;
return cljs$core$async$transduce_$_state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_44510 = f__43545__auto__();
(statearr_44510[(6)] = c__43544__auto__);

return statearr_44510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));

return c__43544__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__44516 = arguments.length;
switch (G__44516) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__43544__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_44542){
var state_val_44543 = (state_44542[(1)]);
if((state_val_44543 === (7))){
var inst_44524 = (state_44542[(2)]);
var state_44542__$1 = state_44542;
var statearr_44548_46714 = state_44542__$1;
(statearr_44548_46714[(2)] = inst_44524);

(statearr_44548_46714[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (1))){
var inst_44518 = cljs.core.seq(coll);
var inst_44519 = inst_44518;
var state_44542__$1 = (function (){var statearr_44549 = state_44542;
(statearr_44549[(7)] = inst_44519);

return statearr_44549;
})();
var statearr_44550_46724 = state_44542__$1;
(statearr_44550_46724[(2)] = null);

(statearr_44550_46724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (4))){
var inst_44519 = (state_44542[(7)]);
var inst_44522 = cljs.core.first(inst_44519);
var state_44542__$1 = state_44542;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44542__$1,(7),ch,inst_44522);
} else {
if((state_val_44543 === (13))){
var inst_44536 = (state_44542[(2)]);
var state_44542__$1 = state_44542;
var statearr_44560_46725 = state_44542__$1;
(statearr_44560_46725[(2)] = inst_44536);

(statearr_44560_46725[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (6))){
var inst_44527 = (state_44542[(2)]);
var state_44542__$1 = state_44542;
if(cljs.core.truth_(inst_44527)){
var statearr_44561_46732 = state_44542__$1;
(statearr_44561_46732[(1)] = (8));

} else {
var statearr_44564_46733 = state_44542__$1;
(statearr_44564_46733[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (3))){
var inst_44540 = (state_44542[(2)]);
var state_44542__$1 = state_44542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44542__$1,inst_44540);
} else {
if((state_val_44543 === (12))){
var state_44542__$1 = state_44542;
var statearr_44565_46735 = state_44542__$1;
(statearr_44565_46735[(2)] = null);

(statearr_44565_46735[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (2))){
var inst_44519 = (state_44542[(7)]);
var state_44542__$1 = state_44542;
if(cljs.core.truth_(inst_44519)){
var statearr_44566_46737 = state_44542__$1;
(statearr_44566_46737[(1)] = (4));

} else {
var statearr_44569_46739 = state_44542__$1;
(statearr_44569_46739[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (11))){
var inst_44533 = cljs.core.async.close_BANG_(ch);
var state_44542__$1 = state_44542;
var statearr_44570_46743 = state_44542__$1;
(statearr_44570_46743[(2)] = inst_44533);

(statearr_44570_46743[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (9))){
var state_44542__$1 = state_44542;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44571_46744 = state_44542__$1;
(statearr_44571_46744[(1)] = (11));

} else {
var statearr_44572_46745 = state_44542__$1;
(statearr_44572_46745[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (5))){
var inst_44519 = (state_44542[(7)]);
var state_44542__$1 = state_44542;
var statearr_44578_46747 = state_44542__$1;
(statearr_44578_46747[(2)] = inst_44519);

(statearr_44578_46747[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (10))){
var inst_44538 = (state_44542[(2)]);
var state_44542__$1 = state_44542;
var statearr_44579_46749 = state_44542__$1;
(statearr_44579_46749[(2)] = inst_44538);

(statearr_44579_46749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44543 === (8))){
var inst_44519 = (state_44542[(7)]);
var inst_44529 = cljs.core.next(inst_44519);
var inst_44519__$1 = inst_44529;
var state_44542__$1 = (function (){var statearr_44581 = state_44542;
(statearr_44581[(7)] = inst_44519__$1);

return statearr_44581;
})();
var statearr_44583_46752 = state_44542__$1;
(statearr_44583_46752[(2)] = null);

(statearr_44583_46752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_44586 = [null,null,null,null,null,null,null,null];
(statearr_44586[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_44586[(1)] = (1));

return statearr_44586;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_44542){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44542);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44588){var ex__43301__auto__ = e44588;
var statearr_44589_46754 = state_44542;
(statearr_44589_46754[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44542[(4)]))){
var statearr_44590_46762 = state_44542;
(statearr_44590_46762[(1)] = cljs.core.first((state_44542[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46764 = state_44542;
state_44542 = G__46764;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_44542){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_44542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_44594 = f__43545__auto__();
(statearr_44594[(6)] = c__43544__auto__);

return statearr_44594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));

return c__43544__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__44606 = arguments.length;
switch (G__44606) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_46775 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_46775(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_46788 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_46788(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_46800 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_46800(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_46804 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_46804(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44653 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44653 = (function (ch,cs,meta44654){
this.ch = ch;
this.cs = cs;
this.meta44654 = meta44654;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44653.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44655,meta44654__$1){
var self__ = this;
var _44655__$1 = this;
return (new cljs.core.async.t_cljs$core$async44653(self__.ch,self__.cs,meta44654__$1));
}));

(cljs.core.async.t_cljs$core$async44653.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44655){
var self__ = this;
var _44655__$1 = this;
return self__.meta44654;
}));

(cljs.core.async.t_cljs$core$async44653.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44653.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44653.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44653.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async44653.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async44653.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async44653.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta44654","meta44654",818532125,null)], null);
}));

(cljs.core.async.t_cljs$core$async44653.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44653.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44653");

(cljs.core.async.t_cljs$core$async44653.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44653");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44653.
 */
cljs.core.async.__GT_t_cljs$core$async44653 = (function cljs$core$async$mult_$___GT_t_cljs$core$async44653(ch__$1,cs__$1,meta44654){
return (new cljs.core.async.t_cljs$core$async44653(ch__$1,cs__$1,meta44654));
});

}

return (new cljs.core.async.t_cljs$core$async44653(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__43544__auto___46829 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_44824){
var state_val_44826 = (state_44824[(1)]);
if((state_val_44826 === (7))){
var inst_44818 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
var statearr_44833_46830 = state_44824__$1;
(statearr_44833_46830[(2)] = inst_44818);

(statearr_44833_46830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (20))){
var inst_44712 = (state_44824[(7)]);
var inst_44726 = cljs.core.first(inst_44712);
var inst_44727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44726,(0),null);
var inst_44728 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44726,(1),null);
var state_44824__$1 = (function (){var statearr_44837 = state_44824;
(statearr_44837[(8)] = inst_44727);

return statearr_44837;
})();
if(cljs.core.truth_(inst_44728)){
var statearr_44838_46835 = state_44824__$1;
(statearr_44838_46835[(1)] = (22));

} else {
var statearr_44840_46837 = state_44824__$1;
(statearr_44840_46837[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (27))){
var inst_44764 = (state_44824[(9)]);
var inst_44759 = (state_44824[(10)]);
var inst_44677 = (state_44824[(11)]);
var inst_44757 = (state_44824[(12)]);
var inst_44764__$1 = cljs.core._nth(inst_44757,inst_44759);
var inst_44766 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44764__$1,inst_44677,done);
var state_44824__$1 = (function (){var statearr_44844 = state_44824;
(statearr_44844[(9)] = inst_44764__$1);

return statearr_44844;
})();
if(cljs.core.truth_(inst_44766)){
var statearr_44845_46843 = state_44824__$1;
(statearr_44845_46843[(1)] = (30));

} else {
var statearr_44850_46845 = state_44824__$1;
(statearr_44850_46845[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (1))){
var state_44824__$1 = state_44824;
var statearr_44852_46847 = state_44824__$1;
(statearr_44852_46847[(2)] = null);

(statearr_44852_46847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (24))){
var inst_44712 = (state_44824[(7)]);
var inst_44733 = (state_44824[(2)]);
var inst_44734 = cljs.core.next(inst_44712);
var inst_44687 = inst_44734;
var inst_44688 = null;
var inst_44689 = (0);
var inst_44690 = (0);
var state_44824__$1 = (function (){var statearr_44856 = state_44824;
(statearr_44856[(13)] = inst_44688);

(statearr_44856[(14)] = inst_44690);

(statearr_44856[(15)] = inst_44733);

(statearr_44856[(16)] = inst_44687);

(statearr_44856[(17)] = inst_44689);

return statearr_44856;
})();
var statearr_44858_46851 = state_44824__$1;
(statearr_44858_46851[(2)] = null);

(statearr_44858_46851[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (39))){
var state_44824__$1 = state_44824;
var statearr_44865_46853 = state_44824__$1;
(statearr_44865_46853[(2)] = null);

(statearr_44865_46853[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (4))){
var inst_44677 = (state_44824[(11)]);
var inst_44677__$1 = (state_44824[(2)]);
var inst_44678 = (inst_44677__$1 == null);
var state_44824__$1 = (function (){var statearr_44872 = state_44824;
(statearr_44872[(11)] = inst_44677__$1);

return statearr_44872;
})();
if(cljs.core.truth_(inst_44678)){
var statearr_44874_46869 = state_44824__$1;
(statearr_44874_46869[(1)] = (5));

} else {
var statearr_44875_46870 = state_44824__$1;
(statearr_44875_46870[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (15))){
var inst_44688 = (state_44824[(13)]);
var inst_44690 = (state_44824[(14)]);
var inst_44687 = (state_44824[(16)]);
var inst_44689 = (state_44824[(17)]);
var inst_44707 = (state_44824[(2)]);
var inst_44708 = (inst_44690 + (1));
var tmp44862 = inst_44688;
var tmp44863 = inst_44687;
var tmp44864 = inst_44689;
var inst_44687__$1 = tmp44863;
var inst_44688__$1 = tmp44862;
var inst_44689__$1 = tmp44864;
var inst_44690__$1 = inst_44708;
var state_44824__$1 = (function (){var statearr_44879 = state_44824;
(statearr_44879[(13)] = inst_44688__$1);

(statearr_44879[(14)] = inst_44690__$1);

(statearr_44879[(18)] = inst_44707);

(statearr_44879[(16)] = inst_44687__$1);

(statearr_44879[(17)] = inst_44689__$1);

return statearr_44879;
})();
var statearr_44881_46873 = state_44824__$1;
(statearr_44881_46873[(2)] = null);

(statearr_44881_46873[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (21))){
var inst_44737 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
var statearr_44889_46879 = state_44824__$1;
(statearr_44889_46879[(2)] = inst_44737);

(statearr_44889_46879[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (31))){
var inst_44764 = (state_44824[(9)]);
var inst_44769 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44764);
var state_44824__$1 = state_44824;
var statearr_44890_46881 = state_44824__$1;
(statearr_44890_46881[(2)] = inst_44769);

(statearr_44890_46881[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (32))){
var inst_44756 = (state_44824[(19)]);
var inst_44758 = (state_44824[(20)]);
var inst_44759 = (state_44824[(10)]);
var inst_44757 = (state_44824[(12)]);
var inst_44771 = (state_44824[(2)]);
var inst_44774 = (inst_44759 + (1));
var tmp44886 = inst_44756;
var tmp44887 = inst_44758;
var tmp44888 = inst_44757;
var inst_44756__$1 = tmp44886;
var inst_44757__$1 = tmp44888;
var inst_44758__$1 = tmp44887;
var inst_44759__$1 = inst_44774;
var state_44824__$1 = (function (){var statearr_44898 = state_44824;
(statearr_44898[(19)] = inst_44756__$1);

(statearr_44898[(20)] = inst_44758__$1);

(statearr_44898[(21)] = inst_44771);

(statearr_44898[(10)] = inst_44759__$1);

(statearr_44898[(12)] = inst_44757__$1);

return statearr_44898;
})();
var statearr_44900_46887 = state_44824__$1;
(statearr_44900_46887[(2)] = null);

(statearr_44900_46887[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (40))){
var inst_44790 = (state_44824[(22)]);
var inst_44794 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44790);
var state_44824__$1 = state_44824;
var statearr_44901_46899 = state_44824__$1;
(statearr_44901_46899[(2)] = inst_44794);

(statearr_44901_46899[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (33))){
var inst_44779 = (state_44824[(23)]);
var inst_44781 = cljs.core.chunked_seq_QMARK_(inst_44779);
var state_44824__$1 = state_44824;
if(inst_44781){
var statearr_44902_46904 = state_44824__$1;
(statearr_44902_46904[(1)] = (36));

} else {
var statearr_44903_46905 = state_44824__$1;
(statearr_44903_46905[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (13))){
var inst_44701 = (state_44824[(24)]);
var inst_44704 = cljs.core.async.close_BANG_(inst_44701);
var state_44824__$1 = state_44824;
var statearr_44904_46909 = state_44824__$1;
(statearr_44904_46909[(2)] = inst_44704);

(statearr_44904_46909[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (22))){
var inst_44727 = (state_44824[(8)]);
var inst_44730 = cljs.core.async.close_BANG_(inst_44727);
var state_44824__$1 = state_44824;
var statearr_44909_46914 = state_44824__$1;
(statearr_44909_46914[(2)] = inst_44730);

(statearr_44909_46914[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (36))){
var inst_44779 = (state_44824[(23)]);
var inst_44783 = cljs.core.chunk_first(inst_44779);
var inst_44784 = cljs.core.chunk_rest(inst_44779);
var inst_44785 = cljs.core.count(inst_44783);
var inst_44756 = inst_44784;
var inst_44757 = inst_44783;
var inst_44758 = inst_44785;
var inst_44759 = (0);
var state_44824__$1 = (function (){var statearr_44914 = state_44824;
(statearr_44914[(19)] = inst_44756);

(statearr_44914[(20)] = inst_44758);

(statearr_44914[(10)] = inst_44759);

(statearr_44914[(12)] = inst_44757);

return statearr_44914;
})();
var statearr_44915_46916 = state_44824__$1;
(statearr_44915_46916[(2)] = null);

(statearr_44915_46916[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (41))){
var inst_44779 = (state_44824[(23)]);
var inst_44796 = (state_44824[(2)]);
var inst_44798 = cljs.core.next(inst_44779);
var inst_44756 = inst_44798;
var inst_44757 = null;
var inst_44758 = (0);
var inst_44759 = (0);
var state_44824__$1 = (function (){var statearr_44920 = state_44824;
(statearr_44920[(19)] = inst_44756);

(statearr_44920[(20)] = inst_44758);

(statearr_44920[(25)] = inst_44796);

(statearr_44920[(10)] = inst_44759);

(statearr_44920[(12)] = inst_44757);

return statearr_44920;
})();
var statearr_44921_46919 = state_44824__$1;
(statearr_44921_46919[(2)] = null);

(statearr_44921_46919[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (43))){
var state_44824__$1 = state_44824;
var statearr_44922_46920 = state_44824__$1;
(statearr_44922_46920[(2)] = null);

(statearr_44922_46920[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (29))){
var inst_44806 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
var statearr_44923_46925 = state_44824__$1;
(statearr_44923_46925[(2)] = inst_44806);

(statearr_44923_46925[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (44))){
var inst_44815 = (state_44824[(2)]);
var state_44824__$1 = (function (){var statearr_44925 = state_44824;
(statearr_44925[(26)] = inst_44815);

return statearr_44925;
})();
var statearr_44928_46926 = state_44824__$1;
(statearr_44928_46926[(2)] = null);

(statearr_44928_46926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (6))){
var inst_44748 = (state_44824[(27)]);
var inst_44747 = cljs.core.deref(cs);
var inst_44748__$1 = cljs.core.keys(inst_44747);
var inst_44749 = cljs.core.count(inst_44748__$1);
var inst_44750 = cljs.core.reset_BANG_(dctr,inst_44749);
var inst_44755 = cljs.core.seq(inst_44748__$1);
var inst_44756 = inst_44755;
var inst_44757 = null;
var inst_44758 = (0);
var inst_44759 = (0);
var state_44824__$1 = (function (){var statearr_44930 = state_44824;
(statearr_44930[(19)] = inst_44756);

(statearr_44930[(20)] = inst_44758);

(statearr_44930[(28)] = inst_44750);

(statearr_44930[(27)] = inst_44748__$1);

(statearr_44930[(10)] = inst_44759);

(statearr_44930[(12)] = inst_44757);

return statearr_44930;
})();
var statearr_44931_46936 = state_44824__$1;
(statearr_44931_46936[(2)] = null);

(statearr_44931_46936[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (28))){
var inst_44756 = (state_44824[(19)]);
var inst_44779 = (state_44824[(23)]);
var inst_44779__$1 = cljs.core.seq(inst_44756);
var state_44824__$1 = (function (){var statearr_44932 = state_44824;
(statearr_44932[(23)] = inst_44779__$1);

return statearr_44932;
})();
if(inst_44779__$1){
var statearr_44933_46939 = state_44824__$1;
(statearr_44933_46939[(1)] = (33));

} else {
var statearr_44934_46940 = state_44824__$1;
(statearr_44934_46940[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (25))){
var inst_44758 = (state_44824[(20)]);
var inst_44759 = (state_44824[(10)]);
var inst_44761 = (inst_44759 < inst_44758);
var inst_44762 = inst_44761;
var state_44824__$1 = state_44824;
if(cljs.core.truth_(inst_44762)){
var statearr_44935_46941 = state_44824__$1;
(statearr_44935_46941[(1)] = (27));

} else {
var statearr_44936_46942 = state_44824__$1;
(statearr_44936_46942[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (34))){
var state_44824__$1 = state_44824;
var statearr_44937_46944 = state_44824__$1;
(statearr_44937_46944[(2)] = null);

(statearr_44937_46944[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (17))){
var state_44824__$1 = state_44824;
var statearr_44938_46947 = state_44824__$1;
(statearr_44938_46947[(2)] = null);

(statearr_44938_46947[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (3))){
var inst_44820 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44824__$1,inst_44820);
} else {
if((state_val_44826 === (12))){
var inst_44742 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
var statearr_44943_46952 = state_44824__$1;
(statearr_44943_46952[(2)] = inst_44742);

(statearr_44943_46952[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (2))){
var state_44824__$1 = state_44824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44824__$1,(4),ch);
} else {
if((state_val_44826 === (23))){
var state_44824__$1 = state_44824;
var statearr_44944_46960 = state_44824__$1;
(statearr_44944_46960[(2)] = null);

(statearr_44944_46960[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (35))){
var inst_44804 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
var statearr_44946_46963 = state_44824__$1;
(statearr_44946_46963[(2)] = inst_44804);

(statearr_44946_46963[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (19))){
var inst_44712 = (state_44824[(7)]);
var inst_44718 = cljs.core.chunk_first(inst_44712);
var inst_44719 = cljs.core.chunk_rest(inst_44712);
var inst_44720 = cljs.core.count(inst_44718);
var inst_44687 = inst_44719;
var inst_44688 = inst_44718;
var inst_44689 = inst_44720;
var inst_44690 = (0);
var state_44824__$1 = (function (){var statearr_44949 = state_44824;
(statearr_44949[(13)] = inst_44688);

(statearr_44949[(14)] = inst_44690);

(statearr_44949[(16)] = inst_44687);

(statearr_44949[(17)] = inst_44689);

return statearr_44949;
})();
var statearr_44950_46964 = state_44824__$1;
(statearr_44950_46964[(2)] = null);

(statearr_44950_46964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (11))){
var inst_44712 = (state_44824[(7)]);
var inst_44687 = (state_44824[(16)]);
var inst_44712__$1 = cljs.core.seq(inst_44687);
var state_44824__$1 = (function (){var statearr_44953 = state_44824;
(statearr_44953[(7)] = inst_44712__$1);

return statearr_44953;
})();
if(inst_44712__$1){
var statearr_44955_46966 = state_44824__$1;
(statearr_44955_46966[(1)] = (16));

} else {
var statearr_44956_46967 = state_44824__$1;
(statearr_44956_46967[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (9))){
var inst_44744 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
var statearr_44958_46968 = state_44824__$1;
(statearr_44958_46968[(2)] = inst_44744);

(statearr_44958_46968[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (5))){
var inst_44685 = cljs.core.deref(cs);
var inst_44686 = cljs.core.seq(inst_44685);
var inst_44687 = inst_44686;
var inst_44688 = null;
var inst_44689 = (0);
var inst_44690 = (0);
var state_44824__$1 = (function (){var statearr_44960 = state_44824;
(statearr_44960[(13)] = inst_44688);

(statearr_44960[(14)] = inst_44690);

(statearr_44960[(16)] = inst_44687);

(statearr_44960[(17)] = inst_44689);

return statearr_44960;
})();
var statearr_44963_46969 = state_44824__$1;
(statearr_44963_46969[(2)] = null);

(statearr_44963_46969[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (14))){
var state_44824__$1 = state_44824;
var statearr_44964_46970 = state_44824__$1;
(statearr_44964_46970[(2)] = null);

(statearr_44964_46970[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (45))){
var inst_44812 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
var statearr_44965_46971 = state_44824__$1;
(statearr_44965_46971[(2)] = inst_44812);

(statearr_44965_46971[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (26))){
var inst_44748 = (state_44824[(27)]);
var inst_44808 = (state_44824[(2)]);
var inst_44809 = cljs.core.seq(inst_44748);
var state_44824__$1 = (function (){var statearr_44966 = state_44824;
(statearr_44966[(29)] = inst_44808);

return statearr_44966;
})();
if(inst_44809){
var statearr_44968_46973 = state_44824__$1;
(statearr_44968_46973[(1)] = (42));

} else {
var statearr_44970_46974 = state_44824__$1;
(statearr_44970_46974[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (16))){
var inst_44712 = (state_44824[(7)]);
var inst_44715 = cljs.core.chunked_seq_QMARK_(inst_44712);
var state_44824__$1 = state_44824;
if(inst_44715){
var statearr_44972_46976 = state_44824__$1;
(statearr_44972_46976[(1)] = (19));

} else {
var statearr_44975_46977 = state_44824__$1;
(statearr_44975_46977[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (38))){
var inst_44801 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
var statearr_44977_46978 = state_44824__$1;
(statearr_44977_46978[(2)] = inst_44801);

(statearr_44977_46978[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (30))){
var state_44824__$1 = state_44824;
var statearr_44978_46979 = state_44824__$1;
(statearr_44978_46979[(2)] = null);

(statearr_44978_46979[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (10))){
var inst_44688 = (state_44824[(13)]);
var inst_44690 = (state_44824[(14)]);
var inst_44700 = cljs.core._nth(inst_44688,inst_44690);
var inst_44701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44700,(0),null);
var inst_44702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44700,(1),null);
var state_44824__$1 = (function (){var statearr_44979 = state_44824;
(statearr_44979[(24)] = inst_44701);

return statearr_44979;
})();
if(cljs.core.truth_(inst_44702)){
var statearr_44980_46981 = state_44824__$1;
(statearr_44980_46981[(1)] = (13));

} else {
var statearr_44981_46983 = state_44824__$1;
(statearr_44981_46983[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (18))){
var inst_44740 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
var statearr_44982_46984 = state_44824__$1;
(statearr_44982_46984[(2)] = inst_44740);

(statearr_44982_46984[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (42))){
var state_44824__$1 = state_44824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44824__$1,(45),dchan);
} else {
if((state_val_44826 === (37))){
var inst_44779 = (state_44824[(23)]);
var inst_44790 = (state_44824[(22)]);
var inst_44677 = (state_44824[(11)]);
var inst_44790__$1 = cljs.core.first(inst_44779);
var inst_44791 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44790__$1,inst_44677,done);
var state_44824__$1 = (function (){var statearr_44986 = state_44824;
(statearr_44986[(22)] = inst_44790__$1);

return statearr_44986;
})();
if(cljs.core.truth_(inst_44791)){
var statearr_44989_46988 = state_44824__$1;
(statearr_44989_46988[(1)] = (39));

} else {
var statearr_44991_46989 = state_44824__$1;
(statearr_44991_46989[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44826 === (8))){
var inst_44690 = (state_44824[(14)]);
var inst_44689 = (state_44824[(17)]);
var inst_44692 = (inst_44690 < inst_44689);
var inst_44693 = inst_44692;
var state_44824__$1 = state_44824;
if(cljs.core.truth_(inst_44693)){
var statearr_44992_46990 = state_44824__$1;
(statearr_44992_46990[(1)] = (10));

} else {
var statearr_44995_46991 = state_44824__$1;
(statearr_44995_46991[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__43298__auto__ = null;
var cljs$core$async$mult_$_state_machine__43298__auto____0 = (function (){
var statearr_44997 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44997[(0)] = cljs$core$async$mult_$_state_machine__43298__auto__);

(statearr_44997[(1)] = (1));

return statearr_44997;
});
var cljs$core$async$mult_$_state_machine__43298__auto____1 = (function (state_44824){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_44824);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e44999){var ex__43301__auto__ = e44999;
var statearr_45000_46993 = state_44824;
(statearr_45000_46993[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_44824[(4)]))){
var statearr_45001_46994 = state_44824;
(statearr_45001_46994[(1)] = cljs.core.first((state_44824[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46995 = state_44824;
state_44824 = G__46995;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__43298__auto__ = function(state_44824){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__43298__auto____1.call(this,state_44824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__43298__auto____0;
cljs$core$async$mult_$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__43298__auto____1;
return cljs$core$async$mult_$_state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_45003 = f__43545__auto__();
(statearr_45003[(6)] = c__43544__auto___46829);

return statearr_45003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45009 = arguments.length;
switch (G__45009) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_46998 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_46998(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_47005 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_47005(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_47015 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_47015(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_47016 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_47016(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_47017 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_47017(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47021 = arguments.length;
var i__4737__auto___47022 = (0);
while(true){
if((i__4737__auto___47022 < len__4736__auto___47021)){
args__4742__auto__.push((arguments[i__4737__auto___47022]));

var G__47023 = (i__4737__auto___47022 + (1));
i__4737__auto___47022 = G__47023;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45065){
var map__45067 = p__45065;
var map__45067__$1 = (((((!((map__45067 == null))))?(((((map__45067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45067.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45067):map__45067);
var opts = map__45067__$1;
var statearr_45070_47025 = state;
(statearr_45070_47025[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_45073_47026 = state;
(statearr_45073_47026[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_45075_47027 = state;
(statearr_45075_47027[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45050){
var G__45051 = cljs.core.first(seq45050);
var seq45050__$1 = cljs.core.next(seq45050);
var G__45052 = cljs.core.first(seq45050__$1);
var seq45050__$2 = cljs.core.next(seq45050__$1);
var G__45053 = cljs.core.first(seq45050__$2);
var seq45050__$3 = cljs.core.next(seq45050__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45051,G__45052,G__45053,seq45050__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45090 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45090 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45091){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45091 = meta45091;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45092,meta45091__$1){
var self__ = this;
var _45092__$1 = this;
return (new cljs.core.async.t_cljs$core$async45090(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45091__$1));
}));

(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45092){
var self__ = this;
var _45092__$1 = this;
return self__.meta45091;
}));

(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45090.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45090.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45091","meta45091",-1077731783,null)], null);
}));

(cljs.core.async.t_cljs$core$async45090.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45090.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45090");

(cljs.core.async.t_cljs$core$async45090.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45090");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45090.
 */
cljs.core.async.__GT_t_cljs$core$async45090 = (function cljs$core$async$mix_$___GT_t_cljs$core$async45090(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45091){
return (new cljs.core.async.t_cljs$core$async45090(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45091));
});

}

return (new cljs.core.async.t_cljs$core$async45090(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43544__auto___47046 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_45236){
var state_val_45237 = (state_45236[(1)]);
if((state_val_45237 === (7))){
var inst_45129 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
var statearr_45241_47047 = state_45236__$1;
(statearr_45241_47047[(2)] = inst_45129);

(statearr_45241_47047[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (20))){
var inst_45143 = (state_45236[(7)]);
var state_45236__$1 = state_45236;
var statearr_45243_47051 = state_45236__$1;
(statearr_45243_47051[(2)] = inst_45143);

(statearr_45243_47051[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (27))){
var state_45236__$1 = state_45236;
var statearr_45244_47052 = state_45236__$1;
(statearr_45244_47052[(2)] = null);

(statearr_45244_47052[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (1))){
var inst_45113 = (state_45236[(8)]);
var inst_45113__$1 = calc_state();
var inst_45116 = (inst_45113__$1 == null);
var inst_45117 = cljs.core.not(inst_45116);
var state_45236__$1 = (function (){var statearr_45249 = state_45236;
(statearr_45249[(8)] = inst_45113__$1);

return statearr_45249;
})();
if(inst_45117){
var statearr_45250_47057 = state_45236__$1;
(statearr_45250_47057[(1)] = (2));

} else {
var statearr_45251_47058 = state_45236__$1;
(statearr_45251_47058[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (24))){
var inst_45182 = (state_45236[(9)]);
var inst_45173 = (state_45236[(10)]);
var inst_45202 = (state_45236[(11)]);
var inst_45202__$1 = (inst_45173.cljs$core$IFn$_invoke$arity$1 ? inst_45173.cljs$core$IFn$_invoke$arity$1(inst_45182) : inst_45173.call(null,inst_45182));
var state_45236__$1 = (function (){var statearr_45258 = state_45236;
(statearr_45258[(11)] = inst_45202__$1);

return statearr_45258;
})();
if(cljs.core.truth_(inst_45202__$1)){
var statearr_45259_47059 = state_45236__$1;
(statearr_45259_47059[(1)] = (29));

} else {
var statearr_45263_47060 = state_45236__$1;
(statearr_45263_47060[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (4))){
var inst_45132 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
if(cljs.core.truth_(inst_45132)){
var statearr_45266_47061 = state_45236__$1;
(statearr_45266_47061[(1)] = (8));

} else {
var statearr_45267_47062 = state_45236__$1;
(statearr_45267_47062[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (15))){
var inst_45167 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
if(cljs.core.truth_(inst_45167)){
var statearr_45271_47063 = state_45236__$1;
(statearr_45271_47063[(1)] = (19));

} else {
var statearr_45274_47064 = state_45236__$1;
(statearr_45274_47064[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (21))){
var inst_45172 = (state_45236[(12)]);
var inst_45172__$1 = (state_45236[(2)]);
var inst_45173 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45172__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45174 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45172__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45175 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45172__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_45236__$1 = (function (){var statearr_45278 = state_45236;
(statearr_45278[(12)] = inst_45172__$1);

(statearr_45278[(10)] = inst_45173);

(statearr_45278[(13)] = inst_45174);

return statearr_45278;
})();
return cljs.core.async.ioc_alts_BANG_(state_45236__$1,(22),inst_45175);
} else {
if((state_val_45237 === (31))){
var inst_45211 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
if(cljs.core.truth_(inst_45211)){
var statearr_45279_47065 = state_45236__$1;
(statearr_45279_47065[(1)] = (32));

} else {
var statearr_45280_47066 = state_45236__$1;
(statearr_45280_47066[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (32))){
var inst_45181 = (state_45236[(14)]);
var state_45236__$1 = state_45236;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45236__$1,(35),out,inst_45181);
} else {
if((state_val_45237 === (33))){
var inst_45172 = (state_45236[(12)]);
var inst_45143 = inst_45172;
var state_45236__$1 = (function (){var statearr_45281 = state_45236;
(statearr_45281[(7)] = inst_45143);

return statearr_45281;
})();
var statearr_45282_47068 = state_45236__$1;
(statearr_45282_47068[(2)] = null);

(statearr_45282_47068[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (13))){
var inst_45143 = (state_45236[(7)]);
var inst_45156 = inst_45143.cljs$lang$protocol_mask$partition0$;
var inst_45157 = (inst_45156 & (64));
var inst_45158 = inst_45143.cljs$core$ISeq$;
var inst_45159 = (cljs.core.PROTOCOL_SENTINEL === inst_45158);
var inst_45160 = ((inst_45157) || (inst_45159));
var state_45236__$1 = state_45236;
if(cljs.core.truth_(inst_45160)){
var statearr_45283_47070 = state_45236__$1;
(statearr_45283_47070[(1)] = (16));

} else {
var statearr_45284_47071 = state_45236__$1;
(statearr_45284_47071[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (22))){
var inst_45181 = (state_45236[(14)]);
var inst_45182 = (state_45236[(9)]);
var inst_45180 = (state_45236[(2)]);
var inst_45181__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45180,(0),null);
var inst_45182__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45180,(1),null);
var inst_45183 = (inst_45181__$1 == null);
var inst_45185 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45182__$1,change);
var inst_45186 = ((inst_45183) || (inst_45185));
var state_45236__$1 = (function (){var statearr_45285 = state_45236;
(statearr_45285[(14)] = inst_45181__$1);

(statearr_45285[(9)] = inst_45182__$1);

return statearr_45285;
})();
if(cljs.core.truth_(inst_45186)){
var statearr_45286_47072 = state_45236__$1;
(statearr_45286_47072[(1)] = (23));

} else {
var statearr_45287_47073 = state_45236__$1;
(statearr_45287_47073[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (36))){
var inst_45172 = (state_45236[(12)]);
var inst_45143 = inst_45172;
var state_45236__$1 = (function (){var statearr_45288 = state_45236;
(statearr_45288[(7)] = inst_45143);

return statearr_45288;
})();
var statearr_45289_47074 = state_45236__$1;
(statearr_45289_47074[(2)] = null);

(statearr_45289_47074[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (29))){
var inst_45202 = (state_45236[(11)]);
var state_45236__$1 = state_45236;
var statearr_45293_47075 = state_45236__$1;
(statearr_45293_47075[(2)] = inst_45202);

(statearr_45293_47075[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (6))){
var state_45236__$1 = state_45236;
var statearr_45297_47076 = state_45236__$1;
(statearr_45297_47076[(2)] = false);

(statearr_45297_47076[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (28))){
var inst_45195 = (state_45236[(2)]);
var inst_45197 = calc_state();
var inst_45143 = inst_45197;
var state_45236__$1 = (function (){var statearr_45298 = state_45236;
(statearr_45298[(7)] = inst_45143);

(statearr_45298[(15)] = inst_45195);

return statearr_45298;
})();
var statearr_45300_47077 = state_45236__$1;
(statearr_45300_47077[(2)] = null);

(statearr_45300_47077[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (25))){
var inst_45227 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
var statearr_45301_47078 = state_45236__$1;
(statearr_45301_47078[(2)] = inst_45227);

(statearr_45301_47078[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (34))){
var inst_45225 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
var statearr_45302_47079 = state_45236__$1;
(statearr_45302_47079[(2)] = inst_45225);

(statearr_45302_47079[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (17))){
var state_45236__$1 = state_45236;
var statearr_45303_47080 = state_45236__$1;
(statearr_45303_47080[(2)] = false);

(statearr_45303_47080[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (3))){
var state_45236__$1 = state_45236;
var statearr_45304_47081 = state_45236__$1;
(statearr_45304_47081[(2)] = false);

(statearr_45304_47081[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (12))){
var inst_45229 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45236__$1,inst_45229);
} else {
if((state_val_45237 === (2))){
var inst_45113 = (state_45236[(8)]);
var inst_45119 = inst_45113.cljs$lang$protocol_mask$partition0$;
var inst_45120 = (inst_45119 & (64));
var inst_45122 = inst_45113.cljs$core$ISeq$;
var inst_45123 = (cljs.core.PROTOCOL_SENTINEL === inst_45122);
var inst_45124 = ((inst_45120) || (inst_45123));
var state_45236__$1 = state_45236;
if(cljs.core.truth_(inst_45124)){
var statearr_45307_47082 = state_45236__$1;
(statearr_45307_47082[(1)] = (5));

} else {
var statearr_45308_47083 = state_45236__$1;
(statearr_45308_47083[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (23))){
var inst_45181 = (state_45236[(14)]);
var inst_45189 = (inst_45181 == null);
var state_45236__$1 = state_45236;
if(cljs.core.truth_(inst_45189)){
var statearr_45310_47084 = state_45236__$1;
(statearr_45310_47084[(1)] = (26));

} else {
var statearr_45311_47085 = state_45236__$1;
(statearr_45311_47085[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (35))){
var inst_45216 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
if(cljs.core.truth_(inst_45216)){
var statearr_45312_47090 = state_45236__$1;
(statearr_45312_47090[(1)] = (36));

} else {
var statearr_45313_47091 = state_45236__$1;
(statearr_45313_47091[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (19))){
var inst_45143 = (state_45236[(7)]);
var inst_45169 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45143);
var state_45236__$1 = state_45236;
var statearr_45314_47096 = state_45236__$1;
(statearr_45314_47096[(2)] = inst_45169);

(statearr_45314_47096[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (11))){
var inst_45143 = (state_45236[(7)]);
var inst_45150 = (inst_45143 == null);
var inst_45151 = cljs.core.not(inst_45150);
var state_45236__$1 = state_45236;
if(inst_45151){
var statearr_45317_47105 = state_45236__$1;
(statearr_45317_47105[(1)] = (13));

} else {
var statearr_45318_47106 = state_45236__$1;
(statearr_45318_47106[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (9))){
var inst_45113 = (state_45236[(8)]);
var state_45236__$1 = state_45236;
var statearr_45320_47107 = state_45236__$1;
(statearr_45320_47107[(2)] = inst_45113);

(statearr_45320_47107[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (5))){
var state_45236__$1 = state_45236;
var statearr_45321_47108 = state_45236__$1;
(statearr_45321_47108[(2)] = true);

(statearr_45321_47108[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (14))){
var state_45236__$1 = state_45236;
var statearr_45322_47109 = state_45236__$1;
(statearr_45322_47109[(2)] = false);

(statearr_45322_47109[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (26))){
var inst_45182 = (state_45236[(9)]);
var inst_45192 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_45182);
var state_45236__$1 = state_45236;
var statearr_45326_47110 = state_45236__$1;
(statearr_45326_47110[(2)] = inst_45192);

(statearr_45326_47110[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (16))){
var state_45236__$1 = state_45236;
var statearr_45327_47111 = state_45236__$1;
(statearr_45327_47111[(2)] = true);

(statearr_45327_47111[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (38))){
var inst_45221 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
var statearr_45329_47112 = state_45236__$1;
(statearr_45329_47112[(2)] = inst_45221);

(statearr_45329_47112[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (30))){
var inst_45182 = (state_45236[(9)]);
var inst_45173 = (state_45236[(10)]);
var inst_45174 = (state_45236[(13)]);
var inst_45206 = cljs.core.empty_QMARK_(inst_45173);
var inst_45207 = (inst_45174.cljs$core$IFn$_invoke$arity$1 ? inst_45174.cljs$core$IFn$_invoke$arity$1(inst_45182) : inst_45174.call(null,inst_45182));
var inst_45208 = cljs.core.not(inst_45207);
var inst_45209 = ((inst_45206) && (inst_45208));
var state_45236__$1 = state_45236;
var statearr_45330_47119 = state_45236__$1;
(statearr_45330_47119[(2)] = inst_45209);

(statearr_45330_47119[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (10))){
var inst_45113 = (state_45236[(8)]);
var inst_45138 = (state_45236[(2)]);
var inst_45139 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45138,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45138,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45138,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_45143 = inst_45113;
var state_45236__$1 = (function (){var statearr_45331 = state_45236;
(statearr_45331[(16)] = inst_45139);

(statearr_45331[(17)] = inst_45142);

(statearr_45331[(18)] = inst_45141);

(statearr_45331[(7)] = inst_45143);

return statearr_45331;
})();
var statearr_45334_47121 = state_45236__$1;
(statearr_45334_47121[(2)] = null);

(statearr_45334_47121[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (18))){
var inst_45164 = (state_45236[(2)]);
var state_45236__$1 = state_45236;
var statearr_45335_47122 = state_45236__$1;
(statearr_45335_47122[(2)] = inst_45164);

(statearr_45335_47122[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (37))){
var state_45236__$1 = state_45236;
var statearr_45338_47123 = state_45236__$1;
(statearr_45338_47123[(2)] = null);

(statearr_45338_47123[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45237 === (8))){
var inst_45113 = (state_45236[(8)]);
var inst_45135 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45113);
var state_45236__$1 = state_45236;
var statearr_45339_47124 = state_45236__$1;
(statearr_45339_47124[(2)] = inst_45135);

(statearr_45339_47124[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__43298__auto__ = null;
var cljs$core$async$mix_$_state_machine__43298__auto____0 = (function (){
var statearr_45342 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45342[(0)] = cljs$core$async$mix_$_state_machine__43298__auto__);

(statearr_45342[(1)] = (1));

return statearr_45342;
});
var cljs$core$async$mix_$_state_machine__43298__auto____1 = (function (state_45236){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_45236);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e45343){var ex__43301__auto__ = e45343;
var statearr_45344_47126 = state_45236;
(statearr_45344_47126[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_45236[(4)]))){
var statearr_45347_47127 = state_45236;
(statearr_45347_47127[(1)] = cljs.core.first((state_45236[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47128 = state_45236;
state_45236 = G__47128;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__43298__auto__ = function(state_45236){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__43298__auto____1.call(this,state_45236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__43298__auto____0;
cljs$core$async$mix_$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__43298__auto____1;
return cljs$core$async$mix_$_state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_45348 = f__43545__auto__();
(statearr_45348[(6)] = c__43544__auto___47046);

return statearr_45348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_47133 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_47133(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_47134 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_47134(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_47137 = (function() {
var G__47138 = null;
var G__47138__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__47138__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__47138 = function(p,v){
switch(arguments.length){
case 1:
return G__47138__1.call(this,p);
case 2:
return G__47138__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47138.cljs$core$IFn$_invoke$arity$1 = G__47138__1;
G__47138.cljs$core$IFn$_invoke$arity$2 = G__47138__2;
return G__47138;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__45363 = arguments.length;
switch (G__45363) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47137(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47137(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__45381 = arguments.length;
switch (G__45381) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__45367_SHARP_){
if(cljs.core.truth_((p1__45367_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__45367_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__45367_SHARP_.call(null,topic)))){
return p1__45367_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__45367_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45386 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45386 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta45387){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta45387 = meta45387;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45386.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45388,meta45387__$1){
var self__ = this;
var _45388__$1 = this;
return (new cljs.core.async.t_cljs$core$async45386(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta45387__$1));
}));

(cljs.core.async.t_cljs$core$async45386.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45388){
var self__ = this;
var _45388__$1 = this;
return self__.meta45387;
}));

(cljs.core.async.t_cljs$core$async45386.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45386.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45386.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45386.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async45386.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async45386.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async45386.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async45386.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta45387","meta45387",-1279864343,null)], null);
}));

(cljs.core.async.t_cljs$core$async45386.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45386.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45386");

(cljs.core.async.t_cljs$core$async45386.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45386");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45386.
 */
cljs.core.async.__GT_t_cljs$core$async45386 = (function cljs$core$async$__GT_t_cljs$core$async45386(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45387){
return (new cljs.core.async.t_cljs$core$async45386(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45387));
});

}

return (new cljs.core.async.t_cljs$core$async45386(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43544__auto___47164 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_45477){
var state_val_45478 = (state_45477[(1)]);
if((state_val_45478 === (7))){
var inst_45473 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
var statearr_45479_47166 = state_45477__$1;
(statearr_45479_47166[(2)] = inst_45473);

(statearr_45479_47166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (20))){
var state_45477__$1 = state_45477;
var statearr_45481_47168 = state_45477__$1;
(statearr_45481_47168[(2)] = null);

(statearr_45481_47168[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (1))){
var state_45477__$1 = state_45477;
var statearr_45483_47169 = state_45477__$1;
(statearr_45483_47169[(2)] = null);

(statearr_45483_47169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (24))){
var inst_45456 = (state_45477[(7)]);
var inst_45465 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_45456);
var state_45477__$1 = state_45477;
var statearr_45484_47172 = state_45477__$1;
(statearr_45484_47172[(2)] = inst_45465);

(statearr_45484_47172[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (4))){
var inst_45404 = (state_45477[(8)]);
var inst_45404__$1 = (state_45477[(2)]);
var inst_45405 = (inst_45404__$1 == null);
var state_45477__$1 = (function (){var statearr_45487 = state_45477;
(statearr_45487[(8)] = inst_45404__$1);

return statearr_45487;
})();
if(cljs.core.truth_(inst_45405)){
var statearr_45489_47174 = state_45477__$1;
(statearr_45489_47174[(1)] = (5));

} else {
var statearr_45490_47175 = state_45477__$1;
(statearr_45490_47175[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (15))){
var inst_45450 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
var statearr_45491_47178 = state_45477__$1;
(statearr_45491_47178[(2)] = inst_45450);

(statearr_45491_47178[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (21))){
var inst_45470 = (state_45477[(2)]);
var state_45477__$1 = (function (){var statearr_45493 = state_45477;
(statearr_45493[(9)] = inst_45470);

return statearr_45493;
})();
var statearr_45494_47179 = state_45477__$1;
(statearr_45494_47179[(2)] = null);

(statearr_45494_47179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (13))){
var inst_45428 = (state_45477[(10)]);
var inst_45431 = cljs.core.chunked_seq_QMARK_(inst_45428);
var state_45477__$1 = state_45477;
if(inst_45431){
var statearr_45495_47182 = state_45477__$1;
(statearr_45495_47182[(1)] = (16));

} else {
var statearr_45496_47183 = state_45477__$1;
(statearr_45496_47183[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (22))){
var inst_45462 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
if(cljs.core.truth_(inst_45462)){
var statearr_45497_47185 = state_45477__$1;
(statearr_45497_47185[(1)] = (23));

} else {
var statearr_45498_47186 = state_45477__$1;
(statearr_45498_47186[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (6))){
var inst_45458 = (state_45477[(11)]);
var inst_45404 = (state_45477[(8)]);
var inst_45456 = (state_45477[(7)]);
var inst_45456__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_45404) : topic_fn.call(null,inst_45404));
var inst_45457 = cljs.core.deref(mults);
var inst_45458__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45457,inst_45456__$1);
var state_45477__$1 = (function (){var statearr_45500 = state_45477;
(statearr_45500[(11)] = inst_45458__$1);

(statearr_45500[(7)] = inst_45456__$1);

return statearr_45500;
})();
if(cljs.core.truth_(inst_45458__$1)){
var statearr_45501_47193 = state_45477__$1;
(statearr_45501_47193[(1)] = (19));

} else {
var statearr_45502_47194 = state_45477__$1;
(statearr_45502_47194[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (25))){
var inst_45467 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
var statearr_45503_47196 = state_45477__$1;
(statearr_45503_47196[(2)] = inst_45467);

(statearr_45503_47196[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (17))){
var inst_45428 = (state_45477[(10)]);
var inst_45440 = cljs.core.first(inst_45428);
var inst_45441 = cljs.core.async.muxch_STAR_(inst_45440);
var inst_45442 = cljs.core.async.close_BANG_(inst_45441);
var inst_45443 = cljs.core.next(inst_45428);
var inst_45414 = inst_45443;
var inst_45415 = null;
var inst_45416 = (0);
var inst_45417 = (0);
var state_45477__$1 = (function (){var statearr_45505 = state_45477;
(statearr_45505[(12)] = inst_45414);

(statearr_45505[(13)] = inst_45442);

(statearr_45505[(14)] = inst_45415);

(statearr_45505[(15)] = inst_45417);

(statearr_45505[(16)] = inst_45416);

return statearr_45505;
})();
var statearr_45507_47198 = state_45477__$1;
(statearr_45507_47198[(2)] = null);

(statearr_45507_47198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (3))){
var inst_45475 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45477__$1,inst_45475);
} else {
if((state_val_45478 === (12))){
var inst_45452 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
var statearr_45513_47199 = state_45477__$1;
(statearr_45513_47199[(2)] = inst_45452);

(statearr_45513_47199[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (2))){
var state_45477__$1 = state_45477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45477__$1,(4),ch);
} else {
if((state_val_45478 === (23))){
var state_45477__$1 = state_45477;
var statearr_45517_47201 = state_45477__$1;
(statearr_45517_47201[(2)] = null);

(statearr_45517_47201[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (19))){
var inst_45458 = (state_45477[(11)]);
var inst_45404 = (state_45477[(8)]);
var inst_45460 = cljs.core.async.muxch_STAR_(inst_45458);
var state_45477__$1 = state_45477;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45477__$1,(22),inst_45460,inst_45404);
} else {
if((state_val_45478 === (11))){
var inst_45428 = (state_45477[(10)]);
var inst_45414 = (state_45477[(12)]);
var inst_45428__$1 = cljs.core.seq(inst_45414);
var state_45477__$1 = (function (){var statearr_45518 = state_45477;
(statearr_45518[(10)] = inst_45428__$1);

return statearr_45518;
})();
if(inst_45428__$1){
var statearr_45519_47203 = state_45477__$1;
(statearr_45519_47203[(1)] = (13));

} else {
var statearr_45520_47204 = state_45477__$1;
(statearr_45520_47204[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (9))){
var inst_45454 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
var statearr_45521_47205 = state_45477__$1;
(statearr_45521_47205[(2)] = inst_45454);

(statearr_45521_47205[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (5))){
var inst_45411 = cljs.core.deref(mults);
var inst_45412 = cljs.core.vals(inst_45411);
var inst_45413 = cljs.core.seq(inst_45412);
var inst_45414 = inst_45413;
var inst_45415 = null;
var inst_45416 = (0);
var inst_45417 = (0);
var state_45477__$1 = (function (){var statearr_45522 = state_45477;
(statearr_45522[(12)] = inst_45414);

(statearr_45522[(14)] = inst_45415);

(statearr_45522[(15)] = inst_45417);

(statearr_45522[(16)] = inst_45416);

return statearr_45522;
})();
var statearr_45524_47210 = state_45477__$1;
(statearr_45524_47210[(2)] = null);

(statearr_45524_47210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (14))){
var state_45477__$1 = state_45477;
var statearr_45530_47211 = state_45477__$1;
(statearr_45530_47211[(2)] = null);

(statearr_45530_47211[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (16))){
var inst_45428 = (state_45477[(10)]);
var inst_45433 = cljs.core.chunk_first(inst_45428);
var inst_45434 = cljs.core.chunk_rest(inst_45428);
var inst_45436 = cljs.core.count(inst_45433);
var inst_45414 = inst_45434;
var inst_45415 = inst_45433;
var inst_45416 = inst_45436;
var inst_45417 = (0);
var state_45477__$1 = (function (){var statearr_45533 = state_45477;
(statearr_45533[(12)] = inst_45414);

(statearr_45533[(14)] = inst_45415);

(statearr_45533[(15)] = inst_45417);

(statearr_45533[(16)] = inst_45416);

return statearr_45533;
})();
var statearr_45535_47212 = state_45477__$1;
(statearr_45535_47212[(2)] = null);

(statearr_45535_47212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (10))){
var inst_45414 = (state_45477[(12)]);
var inst_45415 = (state_45477[(14)]);
var inst_45417 = (state_45477[(15)]);
var inst_45416 = (state_45477[(16)]);
var inst_45422 = cljs.core._nth(inst_45415,inst_45417);
var inst_45423 = cljs.core.async.muxch_STAR_(inst_45422);
var inst_45424 = cljs.core.async.close_BANG_(inst_45423);
var inst_45425 = (inst_45417 + (1));
var tmp45527 = inst_45414;
var tmp45528 = inst_45415;
var tmp45529 = inst_45416;
var inst_45414__$1 = tmp45527;
var inst_45415__$1 = tmp45528;
var inst_45416__$1 = tmp45529;
var inst_45417__$1 = inst_45425;
var state_45477__$1 = (function (){var statearr_45541 = state_45477;
(statearr_45541[(12)] = inst_45414__$1);

(statearr_45541[(14)] = inst_45415__$1);

(statearr_45541[(15)] = inst_45417__$1);

(statearr_45541[(16)] = inst_45416__$1);

(statearr_45541[(17)] = inst_45424);

return statearr_45541;
})();
var statearr_45546_47213 = state_45477__$1;
(statearr_45546_47213[(2)] = null);

(statearr_45546_47213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (18))){
var inst_45446 = (state_45477[(2)]);
var state_45477__$1 = state_45477;
var statearr_45551_47214 = state_45477__$1;
(statearr_45551_47214[(2)] = inst_45446);

(statearr_45551_47214[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45478 === (8))){
var inst_45417 = (state_45477[(15)]);
var inst_45416 = (state_45477[(16)]);
var inst_45419 = (inst_45417 < inst_45416);
var inst_45420 = inst_45419;
var state_45477__$1 = state_45477;
if(cljs.core.truth_(inst_45420)){
var statearr_45553_47215 = state_45477__$1;
(statearr_45553_47215[(1)] = (10));

} else {
var statearr_45555_47216 = state_45477__$1;
(statearr_45555_47216[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_45557 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45557[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_45557[(1)] = (1));

return statearr_45557;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_45477){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_45477);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e45564){var ex__43301__auto__ = e45564;
var statearr_45565_47218 = state_45477;
(statearr_45565_47218[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_45477[(4)]))){
var statearr_45567_47219 = state_45477;
(statearr_45567_47219[(1)] = cljs.core.first((state_45477[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47221 = state_45477;
state_45477 = G__47221;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_45477){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_45477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_45568 = f__43545__auto__();
(statearr_45568[(6)] = c__43544__auto___47164);

return statearr_45568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__45570 = arguments.length;
switch (G__45570) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__45573 = arguments.length;
switch (G__45573) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__45580 = arguments.length;
switch (G__45580) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__43544__auto___47228 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_45633){
var state_val_45634 = (state_45633[(1)]);
if((state_val_45634 === (7))){
var state_45633__$1 = state_45633;
var statearr_45647_47229 = state_45633__$1;
(statearr_45647_47229[(2)] = null);

(statearr_45647_47229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (1))){
var state_45633__$1 = state_45633;
var statearr_45652_47230 = state_45633__$1;
(statearr_45652_47230[(2)] = null);

(statearr_45652_47230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (4))){
var inst_45584 = (state_45633[(7)]);
var inst_45585 = (state_45633[(8)]);
var inst_45587 = (inst_45585 < inst_45584);
var state_45633__$1 = state_45633;
if(cljs.core.truth_(inst_45587)){
var statearr_45655_47234 = state_45633__$1;
(statearr_45655_47234[(1)] = (6));

} else {
var statearr_45658_47235 = state_45633__$1;
(statearr_45658_47235[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (15))){
var inst_45612 = (state_45633[(9)]);
var inst_45621 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_45612);
var state_45633__$1 = state_45633;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45633__$1,(17),out,inst_45621);
} else {
if((state_val_45634 === (13))){
var inst_45612 = (state_45633[(9)]);
var inst_45612__$1 = (state_45633[(2)]);
var inst_45613 = cljs.core.some(cljs.core.nil_QMARK_,inst_45612__$1);
var state_45633__$1 = (function (){var statearr_45659 = state_45633;
(statearr_45659[(9)] = inst_45612__$1);

return statearr_45659;
})();
if(cljs.core.truth_(inst_45613)){
var statearr_45660_47236 = state_45633__$1;
(statearr_45660_47236[(1)] = (14));

} else {
var statearr_45661_47237 = state_45633__$1;
(statearr_45661_47237[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (6))){
var state_45633__$1 = state_45633;
var statearr_45662_47241 = state_45633__$1;
(statearr_45662_47241[(2)] = null);

(statearr_45662_47241[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (17))){
var inst_45623 = (state_45633[(2)]);
var state_45633__$1 = (function (){var statearr_45664 = state_45633;
(statearr_45664[(10)] = inst_45623);

return statearr_45664;
})();
var statearr_45665_47243 = state_45633__$1;
(statearr_45665_47243[(2)] = null);

(statearr_45665_47243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (3))){
var inst_45628 = (state_45633[(2)]);
var state_45633__$1 = state_45633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45633__$1,inst_45628);
} else {
if((state_val_45634 === (12))){
var _ = (function (){var statearr_45666 = state_45633;
(statearr_45666[(4)] = cljs.core.rest((state_45633[(4)])));

return statearr_45666;
})();
var state_45633__$1 = state_45633;
var ex45663 = (state_45633__$1[(2)]);
var statearr_45667_47244 = state_45633__$1;
(statearr_45667_47244[(5)] = ex45663);


if((ex45663 instanceof Object)){
var statearr_45668_47245 = state_45633__$1;
(statearr_45668_47245[(1)] = (11));

(statearr_45668_47245[(5)] = null);

} else {
throw ex45663;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (2))){
var inst_45583 = cljs.core.reset_BANG_(dctr,cnt);
var inst_45584 = cnt;
var inst_45585 = (0);
var state_45633__$1 = (function (){var statearr_45670 = state_45633;
(statearr_45670[(7)] = inst_45584);

(statearr_45670[(8)] = inst_45585);

(statearr_45670[(11)] = inst_45583);

return statearr_45670;
})();
var statearr_45671_47246 = state_45633__$1;
(statearr_45671_47246[(2)] = null);

(statearr_45671_47246[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (11))){
var inst_45589 = (state_45633[(2)]);
var inst_45592 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_45633__$1 = (function (){var statearr_45672 = state_45633;
(statearr_45672[(12)] = inst_45589);

return statearr_45672;
})();
var statearr_45673_47249 = state_45633__$1;
(statearr_45673_47249[(2)] = inst_45592);

(statearr_45673_47249[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (9))){
var inst_45585 = (state_45633[(8)]);
var _ = (function (){var statearr_45677 = state_45633;
(statearr_45677[(4)] = cljs.core.cons((12),(state_45633[(4)])));

return statearr_45677;
})();
var inst_45598 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_45585) : chs__$1.call(null,inst_45585));
var inst_45599 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_45585) : done.call(null,inst_45585));
var inst_45600 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_45598,inst_45599);
var ___$1 = (function (){var statearr_45678 = state_45633;
(statearr_45678[(4)] = cljs.core.rest((state_45633[(4)])));

return statearr_45678;
})();
var state_45633__$1 = state_45633;
var statearr_45679_47250 = state_45633__$1;
(statearr_45679_47250[(2)] = inst_45600);

(statearr_45679_47250[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (5))){
var inst_45610 = (state_45633[(2)]);
var state_45633__$1 = (function (){var statearr_45682 = state_45633;
(statearr_45682[(13)] = inst_45610);

return statearr_45682;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45633__$1,(13),dchan);
} else {
if((state_val_45634 === (14))){
var inst_45615 = cljs.core.async.close_BANG_(out);
var state_45633__$1 = state_45633;
var statearr_45684_47251 = state_45633__$1;
(statearr_45684_47251[(2)] = inst_45615);

(statearr_45684_47251[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (16))){
var inst_45626 = (state_45633[(2)]);
var state_45633__$1 = state_45633;
var statearr_45686_47252 = state_45633__$1;
(statearr_45686_47252[(2)] = inst_45626);

(statearr_45686_47252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (10))){
var inst_45585 = (state_45633[(8)]);
var inst_45603 = (state_45633[(2)]);
var inst_45604 = (inst_45585 + (1));
var inst_45585__$1 = inst_45604;
var state_45633__$1 = (function (){var statearr_45687 = state_45633;
(statearr_45687[(14)] = inst_45603);

(statearr_45687[(8)] = inst_45585__$1);

return statearr_45687;
})();
var statearr_45688_47253 = state_45633__$1;
(statearr_45688_47253[(2)] = null);

(statearr_45688_47253[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45634 === (8))){
var inst_45608 = (state_45633[(2)]);
var state_45633__$1 = state_45633;
var statearr_45689_47254 = state_45633__$1;
(statearr_45689_47254[(2)] = inst_45608);

(statearr_45689_47254[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_45690 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45690[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_45690[(1)] = (1));

return statearr_45690;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_45633){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_45633);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e45695){var ex__43301__auto__ = e45695;
var statearr_45696_47260 = state_45633;
(statearr_45696_47260[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_45633[(4)]))){
var statearr_45701_47264 = state_45633;
(statearr_45701_47264[(1)] = cljs.core.first((state_45633[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47269 = state_45633;
state_45633 = G__47269;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_45633){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_45633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_45702 = f__43545__auto__();
(statearr_45702[(6)] = c__43544__auto___47228);

return statearr_45702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__45705 = arguments.length;
switch (G__45705) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43544__auto___47279 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_45737){
var state_val_45738 = (state_45737[(1)]);
if((state_val_45738 === (7))){
var inst_45716 = (state_45737[(7)]);
var inst_45717 = (state_45737[(8)]);
var inst_45716__$1 = (state_45737[(2)]);
var inst_45717__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45716__$1,(0),null);
var inst_45718 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45716__$1,(1),null);
var inst_45719 = (inst_45717__$1 == null);
var state_45737__$1 = (function (){var statearr_45742 = state_45737;
(statearr_45742[(7)] = inst_45716__$1);

(statearr_45742[(9)] = inst_45718);

(statearr_45742[(8)] = inst_45717__$1);

return statearr_45742;
})();
if(cljs.core.truth_(inst_45719)){
var statearr_45745_47281 = state_45737__$1;
(statearr_45745_47281[(1)] = (8));

} else {
var statearr_45748_47283 = state_45737__$1;
(statearr_45748_47283[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45738 === (1))){
var inst_45706 = cljs.core.vec(chs);
var inst_45707 = inst_45706;
var state_45737__$1 = (function (){var statearr_45749 = state_45737;
(statearr_45749[(10)] = inst_45707);

return statearr_45749;
})();
var statearr_45750_47284 = state_45737__$1;
(statearr_45750_47284[(2)] = null);

(statearr_45750_47284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45738 === (4))){
var inst_45707 = (state_45737[(10)]);
var state_45737__$1 = state_45737;
return cljs.core.async.ioc_alts_BANG_(state_45737__$1,(7),inst_45707);
} else {
if((state_val_45738 === (6))){
var inst_45733 = (state_45737[(2)]);
var state_45737__$1 = state_45737;
var statearr_45751_47285 = state_45737__$1;
(statearr_45751_47285[(2)] = inst_45733);

(statearr_45751_47285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45738 === (3))){
var inst_45735 = (state_45737[(2)]);
var state_45737__$1 = state_45737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45737__$1,inst_45735);
} else {
if((state_val_45738 === (2))){
var inst_45707 = (state_45737[(10)]);
var inst_45709 = cljs.core.count(inst_45707);
var inst_45710 = (inst_45709 > (0));
var state_45737__$1 = state_45737;
if(cljs.core.truth_(inst_45710)){
var statearr_45760_47286 = state_45737__$1;
(statearr_45760_47286[(1)] = (4));

} else {
var statearr_45761_47287 = state_45737__$1;
(statearr_45761_47287[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45738 === (11))){
var inst_45707 = (state_45737[(10)]);
var inst_45726 = (state_45737[(2)]);
var tmp45752 = inst_45707;
var inst_45707__$1 = tmp45752;
var state_45737__$1 = (function (){var statearr_45764 = state_45737;
(statearr_45764[(10)] = inst_45707__$1);

(statearr_45764[(11)] = inst_45726);

return statearr_45764;
})();
var statearr_45766_47288 = state_45737__$1;
(statearr_45766_47288[(2)] = null);

(statearr_45766_47288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45738 === (9))){
var inst_45717 = (state_45737[(8)]);
var state_45737__$1 = state_45737;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45737__$1,(11),out,inst_45717);
} else {
if((state_val_45738 === (5))){
var inst_45731 = cljs.core.async.close_BANG_(out);
var state_45737__$1 = state_45737;
var statearr_45770_47290 = state_45737__$1;
(statearr_45770_47290[(2)] = inst_45731);

(statearr_45770_47290[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45738 === (10))){
var inst_45729 = (state_45737[(2)]);
var state_45737__$1 = state_45737;
var statearr_45771_47291 = state_45737__$1;
(statearr_45771_47291[(2)] = inst_45729);

(statearr_45771_47291[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45738 === (8))){
var inst_45707 = (state_45737[(10)]);
var inst_45716 = (state_45737[(7)]);
var inst_45718 = (state_45737[(9)]);
var inst_45717 = (state_45737[(8)]);
var inst_45721 = (function (){var cs = inst_45707;
var vec__45712 = inst_45716;
var v = inst_45717;
var c = inst_45718;
return (function (p1__45703_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__45703_SHARP_);
});
})();
var inst_45722 = cljs.core.filterv(inst_45721,inst_45707);
var inst_45707__$1 = inst_45722;
var state_45737__$1 = (function (){var statearr_45774 = state_45737;
(statearr_45774[(10)] = inst_45707__$1);

return statearr_45774;
})();
var statearr_45775_47292 = state_45737__$1;
(statearr_45775_47292[(2)] = null);

(statearr_45775_47292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_45778 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45778[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_45778[(1)] = (1));

return statearr_45778;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_45737){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_45737);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e45780){var ex__43301__auto__ = e45780;
var statearr_45781_47293 = state_45737;
(statearr_45781_47293[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_45737[(4)]))){
var statearr_45782_47294 = state_45737;
(statearr_45782_47294[(1)] = cljs.core.first((state_45737[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47297 = state_45737;
state_45737 = G__47297;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_45737){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_45737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_45786 = f__43545__auto__();
(statearr_45786[(6)] = c__43544__auto___47279);

return statearr_45786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__45790 = arguments.length;
switch (G__45790) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43544__auto___47304 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_45815){
var state_val_45816 = (state_45815[(1)]);
if((state_val_45816 === (7))){
var inst_45797 = (state_45815[(7)]);
var inst_45797__$1 = (state_45815[(2)]);
var inst_45798 = (inst_45797__$1 == null);
var inst_45799 = cljs.core.not(inst_45798);
var state_45815__$1 = (function (){var statearr_45817 = state_45815;
(statearr_45817[(7)] = inst_45797__$1);

return statearr_45817;
})();
if(inst_45799){
var statearr_45818_47308 = state_45815__$1;
(statearr_45818_47308[(1)] = (8));

} else {
var statearr_45819_47309 = state_45815__$1;
(statearr_45819_47309[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45816 === (1))){
var inst_45792 = (0);
var state_45815__$1 = (function (){var statearr_45820 = state_45815;
(statearr_45820[(8)] = inst_45792);

return statearr_45820;
})();
var statearr_45821_47310 = state_45815__$1;
(statearr_45821_47310[(2)] = null);

(statearr_45821_47310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45816 === (4))){
var state_45815__$1 = state_45815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45815__$1,(7),ch);
} else {
if((state_val_45816 === (6))){
var inst_45810 = (state_45815[(2)]);
var state_45815__$1 = state_45815;
var statearr_45822_47311 = state_45815__$1;
(statearr_45822_47311[(2)] = inst_45810);

(statearr_45822_47311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45816 === (3))){
var inst_45812 = (state_45815[(2)]);
var inst_45813 = cljs.core.async.close_BANG_(out);
var state_45815__$1 = (function (){var statearr_45823 = state_45815;
(statearr_45823[(9)] = inst_45812);

return statearr_45823;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45815__$1,inst_45813);
} else {
if((state_val_45816 === (2))){
var inst_45792 = (state_45815[(8)]);
var inst_45794 = (inst_45792 < n);
var state_45815__$1 = state_45815;
if(cljs.core.truth_(inst_45794)){
var statearr_45824_47312 = state_45815__$1;
(statearr_45824_47312[(1)] = (4));

} else {
var statearr_45825_47313 = state_45815__$1;
(statearr_45825_47313[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45816 === (11))){
var inst_45792 = (state_45815[(8)]);
var inst_45802 = (state_45815[(2)]);
var inst_45803 = (inst_45792 + (1));
var inst_45792__$1 = inst_45803;
var state_45815__$1 = (function (){var statearr_45826 = state_45815;
(statearr_45826[(10)] = inst_45802);

(statearr_45826[(8)] = inst_45792__$1);

return statearr_45826;
})();
var statearr_45827_47314 = state_45815__$1;
(statearr_45827_47314[(2)] = null);

(statearr_45827_47314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45816 === (9))){
var state_45815__$1 = state_45815;
var statearr_45828_47315 = state_45815__$1;
(statearr_45828_47315[(2)] = null);

(statearr_45828_47315[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45816 === (5))){
var state_45815__$1 = state_45815;
var statearr_45830_47317 = state_45815__$1;
(statearr_45830_47317[(2)] = null);

(statearr_45830_47317[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45816 === (10))){
var inst_45807 = (state_45815[(2)]);
var state_45815__$1 = state_45815;
var statearr_45831_47318 = state_45815__$1;
(statearr_45831_47318[(2)] = inst_45807);

(statearr_45831_47318[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45816 === (8))){
var inst_45797 = (state_45815[(7)]);
var state_45815__$1 = state_45815;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45815__$1,(11),out,inst_45797);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_45832 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45832[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_45832[(1)] = (1));

return statearr_45832;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_45815){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_45815);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e45833){var ex__43301__auto__ = e45833;
var statearr_45834_47319 = state_45815;
(statearr_45834_47319[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_45815[(4)]))){
var statearr_45835_47323 = state_45815;
(statearr_45835_47323[(1)] = cljs.core.first((state_45815[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47324 = state_45815;
state_45815 = G__47324;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_45815){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_45815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_45836 = f__43545__auto__();
(statearr_45836[(6)] = c__43544__auto___47304);

return statearr_45836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45840 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45840 = (function (f,ch,meta45841){
this.f = f;
this.ch = ch;
this.meta45841 = meta45841;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45840.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45842,meta45841__$1){
var self__ = this;
var _45842__$1 = this;
return (new cljs.core.async.t_cljs$core$async45840(self__.f,self__.ch,meta45841__$1));
}));

(cljs.core.async.t_cljs$core$async45840.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45842){
var self__ = this;
var _45842__$1 = this;
return self__.meta45841;
}));

(cljs.core.async.t_cljs$core$async45840.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45840.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45840.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45840.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45840.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45847 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45847 = (function (f,ch,meta45841,_,fn1,meta45848){
this.f = f;
this.ch = ch;
this.meta45841 = meta45841;
this._ = _;
this.fn1 = fn1;
this.meta45848 = meta45848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45849,meta45848__$1){
var self__ = this;
var _45849__$1 = this;
return (new cljs.core.async.t_cljs$core$async45847(self__.f,self__.ch,self__.meta45841,self__._,self__.fn1,meta45848__$1));
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45849){
var self__ = this;
var _45849__$1 = this;
return self__.meta45848;
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__45838_SHARP_){
var G__45850 = (((p1__45838_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__45838_SHARP_) : self__.f.call(null,p1__45838_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__45850) : f1.call(null,G__45850));
});
}));

(cljs.core.async.t_cljs$core$async45847.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45841","meta45841",1022374965,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async45840","cljs.core.async/t_cljs$core$async45840",944201181,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta45848","meta45848",-2107567665,null)], null);
}));

(cljs.core.async.t_cljs$core$async45847.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45847.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45847");

(cljs.core.async.t_cljs$core$async45847.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45847");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45847.
 */
cljs.core.async.__GT_t_cljs$core$async45847 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45847(f__$1,ch__$1,meta45841__$1,___$2,fn1__$1,meta45848){
return (new cljs.core.async.t_cljs$core$async45847(f__$1,ch__$1,meta45841__$1,___$2,fn1__$1,meta45848));
});

}

return (new cljs.core.async.t_cljs$core$async45847(self__.f,self__.ch,self__.meta45841,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__45851 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__45851) : self__.f.call(null,G__45851));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async45840.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45840.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async45840.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45841","meta45841",1022374965,null)], null);
}));

(cljs.core.async.t_cljs$core$async45840.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45840.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45840");

(cljs.core.async.t_cljs$core$async45840.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45840");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45840.
 */
cljs.core.async.__GT_t_cljs$core$async45840 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45840(f__$1,ch__$1,meta45841){
return (new cljs.core.async.t_cljs$core$async45840(f__$1,ch__$1,meta45841));
});

}

return (new cljs.core.async.t_cljs$core$async45840(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45853 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45853 = (function (f,ch,meta45854){
this.f = f;
this.ch = ch;
this.meta45854 = meta45854;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45853.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45855,meta45854__$1){
var self__ = this;
var _45855__$1 = this;
return (new cljs.core.async.t_cljs$core$async45853(self__.f,self__.ch,meta45854__$1));
}));

(cljs.core.async.t_cljs$core$async45853.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45855){
var self__ = this;
var _45855__$1 = this;
return self__.meta45854;
}));

(cljs.core.async.t_cljs$core$async45853.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45853.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45853.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45853.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45853.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45853.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async45853.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45854","meta45854",-2006121390,null)], null);
}));

(cljs.core.async.t_cljs$core$async45853.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45853.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45853");

(cljs.core.async.t_cljs$core$async45853.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45853");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45853.
 */
cljs.core.async.__GT_t_cljs$core$async45853 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async45853(f__$1,ch__$1,meta45854){
return (new cljs.core.async.t_cljs$core$async45853(f__$1,ch__$1,meta45854));
});

}

return (new cljs.core.async.t_cljs$core$async45853(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45862 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45862 = (function (p,ch,meta45863){
this.p = p;
this.ch = ch;
this.meta45863 = meta45863;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45862.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45864,meta45863__$1){
var self__ = this;
var _45864__$1 = this;
return (new cljs.core.async.t_cljs$core$async45862(self__.p,self__.ch,meta45863__$1));
}));

(cljs.core.async.t_cljs$core$async45862.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45864){
var self__ = this;
var _45864__$1 = this;
return self__.meta45863;
}));

(cljs.core.async.t_cljs$core$async45862.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45862.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45862.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45862.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45862.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45862.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45862.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async45862.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45863","meta45863",-1413758356,null)], null);
}));

(cljs.core.async.t_cljs$core$async45862.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45862.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45862");

(cljs.core.async.t_cljs$core$async45862.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45862");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45862.
 */
cljs.core.async.__GT_t_cljs$core$async45862 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async45862(p__$1,ch__$1,meta45863){
return (new cljs.core.async.t_cljs$core$async45862(p__$1,ch__$1,meta45863));
});

}

return (new cljs.core.async.t_cljs$core$async45862(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__45874 = arguments.length;
switch (G__45874) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43544__auto___47373 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_45895){
var state_val_45896 = (state_45895[(1)]);
if((state_val_45896 === (7))){
var inst_45891 = (state_45895[(2)]);
var state_45895__$1 = state_45895;
var statearr_45897_47374 = state_45895__$1;
(statearr_45897_47374[(2)] = inst_45891);

(statearr_45897_47374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (1))){
var state_45895__$1 = state_45895;
var statearr_45898_47375 = state_45895__$1;
(statearr_45898_47375[(2)] = null);

(statearr_45898_47375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (4))){
var inst_45877 = (state_45895[(7)]);
var inst_45877__$1 = (state_45895[(2)]);
var inst_45878 = (inst_45877__$1 == null);
var state_45895__$1 = (function (){var statearr_45899 = state_45895;
(statearr_45899[(7)] = inst_45877__$1);

return statearr_45899;
})();
if(cljs.core.truth_(inst_45878)){
var statearr_45904_47378 = state_45895__$1;
(statearr_45904_47378[(1)] = (5));

} else {
var statearr_45905_47379 = state_45895__$1;
(statearr_45905_47379[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (6))){
var inst_45877 = (state_45895[(7)]);
var inst_45882 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45877) : p.call(null,inst_45877));
var state_45895__$1 = state_45895;
if(cljs.core.truth_(inst_45882)){
var statearr_45906_47381 = state_45895__$1;
(statearr_45906_47381[(1)] = (8));

} else {
var statearr_45907_47389 = state_45895__$1;
(statearr_45907_47389[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (3))){
var inst_45893 = (state_45895[(2)]);
var state_45895__$1 = state_45895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45895__$1,inst_45893);
} else {
if((state_val_45896 === (2))){
var state_45895__$1 = state_45895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45895__$1,(4),ch);
} else {
if((state_val_45896 === (11))){
var inst_45885 = (state_45895[(2)]);
var state_45895__$1 = state_45895;
var statearr_45912_47392 = state_45895__$1;
(statearr_45912_47392[(2)] = inst_45885);

(statearr_45912_47392[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (9))){
var state_45895__$1 = state_45895;
var statearr_45913_47393 = state_45895__$1;
(statearr_45913_47393[(2)] = null);

(statearr_45913_47393[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (5))){
var inst_45880 = cljs.core.async.close_BANG_(out);
var state_45895__$1 = state_45895;
var statearr_45915_47394 = state_45895__$1;
(statearr_45915_47394[(2)] = inst_45880);

(statearr_45915_47394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (10))){
var inst_45888 = (state_45895[(2)]);
var state_45895__$1 = (function (){var statearr_45916 = state_45895;
(statearr_45916[(8)] = inst_45888);

return statearr_45916;
})();
var statearr_45917_47398 = state_45895__$1;
(statearr_45917_47398[(2)] = null);

(statearr_45917_47398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (8))){
var inst_45877 = (state_45895[(7)]);
var state_45895__$1 = state_45895;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45895__$1,(11),out,inst_45877);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_45920 = [null,null,null,null,null,null,null,null,null];
(statearr_45920[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_45920[(1)] = (1));

return statearr_45920;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_45895){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_45895);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e45924){var ex__43301__auto__ = e45924;
var statearr_45925_47401 = state_45895;
(statearr_45925_47401[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_45895[(4)]))){
var statearr_45926_47402 = state_45895;
(statearr_45926_47402[(1)] = cljs.core.first((state_45895[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47404 = state_45895;
state_45895 = G__47404;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_45895){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_45895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_45927 = f__43545__auto__();
(statearr_45927[(6)] = c__43544__auto___47373);

return statearr_45927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__45932 = arguments.length;
switch (G__45932) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__43544__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_46006){
var state_val_46007 = (state_46006[(1)]);
if((state_val_46007 === (7))){
var inst_46000 = (state_46006[(2)]);
var state_46006__$1 = state_46006;
var statearr_46009_47413 = state_46006__$1;
(statearr_46009_47413[(2)] = inst_46000);

(statearr_46009_47413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (20))){
var inst_45970 = (state_46006[(7)]);
var inst_45981 = (state_46006[(2)]);
var inst_45982 = cljs.core.next(inst_45970);
var inst_45956 = inst_45982;
var inst_45957 = null;
var inst_45958 = (0);
var inst_45959 = (0);
var state_46006__$1 = (function (){var statearr_46010 = state_46006;
(statearr_46010[(8)] = inst_45981);

(statearr_46010[(9)] = inst_45958);

(statearr_46010[(10)] = inst_45957);

(statearr_46010[(11)] = inst_45956);

(statearr_46010[(12)] = inst_45959);

return statearr_46010;
})();
var statearr_46012_47414 = state_46006__$1;
(statearr_46012_47414[(2)] = null);

(statearr_46012_47414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (1))){
var state_46006__$1 = state_46006;
var statearr_46013_47416 = state_46006__$1;
(statearr_46013_47416[(2)] = null);

(statearr_46013_47416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (4))){
var inst_45945 = (state_46006[(13)]);
var inst_45945__$1 = (state_46006[(2)]);
var inst_45946 = (inst_45945__$1 == null);
var state_46006__$1 = (function (){var statearr_46014 = state_46006;
(statearr_46014[(13)] = inst_45945__$1);

return statearr_46014;
})();
if(cljs.core.truth_(inst_45946)){
var statearr_46015_47418 = state_46006__$1;
(statearr_46015_47418[(1)] = (5));

} else {
var statearr_46016_47419 = state_46006__$1;
(statearr_46016_47419[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (15))){
var state_46006__$1 = state_46006;
var statearr_46020_47420 = state_46006__$1;
(statearr_46020_47420[(2)] = null);

(statearr_46020_47420[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (21))){
var state_46006__$1 = state_46006;
var statearr_46021_47421 = state_46006__$1;
(statearr_46021_47421[(2)] = null);

(statearr_46021_47421[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (13))){
var inst_45958 = (state_46006[(9)]);
var inst_45957 = (state_46006[(10)]);
var inst_45956 = (state_46006[(11)]);
var inst_45959 = (state_46006[(12)]);
var inst_45966 = (state_46006[(2)]);
var inst_45967 = (inst_45959 + (1));
var tmp46017 = inst_45958;
var tmp46018 = inst_45957;
var tmp46019 = inst_45956;
var inst_45956__$1 = tmp46019;
var inst_45957__$1 = tmp46018;
var inst_45958__$1 = tmp46017;
var inst_45959__$1 = inst_45967;
var state_46006__$1 = (function (){var statearr_46023 = state_46006;
(statearr_46023[(9)] = inst_45958__$1);

(statearr_46023[(10)] = inst_45957__$1);

(statearr_46023[(14)] = inst_45966);

(statearr_46023[(11)] = inst_45956__$1);

(statearr_46023[(12)] = inst_45959__$1);

return statearr_46023;
})();
var statearr_46024_47432 = state_46006__$1;
(statearr_46024_47432[(2)] = null);

(statearr_46024_47432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (22))){
var state_46006__$1 = state_46006;
var statearr_46025_47433 = state_46006__$1;
(statearr_46025_47433[(2)] = null);

(statearr_46025_47433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (6))){
var inst_45945 = (state_46006[(13)]);
var inst_45954 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_45945) : f.call(null,inst_45945));
var inst_45955 = cljs.core.seq(inst_45954);
var inst_45956 = inst_45955;
var inst_45957 = null;
var inst_45958 = (0);
var inst_45959 = (0);
var state_46006__$1 = (function (){var statearr_46026 = state_46006;
(statearr_46026[(9)] = inst_45958);

(statearr_46026[(10)] = inst_45957);

(statearr_46026[(11)] = inst_45956);

(statearr_46026[(12)] = inst_45959);

return statearr_46026;
})();
var statearr_46027_47440 = state_46006__$1;
(statearr_46027_47440[(2)] = null);

(statearr_46027_47440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (17))){
var inst_45970 = (state_46006[(7)]);
var inst_45974 = cljs.core.chunk_first(inst_45970);
var inst_45975 = cljs.core.chunk_rest(inst_45970);
var inst_45976 = cljs.core.count(inst_45974);
var inst_45956 = inst_45975;
var inst_45957 = inst_45974;
var inst_45958 = inst_45976;
var inst_45959 = (0);
var state_46006__$1 = (function (){var statearr_46028 = state_46006;
(statearr_46028[(9)] = inst_45958);

(statearr_46028[(10)] = inst_45957);

(statearr_46028[(11)] = inst_45956);

(statearr_46028[(12)] = inst_45959);

return statearr_46028;
})();
var statearr_46029_47442 = state_46006__$1;
(statearr_46029_47442[(2)] = null);

(statearr_46029_47442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (3))){
var inst_46002 = (state_46006[(2)]);
var state_46006__$1 = state_46006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46006__$1,inst_46002);
} else {
if((state_val_46007 === (12))){
var inst_45990 = (state_46006[(2)]);
var state_46006__$1 = state_46006;
var statearr_46030_47443 = state_46006__$1;
(statearr_46030_47443[(2)] = inst_45990);

(statearr_46030_47443[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (2))){
var state_46006__$1 = state_46006;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46006__$1,(4),in$);
} else {
if((state_val_46007 === (23))){
var inst_45998 = (state_46006[(2)]);
var state_46006__$1 = state_46006;
var statearr_46031_47444 = state_46006__$1;
(statearr_46031_47444[(2)] = inst_45998);

(statearr_46031_47444[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (19))){
var inst_45985 = (state_46006[(2)]);
var state_46006__$1 = state_46006;
var statearr_46032_47445 = state_46006__$1;
(statearr_46032_47445[(2)] = inst_45985);

(statearr_46032_47445[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (11))){
var inst_45970 = (state_46006[(7)]);
var inst_45956 = (state_46006[(11)]);
var inst_45970__$1 = cljs.core.seq(inst_45956);
var state_46006__$1 = (function (){var statearr_46034 = state_46006;
(statearr_46034[(7)] = inst_45970__$1);

return statearr_46034;
})();
if(inst_45970__$1){
var statearr_46035_47449 = state_46006__$1;
(statearr_46035_47449[(1)] = (14));

} else {
var statearr_46036_47450 = state_46006__$1;
(statearr_46036_47450[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (9))){
var inst_45992 = (state_46006[(2)]);
var inst_45993 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_46006__$1 = (function (){var statearr_46037 = state_46006;
(statearr_46037[(15)] = inst_45992);

return statearr_46037;
})();
if(cljs.core.truth_(inst_45993)){
var statearr_46038_47452 = state_46006__$1;
(statearr_46038_47452[(1)] = (21));

} else {
var statearr_46041_47453 = state_46006__$1;
(statearr_46041_47453[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (5))){
var inst_45948 = cljs.core.async.close_BANG_(out);
var state_46006__$1 = state_46006;
var statearr_46042_47456 = state_46006__$1;
(statearr_46042_47456[(2)] = inst_45948);

(statearr_46042_47456[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (14))){
var inst_45970 = (state_46006[(7)]);
var inst_45972 = cljs.core.chunked_seq_QMARK_(inst_45970);
var state_46006__$1 = state_46006;
if(inst_45972){
var statearr_46045_47457 = state_46006__$1;
(statearr_46045_47457[(1)] = (17));

} else {
var statearr_46046_47458 = state_46006__$1;
(statearr_46046_47458[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (16))){
var inst_45988 = (state_46006[(2)]);
var state_46006__$1 = state_46006;
var statearr_46048_47459 = state_46006__$1;
(statearr_46048_47459[(2)] = inst_45988);

(statearr_46048_47459[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46007 === (10))){
var inst_45957 = (state_46006[(10)]);
var inst_45959 = (state_46006[(12)]);
var inst_45964 = cljs.core._nth(inst_45957,inst_45959);
var state_46006__$1 = state_46006;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46006__$1,(13),out,inst_45964);
} else {
if((state_val_46007 === (18))){
var inst_45970 = (state_46006[(7)]);
var inst_45979 = cljs.core.first(inst_45970);
var state_46006__$1 = state_46006;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46006__$1,(20),out,inst_45979);
} else {
if((state_val_46007 === (8))){
var inst_45958 = (state_46006[(9)]);
var inst_45959 = (state_46006[(12)]);
var inst_45961 = (inst_45959 < inst_45958);
var inst_45962 = inst_45961;
var state_46006__$1 = state_46006;
if(cljs.core.truth_(inst_45962)){
var statearr_46054_47460 = state_46006__$1;
(statearr_46054_47460[(1)] = (10));

} else {
var statearr_46055_47461 = state_46006__$1;
(statearr_46055_47461[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__43298__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__43298__auto____0 = (function (){
var statearr_46056 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46056[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__43298__auto__);

(statearr_46056[(1)] = (1));

return statearr_46056;
});
var cljs$core$async$mapcat_STAR__$_state_machine__43298__auto____1 = (function (state_46006){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_46006);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e46057){var ex__43301__auto__ = e46057;
var statearr_46058_47463 = state_46006;
(statearr_46058_47463[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_46006[(4)]))){
var statearr_46059_47464 = state_46006;
(statearr_46059_47464[(1)] = cljs.core.first((state_46006[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47467 = state_46006;
state_46006 = G__47467;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__43298__auto__ = function(state_46006){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__43298__auto____1.call(this,state_46006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__43298__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__43298__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_46066 = f__43545__auto__();
(statearr_46066[(6)] = c__43544__auto__);

return statearr_46066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));

return c__43544__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__46092 = arguments.length;
switch (G__46092) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__46099 = arguments.length;
switch (G__46099) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__46103 = arguments.length;
switch (G__46103) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43544__auto___47480 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_46127){
var state_val_46128 = (state_46127[(1)]);
if((state_val_46128 === (7))){
var inst_46122 = (state_46127[(2)]);
var state_46127__$1 = state_46127;
var statearr_46129_47481 = state_46127__$1;
(statearr_46129_47481[(2)] = inst_46122);

(statearr_46129_47481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (1))){
var inst_46104 = null;
var state_46127__$1 = (function (){var statearr_46130 = state_46127;
(statearr_46130[(7)] = inst_46104);

return statearr_46130;
})();
var statearr_46131_47482 = state_46127__$1;
(statearr_46131_47482[(2)] = null);

(statearr_46131_47482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (4))){
var inst_46107 = (state_46127[(8)]);
var inst_46107__$1 = (state_46127[(2)]);
var inst_46108 = (inst_46107__$1 == null);
var inst_46109 = cljs.core.not(inst_46108);
var state_46127__$1 = (function (){var statearr_46132 = state_46127;
(statearr_46132[(8)] = inst_46107__$1);

return statearr_46132;
})();
if(inst_46109){
var statearr_46133_47483 = state_46127__$1;
(statearr_46133_47483[(1)] = (5));

} else {
var statearr_46134_47484 = state_46127__$1;
(statearr_46134_47484[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (6))){
var state_46127__$1 = state_46127;
var statearr_46135_47486 = state_46127__$1;
(statearr_46135_47486[(2)] = null);

(statearr_46135_47486[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (3))){
var inst_46124 = (state_46127[(2)]);
var inst_46125 = cljs.core.async.close_BANG_(out);
var state_46127__$1 = (function (){var statearr_46136 = state_46127;
(statearr_46136[(9)] = inst_46124);

return statearr_46136;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46127__$1,inst_46125);
} else {
if((state_val_46128 === (2))){
var state_46127__$1 = state_46127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46127__$1,(4),ch);
} else {
if((state_val_46128 === (11))){
var inst_46107 = (state_46127[(8)]);
var inst_46116 = (state_46127[(2)]);
var inst_46104 = inst_46107;
var state_46127__$1 = (function (){var statearr_46138 = state_46127;
(statearr_46138[(7)] = inst_46104);

(statearr_46138[(10)] = inst_46116);

return statearr_46138;
})();
var statearr_46139_47491 = state_46127__$1;
(statearr_46139_47491[(2)] = null);

(statearr_46139_47491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (9))){
var inst_46107 = (state_46127[(8)]);
var state_46127__$1 = state_46127;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46127__$1,(11),out,inst_46107);
} else {
if((state_val_46128 === (5))){
var inst_46104 = (state_46127[(7)]);
var inst_46107 = (state_46127[(8)]);
var inst_46111 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46107,inst_46104);
var state_46127__$1 = state_46127;
if(inst_46111){
var statearr_46143_47494 = state_46127__$1;
(statearr_46143_47494[(1)] = (8));

} else {
var statearr_46144_47495 = state_46127__$1;
(statearr_46144_47495[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (10))){
var inst_46119 = (state_46127[(2)]);
var state_46127__$1 = state_46127;
var statearr_46146_47496 = state_46127__$1;
(statearr_46146_47496[(2)] = inst_46119);

(statearr_46146_47496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (8))){
var inst_46104 = (state_46127[(7)]);
var tmp46141 = inst_46104;
var inst_46104__$1 = tmp46141;
var state_46127__$1 = (function (){var statearr_46147 = state_46127;
(statearr_46147[(7)] = inst_46104__$1);

return statearr_46147;
})();
var statearr_46149_47497 = state_46127__$1;
(statearr_46149_47497[(2)] = null);

(statearr_46149_47497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_46150 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46150[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_46150[(1)] = (1));

return statearr_46150;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_46127){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_46127);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e46151){var ex__43301__auto__ = e46151;
var statearr_46152_47499 = state_46127;
(statearr_46152_47499[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_46127[(4)]))){
var statearr_46153_47500 = state_46127;
(statearr_46153_47500[(1)] = cljs.core.first((state_46127[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47501 = state_46127;
state_46127 = G__47501;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_46127){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_46127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_46159 = f__43545__auto__();
(statearr_46159[(6)] = c__43544__auto___47480);

return statearr_46159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__46163 = arguments.length;
switch (G__46163) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43544__auto___47504 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_46204){
var state_val_46205 = (state_46204[(1)]);
if((state_val_46205 === (7))){
var inst_46200 = (state_46204[(2)]);
var state_46204__$1 = state_46204;
var statearr_46209_47505 = state_46204__$1;
(statearr_46209_47505[(2)] = inst_46200);

(statearr_46209_47505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (1))){
var inst_46167 = (new Array(n));
var inst_46168 = inst_46167;
var inst_46169 = (0);
var state_46204__$1 = (function (){var statearr_46210 = state_46204;
(statearr_46210[(7)] = inst_46168);

(statearr_46210[(8)] = inst_46169);

return statearr_46210;
})();
var statearr_46211_47507 = state_46204__$1;
(statearr_46211_47507[(2)] = null);

(statearr_46211_47507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (4))){
var inst_46172 = (state_46204[(9)]);
var inst_46172__$1 = (state_46204[(2)]);
var inst_46173 = (inst_46172__$1 == null);
var inst_46174 = cljs.core.not(inst_46173);
var state_46204__$1 = (function (){var statearr_46212 = state_46204;
(statearr_46212[(9)] = inst_46172__$1);

return statearr_46212;
})();
if(inst_46174){
var statearr_46213_47508 = state_46204__$1;
(statearr_46213_47508[(1)] = (5));

} else {
var statearr_46214_47509 = state_46204__$1;
(statearr_46214_47509[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (15))){
var inst_46194 = (state_46204[(2)]);
var state_46204__$1 = state_46204;
var statearr_46218_47510 = state_46204__$1;
(statearr_46218_47510[(2)] = inst_46194);

(statearr_46218_47510[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (13))){
var state_46204__$1 = state_46204;
var statearr_46219_47511 = state_46204__$1;
(statearr_46219_47511[(2)] = null);

(statearr_46219_47511[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (6))){
var inst_46169 = (state_46204[(8)]);
var inst_46190 = (inst_46169 > (0));
var state_46204__$1 = state_46204;
if(cljs.core.truth_(inst_46190)){
var statearr_46220_47512 = state_46204__$1;
(statearr_46220_47512[(1)] = (12));

} else {
var statearr_46221_47513 = state_46204__$1;
(statearr_46221_47513[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (3))){
var inst_46202 = (state_46204[(2)]);
var state_46204__$1 = state_46204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46204__$1,inst_46202);
} else {
if((state_val_46205 === (12))){
var inst_46168 = (state_46204[(7)]);
var inst_46192 = cljs.core.vec(inst_46168);
var state_46204__$1 = state_46204;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46204__$1,(15),out,inst_46192);
} else {
if((state_val_46205 === (2))){
var state_46204__$1 = state_46204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46204__$1,(4),ch);
} else {
if((state_val_46205 === (11))){
var inst_46184 = (state_46204[(2)]);
var inst_46185 = (new Array(n));
var inst_46168 = inst_46185;
var inst_46169 = (0);
var state_46204__$1 = (function (){var statearr_46225 = state_46204;
(statearr_46225[(7)] = inst_46168);

(statearr_46225[(8)] = inst_46169);

(statearr_46225[(10)] = inst_46184);

return statearr_46225;
})();
var statearr_46226_47514 = state_46204__$1;
(statearr_46226_47514[(2)] = null);

(statearr_46226_47514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (9))){
var inst_46168 = (state_46204[(7)]);
var inst_46182 = cljs.core.vec(inst_46168);
var state_46204__$1 = state_46204;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46204__$1,(11),out,inst_46182);
} else {
if((state_val_46205 === (5))){
var inst_46177 = (state_46204[(11)]);
var inst_46168 = (state_46204[(7)]);
var inst_46169 = (state_46204[(8)]);
var inst_46172 = (state_46204[(9)]);
var inst_46176 = (inst_46168[inst_46169] = inst_46172);
var inst_46177__$1 = (inst_46169 + (1));
var inst_46178 = (inst_46177__$1 < n);
var state_46204__$1 = (function (){var statearr_46229 = state_46204;
(statearr_46229[(11)] = inst_46177__$1);

(statearr_46229[(12)] = inst_46176);

return statearr_46229;
})();
if(cljs.core.truth_(inst_46178)){
var statearr_46230_47517 = state_46204__$1;
(statearr_46230_47517[(1)] = (8));

} else {
var statearr_46231_47518 = state_46204__$1;
(statearr_46231_47518[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (14))){
var inst_46197 = (state_46204[(2)]);
var inst_46198 = cljs.core.async.close_BANG_(out);
var state_46204__$1 = (function (){var statearr_46233 = state_46204;
(statearr_46233[(13)] = inst_46197);

return statearr_46233;
})();
var statearr_46234_47520 = state_46204__$1;
(statearr_46234_47520[(2)] = inst_46198);

(statearr_46234_47520[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (10))){
var inst_46188 = (state_46204[(2)]);
var state_46204__$1 = state_46204;
var statearr_46235_47521 = state_46204__$1;
(statearr_46235_47521[(2)] = inst_46188);

(statearr_46235_47521[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46205 === (8))){
var inst_46177 = (state_46204[(11)]);
var inst_46168 = (state_46204[(7)]);
var tmp46232 = inst_46168;
var inst_46168__$1 = tmp46232;
var inst_46169 = inst_46177;
var state_46204__$1 = (function (){var statearr_46236 = state_46204;
(statearr_46236[(7)] = inst_46168__$1);

(statearr_46236[(8)] = inst_46169);

return statearr_46236;
})();
var statearr_46237_47524 = state_46204__$1;
(statearr_46237_47524[(2)] = null);

(statearr_46237_47524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_46238 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46238[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_46238[(1)] = (1));

return statearr_46238;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_46204){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_46204);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e46243){var ex__43301__auto__ = e46243;
var statearr_46244_47526 = state_46204;
(statearr_46244_47526[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_46204[(4)]))){
var statearr_46245_47527 = state_46204;
(statearr_46245_47527[(1)] = cljs.core.first((state_46204[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47528 = state_46204;
state_46204 = G__47528;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_46204){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_46204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_46250 = f__43545__auto__();
(statearr_46250[(6)] = c__43544__auto___47504);

return statearr_46250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__46252 = arguments.length;
switch (G__46252) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43544__auto___47531 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_46294){
var state_val_46295 = (state_46294[(1)]);
if((state_val_46295 === (7))){
var inst_46290 = (state_46294[(2)]);
var state_46294__$1 = state_46294;
var statearr_46304_47532 = state_46294__$1;
(statearr_46304_47532[(2)] = inst_46290);

(statearr_46304_47532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (1))){
var inst_46253 = [];
var inst_46254 = inst_46253;
var inst_46255 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_46294__$1 = (function (){var statearr_46305 = state_46294;
(statearr_46305[(7)] = inst_46254);

(statearr_46305[(8)] = inst_46255);

return statearr_46305;
})();
var statearr_46306_47533 = state_46294__$1;
(statearr_46306_47533[(2)] = null);

(statearr_46306_47533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (4))){
var inst_46258 = (state_46294[(9)]);
var inst_46258__$1 = (state_46294[(2)]);
var inst_46259 = (inst_46258__$1 == null);
var inst_46260 = cljs.core.not(inst_46259);
var state_46294__$1 = (function (){var statearr_46311 = state_46294;
(statearr_46311[(9)] = inst_46258__$1);

return statearr_46311;
})();
if(inst_46260){
var statearr_46312_47535 = state_46294__$1;
(statearr_46312_47535[(1)] = (5));

} else {
var statearr_46313_47536 = state_46294__$1;
(statearr_46313_47536[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (15))){
var inst_46284 = (state_46294[(2)]);
var state_46294__$1 = state_46294;
var statearr_46314_47537 = state_46294__$1;
(statearr_46314_47537[(2)] = inst_46284);

(statearr_46314_47537[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (13))){
var state_46294__$1 = state_46294;
var statearr_46315_47538 = state_46294__$1;
(statearr_46315_47538[(2)] = null);

(statearr_46315_47538[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (6))){
var inst_46254 = (state_46294[(7)]);
var inst_46279 = inst_46254.length;
var inst_46280 = (inst_46279 > (0));
var state_46294__$1 = state_46294;
if(cljs.core.truth_(inst_46280)){
var statearr_46318_47539 = state_46294__$1;
(statearr_46318_47539[(1)] = (12));

} else {
var statearr_46319_47540 = state_46294__$1;
(statearr_46319_47540[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (3))){
var inst_46292 = (state_46294[(2)]);
var state_46294__$1 = state_46294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46294__$1,inst_46292);
} else {
if((state_val_46295 === (12))){
var inst_46254 = (state_46294[(7)]);
var inst_46282 = cljs.core.vec(inst_46254);
var state_46294__$1 = state_46294;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46294__$1,(15),out,inst_46282);
} else {
if((state_val_46295 === (2))){
var state_46294__$1 = state_46294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46294__$1,(4),ch);
} else {
if((state_val_46295 === (11))){
var inst_46262 = (state_46294[(10)]);
var inst_46258 = (state_46294[(9)]);
var inst_46272 = (state_46294[(2)]);
var inst_46273 = [];
var inst_46274 = inst_46273.push(inst_46258);
var inst_46254 = inst_46273;
var inst_46255 = inst_46262;
var state_46294__$1 = (function (){var statearr_46321 = state_46294;
(statearr_46321[(11)] = inst_46272);

(statearr_46321[(12)] = inst_46274);

(statearr_46321[(7)] = inst_46254);

(statearr_46321[(8)] = inst_46255);

return statearr_46321;
})();
var statearr_46322_47543 = state_46294__$1;
(statearr_46322_47543[(2)] = null);

(statearr_46322_47543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (9))){
var inst_46254 = (state_46294[(7)]);
var inst_46270 = cljs.core.vec(inst_46254);
var state_46294__$1 = state_46294;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46294__$1,(11),out,inst_46270);
} else {
if((state_val_46295 === (5))){
var inst_46262 = (state_46294[(10)]);
var inst_46258 = (state_46294[(9)]);
var inst_46255 = (state_46294[(8)]);
var inst_46262__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46258) : f.call(null,inst_46258));
var inst_46263 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46262__$1,inst_46255);
var inst_46264 = cljs.core.keyword_identical_QMARK_(inst_46255,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_46265 = ((inst_46263) || (inst_46264));
var state_46294__$1 = (function (){var statearr_46323 = state_46294;
(statearr_46323[(10)] = inst_46262__$1);

return statearr_46323;
})();
if(cljs.core.truth_(inst_46265)){
var statearr_46324_47553 = state_46294__$1;
(statearr_46324_47553[(1)] = (8));

} else {
var statearr_46325_47555 = state_46294__$1;
(statearr_46325_47555[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (14))){
var inst_46287 = (state_46294[(2)]);
var inst_46288 = cljs.core.async.close_BANG_(out);
var state_46294__$1 = (function (){var statearr_46331 = state_46294;
(statearr_46331[(13)] = inst_46287);

return statearr_46331;
})();
var statearr_46332_47556 = state_46294__$1;
(statearr_46332_47556[(2)] = inst_46288);

(statearr_46332_47556[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (10))){
var inst_46277 = (state_46294[(2)]);
var state_46294__$1 = state_46294;
var statearr_46333_47561 = state_46294__$1;
(statearr_46333_47561[(2)] = inst_46277);

(statearr_46333_47561[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46295 === (8))){
var inst_46262 = (state_46294[(10)]);
var inst_46258 = (state_46294[(9)]);
var inst_46254 = (state_46294[(7)]);
var inst_46267 = inst_46254.push(inst_46258);
var tmp46328 = inst_46254;
var inst_46254__$1 = tmp46328;
var inst_46255 = inst_46262;
var state_46294__$1 = (function (){var statearr_46338 = state_46294;
(statearr_46338[(7)] = inst_46254__$1);

(statearr_46338[(14)] = inst_46267);

(statearr_46338[(8)] = inst_46255);

return statearr_46338;
})();
var statearr_46339_47563 = state_46294__$1;
(statearr_46339_47563[(2)] = null);

(statearr_46339_47563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43298__auto__ = null;
var cljs$core$async$state_machine__43298__auto____0 = (function (){
var statearr_46340 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46340[(0)] = cljs$core$async$state_machine__43298__auto__);

(statearr_46340[(1)] = (1));

return statearr_46340;
});
var cljs$core$async$state_machine__43298__auto____1 = (function (state_46294){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_46294);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e46346){var ex__43301__auto__ = e46346;
var statearr_46347_47565 = state_46294;
(statearr_46347_47565[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_46294[(4)]))){
var statearr_46348_47566 = state_46294;
(statearr_46348_47566[(1)] = cljs.core.first((state_46294[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47567 = state_46294;
state_46294 = G__47567;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
cljs$core$async$state_machine__43298__auto__ = function(state_46294){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43298__auto____1.call(this,state_46294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43298__auto____0;
cljs$core$async$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43298__auto____1;
return cljs$core$async$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_46351 = f__43545__auto__();
(statearr_46351[(6)] = c__43544__auto___47531);

return statearr_46351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
