(ns marram.core
  (:require ["max-api" :as max-api]
            [re-frame.core :as rf]))

(rf/reg-cofx
 :max/get-dict
 (fn [id]
   (.getDict max-api id)))

(rf/reg-fx
 :max/outlet
 (fn [[& args]]
   (-> (apply (.-outlet max-api) args)
       (.catch #(rf/dispatch [:max.outlet/error {:args args :err %}])))))

(rf/reg-fx
 :max/outlet-n
 (fn [[& events]]
   (doseq [event events]
     (-> (apply (.-outlet max-api) event)
         (.catch #(rf/dispatch [:max.outlet/error {:args event :err %}]))))))

(rf/reg-fx
 :max/outlet-bang
 (fn [_]
   (-> (.outletBang max-api)
       (.catch #(rf/dispatch [:max.outlet-bang/error {:err %}])))))

(rf/reg-fx
 :max/post
 (fn [[level & args]]
   (apply (.-post max-api) (conj args level))))

(rf/reg-fx
 :max/set-dict
 (fn [[id content]]
   (.setDict max-api id content)))

(rf/reg-fx
 :max/update-dict
 (fn [[id content value]]
   (.updateDict max-api id content value)))

(defn handle-message
  [handled? msg-type & args]
  (rf/dispatch [:max/message {:handled? handled?
                              :type     msg-type
                              :args     args}]))

(js/console.log "♫♪♬... marram.core initialized")
(.addHandler max-api "all" handle-message)