'use strict';


angular.module('myApp.service',['ngResource']).config(function($httpProvider){
    $httpProvider.defaults.transformRequest = function (data) {
        var str = [];
        for (var p in data) {
            data[p] !== undefined && str.push(encodeURIComponent(p) + '=' + encodeURIComponent(data[p]));
        }
        return str.join('&');
    };
    $httpProvider.defaults.headers.put['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';
    $httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';

}).factory('Home', function ($resource){
    return $resource('/home/:id',
                     { id: '@id' },
                     { list: { method: 'GET' ,
                               params: {page: "@page"},
                               isArray: true },
                       create: { method: 'POST' },
                       update: { method: 'PUT' }
                     });
}).factory('User', function ($resource){
    return $resource('/user/:id',
                     { id: '@id' },
                     { list: { method: 'GET' ,
                               params: {page: "@page"},
                               isArray: true },
                       create: { method: 'POST' },
                       update: { method: 'PUT' }
                     });
});


angular.module('myapp.timeline', ["ui.router", "ui.bootstrap"]).
    config(function($stateProvider, $urlRouterProvider){

        var TimeLine = {
            name: 'timeline',
            url: "/timeline",
            //            templateUrl: 'partials/timeline.html'
            templateUrl: 'history.htm',
            controller: ['$scope', function ($scope) {
                console.log("Call history ");
                $scope.name = "World";
                //                                         $state.go(".user.list");
            }]
        };

        $stateProvider.state(TimeLine);
    });


angular.module('myapp.home', ["ui.router", "ui.bootstrap", "myApp.service"]).
    config(function($stateProvider, $urlRouterProvider){
        $urlRouterProvider.when('/home', '/home/user');

        var Home = {
            name: 'home',
            url: '/home',
            templateUrl: 'app/home/home.html',
            controller: ['$scope', function ($scope) {
                $scope.name = "World";
                //                                         $state.go(".user.list");
            }]};

        var User = {
            parent: Home,
            name: 'home.user',
            abstract: true,
            url: '/user',
            template: '<ui-view/>'
        };

        var UserList = {
            parent: User,
            name: 'home.user.list',
            url: '?page',
            templateUrl: 'app/home/user.list.html',
            controller: ['$location','$state', '$stateParams','$scope','User', function($location,$state,$stateParams, $scope,User){

                $scope.users = User.list({page: $location.search().page});
                $scope.totalItems = 164;
                $scope.currentPage = (undefined != $location.search().page)?$location.search().page:1;
                $scope.maxSize = 7;

                $scope.pageChanged = function (pageNo) {
                    $state.go(".^.list",{page: pageNo});
                };
            }]
        };

        var UserCreate = {
            parent: User,
            name: 'home.user.create',
            templateUrl: 'app/home/user.edit.html',
            url: "/new",
            controller: ['$state','$scope', 'User', function($state, $scope, User){
             console.log("User create controller");

                $scope.submit = function() {
                    User.create($scope.user,function(data,headers) {
                        $state.go(".^.list");
                    },function(err,headers){
                        alert('FAILED');
                    });
                };
            }]
        };

        var UserDetails = {
            parent: User,
            name: 'home.user.details',
            url: "/:id",
            templateUrl: 'app/home/user.details.html',
            controller: ['$stateParams', '$scope','User', function($stateParams, $scope, User){
                $scope.user = User.get({id: $stateParams.id});
            }]
        };

        var UserEdit = {
            parent: User,
            name: 'home.user.edit',
            url: "/edit/:id",
            templateUrl: 'app/home/user.edit.html',
            controller: ['$state','$stateParams','$scope','User', function($state,$stateParams, $scope, User){
                $scope.user = User.get({id: $stateParams.id});
                $scope.submit = function() {

                    var data = {id: $scope.user.id,
                                lname:$scope.user.lname,
                                sname:$scope.user.sname };

                    User.update(data, function(data, headers){
                        $state.go(".^.list");
                    }, function(err, headers){
                        alert('FAILED');
                    });
                };
            }]
        };

        var Upload = {
            parent: Home,
            name: 'home.upload',
            url: '/upload',
            templateUrl: 'app/home/upload.html'
        };

        var Report = {
            parent: Home,
            name: 'home.report',
            url: '/report',
            templateUrl: 'app/home/report.html'
        };

        $stateProvider
            .state(Home)
            .state(User)
            .state(UserList)
            .state(UserCreate)
            .state(UserEdit)
            .state(UserDetails)
            .state(Upload)
            .state(Report);

    });


var myapp = angular.module('myapp', ["ui.router", "ngAnimate","ui.bootstrap", "myapp.timeline", "myapp.home"]);
myapp.config(function( $stateProvider, $urlRouterProvider){
    // For any unmatched url, send to /route1
    $urlRouterProvider.otherwise("/home");
}).run(function($rootScope, $state, $stateParams) {
    $rootScope.$state = $state;
    $rootScope.$stateParams = $stateParams;
});
