(ns zme.crosspage
  (:require-macros  [cljs.core.async.macros :refer [go alt!]] )
  (:use [cljs.net.crosspages :only [create-channel create-peer-channel]])
  (:require
   [cljs.reader :as reader]
   [goog.events :as events]
   [goog.Timer :as timer]
   [cljs.core.async :as async :refer [chan close! put!]]))


(def system (js-obj))


(defn push [data]
  (let [role (.getRole (.-channel system))]
    (.log js/console role)
    (.log js/console data)))


(defn init-channel []
  (let [inner-page "inner.html"
        channel (create-channel inner-page)]
    (.registerService channel "push" push)
    (set! (.-channel system) channel)))


(defn init-peer-channel []
  (if (nil? (.-channel system))
    (let [channel (create-peer-channel)
          timer (goog.Timer. 90000)]
      (.start timer)
      (.registerService channel "push" push)
      (set! (.-channel system) channel)
      (events/listen timer goog.Timer/TICK
                     (fn []
                       (.send (.-channel system) "push" "From peer data")
                       )))))


(defn push-msg []
  (go
   (when-let [channel (.-channel system)]
     (if (.isConnected channel )
       (.send channel "push" (.-href (.-location js/window))))))
  nil)


(defn ^:export initChannel []  (events/listen js/window "load" init-channel))
(defn ^:export initPeerChannel [] (events/listen js/window "load" init-peer-channel))
(defn ^:export save [] (push-msg))


(comment
  (println (first (reader/read-string (pr-str [3 4 5]))))
  (println "Hello")
  (.log js/console "Hello")
  (send "Hello from server")
  (outer-channel)
  (go (push-msg))
  )
