(ns {{name}}.datomic
  (:use
   [datomic.api :only [q db] :as d])
  (:require [clojure.java.io :as io]))


(defonce ^:dynamic uri "datomic:mem://hello")

(defonce ^:dynamic schema-tx (->
                              "{{name}}/datomicSchema.edn"
                              (io/resource )
                              (slurp )
                              (read-string )))

(defonce connection (delay (when (d/create-database uri)
                             @(d/transact (d/connect uri) schema-tx))
                           (d/connect uri)))

(defn init-db [] @connection)


(defn delete-db []
  (d/delete-database uri))
