(ns {{name}}.sqldb
  (:import com.mchange.v2.c3p0.ComboPooledDataSource)
  (:require  [clojure.java.jdbc :as sql]))


(defonce ^:dynamic db-config
  {:classname "org.postgresql.Driver"
   :subprotocol "postgresql"
   :subname "//localhost:5432/zme"
   :user "postgres"
   :password "postgres"})


(defn pool
  [config]
  (let [cpds (doto (ComboPooledDataSource.)
               (.setDriverClass (:classname config))
               (.setJdbcUrl (str "jdbc:" (:subprotocol config) ":" (:subname config)))
               (.setUser (:user config))
               (.setPassword (:password config))
               (.setMaxPoolSize 6)
               (.setMinPoolSize 1)
               (.setInitialPoolSize 1))]
    {:datasource cpds}))


(defonce pooled-db (delay (pool db-config)))


(defn db-connection [] @pooled-db)


(defn create-schema [db-connection]
  (sql/with-connection (db-connection)
    (sql/create-table :documents [:id "varchar(256)" "primary key"]
                      [:title "varchar(1024)"]
                      [:text :varchar])) )


(defn delete-schema [db-connection]
  (sql/with-connection (db-connection)
    (sql/drop-table :documents)))
