(ns zme.modules.user_test
  (:require [clojure.test :refer :all])
  (:use [zme.modules.user]
        [zme.datomic]
        [zme.modules.user-util]
        [zme.system]))


(defonce test-system nil)

(when (nil? test-system)
  (println "Init system")
  (alter-var-root #'test-system  (constantly (system) )))


(deftest test-find-all
  (testing "testing user list"
    (let [total (find-all (:datomic-conn test-system) 0 80)]
      (println total)
      (println (count  total))
      (println "Test list template"))))


(deftest test-update
  (testing "testing update"
    (let [data (->
                (defaults)
                (assoc :lname "mamun")
                (assoc :sname "mamun"))
          _ (update (:datomic-conn test-system) data)
          fdata (find-by-name (:datomic-conn test-system) "mamun")]
      (println fdata))))


(deftest test-find-by-name
  (testing "testing find by sname"
    (let [data (find-by-name (:datomic-conn test-system) "NbRiJ")]
      (is (= "NbRiJ" (:sname data))))))


(deftest test-find-by-id
  (testing "testing find by id"
    (let [id 4611681620380878000
          data (find-by-id (:datomic-conn test-system) id )]
      (println data)
      (is (= id (:id data) )))))
