(ns {{name}}.user
  (:use [cljs.net.xhr :only [GET POST uri-with-params]]
        [cljs.net.remote.client :only [remotes]])
  (:require
   [cljs.core.async :as async :refer [chan close! put! ]])
  (:require-macros  [cljs.core.async.macros :refer [go alt!]]
                    [cljs.net.remote.client :as rc]))


(defn user-list2 [page handler]
  (GET (uri-with-params "/user" {:page page})
       (fn [{:keys [response xhr]}]
         (handler (clj->js response)))))

;(.log js/console (.getStatus xhr))
;(.log js/console (.getLastErrorCode xhr))
(defn user-list [page handler]
  (rc/remote (user-list page) [{:keys [response xhr]}]
             (if (.isSuccess xhr)
               (handler (clj->js response)))))


;(.log js/console (.getStatus xhr))
(defn user-details [id handler]
  (rc/remote (user-details id) [{:keys [response xhr]}]
             (if (.isSuccess xhr)
               (handler (clj->js response)))))


(defn user-save [u handler]
  (let [user (js->clj u :keywordize-keys true)]
    (rc/remote (user-save (:id user) user) [{:keys [response xhr]}]
               (if (.isSuccess xhr)
                 (handler (clj->js response))))))


(defn user-delete [user handler]
  (rc/remote (user-delete user) [{:keys [response xhr]}]
             (if (.isSuccess xhr)
               (handler (clj->js response)))))


;(defn ^:export userList [page handler] (user-list page handler))
;(defn ^:export userDetails [page handler] (user-details page handler))
;(defn ^:export userSave [user handler] (user-save user handler))

;(js/alert "Hello")





(comment
  "Testing code"

  (user-list2 "1" (fn [t] (.log js/console t)))

  (defn update-user [v handler]
    (POST "/user/update" v handler))


  (defn get-user2 [page handler]
    (GET (uri-with-params "/user" {:page page})
         (fn [{:keys [response xhr]}]
           (handler (clj->js response)))))

  (defn get-user-details2 [userId handler]
    (GET (str "/user/" userId)
         (fn [{:keys [response xhr]}]
           (handler (clj->js response)))))

  (get-user-details2 "GQLSX" (fn [r] (println t)))

  (get-user2 1 (fn [t] (.log js/console t)))

  (js/alert "Hello")
  (getUserDetails "wjxjt" (fn [r]
                            (println r)))

  (getUserDetails "nkeoy" (fn [r]
                            (let [t (assoc r :id (:sname r))]
                              (updateUser r (fn [v] (println v)))
                              (println t))))

  (updateUser
   {:user "test", :lname "345", :sname "test", :password "$2a$10$s3xPgb/jIZ64aYtgiAOyVO8vNu0A46T7SiFX49DMSLCGtEb6cXQAS"}
   (fn [t] (println t)))


  (let [rc (chan 1)]
    (go
     (<! (async/timeout 2000))
     (>! rc "6"))
    (render-list "/user/snippet/" rc ) )

  (if-let [a 0]
    (println "nil"))

  (js/alert "Hello from repl"))
