(def common-deps '[[metis "0.3.3"] ;;Validation Lib
                   [slingshot "0.10.3"]  ;;For throw and catch
                   [c3p0/c3p0 "0.9.1.2"]   ;;Database lib
                   [org.clojure/java.jdbc "0.3.0-beta1"]
                   [postgresql "9.1-901.jdbc4"]
                   [com.datomic/datomic-free "0.8.4020.24"
                    :exclusions [org.slf4j/log4j-over-slf4j
                                 org.slf4j/slf4j-nop ]]
                   [ring "1.1.0"]   ;;Web Application Lib
                   [ring-server "0.2.8"]
                   [ring/ring-json "0.2.0"]
                   [ring-middleware-format "0.3.0"
                    :exclusions [ring] ]
                   [compojure "1.1.1"]
                   [com.cemerick/friend "0.1.3"
                    :exclusions [ring] ]
                   [lib-noir "0.6.4"]
                   [enlive "1.1.1"]
                   [incanter "1.5.2"] ;;Reporting Lib

                   [org.clojure/tools.logging "0.2.6"]
                   [log4j "1.2.15"
                    :exclusions [javax.mail/mail
                                 javax.jms/jms
                                 com.sun.jdmk/jmxtools
                                 com.sun.jmx/jmxri]]
                   [org.slf4j/slf4j-log4j12 "1.6.6"]

                   [mamun/cljs-net "0.1.0-SNAPSHOT"]])


(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write this!"
  :url "http://example.com/FIXME"
  :repositories { "sonatype-oss-public" "https://oss.sonatype.org/content/groups/public/" }
  :dependencies ~(cons '[org.clojure/clojure "1.5.1"]
                       common-deps)
  :profiles {:production {:ring {:open-browser? false, :stacktraces? false, :auto-reload? false}}
             :dev {:source-paths ["dev"]
                   :dependencies [[com.h2database/h2 "1.3.154"]

                                  [ring-mock "0.1.3"]  ;testing
                                  [ring/ring-devel "1.1.8"]

                                  [org.clojure/tools.namespace "0.2.3"]
                                  [org.clojure/java.classpath "0.2.0"]

                                  [org.clojure/tools.reader "0.7.10"]
                                  [org.clojure/clojurescript "0.0-1978"]
                                  [org.clojure/core.async "0.1.0-SNAPSHOT"]
                                  [jayq "2.3.0"]
                                  [prismatic/dommy "0.1.1"]
                                  [com.cemerick/clojurescript.test "0.0.4"]
                                  [com.cemerick/piggieback "0.1.0"]]
                   :plugins [[lein-ring "0.8.3"]
                             [lein-midje "3.0.0"]
                             [lein-cljsbuild "0.3.4"]
                             [codox "0.6.4"]]
                   :codox {:sources ["src"]
                           :output-dir "doc/api"}}}
  :source-paths ["src"]
  :test-paths ["test"]
  :ring {:handler {{name}}.system/handler
         :init {{name}}.system/init
         :destroy {{name}}.system/destroy }

  :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
  ;:hooks [leiningen.cljsbuild]
  :cljsbuild {:crossovers [crossover]
              :crossover-path "cljs/src-crossover"
              :builds {:dev {:source-paths  ["cljs/src" "cljs/src-dev"]
                             :incremental true
                           ; :libs ["resources/externs/jquery-1.8.js" "resources/externs/jquery-1.8.js/app.jsrn/app.js"]
                             :jar true
                             :compiler {:warnings true
                                        :pretty-print true
                                        :output-dir "resources/public/out"
                                        :output-to "resources/public/{{name}}.js"
                                        :source-map "resources/public/{{name}}.js.map"
                                        :optimizations :none }}}})
