(ns {{name}}.modules.home-handler
  (:use [noir.request]
        [compojure.core] )
  (:require
   [ring.util.response :as resp]))


(defn handler [app-context]
  (let [r (routes
           (GET "/"  [:as r]
                (resp/response [{:data "Get All"}]))
           (POST "/" [:as r]
                 (resp/response {:data "Create New"}))
           (context "/:id" [id]
                    (routes
                     (GET "/" []
                          (resp/response {:data "Get ID"}))
                     (DELETE "/" []
                             (resp/response {:data "Delete"}))
                     (PUT "/" []
                          (resp/response {:data "Update"})))))]
    [(context "/home" [] r)]))


(comment
  (println (apply str  (html/emit* (index-))))

  (println (apply str (html/emit* (index-snippet ))))

  (println (apply str  (html/emit* (menu-snippet [{:text "USER INFO" :href "#" :header true}
                                                  {:text "user" :href "user"}
                                                  {:text "upload" :href "upload"}
                                                  {:text "report" :href "report"}
                                                  {:text "APP INFO" :href "#" :header true}
                                                  {:text "home" :href "home"}
                                                  ]   ) ))))
