(ns {{name}}.modules.query-handler
   (:use
     [compojure.core])
   (:require
    [clojure.tools.logging :as log]
     [ring.util.response :as resp]
     [clojure.java.jdbc :as jdbc]
     [{{name}}.core.db-util :as db-util]))



(defn load-data [app-context q-name & [params]]
  (let [db (get-in app-context [:sqldb :db])
        conn (get-in app-context [:sqldb :conn])
        q-name (if (keyword? q-name)
               q-name
               (keyword q-name))
        q-str (db-util/get-query @db q-name)
        q (db-util/apply-params params q-str)]
    (if q
      (jdbc/query @conn [q] :as-arrays? true )
      {:error
       {:code 101
        :input params
        :des "Query not found"}})))



(defn handler [app-context]
  (let [r (routes
           (GET "/" [:as r]
                (resp/response
                 (if-let [name (:name (:params r))]
                   (load-data app-context name (:params r))
                   {:error
                    {:des "Provide name parameter"}}
                   ))))]
    [(context "/query" [] r)]))
