(ns {{name}}.modules.user
  (:use
   [metis.core ]
   [datomic.api :only [q db] :as d])
  (:require
   [clojure.tools.logging :as log]
   (cemerick.friend [credentials :as creds])))


(defvalidator user-validator
  [[:lname :sname] :presence {:message "This field is required."} ]
  [:lname :with {:validator (fn [attr] true) :message "error!"}]
  [[:lname :sname] :formatted {:pattern #"[A-Za-z]+" :message "wrong formatting!"}])


#_(defn from-view-model [{:keys [id sname lname]}]
  {:db/id id
   :user/password (creds/hash-bcrypt sname)
   :user/l-name lname
   :user/s-name sname })


(defn to-view-model [db-entity ]
  {:id (:user/s-name db-entity)
   :lname (:user/l-name db-entity)
   :sname (:user/s-name db-entity)
   :password (:user/password db-entity)})


(defn- find-entity-by-name [conn name]
  (let [rule '[[(active? ?u)
                [?u :user/status :user.status/active]]]
        q '[:find ?u
            :in $ ?name %
            :where
            [?u :user/s-name ?name]
            (active? ?u)]]
    (ffirst (d/q q (d/db conn) name rule))))


(defn- find-all-entity [conn]
  (let [rule '[[(active? ?u)
                [?u :user/status :user.status/active]]]
        q '[:find ?u
            :in $ %
            :where
            [?u :user/s-name]
            (active? ?u)]]
    (d/q q (d/db conn) rule)))


(defn find-by-name [conn name]
  (if-let [entity-id (find-entity-by-name conn name)]
    (-> (d/db conn)
        (d/entity entity-id)
        (d/touch)
        (to-view-model))))


(defn find-all [conn page size]
  (let [p (partition-all size (find-all-entity conn))
        v (nth p (- page 1) (last p) )]
    (->> v
         (map (fn [r]
                (-> (d/db conn)
                    (d/entity (first r))
                    (d/touch)
                    (to-view-model)))))))


(defn update [conn name params]
  (let [error-param (user-validator params)]
    (if (empty? error-param)
      (let [v [{:db/id (find-entity-by-name conn name)
                :user/l-name (:lname params)
                :user/s-name (:sname params)
                :user/status :user.status/active}]]
        @(d/transact conn v)
        nil)
      error-param )))


(defn create [conn params]
  (let [error-param (user-validator params)]
    (if (empty? error-param)
      (let [ tempid  (second  (second  (d/tempid :db.part/db )))
            v [{:db/id tempid
                :user/l-name (:lname params)
                :user/s-name (:sname params)
                :user/status :user.status/active}]]
        @(d/transact conn v)
        nil)
      error-param)))


(defn delete [conn name]
  (let [v [{:db/id (find-entity-by-name conn name)
            :user/status :user.status/delete}] ]
    @(d/transact conn v)
    nil))


(defn insert-all [conn data]
  (let [tempid (d/tempid :db.part/db )
        data (conj data {:db/id tempid
                         :user/s-name "admin"
                         :user/l-name "admin"
                         :user/password (creds/hash-bcrypt "admin")
                         :user/status :user.status/active}) ]
    @(d/transact conn data)
    (println "insert data")))

(comment
  (use 'dev)

  (create (:datomic-conn  the-system) {:lname "mamun" :sname "mamunabc"})
  (println (find-all (:datomic-conn  the-system) 1 5))
  (println (find-by-name (:datomic-conn  the-system) "mamunabc"))


  (if-let [entity-id (find-entity-by-name (:datomic-conn the-system) "mamunabc")]
    (println  (-> (d/db (:datomic-conn the-system))
                  (d/entity entity-id)
                  (d/touch))))

  )
