(ns {{name}}.user
    (:use
     [cljs.net.xhr :only [GET POST uri-with-params]]
     [cljs.net.remote.client :only [remotes]])
    (:require
     [cljs.core.async :as async :refer [chan close! put! ]])
    (:require-macros
     [cljs.core.async.macros :refer [go alt!]]
     [cljs.net.remote.client :as rc]))


(defn user-list [page handler]
  (rc/remote (user-list page) [{:keys [response xhr]}]
             (when (.isSuccess xhr)
                                        ;(.log js/console (.getStatus xhr))
                                        ;(.log js/console (.getLastErrorCode xhr))
               (handler (clj->js response)))))


(defn user-details [id handler]
  (rc/remote (user-details id) [{:keys [response xhr]}]
             (when (.isSuccess xhr)
                                        ;(.log js/console (.getStatus xhr))
               (handler (clj->js response)))))


(defn user-save [u handler]
  (let [user (js->clj u :keywordize-keys true)]
    (rc/remote (user-save (:id user) user) [{:keys [response xhr]}]
               (when (.isSuccess xhr)
                 (handler (clj->js response))))))


(defn user-delete [user handler]
  (rc/remote (user-delete user) [{:keys [response xhr]}]
             (when (.isSuccess xhr)
               (handler (clj->js response)))))


(defn user-list2 [page handler]
  (GET (uri-with-params "/user" {:page page})
       (fn [{:keys [response xhr]}]
         (handler (clj->js response)))))


(defn user-details2 [userId handler]
  (GET (str "/user/" userId)
       (fn [{:keys [response xhr]}]
         (handler (clj->js response)))))


(defn update-user [v handler]
  (POST "/user/update" v handler))


(comment
  "Testing code"

  (js/alert "Hello")

  (user-list2 "1" (fn [t] (.log js/console t)))

  (user-details2 "GQLSX" (fn [r] (println t)))

  (update-user
   {:user "test", :lname "345", :sname "test", :password "$2a$10$s3xPgb/jIZ64aYtgiAOyVO8vNu0A46T7SiFX49DMSLCGtEb6cXQAS"}
   (fn [t] (println t)))



  (js/alert "Hello from repl"))
