(defproject {{name}}/cljs "0.1.0-SNAPSHOT"
  :description "FIXME: write this!"
  :url "http://example.com/FIXME"
  :repositories { "sonatype-oss-public" "https://oss.sonatype.org/content/groups/public/" }
  :javac-options      ["-target" "1.6" "-source" "1.6"]
  :jvm-opts ^:replace ["-Dfile.encoding=utf-8" "-Xmx1g" "-server" "-XX:MaxPermSize=512M" ]
  :dependencies [[org.clojure/clojure "1.5.1"]
                 [mamun/cljs-net "0.1.0-SNAPSHOT"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[org.clojure/tools.reader "0.7.10"]
                                  [org.clojure/clojurescript "0.0-2080"]
                                  [org.clojure/core.async "0.1.0-SNAPSHOT"]
                                  [jayq "2.3.0"]
                                  [prismatic/dommy "0.1.1"]
                                  [com.cemerick/clojurescript.test "0.0.4"]
                                  [com.cemerick/piggieback "0.1.2"]]
                   :plugins [[lein-cljsbuild "1.0.0"]
                             [codox "0.6.4"]]
                   :codox {:sources ["src"]
                           :output-dir "doc/api"}}}
  :source-paths ["src"]
  :test-paths ["test"]
  :repl-options {:port 51860
                 :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
  :hooks [leiningen.cljsbuild]
  :cljsbuild {;:crossovers [crossover]
                                        ; :crossover-path "src-crossover"
              :builds {:dev {:source-paths  ["src" "src-dev"]
                             :incremental true
                                        ; :libs ["resources/externs/jquery-1.8.js" "resources/externs/jquery-1.8.js/app.jsrn/app.js"]
                             :jar true
                             :compiler {:warnings true
                                        :pretty-print true
                                        :output-dir "resources/public/out"
                                        :output-to "resources/public/{{name}}.js"
                                        :source-map "resources/public/{{name}}.js.map"
                                        :optimizations :none }}
                       :prod {:source-paths ["src" ]
                              :compiler {:warnings true
                                         :pretty-print false
                                         :output-to "../resources/public/{{name}}.min.js"
                                         :optimizations :advanced}} }})
