(ns user
  (:use
   [ring.server.standalone]
   [clojure.pprint :only [print-table]]
   [{{name}}.core.lifeCycle])
  (:require
   [clojure.java.io :as io]
   [clojure.string :as str]
   [clojure.pprint :refer (pprint)]
   [clojure.repl :refer :all]
   [clojure.test :as test]
   [clojure.tools.namespace.repl :refer (refresh refresh-all)]
   [dev :as dev]
   [{{name}}.system :as sys]))


(defonce the-system nil)

(defn- update-system [state & [c]]
  (condp = state
    :init
    (alter-var-root #'the-system (constantly c))
    :start
    (alter-var-root #'the-system (fn [s]
                                   (when s
                                     (if c
                                       (assoc s c (start (c s) s))
                                       (start s nil)))))
    :stop
    (alter-var-root #'the-system (fn [s]
                                   (when s
                                     (if c
                                       (assoc s c (stop (c s)))
                                       (stop s)))))))

(defn- find-by-comp [c s-c]
  (loop [m? false c c r []]
    (if (empty? c)
      r
      (let [m? (or (= s-c (first c)) m? )
            r (if m?
                (conj r (first c))
                r)]
        (recur m? (rest c) r)))))


(defn app
  ([] (app :help))
  ([state & [opt]]
     (println (str "Running, please wait.." state) )
     (condp = state
       :init
       (let [server (dev/->Server 8083)
             s (-> (sys/system :dev)
                   (assoc :server server)) ]
         (update-system :init s))

       :start
       (if opt
         (update-system :start opt)
         (do
           (update-system :start)
           (update-system :start :server)))

       :go
       (if the-system
         (println "System already running")
         (do
           (app :init)
           (app :start)))

       :stop
       (if opt
         (update-system :stop opt)
         (do
           (update-system :stop)
           (update-system :stop :server)))

       :restart
       (let [r-c (find-by-comp sys/component-order opt)]
         (println (str "Restart component: " (pr-str r-c)))
         (doseq [c r-c] (update-system :stop c))
         (doseq [c r-c] (update-system :start c))
         (update-system :start :server))

       :reset
       (do
         (app :stop)
         (refresh :after 'user/app))

       :cljs
       ; comp 9000
       (start (dev/->Cljs opt) nil)

       :help
       (pprint {:init "Init component"
                :start "Start all component, "
                :go "Init with start"
                :stop "Stop all component"
                :restart "Restart component"})
       (println "Command not found"))

     state))


(defn command-handler [command]
  (println (str "Processing command"  command))
  (condp = command
    :F9
    (do
      (when (nil? the-system)
        (app :init))
      (if (nil? (get the-system :server))
        (app :start)
        (app :restart :web)))
    :C-F9 (app :stop)
    :C-F11 (app :start :cljs)
    :event  "dev"
    (println "command not found")))


(print "type (app) in repl for help")
(app)