(ns {{name}}.modules.query-handler
    (:use
     [compojure.core])
    (:require
     [clojure.tools.logging :as log]
     [ring.util.response :as resp]
     [clojure.java.jdbc :as jdbc]
     [cemerick.friend :as friend]
     [{{name}}.core.db-util :as db-util]))


(defmulti execute-query (fn [v] (keyword (:name v)) ))


(defmethod execute-query :distributors-by-id [{:keys [app-context name params]}]
  (let [db (get-in app-context [:sqldb :db])
        conn (get-in app-context [:sqldb :conn])
        [q error] (db-util/get-sql-with-params @db name params)]
    (if q
      (jdbc/query @conn [q] :as-arrays? true )
      error )))


(defmethod execute-query :default [{:keys [app-context name params]}]
  (if (nil? name)
    {:error {:des "Provide name parameter"}}
    (let [db (get-in app-context [:sqldb :db])
          conn (get-in app-context [:sqldb :conn])
          [q error] (db-util/get-sql-with-params @db name params)]
      (if q
        (jdbc/query @conn [q] :as-arrays? true )
        error ))))


(defn handler [app-context]
  (let [r (routes
           (GET "/" [:as r]
               (resp/response
                 (try
                   (execute-query {:name (:name (:params r))
                                   :params (:params r)
                                   :app-context app-context})
                   (catch Exception e
                     (do
                       (log/info (format "sqlstatement %s params %s" (pr-str (:params r))))
                       (log/error e)
                       "Query operation fail, please check log "))))
                ))]
    [(context "/query" [] r)]))

