'use strict';


angular.module('myApp.service',['ngResource']).config(function($httpProvider){
    $httpProvider.defaults.transformRequest = function (data) {
        var str = [];
        for (var p in data) {
            data[p] !== undefined && str.push(encodeURIComponent(p) + '=' + encodeURIComponent(data[p]));
        }
        return str.join('&');
    };
    $httpProvider.defaults.headers.put['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';
    $httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';

}).factory('Home', function ($resource){
    return $resource('/home/:id',
                     { id: '@id' },
                     { list: { method: 'GET' ,
                               params: {page: "@page"},
                               isArray: true },
                       create: { method: 'POST' },
                       update: { method: 'PUT' }
                     });
}).factory('User', function($http){
    return {
        save: function(data){
          return $http.post("/user", data);
        },
        update: function(id, data){
            var url = "/user/"+id;
            return $http.post(url,data);
        },
        list: function(page, size){
            var params = {params: {name: "users",
                                   page: page,
                                   size: size}};
            return $http.get('/query', params);
        },
        details: function(id){
            var params = {params: {name: "user-by-id",
                                   id: id}};
            return $http.get('/query', params);
        }
    };
});


angular.module('myapp.timeline', ["ui.router", "ui.bootstrap", "myApp.service"]).
    config(function( $stateProvider, $urlRouterProvider){

        var TimeLine = {
            name: 'timeline',
            url: "/timeline",
            //            templateUrl: 'partials/timeline.html'
            templateUrl: 'history.htm',
            controller: ['$http','$scope', function ($http, $scope) {
                $scope.data = "Data is loading...";
            }]
        };
        $stateProvider.state(TimeLine);
    });


angular.module('myapp.home', ["ui.router", "ui.bootstrap", "myApp.service"]).
    config(function($stateProvider, $urlRouterProvider){
        $urlRouterProvider.when('/home', '/home/user');

        var Home = {
            name: 'home',
            url: '/home',
            templateUrl: 'app/home/home.html',
            controller: ['$scope', function ($scope) {
                $scope.name = "World";
                //                                         $state.go(".user.list");
            }]};

        var User = {
            parent: Home,
            name: 'home.user',
            abstract: true,
            url: '/user',
            template: '<ui-view/>'
        };

        var UserList = {
            parent: User,
            name: 'home.user.list',
            url: '?page',
            templateUrl: 'app/home/user.list.html',
            controller: ['User','$location','$state', '$stateParams','$scope',
                         function(User, $location,$state,$stateParams, $scope){

                             $scope.totalItems = 164;
                             $scope.currentPage = (undefined != $location.search().page)?$location.search().page:1;
                             $scope.maxSize = 7;

                             $scope.pageChanged = function (pageNo) {
                                 $state.go(".^.list",{page: pageNo});
                             };

                             User.list($scope.currentPage,$scope.maxSize)
                                 .success(function(data, status, headers, config){
                                     $scope.headers = _.first(data);
                                     $scope.rows = _.rest(data);
                                 }).error(function(data, status, headers, config){
                                     alert("Data load error");
                                 });
                         }]
        };

        var UserCreate = {
            parent: User,
            name: 'home.user.create',
            templateUrl: 'app/home/user.edit.html',
            url: "/new",
            controller: ['$state','$scope', 'User',
                         function($state, $scope, User){
                             console.log("User create controller");

                             $scope.submit = function() {
                                 User.save($scope.user)
                                 .success(function(data, status, headers, config){
                                     $state.go(".^.list");
                                 }).error(function(data,status, headers, config){
                                     alert("Error in saving");
                                 });
                             };
                         }]
        };

        var UserDetails = {
            parent: User,
            name: 'home.user.details',
            url: "/:id",
            templateUrl: 'app/home/user.details.html',
            controller: ['$stateParams', '$scope','User',
                         function($stateParams, $scope, User){
                             User.details($stateParams.id)
                                 .success(function(data, status, headers, config){
                                     $scope.user =_.first(data);
                                 }).error(function(data, status, headers, config){
                                     alert("Data load error");
                                 });
                         }]
        };

        var UserEdit = {
            parent: User,
            name: 'home.user.edit',
            url: "/edit/:id",
            templateUrl: 'app/home/user.edit.html',
            controller: ['$state','$stateParams','$scope','User',
                         function($state,$stateParams, $scope, User){
                             User.details($stateParams.id)
                                 .success(function(data, status, headers, config){
                                     $scope.user =_.first(data);
                                 }).error(function(data, status, headers, config){
                                     alert("Data load error");
                                 });

                             $scope.submit = function() {

                                 var data = {id: $scope.user.id,
                                             lname:$scope.user.lname,
                                             fname:$scope.user.fname };

                                 User.update($scope.user.id, data)
                                     .success(function(data, status, headers, config){
                                         $state.go(".^.list");
                                     });
                             };
                         }]
        };

        var Upload = {
                    parent: Home,
                    name: 'home.upload',
                    url: '/upload',
                    templateUrl: 'app/home/upload.html',
                    controller: [ '$scope', '$upload', function($scope, $upload) {

                      $scope.myModelObj = {text: "data"};
                      $scope.onFileSelect = function($files) {

                       //$files: an array of files selected, each file has name, size, and type.
                        for (var i = 0; i < $files.length; i++) {
                          var file = $files[i];
                          $scope.file = file;

                          $scope.upload = $upload.upload({
                            url: 'upload/file',
                            data: {myObj: $scope.myModelObj},
                            file: file
                          }).progress(function(evt) {
                            console.log('percent: ' + parseInt(100.0 * evt.loaded / evt.total));
                          }).success(function(data, status, headers, config) {
                            // file is uploaded successfully
                              console.log(data);
                          });
                        }
                      };
                    }]
                };


        var Report = {
            parent: Home,
            name: 'home.report',
            url: '/report',
            templateUrl: 'app/home/report.html'
        };

        $stateProvider
            .state(Home)
            .state(User)
            .state(UserList)
            .state(UserCreate)
            .state(UserEdit)
            .state(UserDetails)
            .state(Upload)
            .state(Report);

    });


var myapp = angular.module('myapp', ["ui.router",
                                     "ui.bootstrap",
                                     "angularFileUpload",
                                     "myapp.timeline",
                                     "myapp.home"]);
myapp.config(function( $stateProvider, $urlRouterProvider){
    // For any unmatched url, send to /route1
    $urlRouterProvider.otherwise("/home");
}).run(function($rootScope, $state, $stateParams) {
    $rootScope.$state = $state;
    $rootScope.$stateParams = $stateParams;
});
