(def common-deps '[[metis "0.3.3"] ;;Validation Lib
                   [slingshot "0.10.3"]  ;;For throw and catch
                   [c3p0/c3p0 "0.9.1.2"]   ;;Database lib
                   [org.clojure/java.jdbc "0.3.0-beta1"]
                   [postgresql "9.1-901.jdbc4"]
                   [com.datomic/datomic-free "0.8.4020.24"
                    :exclusions [org.slf4j/log4j-over-slf4j
                                 org.slf4j/slf4j-nop ]]
                   [ring "1.1.0"]   ;;Web Application Lib
                   [ring-server "0.2.8"]
                   [ring/ring-json "0.2.0"]
                   [ring-middleware-format "0.3.0"
                    :exclusions [ring] ]
                   [compojure "1.1.1"]
                   [com.cemerick/friend "0.1.3"
                    :exclusions [ring] ]
                   [lib-noir "0.6.4"]
                   [enlive "1.1.1"]
                   [incanter "1.5.2"] ;;Reporting Lib

                   [org.clojure/tools.logging "0.2.6"]
                   [ch.qos.logback/logback-classic "1.0.9"]

                   [mamun/cljs-net "0.1.0-SNAPSHOT"]])


(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write this!"
  :url "http://example.com/FIXME"
  :repositories { "sonatype-oss-public" "https://oss.sonatype.org/content/groups/public/" }
;  :javac-options      ["-target" "1.6" "-source" "1.6"]
;  :jvm-opts ^:replace ["-Dfile.encoding=utf-8" "-Xmx1g" "-server" "-XX:MaxPermSize=512M" ]
  :dependencies ~(cons '[org.clojure/clojure "1.5.1"]
                       common-deps)
  :plugins [[lein-pprint "1.1.1"]
            [lein-ring "0.8.3"]]

  :ring {:handler {{name}}.system/handler
         :init {{name}}.system/init
         :destroy {{name}}.system/destroy }

  :resource-paths ["resources" "client/resources"]

  :profiles {:dev {:source-paths ["dev-tools"]
                   :dependencies [[com.h2database/h2 "1.3.154"]

                                  [ring-mock "0.1.3"]  ;testing
                                  [ring/ring-devel "1.1.8"]

                                  [org.clojure/tools.namespace "0.2.3"]
                                  [org.clojure/java.classpath "0.2.0"]

                                  [org.clojure/tools.reader "0.7.10"]
                                  [org.clojure/clojurescript "0.0-2080"]
                                  [org.clojure/core.async "0.1.0-SNAPSHOT"]
                                  [com.cemerick/piggieback "0.1.2"]]
                   :plugins [[lein-midje "3.0.0"]
                             [lein-sub "0.3.0"]
                             [lein-resource "0.3.1"]
                             [codox "0.6.4"]]
                   :sub ["client" ]
                   :hooks [leiningen.resource]
                   :resource {:resource-paths ["resources/config/dev"]
                              :target-path "resources"
                              :excludes [#".*~"]}
                   :repl-options {:port 4555
                                  :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
                   :codox {:sources ["src"]
                           :output-dir "doc/api"}}
             :prod {:ring {:open-browser? false
                           :stacktraces? false
                           :auto-reload? false}
                    :resource {:resource-paths ["resources/config/prod"]
                               :target-path "resources"
                               :excludes [#".*~"]}}})
