(ns {{name}}.modules.remote-handler
    (:use
      [compojure.core]
      [cljs.net.remote.service])
    (:require
      [ring.util.response :as resp]
      [{{name}}.modules.user.auth-handler :as u]))


(defremote user-defaults [[] & [opt]]
  {:sname "" :lname "" :id  "" })


(defremote user-delete [[user] & [{:keys [context request]}]]
  (u/delete! context user))


(defremote user-list [[page] & [{:keys [context request]}]]
  (u/find-all context page))


(defremote user-details [[name] & [{:keys [context request]}]]
  (u/details context name))


(defremote user-save [[user params] & [{:keys [context request]}]]
  (u/update! context user params) )



(defn remote-routes
  "Routes for cljs remote

  @param {map} app-context \"App context map generated by system init\"
  @return {compojure.core.routes}"
  [app-context]
  (routes
    (REMOTE POST "/_fetch" [:as request]
            (fn [f] (f request {:request request
                                :context app-context})))))
