(ns {{name}}.modules.upload.upload-handler
    (:require
      [compojure.core :refer :all]
      [ring.util.response :as resp]
      (ring.middleware [multipart-params :as mp])
      [clojure.java.io :as io]
      [clojure.tools.logging :as log]
      [net.cgrand.enlive-html :as html]))


(defn upload-file
  "Upload handler "
  [file]
  (let [file-name (:filename file)
        size (:size file)]
                                        ; (io/copy (:tempfile file)  (format "/tmp/%s" file-name))
    (apply str (html/html [:h1 file-name]
                       [:h1 size]))))


(defn upload-routes
  "Routes for upload_handler

  @param {map} app-context \"App context map generated by system init\"
  @return {compojure.core.routes}"
  [app-context]
  (routes
    (mp/wrap-multipart-params
      (POST "/file" {params :params}
            (let [file (:file params )]
              (log/info params)
              (upload-file file))))))
