(ns webapp.framework.client.core
  (:require
    [goog.net.XhrIo          :as xhr]
    [clojure.browser.repl    :as repl]
    [cljs.reader             :as reader]
    [goog.net.XhrIo]
    [goog.dom]
    [goog.events]
    [webapp.framework.client.help]
    [crate.core :as crate]
    [dommy.core :as dommy]
  )
  (:use
    [domina.events :only [listen!]]
    [jayq.core :only [$ css inner toggle append]]
    [domina :only [append! by-id value destroy! ]]
    [domina.xpath :only [xpath]]
    [domina.css :only [sel]]
    [clojure.browser.event :only [listen]]
  )

  (:use-macros
    [dommy.macros :only [sel sel1]]
  )
)




(defn help []
  (webapp.framework.client.help/help)
)


(defn get-time [] (. (new js/Date)  (getTime)))




(defn make-js-map
  "makes a javascript map from a clojure one"
  [cljmap]
  (let [out (js-obj)]
    (doall
     (map
      #(aset out (name (first %)) (second %)) cljmap))
    out))







(defn clj-to-js
  "Recursively transforms ClojureScript maps into
  Javascript objects, other ClojureScript colls
  into JavaScript arrays, and ClojureScript keywords
  into JavaScript strings."
  [x]

  (clj->js x))





(defn encode-parameter [name value]
          (.
            (goog.Uri.QueryData/createFromMap
              (goog.structs.Map.
                (make-js-map
                  { name value}
                )
              )
            )
            (toString)
           ))







(defn send-request [ address  fn-callback ]
      (let
      [
        headers       (goog.structs.Map.)
        io-object     (goog.net.XhrIo.)
        cb            (fn [ event ]
                          (let
                            [
                              target          (.-target event)
                              status          (. target (getStatus))
                            ]
                                (if (= status 200)
                                  (let
                                    [
                                      response-text   (. target (getResponseText))
                                    ]
                                      (fn-callback  response-text)
                                   )
                                   (js/alert address)
                                )
                              )
                            )
      ]
          (do
            (goog.events.listen    io-object    goog.net.EventType.COMPLETE cb)
            (. headers set "charset" "UTF-8")
            (. io-object send address "POST" nil headers)
          )))




(defn remote
[
  action
  parameters-in
  fn-process-reply2
  ]
  (let
  [
    parameters  (if parameters-in
                  {:params parameters-in :tclock (get-time)})
    ]
    (send-request
       (str "action?action=" action "&"
         (apply
           str
           (map
             (fn [x]
               (str
                 (encode-parameter
                   x
                   (get parameters x)) "&" ) )
                 (keys parameters))))

                 (fn [ response ]
                     (let
                     [
                         data      (reader/read-string response)
                     ]
                        (fn-process-reply2 data) )))))




(defn onclick [& {:keys [
                         element
                         fn-to-call
                         ]}]
    (listen! (by-id element) :click  fn-to-call)
)


(defn add-to [el-sel struct-html]
(-> ($ el-sel) (append
    (crate/html
     struct-html)))
  )

