package webnf;

import clojure.lang.Keyword;
import clojure.lang.Symbol;
import clojure.lang.Var;

import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;

/**
 * Created by herwig on 8/21/15.
 */
public class UpgradeHandler implements HttpUpgradeHandler {

    public static final Var
      CHAN = Var.intern(
            Symbol.intern("clojure.core.async"),
            Symbol.intern("chan")),
      INITIALIZE = Var.intern(
              Symbol.intern("webnf.async-servlet.websocket"),
              Symbol.intern("initialize!")),
      DESTROY = Var.intern(
              Symbol.intern("webnf.async-servlet.websocket"),
              Symbol.intern("destroy!")),
      VOLATILE = Var.intern(
              Symbol.intern("clojure.core"),
              Symbol.intern("volatile!")),
      SET = Var.intern(
              Symbol.intern("clojure.core"),
              Symbol.intern("hash-set"));
    public final Object readChannel, writeChannel, openVolatile;

    public UpgradeHandler() {
        this.readChannel = CHAN.invoke();
        this.writeChannel = CHAN.invoke();
        this.openVolatile = VOLATILE.invoke(SET.invoke(Keyword.intern("read"), Keyword.intern("write")));
    }


    public void init(WebConnection conn) {
        INITIALIZE.invoke(this, conn);
    }

    public void destroy() {
        DESTROY.invoke(this);
    }
}
