(ns webnf.base.bind
  (:require [clojure.spec.alpha :as s]))


;; Macro


#_(defmacro bind [& bindings]
    {:pre (= 1 (mod (count bindings) 2))}
    (let [steps (butlast bindings)
          ret (last bindings)]
      `(comp ~@(map binding-fn-form
                    (take-nth 2 steps)
                    (take-nth 2 (next steps)))
             ~ret)))

(defn ch [xf]
  (fn
    ([s] (xf s))
    ([s [c & nxt]]
     (if c
       ((xf s nxt) c)
       (xf s)))))

(comment

  (((comp ch ch)
    (fn
      ([s]        (println "Closing" s) s)
      ([s ps]
       (fn [result]
         (println "Result" result ps s)
         (conj s result)))))
   [] (seq "abc"))

  )

#_(defn <> [p1 p2]
  (fn [xf]
    (let [pxf (p1 (p2 xf))]
      (fn
        ([s] (pxf s))
        ([s ps] (pxf s ps))))))

#_(defn alt [& parsers]
    (fn [xf]
    
      (fn
        ([s] (xf s))
        ())))
