(ns webnf.cljs.enlive.data)

(def any (constantly true))

(def ^:dynamic child-nodes)
(def ^:dynamic tag=)
(def ^:dynamic attr=)
(def ^:dynamic id=)
(def ^:dynamic attr-values)

(defn attr-has
  "Selector predicate, tests if the specified whitespace-seperated attribute contains the specified values. See CSS ~="
  [attr & values]
  #(when-let [v (attr-values % attr)]
     (every? v values)))

(defn has-class
  "Selector predicate, :.foo.bar is as short-hand for (has-class \"foo\" \"bar\")."
  [& classes]
  (apply attr-has :class classes))

(def ^:dynamic as-nodes)
