# cljs-uuid-utils

ClojureScript micro-library with an implementation of a type 4, random UUID generator compatible with RFC-4122 and cljs.core/UUID (v4), a getter function to obtain the uuid string representation from a UUID-instance (to-str), a uuid-string conformance validating predicate (uuid?), and a UUID factory from uuid-string with conformance validation (to-uuid).

## Installation

Add the following to your `project.clj` dependencies:

```clojure
[whodidthis/cljs-uuid "0.1.0"]
```

## Usage

Require cljs-uuid library:

```clojure
(ns myapp
  (:require [cljs-uuid.core :as uuid]))
```

REPL examples:

```clojure

ClojureScript:cljs.user> (def r (uuid/v4))
#uuid "ec9b1b11-74b0-48a4-989c-7e939fd37dec"
ClojureScript:cljs.user> (type r)
cljs.core/UUID

ClojureScript:cljs.user> (uuid/to-str r)
"ec9b1b11-74b0-48a4-989c-7e939fd37dec"

ClojureScript:cljs.user> (uuid/uuid? "NO-WAY")
nil
ClojureScript:cljs.user> (uuid/uuid? "ec9b1b11-74b0-48a4-989c-7e939fd37dec")
"ec9b1b11-74b0-48a4-989c-7e939fd37dec"
ClojureScript:cljs.user> (uuid/uuid? r)
"ec9b1b11-74b0-48a4-989c-7e939fd37dec"

ClojureScript:cljs.user> (uuid/to-uuid "ec9b1b11-74b0-48a4-989c-7e939fd37dec")
#uuid "ec9b1b11-74b0-48a4-989c-7e939fd37dec"
ClojureScript:cljs.user> (uuid/to-uuid "NO-WAY")
nil
ClojureScript:cljs.user> (uuid/to-uuid r)
#uuid "ec9b1b11-74b0-48a4-989c-7e939fd37dec"
ClojureScript:cljs.user> (uuid/to-uuid (UUID. "NO-WAY"))
nil
ClojureScript:cljs.user> (uuid/to-uuid (UUID. "ec9b1b11-74b0-48a4-989c-7e939fd37dec"))
#uuid "ec9b1b11-74b0-48a4-989c-7e939fd37dec"
```


## License

Copyright (C) 2012 Frank Siebenlist

Distributed under the Eclipse Public License, the same as Clojure.
