// Compiled by ClojureScript 0.0-2227
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t16568 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t16568 = (function (f,fn_handler,meta16569){
this.f = f;
this.fn_handler = fn_handler;
this.meta16569 = meta16569;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t16568.cljs$lang$type = true;
cljs.core.async.t16568.cljs$lang$ctorStr = "cljs.core.async/t16568";
cljs.core.async.t16568.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t16568");
});
cljs.core.async.t16568.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t16568.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t16568.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t16568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16570){var self__ = this;
var _16570__$1 = this;return self__.meta16569;
});
cljs.core.async.t16568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16570,meta16569__$1){var self__ = this;
var _16570__$1 = this;return (new cljs.core.async.t16568(self__.f,self__.fn_handler,meta16569__$1));
});
cljs.core.async.__GT_t16568 = (function __GT_t16568(f__$1,fn_handler__$1,meta16569){return (new cljs.core.async.t16568(f__$1,fn_handler__$1,meta16569));
});
}
return (new cljs.core.async.t16568(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__16572 = buff;if(G__16572)
{var bit__8579__auto__ = null;if(cljs.core.truth_((function (){var or__7929__auto__ = bit__8579__auto__;if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return G__16572.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__16572.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__16572);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__16572);
}
});
/**
* Creates a channel with an optional buffer. If buf-or-n is a number,
* will create and use a fixed buffer of that size.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,0))?null:buf_or_n);return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1));
});
chan = function(buf_or_n){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){if(null)
{return null;
} else
{throw (new Error(("Assert failed: <! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_16573 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_16573);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (val_16573,ret){
return (function (){return fn1.call(null,val_16573);
});})(val_16573,ret))
);
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){if(null)
{return null;
} else
{throw (new Error(("Assert failed: >! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);if(cljs.core.truth_(temp__4124__auto__))
{var ret = temp__4124__auto__;return cljs.core.deref.call(null,ret);
} else
{return true;
}
});
var put_BANG___3 = (function (port,val,fn1){return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(temp__4124__auto__))
{var retb = temp__4124__auto__;var ret = cljs.core.deref.call(null,retb);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,ret);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}
return ret;
} else
{return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__8785__auto___16574 = n;var x_16575 = 0;while(true){
if((x_16575 < n__8785__auto___16574))
{(a[x_16575] = 0);
{
var G__16576 = (x_16575 + 1);
x_16575 = G__16576;
continue;
}
} else
{}
break;
}
var i = 1;while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__16577 = (i + 1);
i = G__16577;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t16581 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t16581 = (function (flag,alt_flag,meta16582){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta16582 = meta16582;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t16581.cljs$lang$type = true;
cljs.core.async.t16581.cljs$lang$ctorStr = "cljs.core.async/t16581";
cljs.core.async.t16581.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t16581");
});})(flag))
;
cljs.core.async.t16581.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t16581.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});})(flag))
;
cljs.core.async.t16581.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});})(flag))
;
cljs.core.async.t16581.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_16583){var self__ = this;
var _16583__$1 = this;return self__.meta16582;
});})(flag))
;
cljs.core.async.t16581.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_16583,meta16582__$1){var self__ = this;
var _16583__$1 = this;return (new cljs.core.async.t16581(self__.flag,self__.alt_flag,meta16582__$1));
});})(flag))
;
cljs.core.async.__GT_t16581 = ((function (flag){
return (function __GT_t16581(flag__$1,alt_flag__$1,meta16582){return (new cljs.core.async.t16581(flag__$1,alt_flag__$1,meta16582));
});})(flag))
;
}
return (new cljs.core.async.t16581(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t16587 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t16587 = (function (cb,flag,alt_handler,meta16588){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta16588 = meta16588;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t16587.cljs$lang$type = true;
cljs.core.async.t16587.cljs$lang$ctorStr = "cljs.core.async/t16587";
cljs.core.async.t16587.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t16587");
});
cljs.core.async.t16587.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t16587.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t16587.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t16587.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16589){var self__ = this;
var _16589__$1 = this;return self__.meta16588;
});
cljs.core.async.t16587.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16589,meta16588__$1){var self__ = this;
var _16589__$1 = this;return (new cljs.core.async.t16587(self__.cb,self__.flag,self__.alt_handler,meta16588__$1));
});
cljs.core.async.__GT_t16587 = (function __GT_t16587(cb__$1,flag__$1,alt_handler__$1,meta16588){return (new cljs.core.async.t16587(cb__$1,flag__$1,alt_handler__$1,meta16588));
});
}
return (new cljs.core.async.t16587(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",4143410454).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = 0;while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,0):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,1);return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16590_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16590_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16591_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16591_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__7929__auto__ = wport;if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__16592 = (i + 1);
i = G__16592;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__7929__auto__ = ret;if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",2558708147)))
{var temp__4126__auto__ = (function (){var and__7917__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__7917__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__7917__auto__;
}
})();if(cljs.core.truth_(temp__4126__auto__))
{var got = temp__4126__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",2558708147).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",2558708147)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__16593){var map__16595 = p__16593;var map__16595__$1 = ((cljs.core.seq_QMARK_.call(null,map__16595))?cljs.core.apply.call(null,cljs.core.hash_map,map__16595):map__16595);var opts = map__16595__$1;if(null)
{return null;
} else
{throw (new Error(("Assert failed: alts! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
};
var alts_BANG_ = function (ports,var_args){
var p__16593 = null;if (arguments.length > 1) {
  p__16593 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__16593);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__16596){
var ports = cljs.core.first(arglist__16596);
var p__16593 = cljs.core.rest(arglist__16596);
return alts_BANG___delegate(ports,p__16593);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes a function and a source channel, and returns a channel which
* contains the values produced by applying f to each value taken from
* the source channel
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t16604 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t16604 = (function (ch,f,map_LT_,meta16605){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta16605 = meta16605;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t16604.cljs$lang$type = true;
cljs.core.async.t16604.cljs$lang$ctorStr = "cljs.core.async/t16604";
cljs.core.async.t16604.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t16604");
});
cljs.core.async.t16604.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t16604.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});
cljs.core.async.t16604.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t16604.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t16607 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t16607 = (function (fn1,_,meta16605,ch,f,map_LT_,meta16608){
this.fn1 = fn1;
this._ = _;
this.meta16605 = meta16605;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta16608 = meta16608;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t16607.cljs$lang$type = true;
cljs.core.async.t16607.cljs$lang$ctorStr = "cljs.core.async/t16607";
cljs.core.async.t16607.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t16607");
});})(___$1))
;
cljs.core.async.t16607.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t16607.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t16607.prototype.cljs$core$async$impl$protocols$Handler$lock_id$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.lock_id.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t16607.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4,___$1){
return (function (p1__16597_SHARP_){return f1.call(null,(((p1__16597_SHARP_ == null))?null:self__.f.call(null,p1__16597_SHARP_)));
});
;})(f1,___$4,___$1))
});})(___$1))
;
cljs.core.async.t16607.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16609){var self__ = this;
var _16609__$1 = this;return self__.meta16608;
});})(___$1))
;
cljs.core.async.t16607.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16609,meta16608__$1){var self__ = this;
var _16609__$1 = this;return (new cljs.core.async.t16607(self__.fn1,self__._,self__.meta16605,self__.ch,self__.f,self__.map_LT_,meta16608__$1));
});})(___$1))
;
cljs.core.async.__GT_t16607 = ((function (___$1){
return (function __GT_t16607(fn1__$1,___$2,meta16605__$1,ch__$2,f__$2,map_LT___$2,meta16608){return (new cljs.core.async.t16607(fn1__$1,___$2,meta16605__$1,ch__$2,f__$2,map_LT___$2,meta16608));
});})(___$1))
;
}
return (new cljs.core.async.t16607(fn1,___$1,self__.meta16605,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__7917__auto__ = ret;if(cljs.core.truth_(and__7917__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__7917__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t16604.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t16604.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t16604.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t16604.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16606){var self__ = this;
var _16606__$1 = this;return self__.meta16605;
});
cljs.core.async.t16604.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16606,meta16605__$1){var self__ = this;
var _16606__$1 = this;return (new cljs.core.async.t16604(self__.ch,self__.f,self__.map_LT_,meta16605__$1));
});
cljs.core.async.__GT_t16604 = (function __GT_t16604(ch__$1,f__$1,map_LT___$1,meta16605){return (new cljs.core.async.t16604(ch__$1,f__$1,map_LT___$1,meta16605));
});
}
return (new cljs.core.async.t16604(ch,f,map_LT_,null));
});
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value before supplying it to the target channel.
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t16613 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t16613 = (function (ch,f,map_GT_,meta16614){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta16614 = meta16614;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t16613.cljs$lang$type = true;
cljs.core.async.t16613.cljs$lang$ctorStr = "cljs.core.async/t16613";
cljs.core.async.t16613.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t16613");
});
cljs.core.async.t16613.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t16613.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});
cljs.core.async.t16613.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t16613.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t16613.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t16613.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t16613.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16615){var self__ = this;
var _16615__$1 = this;return self__.meta16614;
});
cljs.core.async.t16613.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16615,meta16614__$1){var self__ = this;
var _16615__$1 = this;return (new cljs.core.async.t16613(self__.ch,self__.f,self__.map_GT_,meta16614__$1));
});
cljs.core.async.__GT_t16613 = (function __GT_t16613(ch__$1,f__$1,map_GT___$1,meta16614){return (new cljs.core.async.t16613(ch__$1,f__$1,map_GT___$1,meta16614));
});
}
return (new cljs.core.async.t16613(ch,f,map_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns true to the
* target channel.
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t16619 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t16619 = (function (ch,p,filter_GT_,meta16620){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta16620 = meta16620;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t16619.cljs$lang$type = true;
cljs.core.async.t16619.cljs$lang$ctorStr = "cljs.core.async/t16619";
cljs.core.async.t16619.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t16619");
});
cljs.core.async.t16619.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t16619.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else
{return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});
cljs.core.async.t16619.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t16619.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t16619.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t16619.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t16619.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t16619.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16621){var self__ = this;
var _16621__$1 = this;return self__.meta16620;
});
cljs.core.async.t16619.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16621,meta16620__$1){var self__ = this;
var _16621__$1 = this;return (new cljs.core.async.t16619(self__.ch,self__.p,self__.filter_GT_,meta16620__$1));
});
cljs.core.async.__GT_t16619 = (function __GT_t16619(ch__$1,p__$1,filter_GT___$1,meta16620){return (new cljs.core.async.t16619(ch__$1,p__$1,filter_GT___$1,meta16620));
});
}
return (new cljs.core.async.t16619(ch,p,filter_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns false to the
* target channel.
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns true. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11412__auto___16704 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___16704,out){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___16704,out){
return (function (state_16683){var state_val_16684 = (state_16683[1]);if((state_val_16684 === 7))
{var inst_16679 = (state_16683[2]);var state_16683__$1 = state_16683;var statearr_16685_16705 = state_16683__$1;(statearr_16685_16705[2] = inst_16679);
(statearr_16685_16705[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16684 === 1))
{var state_16683__$1 = state_16683;var statearr_16686_16706 = state_16683__$1;(statearr_16686_16706[2] = null);
(statearr_16686_16706[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16684 === 4))
{var inst_16665 = (state_16683[7]);var inst_16665__$1 = (state_16683[2]);var inst_16666 = (inst_16665__$1 == null);var state_16683__$1 = (function (){var statearr_16687 = state_16683;(statearr_16687[7] = inst_16665__$1);
return statearr_16687;
})();if(cljs.core.truth_(inst_16666))
{var statearr_16688_16707 = state_16683__$1;(statearr_16688_16707[1] = 5);
} else
{var statearr_16689_16708 = state_16683__$1;(statearr_16689_16708[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16684 === 6))
{var inst_16665 = (state_16683[7]);var inst_16670 = p.call(null,inst_16665);var state_16683__$1 = state_16683;if(cljs.core.truth_(inst_16670))
{var statearr_16690_16709 = state_16683__$1;(statearr_16690_16709[1] = 8);
} else
{var statearr_16691_16710 = state_16683__$1;(statearr_16691_16710[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16684 === 3))
{var inst_16681 = (state_16683[2]);var state_16683__$1 = state_16683;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16683__$1,inst_16681);
} else
{if((state_val_16684 === 2))
{var state_16683__$1 = state_16683;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16683__$1,4,ch);
} else
{if((state_val_16684 === 11))
{var inst_16673 = (state_16683[2]);var state_16683__$1 = state_16683;var statearr_16692_16711 = state_16683__$1;(statearr_16692_16711[2] = inst_16673);
(statearr_16692_16711[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16684 === 9))
{var state_16683__$1 = state_16683;var statearr_16693_16712 = state_16683__$1;(statearr_16693_16712[2] = null);
(statearr_16693_16712[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16684 === 5))
{var inst_16668 = cljs.core.async.close_BANG_.call(null,out);var state_16683__$1 = state_16683;var statearr_16694_16713 = state_16683__$1;(statearr_16694_16713[2] = inst_16668);
(statearr_16694_16713[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16684 === 10))
{var inst_16676 = (state_16683[2]);var state_16683__$1 = (function (){var statearr_16695 = state_16683;(statearr_16695[8] = inst_16676);
return statearr_16695;
})();var statearr_16696_16714 = state_16683__$1;(statearr_16696_16714[2] = null);
(statearr_16696_16714[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16684 === 8))
{var inst_16665 = (state_16683[7]);var state_16683__$1 = state_16683;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16683__$1,11,out,inst_16665);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___16704,out))
;return ((function (switch__11347__auto__,c__11412__auto___16704,out){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_16700 = [null,null,null,null,null,null,null,null,null];(statearr_16700[0] = state_machine__11348__auto__);
(statearr_16700[1] = 1);
return statearr_16700;
});
var state_machine__11348__auto____1 = (function (state_16683){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_16683);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e16701){if((e16701 instanceof Object))
{var ex__11351__auto__ = e16701;var statearr_16702_16715 = state_16683;(statearr_16702_16715[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16683);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e16701;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__16716 = state_16683;
state_16683 = G__16716;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_16683){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_16683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___16704,out))
})();var state__11414__auto__ = (function (){var statearr_16703 = f__11413__auto__.call(null);(statearr_16703[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___16704);
return statearr_16703;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___16704,out))
);
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns false. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__11412__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto__){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto__){
return (function (state_16882){var state_val_16883 = (state_16882[1]);if((state_val_16883 === 7))
{var inst_16878 = (state_16882[2]);var state_16882__$1 = state_16882;var statearr_16884_16925 = state_16882__$1;(statearr_16884_16925[2] = inst_16878);
(statearr_16884_16925[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 20))
{var inst_16848 = (state_16882[7]);var inst_16859 = (state_16882[2]);var inst_16860 = cljs.core.next.call(null,inst_16848);var inst_16834 = inst_16860;var inst_16835 = null;var inst_16836 = 0;var inst_16837 = 0;var state_16882__$1 = (function (){var statearr_16885 = state_16882;(statearr_16885[8] = inst_16859);
(statearr_16885[9] = inst_16835);
(statearr_16885[10] = inst_16834);
(statearr_16885[11] = inst_16836);
(statearr_16885[12] = inst_16837);
return statearr_16885;
})();var statearr_16886_16926 = state_16882__$1;(statearr_16886_16926[2] = null);
(statearr_16886_16926[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 1))
{var state_16882__$1 = state_16882;var statearr_16887_16927 = state_16882__$1;(statearr_16887_16927[2] = null);
(statearr_16887_16927[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 4))
{var inst_16823 = (state_16882[13]);var inst_16823__$1 = (state_16882[2]);var inst_16824 = (inst_16823__$1 == null);var state_16882__$1 = (function (){var statearr_16888 = state_16882;(statearr_16888[13] = inst_16823__$1);
return statearr_16888;
})();if(cljs.core.truth_(inst_16824))
{var statearr_16889_16928 = state_16882__$1;(statearr_16889_16928[1] = 5);
} else
{var statearr_16890_16929 = state_16882__$1;(statearr_16890_16929[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 15))
{var state_16882__$1 = state_16882;var statearr_16894_16930 = state_16882__$1;(statearr_16894_16930[2] = null);
(statearr_16894_16930[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 21))
{var state_16882__$1 = state_16882;var statearr_16895_16931 = state_16882__$1;(statearr_16895_16931[2] = null);
(statearr_16895_16931[1] = 23);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 13))
{var inst_16835 = (state_16882[9]);var inst_16834 = (state_16882[10]);var inst_16836 = (state_16882[11]);var inst_16837 = (state_16882[12]);var inst_16844 = (state_16882[2]);var inst_16845 = (inst_16837 + 1);var tmp16891 = inst_16835;var tmp16892 = inst_16834;var tmp16893 = inst_16836;var inst_16834__$1 = tmp16892;var inst_16835__$1 = tmp16891;var inst_16836__$1 = tmp16893;var inst_16837__$1 = inst_16845;var state_16882__$1 = (function (){var statearr_16896 = state_16882;(statearr_16896[9] = inst_16835__$1);
(statearr_16896[14] = inst_16844);
(statearr_16896[10] = inst_16834__$1);
(statearr_16896[11] = inst_16836__$1);
(statearr_16896[12] = inst_16837__$1);
return statearr_16896;
})();var statearr_16897_16932 = state_16882__$1;(statearr_16897_16932[2] = null);
(statearr_16897_16932[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 22))
{var state_16882__$1 = state_16882;var statearr_16898_16933 = state_16882__$1;(statearr_16898_16933[2] = null);
(statearr_16898_16933[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 6))
{var inst_16823 = (state_16882[13]);var inst_16832 = f.call(null,inst_16823);var inst_16833 = cljs.core.seq.call(null,inst_16832);var inst_16834 = inst_16833;var inst_16835 = null;var inst_16836 = 0;var inst_16837 = 0;var state_16882__$1 = (function (){var statearr_16899 = state_16882;(statearr_16899[9] = inst_16835);
(statearr_16899[10] = inst_16834);
(statearr_16899[11] = inst_16836);
(statearr_16899[12] = inst_16837);
return statearr_16899;
})();var statearr_16900_16934 = state_16882__$1;(statearr_16900_16934[2] = null);
(statearr_16900_16934[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 17))
{var inst_16848 = (state_16882[7]);var inst_16852 = cljs.core.chunk_first.call(null,inst_16848);var inst_16853 = cljs.core.chunk_rest.call(null,inst_16848);var inst_16854 = cljs.core.count.call(null,inst_16852);var inst_16834 = inst_16853;var inst_16835 = inst_16852;var inst_16836 = inst_16854;var inst_16837 = 0;var state_16882__$1 = (function (){var statearr_16901 = state_16882;(statearr_16901[9] = inst_16835);
(statearr_16901[10] = inst_16834);
(statearr_16901[11] = inst_16836);
(statearr_16901[12] = inst_16837);
return statearr_16901;
})();var statearr_16902_16935 = state_16882__$1;(statearr_16902_16935[2] = null);
(statearr_16902_16935[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 3))
{var inst_16880 = (state_16882[2]);var state_16882__$1 = state_16882;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16882__$1,inst_16880);
} else
{if((state_val_16883 === 12))
{var inst_16868 = (state_16882[2]);var state_16882__$1 = state_16882;var statearr_16903_16936 = state_16882__$1;(statearr_16903_16936[2] = inst_16868);
(statearr_16903_16936[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 2))
{var state_16882__$1 = state_16882;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16882__$1,4,in$);
} else
{if((state_val_16883 === 23))
{var inst_16876 = (state_16882[2]);var state_16882__$1 = state_16882;var statearr_16904_16937 = state_16882__$1;(statearr_16904_16937[2] = inst_16876);
(statearr_16904_16937[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 19))
{var inst_16863 = (state_16882[2]);var state_16882__$1 = state_16882;var statearr_16905_16938 = state_16882__$1;(statearr_16905_16938[2] = inst_16863);
(statearr_16905_16938[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 11))
{var inst_16848 = (state_16882[7]);var inst_16834 = (state_16882[10]);var inst_16848__$1 = cljs.core.seq.call(null,inst_16834);var state_16882__$1 = (function (){var statearr_16906 = state_16882;(statearr_16906[7] = inst_16848__$1);
return statearr_16906;
})();if(inst_16848__$1)
{var statearr_16907_16939 = state_16882__$1;(statearr_16907_16939[1] = 14);
} else
{var statearr_16908_16940 = state_16882__$1;(statearr_16908_16940[1] = 15);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 9))
{var inst_16870 = (state_16882[2]);var inst_16871 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);var state_16882__$1 = (function (){var statearr_16909 = state_16882;(statearr_16909[15] = inst_16870);
return statearr_16909;
})();if(cljs.core.truth_(inst_16871))
{var statearr_16910_16941 = state_16882__$1;(statearr_16910_16941[1] = 21);
} else
{var statearr_16911_16942 = state_16882__$1;(statearr_16911_16942[1] = 22);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 5))
{var inst_16826 = cljs.core.async.close_BANG_.call(null,out);var state_16882__$1 = state_16882;var statearr_16912_16943 = state_16882__$1;(statearr_16912_16943[2] = inst_16826);
(statearr_16912_16943[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 14))
{var inst_16848 = (state_16882[7]);var inst_16850 = cljs.core.chunked_seq_QMARK_.call(null,inst_16848);var state_16882__$1 = state_16882;if(inst_16850)
{var statearr_16913_16944 = state_16882__$1;(statearr_16913_16944[1] = 17);
} else
{var statearr_16914_16945 = state_16882__$1;(statearr_16914_16945[1] = 18);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 16))
{var inst_16866 = (state_16882[2]);var state_16882__$1 = state_16882;var statearr_16915_16946 = state_16882__$1;(statearr_16915_16946[2] = inst_16866);
(statearr_16915_16946[1] = 12);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16883 === 10))
{var inst_16835 = (state_16882[9]);var inst_16837 = (state_16882[12]);var inst_16842 = cljs.core._nth.call(null,inst_16835,inst_16837);var state_16882__$1 = state_16882;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16882__$1,13,out,inst_16842);
} else
{if((state_val_16883 === 18))
{var inst_16848 = (state_16882[7]);var inst_16857 = cljs.core.first.call(null,inst_16848);var state_16882__$1 = state_16882;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16882__$1,20,out,inst_16857);
} else
{if((state_val_16883 === 8))
{var inst_16836 = (state_16882[11]);var inst_16837 = (state_16882[12]);var inst_16839 = (inst_16837 < inst_16836);var inst_16840 = inst_16839;var state_16882__$1 = state_16882;if(cljs.core.truth_(inst_16840))
{var statearr_16916_16947 = state_16882__$1;(statearr_16916_16947[1] = 10);
} else
{var statearr_16917_16948 = state_16882__$1;(statearr_16917_16948[1] = 11);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto__))
;return ((function (switch__11347__auto__,c__11412__auto__){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_16921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_16921[0] = state_machine__11348__auto__);
(statearr_16921[1] = 1);
return statearr_16921;
});
var state_machine__11348__auto____1 = (function (state_16882){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_16882);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e16922){if((e16922 instanceof Object))
{var ex__11351__auto__ = e16922;var statearr_16923_16949 = state_16882;(statearr_16923_16949[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16882);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e16922;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__16950 = state_16882;
state_16882 = G__16950;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_16882){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_16882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto__))
})();var state__11414__auto__ = (function (){var statearr_16924 = f__11413__auto__.call(null);(statearr_16924[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto__);
return statearr_16924;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto__))
);
return c__11412__auto__;
});
/**
* Takes a function and a source channel, and returns a channel which
* contains the values in each collection produced by applying f to
* each value taken from the source channel. f must return a
* collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The channel will close when the source channel
* closes.
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value put, then supplies each element of the result
* to the target channel. f must return a collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The target channel will be closed when the source
* channel closes.
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__11412__auto___17045 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___17045){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___17045){
return (function (state_17021){var state_val_17022 = (state_17021[1]);if((state_val_17022 === 7))
{var inst_17017 = (state_17021[2]);var state_17021__$1 = state_17021;var statearr_17023_17046 = state_17021__$1;(statearr_17023_17046[2] = inst_17017);
(statearr_17023_17046[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 1))
{var state_17021__$1 = state_17021;var statearr_17024_17047 = state_17021__$1;(statearr_17024_17047[2] = null);
(statearr_17024_17047[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 4))
{var inst_17000 = (state_17021[7]);var inst_17000__$1 = (state_17021[2]);var inst_17001 = (inst_17000__$1 == null);var state_17021__$1 = (function (){var statearr_17025 = state_17021;(statearr_17025[7] = inst_17000__$1);
return statearr_17025;
})();if(cljs.core.truth_(inst_17001))
{var statearr_17026_17048 = state_17021__$1;(statearr_17026_17048[1] = 5);
} else
{var statearr_17027_17049 = state_17021__$1;(statearr_17027_17049[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 13))
{var state_17021__$1 = state_17021;var statearr_17028_17050 = state_17021__$1;(statearr_17028_17050[2] = null);
(statearr_17028_17050[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 6))
{var inst_17000 = (state_17021[7]);var state_17021__$1 = state_17021;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17021__$1,11,to,inst_17000);
} else
{if((state_val_17022 === 3))
{var inst_17019 = (state_17021[2]);var state_17021__$1 = state_17021;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17021__$1,inst_17019);
} else
{if((state_val_17022 === 12))
{var state_17021__$1 = state_17021;var statearr_17029_17051 = state_17021__$1;(statearr_17029_17051[2] = null);
(statearr_17029_17051[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 2))
{var state_17021__$1 = state_17021;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17021__$1,4,from);
} else
{if((state_val_17022 === 11))
{var inst_17010 = (state_17021[2]);var state_17021__$1 = state_17021;if(cljs.core.truth_(inst_17010))
{var statearr_17030_17052 = state_17021__$1;(statearr_17030_17052[1] = 12);
} else
{var statearr_17031_17053 = state_17021__$1;(statearr_17031_17053[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 9))
{var state_17021__$1 = state_17021;var statearr_17032_17054 = state_17021__$1;(statearr_17032_17054[2] = null);
(statearr_17032_17054[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 5))
{var state_17021__$1 = state_17021;if(cljs.core.truth_(close_QMARK_))
{var statearr_17033_17055 = state_17021__$1;(statearr_17033_17055[1] = 8);
} else
{var statearr_17034_17056 = state_17021__$1;(statearr_17034_17056[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 14))
{var inst_17015 = (state_17021[2]);var state_17021__$1 = state_17021;var statearr_17035_17057 = state_17021__$1;(statearr_17035_17057[2] = inst_17015);
(statearr_17035_17057[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 10))
{var inst_17007 = (state_17021[2]);var state_17021__$1 = state_17021;var statearr_17036_17058 = state_17021__$1;(statearr_17036_17058[2] = inst_17007);
(statearr_17036_17058[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17022 === 8))
{var inst_17004 = cljs.core.async.close_BANG_.call(null,to);var state_17021__$1 = state_17021;var statearr_17037_17059 = state_17021__$1;(statearr_17037_17059[2] = inst_17004);
(statearr_17037_17059[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___17045))
;return ((function (switch__11347__auto__,c__11412__auto___17045){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_17041 = [null,null,null,null,null,null,null,null];(statearr_17041[0] = state_machine__11348__auto__);
(statearr_17041[1] = 1);
return statearr_17041;
});
var state_machine__11348__auto____1 = (function (state_17021){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_17021);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e17042){if((e17042 instanceof Object))
{var ex__11351__auto__ = e17042;var statearr_17043_17060 = state_17021;(statearr_17043_17060[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17021);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e17042;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__17061 = state_17021;
state_17021 = G__17061;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_17021){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_17021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___17045))
})();var state__11414__auto__ = (function (){var statearr_17044 = f__11413__auto__.call(null);(statearr_17044[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___17045);
return statearr_17044;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___17045))
);
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__11412__auto___17162 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___17162,tc,fc){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___17162,tc,fc){
return (function (state_17137){var state_val_17138 = (state_17137[1]);if((state_val_17138 === 7))
{var inst_17133 = (state_17137[2]);var state_17137__$1 = state_17137;var statearr_17139_17163 = state_17137__$1;(statearr_17139_17163[2] = inst_17133);
(statearr_17139_17163[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 1))
{var state_17137__$1 = state_17137;var statearr_17140_17164 = state_17137__$1;(statearr_17140_17164[2] = null);
(statearr_17140_17164[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 4))
{var inst_17114 = (state_17137[7]);var inst_17114__$1 = (state_17137[2]);var inst_17115 = (inst_17114__$1 == null);var state_17137__$1 = (function (){var statearr_17141 = state_17137;(statearr_17141[7] = inst_17114__$1);
return statearr_17141;
})();if(cljs.core.truth_(inst_17115))
{var statearr_17142_17165 = state_17137__$1;(statearr_17142_17165[1] = 5);
} else
{var statearr_17143_17166 = state_17137__$1;(statearr_17143_17166[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 13))
{var state_17137__$1 = state_17137;var statearr_17144_17167 = state_17137__$1;(statearr_17144_17167[2] = null);
(statearr_17144_17167[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 6))
{var inst_17114 = (state_17137[7]);var inst_17120 = p.call(null,inst_17114);var state_17137__$1 = state_17137;if(cljs.core.truth_(inst_17120))
{var statearr_17145_17168 = state_17137__$1;(statearr_17145_17168[1] = 9);
} else
{var statearr_17146_17169 = state_17137__$1;(statearr_17146_17169[1] = 10);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 3))
{var inst_17135 = (state_17137[2]);var state_17137__$1 = state_17137;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17137__$1,inst_17135);
} else
{if((state_val_17138 === 12))
{var state_17137__$1 = state_17137;var statearr_17147_17170 = state_17137__$1;(statearr_17147_17170[2] = null);
(statearr_17147_17170[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 2))
{var state_17137__$1 = state_17137;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17137__$1,4,ch);
} else
{if((state_val_17138 === 11))
{var inst_17114 = (state_17137[7]);var inst_17124 = (state_17137[2]);var state_17137__$1 = state_17137;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17137__$1,8,inst_17124,inst_17114);
} else
{if((state_val_17138 === 9))
{var state_17137__$1 = state_17137;var statearr_17148_17171 = state_17137__$1;(statearr_17148_17171[2] = tc);
(statearr_17148_17171[1] = 11);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 5))
{var inst_17117 = cljs.core.async.close_BANG_.call(null,tc);var inst_17118 = cljs.core.async.close_BANG_.call(null,fc);var state_17137__$1 = (function (){var statearr_17149 = state_17137;(statearr_17149[8] = inst_17117);
return statearr_17149;
})();var statearr_17150_17172 = state_17137__$1;(statearr_17150_17172[2] = inst_17118);
(statearr_17150_17172[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 14))
{var inst_17131 = (state_17137[2]);var state_17137__$1 = state_17137;var statearr_17151_17173 = state_17137__$1;(statearr_17151_17173[2] = inst_17131);
(statearr_17151_17173[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 10))
{var state_17137__$1 = state_17137;var statearr_17152_17174 = state_17137__$1;(statearr_17152_17174[2] = fc);
(statearr_17152_17174[1] = 11);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17138 === 8))
{var inst_17126 = (state_17137[2]);var state_17137__$1 = state_17137;if(cljs.core.truth_(inst_17126))
{var statearr_17153_17175 = state_17137__$1;(statearr_17153_17175[1] = 12);
} else
{var statearr_17154_17176 = state_17137__$1;(statearr_17154_17176[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___17162,tc,fc))
;return ((function (switch__11347__auto__,c__11412__auto___17162,tc,fc){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_17158 = [null,null,null,null,null,null,null,null,null];(statearr_17158[0] = state_machine__11348__auto__);
(statearr_17158[1] = 1);
return statearr_17158;
});
var state_machine__11348__auto____1 = (function (state_17137){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_17137);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e17159){if((e17159 instanceof Object))
{var ex__11351__auto__ = e17159;var statearr_17160_17177 = state_17137;(statearr_17160_17177[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17137);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e17159;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__17178 = state_17137;
state_17137 = G__17178;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_17137){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_17137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___17162,tc,fc))
})();var state__11414__auto__ = (function (){var statearr_17161 = f__11413__auto__.call(null);(statearr_17161[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___17162);
return statearr_17161;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___17162,tc,fc))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__11412__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto__){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto__){
return (function (state_17225){var state_val_17226 = (state_17225[1]);if((state_val_17226 === 7))
{var inst_17221 = (state_17225[2]);var state_17225__$1 = state_17225;var statearr_17227_17243 = state_17225__$1;(statearr_17227_17243[2] = inst_17221);
(statearr_17227_17243[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17226 === 6))
{var inst_17214 = (state_17225[7]);var inst_17211 = (state_17225[8]);var inst_17218 = f.call(null,inst_17211,inst_17214);var inst_17211__$1 = inst_17218;var state_17225__$1 = (function (){var statearr_17228 = state_17225;(statearr_17228[8] = inst_17211__$1);
return statearr_17228;
})();var statearr_17229_17244 = state_17225__$1;(statearr_17229_17244[2] = null);
(statearr_17229_17244[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17226 === 5))
{var inst_17211 = (state_17225[8]);var state_17225__$1 = state_17225;var statearr_17230_17245 = state_17225__$1;(statearr_17230_17245[2] = inst_17211);
(statearr_17230_17245[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17226 === 4))
{var inst_17214 = (state_17225[7]);var inst_17214__$1 = (state_17225[2]);var inst_17215 = (inst_17214__$1 == null);var state_17225__$1 = (function (){var statearr_17231 = state_17225;(statearr_17231[7] = inst_17214__$1);
return statearr_17231;
})();if(cljs.core.truth_(inst_17215))
{var statearr_17232_17246 = state_17225__$1;(statearr_17232_17246[1] = 5);
} else
{var statearr_17233_17247 = state_17225__$1;(statearr_17233_17247[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17226 === 3))
{var inst_17223 = (state_17225[2]);var state_17225__$1 = state_17225;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17225__$1,inst_17223);
} else
{if((state_val_17226 === 2))
{var state_17225__$1 = state_17225;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17225__$1,4,ch);
} else
{if((state_val_17226 === 1))
{var inst_17211 = init;var state_17225__$1 = (function (){var statearr_17234 = state_17225;(statearr_17234[8] = inst_17211);
return statearr_17234;
})();var statearr_17235_17248 = state_17225__$1;(statearr_17235_17248[2] = null);
(statearr_17235_17248[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
});})(c__11412__auto__))
;return ((function (switch__11347__auto__,c__11412__auto__){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_17239 = [null,null,null,null,null,null,null,null,null];(statearr_17239[0] = state_machine__11348__auto__);
(statearr_17239[1] = 1);
return statearr_17239;
});
var state_machine__11348__auto____1 = (function (state_17225){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_17225);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e17240){if((e17240 instanceof Object))
{var ex__11351__auto__ = e17240;var statearr_17241_17249 = state_17225;(statearr_17241_17249[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17225);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e17240;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__17250 = state_17225;
state_17225 = G__17250;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_17225){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_17225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto__))
})();var state__11414__auto__ = (function (){var statearr_17242 = f__11413__auto__.call(null);(statearr_17242[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto__);
return statearr_17242;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto__))
);
return c__11412__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__11412__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto__){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto__){
return (function (state_17324){var state_val_17325 = (state_17324[1]);if((state_val_17325 === 7))
{var inst_17306 = (state_17324[2]);var state_17324__$1 = state_17324;var statearr_17326_17349 = state_17324__$1;(statearr_17326_17349[2] = inst_17306);
(statearr_17326_17349[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 1))
{var inst_17300 = cljs.core.seq.call(null,coll);var inst_17301 = inst_17300;var state_17324__$1 = (function (){var statearr_17327 = state_17324;(statearr_17327[7] = inst_17301);
return statearr_17327;
})();var statearr_17328_17350 = state_17324__$1;(statearr_17328_17350[2] = null);
(statearr_17328_17350[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 4))
{var inst_17301 = (state_17324[7]);var inst_17304 = cljs.core.first.call(null,inst_17301);var state_17324__$1 = state_17324;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17324__$1,7,ch,inst_17304);
} else
{if((state_val_17325 === 13))
{var inst_17318 = (state_17324[2]);var state_17324__$1 = state_17324;var statearr_17329_17351 = state_17324__$1;(statearr_17329_17351[2] = inst_17318);
(statearr_17329_17351[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 6))
{var inst_17309 = (state_17324[2]);var state_17324__$1 = state_17324;if(cljs.core.truth_(inst_17309))
{var statearr_17330_17352 = state_17324__$1;(statearr_17330_17352[1] = 8);
} else
{var statearr_17331_17353 = state_17324__$1;(statearr_17331_17353[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 3))
{var inst_17322 = (state_17324[2]);var state_17324__$1 = state_17324;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17324__$1,inst_17322);
} else
{if((state_val_17325 === 12))
{var state_17324__$1 = state_17324;var statearr_17332_17354 = state_17324__$1;(statearr_17332_17354[2] = null);
(statearr_17332_17354[1] = 13);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 2))
{var inst_17301 = (state_17324[7]);var state_17324__$1 = state_17324;if(cljs.core.truth_(inst_17301))
{var statearr_17333_17355 = state_17324__$1;(statearr_17333_17355[1] = 4);
} else
{var statearr_17334_17356 = state_17324__$1;(statearr_17334_17356[1] = 5);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 11))
{var inst_17315 = cljs.core.async.close_BANG_.call(null,ch);var state_17324__$1 = state_17324;var statearr_17335_17357 = state_17324__$1;(statearr_17335_17357[2] = inst_17315);
(statearr_17335_17357[1] = 13);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 9))
{var state_17324__$1 = state_17324;if(cljs.core.truth_(close_QMARK_))
{var statearr_17336_17358 = state_17324__$1;(statearr_17336_17358[1] = 11);
} else
{var statearr_17337_17359 = state_17324__$1;(statearr_17337_17359[1] = 12);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 5))
{var inst_17301 = (state_17324[7]);var state_17324__$1 = state_17324;var statearr_17338_17360 = state_17324__$1;(statearr_17338_17360[2] = inst_17301);
(statearr_17338_17360[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 10))
{var inst_17320 = (state_17324[2]);var state_17324__$1 = state_17324;var statearr_17339_17361 = state_17324__$1;(statearr_17339_17361[2] = inst_17320);
(statearr_17339_17361[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17325 === 8))
{var inst_17301 = (state_17324[7]);var inst_17311 = cljs.core.next.call(null,inst_17301);var inst_17301__$1 = inst_17311;var state_17324__$1 = (function (){var statearr_17340 = state_17324;(statearr_17340[7] = inst_17301__$1);
return statearr_17340;
})();var statearr_17341_17362 = state_17324__$1;(statearr_17341_17362[2] = null);
(statearr_17341_17362[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto__))
;return ((function (switch__11347__auto__,c__11412__auto__){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_17345 = [null,null,null,null,null,null,null,null];(statearr_17345[0] = state_machine__11348__auto__);
(statearr_17345[1] = 1);
return statearr_17345;
});
var state_machine__11348__auto____1 = (function (state_17324){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_17324);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e17346){if((e17346 instanceof Object))
{var ex__11351__auto__ = e17346;var statearr_17347_17363 = state_17324;(statearr_17347_17363[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17324);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e17346;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__17364 = state_17324;
state_17324 = G__17364;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_17324){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_17324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto__))
})();var state__11414__auto__ = (function (){var statearr_17348 = f__11413__auto__.call(null);(statearr_17348[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto__);
return statearr_17348;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto__))
);
return c__11412__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,100,coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj17366 = {};return obj17366;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__7917__auto__ = _;if(and__7917__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__7917__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__8556__auto__ = (((_ == null))?null:_);return (function (){var or__7929__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj17368 = {};return obj17368;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__7917__auto__ = m;if(and__7917__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__7917__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__8556__auto__ = (((m == null))?null:m);return (function (){var or__7929__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__7917__auto__ = m;if(and__7917__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__7917__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__8556__auto__ = (((m == null))?null:m);return (function (){var or__7929__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__7917__auto__ = m;if(and__7917__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__7917__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__8556__auto__ = (((m == null))?null:m);return (function (){var or__7929__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t17590 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t17590 = (function (cs,ch,mult,meta17591){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta17591 = meta17591;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t17590.cljs$lang$type = true;
cljs.core.async.t17590.cljs$lang$ctorStr = "cljs.core.async/t17590";
cljs.core.async.t17590.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t17590");
});})(cs))
;
cljs.core.async.t17590.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t17590.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t17590.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t17590.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t17590.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t17590.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t17590.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_17592){var self__ = this;
var _17592__$1 = this;return self__.meta17591;
});})(cs))
;
cljs.core.async.t17590.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_17592,meta17591__$1){var self__ = this;
var _17592__$1 = this;return (new cljs.core.async.t17590(self__.cs,self__.ch,self__.mult,meta17591__$1));
});})(cs))
;
cljs.core.async.__GT_t17590 = ((function (cs){
return (function __GT_t17590(cs__$1,ch__$1,mult__$1,meta17591){return (new cljs.core.async.t17590(cs__$1,ch__$1,mult__$1,meta17591));
});})(cs))
;
}
return (new cljs.core.async.t17590(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,1);var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (_){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === 0))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__11412__auto___17811 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___17811,cs,m,dchan,dctr,done){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___17811,cs,m,dchan,dctr,done){
return (function (state_17723){var state_val_17724 = (state_17723[1]);if((state_val_17724 === 7))
{var inst_17719 = (state_17723[2]);var state_17723__$1 = state_17723;var statearr_17725_17812 = state_17723__$1;(statearr_17725_17812[2] = inst_17719);
(statearr_17725_17812[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 20))
{var inst_17624 = (state_17723[7]);var inst_17634 = cljs.core.first.call(null,inst_17624);var inst_17635 = cljs.core.nth.call(null,inst_17634,0,null);var inst_17636 = cljs.core.nth.call(null,inst_17634,1,null);var state_17723__$1 = (function (){var statearr_17726 = state_17723;(statearr_17726[8] = inst_17635);
return statearr_17726;
})();if(cljs.core.truth_(inst_17636))
{var statearr_17727_17813 = state_17723__$1;(statearr_17727_17813[1] = 22);
} else
{var statearr_17728_17814 = state_17723__$1;(statearr_17728_17814[1] = 23);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 27))
{var inst_17671 = (state_17723[9]);var inst_17595 = (state_17723[10]);var inst_17666 = (state_17723[11]);var inst_17664 = (state_17723[12]);var inst_17671__$1 = cljs.core._nth.call(null,inst_17664,inst_17666);var inst_17672 = cljs.core.async.put_BANG_.call(null,inst_17671__$1,inst_17595,done);var state_17723__$1 = (function (){var statearr_17729 = state_17723;(statearr_17729[9] = inst_17671__$1);
return statearr_17729;
})();if(cljs.core.truth_(inst_17672))
{var statearr_17730_17815 = state_17723__$1;(statearr_17730_17815[1] = 30);
} else
{var statearr_17731_17816 = state_17723__$1;(statearr_17731_17816[1] = 31);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 1))
{var state_17723__$1 = state_17723;var statearr_17732_17817 = state_17723__$1;(statearr_17732_17817[2] = null);
(statearr_17732_17817[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 24))
{var inst_17624 = (state_17723[7]);var inst_17641 = (state_17723[2]);var inst_17642 = cljs.core.next.call(null,inst_17624);var inst_17604 = inst_17642;var inst_17605 = null;var inst_17606 = 0;var inst_17607 = 0;var state_17723__$1 = (function (){var statearr_17733 = state_17723;(statearr_17733[13] = inst_17605);
(statearr_17733[14] = inst_17604);
(statearr_17733[15] = inst_17606);
(statearr_17733[16] = inst_17641);
(statearr_17733[17] = inst_17607);
return statearr_17733;
})();var statearr_17734_17818 = state_17723__$1;(statearr_17734_17818[2] = null);
(statearr_17734_17818[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 39))
{var state_17723__$1 = state_17723;var statearr_17738_17819 = state_17723__$1;(statearr_17738_17819[2] = null);
(statearr_17738_17819[1] = 41);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 4))
{var inst_17595 = (state_17723[10]);var inst_17595__$1 = (state_17723[2]);var inst_17596 = (inst_17595__$1 == null);var state_17723__$1 = (function (){var statearr_17739 = state_17723;(statearr_17739[10] = inst_17595__$1);
return statearr_17739;
})();if(cljs.core.truth_(inst_17596))
{var statearr_17740_17820 = state_17723__$1;(statearr_17740_17820[1] = 5);
} else
{var statearr_17741_17821 = state_17723__$1;(statearr_17741_17821[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 15))
{var inst_17605 = (state_17723[13]);var inst_17604 = (state_17723[14]);var inst_17606 = (state_17723[15]);var inst_17607 = (state_17723[17]);var inst_17620 = (state_17723[2]);var inst_17621 = (inst_17607 + 1);var tmp17735 = inst_17605;var tmp17736 = inst_17604;var tmp17737 = inst_17606;var inst_17604__$1 = tmp17736;var inst_17605__$1 = tmp17735;var inst_17606__$1 = tmp17737;var inst_17607__$1 = inst_17621;var state_17723__$1 = (function (){var statearr_17742 = state_17723;(statearr_17742[13] = inst_17605__$1);
(statearr_17742[14] = inst_17604__$1);
(statearr_17742[18] = inst_17620);
(statearr_17742[15] = inst_17606__$1);
(statearr_17742[17] = inst_17607__$1);
return statearr_17742;
})();var statearr_17743_17822 = state_17723__$1;(statearr_17743_17822[2] = null);
(statearr_17743_17822[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 21))
{var inst_17645 = (state_17723[2]);var state_17723__$1 = state_17723;var statearr_17747_17823 = state_17723__$1;(statearr_17747_17823[2] = inst_17645);
(statearr_17747_17823[1] = 18);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 31))
{var inst_17671 = (state_17723[9]);var inst_17675 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_17676 = cljs.core.async.untap_STAR_.call(null,m,inst_17671);var state_17723__$1 = (function (){var statearr_17748 = state_17723;(statearr_17748[19] = inst_17675);
return statearr_17748;
})();var statearr_17749_17824 = state_17723__$1;(statearr_17749_17824[2] = inst_17676);
(statearr_17749_17824[1] = 32);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 32))
{var inst_17666 = (state_17723[11]);var inst_17665 = (state_17723[20]);var inst_17664 = (state_17723[12]);var inst_17663 = (state_17723[21]);var inst_17678 = (state_17723[2]);var inst_17679 = (inst_17666 + 1);var tmp17744 = inst_17665;var tmp17745 = inst_17664;var tmp17746 = inst_17663;var inst_17663__$1 = tmp17746;var inst_17664__$1 = tmp17745;var inst_17665__$1 = tmp17744;var inst_17666__$1 = inst_17679;var state_17723__$1 = (function (){var statearr_17750 = state_17723;(statearr_17750[22] = inst_17678);
(statearr_17750[11] = inst_17666__$1);
(statearr_17750[20] = inst_17665__$1);
(statearr_17750[12] = inst_17664__$1);
(statearr_17750[21] = inst_17663__$1);
return statearr_17750;
})();var statearr_17751_17825 = state_17723__$1;(statearr_17751_17825[2] = null);
(statearr_17751_17825[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 40))
{var inst_17691 = (state_17723[23]);var inst_17695 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_17696 = cljs.core.async.untap_STAR_.call(null,m,inst_17691);var state_17723__$1 = (function (){var statearr_17752 = state_17723;(statearr_17752[24] = inst_17695);
return statearr_17752;
})();var statearr_17753_17826 = state_17723__$1;(statearr_17753_17826[2] = inst_17696);
(statearr_17753_17826[1] = 41);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 33))
{var inst_17682 = (state_17723[25]);var inst_17684 = cljs.core.chunked_seq_QMARK_.call(null,inst_17682);var state_17723__$1 = state_17723;if(inst_17684)
{var statearr_17754_17827 = state_17723__$1;(statearr_17754_17827[1] = 36);
} else
{var statearr_17755_17828 = state_17723__$1;(statearr_17755_17828[1] = 37);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 13))
{var inst_17614 = (state_17723[26]);var inst_17617 = cljs.core.async.close_BANG_.call(null,inst_17614);var state_17723__$1 = state_17723;var statearr_17756_17829 = state_17723__$1;(statearr_17756_17829[2] = inst_17617);
(statearr_17756_17829[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 22))
{var inst_17635 = (state_17723[8]);var inst_17638 = cljs.core.async.close_BANG_.call(null,inst_17635);var state_17723__$1 = state_17723;var statearr_17757_17830 = state_17723__$1;(statearr_17757_17830[2] = inst_17638);
(statearr_17757_17830[1] = 24);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 36))
{var inst_17682 = (state_17723[25]);var inst_17686 = cljs.core.chunk_first.call(null,inst_17682);var inst_17687 = cljs.core.chunk_rest.call(null,inst_17682);var inst_17688 = cljs.core.count.call(null,inst_17686);var inst_17663 = inst_17687;var inst_17664 = inst_17686;var inst_17665 = inst_17688;var inst_17666 = 0;var state_17723__$1 = (function (){var statearr_17758 = state_17723;(statearr_17758[11] = inst_17666);
(statearr_17758[20] = inst_17665);
(statearr_17758[12] = inst_17664);
(statearr_17758[21] = inst_17663);
return statearr_17758;
})();var statearr_17759_17831 = state_17723__$1;(statearr_17759_17831[2] = null);
(statearr_17759_17831[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 41))
{var inst_17682 = (state_17723[25]);var inst_17698 = (state_17723[2]);var inst_17699 = cljs.core.next.call(null,inst_17682);var inst_17663 = inst_17699;var inst_17664 = null;var inst_17665 = 0;var inst_17666 = 0;var state_17723__$1 = (function (){var statearr_17760 = state_17723;(statearr_17760[27] = inst_17698);
(statearr_17760[11] = inst_17666);
(statearr_17760[20] = inst_17665);
(statearr_17760[12] = inst_17664);
(statearr_17760[21] = inst_17663);
return statearr_17760;
})();var statearr_17761_17832 = state_17723__$1;(statearr_17761_17832[2] = null);
(statearr_17761_17832[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 43))
{var state_17723__$1 = state_17723;var statearr_17762_17833 = state_17723__$1;(statearr_17762_17833[2] = null);
(statearr_17762_17833[1] = 44);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 29))
{var inst_17707 = (state_17723[2]);var state_17723__$1 = state_17723;var statearr_17763_17834 = state_17723__$1;(statearr_17763_17834[2] = inst_17707);
(statearr_17763_17834[1] = 26);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 44))
{var inst_17716 = (state_17723[2]);var state_17723__$1 = (function (){var statearr_17764 = state_17723;(statearr_17764[28] = inst_17716);
return statearr_17764;
})();var statearr_17765_17835 = state_17723__$1;(statearr_17765_17835[2] = null);
(statearr_17765_17835[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 6))
{var inst_17655 = (state_17723[29]);var inst_17654 = cljs.core.deref.call(null,cs);var inst_17655__$1 = cljs.core.keys.call(null,inst_17654);var inst_17656 = cljs.core.count.call(null,inst_17655__$1);var inst_17657 = cljs.core.reset_BANG_.call(null,dctr,inst_17656);var inst_17662 = cljs.core.seq.call(null,inst_17655__$1);var inst_17663 = inst_17662;var inst_17664 = null;var inst_17665 = 0;var inst_17666 = 0;var state_17723__$1 = (function (){var statearr_17766 = state_17723;(statearr_17766[30] = inst_17657);
(statearr_17766[11] = inst_17666);
(statearr_17766[20] = inst_17665);
(statearr_17766[12] = inst_17664);
(statearr_17766[29] = inst_17655__$1);
(statearr_17766[21] = inst_17663);
return statearr_17766;
})();var statearr_17767_17836 = state_17723__$1;(statearr_17767_17836[2] = null);
(statearr_17767_17836[1] = 25);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 28))
{var inst_17682 = (state_17723[25]);var inst_17663 = (state_17723[21]);var inst_17682__$1 = cljs.core.seq.call(null,inst_17663);var state_17723__$1 = (function (){var statearr_17768 = state_17723;(statearr_17768[25] = inst_17682__$1);
return statearr_17768;
})();if(inst_17682__$1)
{var statearr_17769_17837 = state_17723__$1;(statearr_17769_17837[1] = 33);
} else
{var statearr_17770_17838 = state_17723__$1;(statearr_17770_17838[1] = 34);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 25))
{var inst_17666 = (state_17723[11]);var inst_17665 = (state_17723[20]);var inst_17668 = (inst_17666 < inst_17665);var inst_17669 = inst_17668;var state_17723__$1 = state_17723;if(cljs.core.truth_(inst_17669))
{var statearr_17771_17839 = state_17723__$1;(statearr_17771_17839[1] = 27);
} else
{var statearr_17772_17840 = state_17723__$1;(statearr_17772_17840[1] = 28);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 34))
{var state_17723__$1 = state_17723;var statearr_17773_17841 = state_17723__$1;(statearr_17773_17841[2] = null);
(statearr_17773_17841[1] = 35);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 17))
{var state_17723__$1 = state_17723;var statearr_17774_17842 = state_17723__$1;(statearr_17774_17842[2] = null);
(statearr_17774_17842[1] = 18);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 3))
{var inst_17721 = (state_17723[2]);var state_17723__$1 = state_17723;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17723__$1,inst_17721);
} else
{if((state_val_17724 === 12))
{var inst_17650 = (state_17723[2]);var state_17723__$1 = state_17723;var statearr_17775_17843 = state_17723__$1;(statearr_17775_17843[2] = inst_17650);
(statearr_17775_17843[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 2))
{var state_17723__$1 = state_17723;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17723__$1,4,ch);
} else
{if((state_val_17724 === 23))
{var state_17723__$1 = state_17723;var statearr_17776_17844 = state_17723__$1;(statearr_17776_17844[2] = null);
(statearr_17776_17844[1] = 24);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 35))
{var inst_17705 = (state_17723[2]);var state_17723__$1 = state_17723;var statearr_17777_17845 = state_17723__$1;(statearr_17777_17845[2] = inst_17705);
(statearr_17777_17845[1] = 29);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 19))
{var inst_17624 = (state_17723[7]);var inst_17628 = cljs.core.chunk_first.call(null,inst_17624);var inst_17629 = cljs.core.chunk_rest.call(null,inst_17624);var inst_17630 = cljs.core.count.call(null,inst_17628);var inst_17604 = inst_17629;var inst_17605 = inst_17628;var inst_17606 = inst_17630;var inst_17607 = 0;var state_17723__$1 = (function (){var statearr_17778 = state_17723;(statearr_17778[13] = inst_17605);
(statearr_17778[14] = inst_17604);
(statearr_17778[15] = inst_17606);
(statearr_17778[17] = inst_17607);
return statearr_17778;
})();var statearr_17779_17846 = state_17723__$1;(statearr_17779_17846[2] = null);
(statearr_17779_17846[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 11))
{var inst_17604 = (state_17723[14]);var inst_17624 = (state_17723[7]);var inst_17624__$1 = cljs.core.seq.call(null,inst_17604);var state_17723__$1 = (function (){var statearr_17780 = state_17723;(statearr_17780[7] = inst_17624__$1);
return statearr_17780;
})();if(inst_17624__$1)
{var statearr_17781_17847 = state_17723__$1;(statearr_17781_17847[1] = 16);
} else
{var statearr_17782_17848 = state_17723__$1;(statearr_17782_17848[1] = 17);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 9))
{var inst_17652 = (state_17723[2]);var state_17723__$1 = state_17723;var statearr_17783_17849 = state_17723__$1;(statearr_17783_17849[2] = inst_17652);
(statearr_17783_17849[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 5))
{var inst_17602 = cljs.core.deref.call(null,cs);var inst_17603 = cljs.core.seq.call(null,inst_17602);var inst_17604 = inst_17603;var inst_17605 = null;var inst_17606 = 0;var inst_17607 = 0;var state_17723__$1 = (function (){var statearr_17784 = state_17723;(statearr_17784[13] = inst_17605);
(statearr_17784[14] = inst_17604);
(statearr_17784[15] = inst_17606);
(statearr_17784[17] = inst_17607);
return statearr_17784;
})();var statearr_17785_17850 = state_17723__$1;(statearr_17785_17850[2] = null);
(statearr_17785_17850[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 14))
{var state_17723__$1 = state_17723;var statearr_17786_17851 = state_17723__$1;(statearr_17786_17851[2] = null);
(statearr_17786_17851[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 45))
{var inst_17713 = (state_17723[2]);var state_17723__$1 = state_17723;var statearr_17787_17852 = state_17723__$1;(statearr_17787_17852[2] = inst_17713);
(statearr_17787_17852[1] = 44);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 26))
{var inst_17655 = (state_17723[29]);var inst_17709 = (state_17723[2]);var inst_17710 = cljs.core.seq.call(null,inst_17655);var state_17723__$1 = (function (){var statearr_17788 = state_17723;(statearr_17788[31] = inst_17709);
return statearr_17788;
})();if(inst_17710)
{var statearr_17789_17853 = state_17723__$1;(statearr_17789_17853[1] = 42);
} else
{var statearr_17790_17854 = state_17723__$1;(statearr_17790_17854[1] = 43);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 16))
{var inst_17624 = (state_17723[7]);var inst_17626 = cljs.core.chunked_seq_QMARK_.call(null,inst_17624);var state_17723__$1 = state_17723;if(inst_17626)
{var statearr_17791_17855 = state_17723__$1;(statearr_17791_17855[1] = 19);
} else
{var statearr_17792_17856 = state_17723__$1;(statearr_17792_17856[1] = 20);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 38))
{var inst_17702 = (state_17723[2]);var state_17723__$1 = state_17723;var statearr_17793_17857 = state_17723__$1;(statearr_17793_17857[2] = inst_17702);
(statearr_17793_17857[1] = 35);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 30))
{var state_17723__$1 = state_17723;var statearr_17794_17858 = state_17723__$1;(statearr_17794_17858[2] = null);
(statearr_17794_17858[1] = 32);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 10))
{var inst_17605 = (state_17723[13]);var inst_17607 = (state_17723[17]);var inst_17613 = cljs.core._nth.call(null,inst_17605,inst_17607);var inst_17614 = cljs.core.nth.call(null,inst_17613,0,null);var inst_17615 = cljs.core.nth.call(null,inst_17613,1,null);var state_17723__$1 = (function (){var statearr_17795 = state_17723;(statearr_17795[26] = inst_17614);
return statearr_17795;
})();if(cljs.core.truth_(inst_17615))
{var statearr_17796_17859 = state_17723__$1;(statearr_17796_17859[1] = 13);
} else
{var statearr_17797_17860 = state_17723__$1;(statearr_17797_17860[1] = 14);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 18))
{var inst_17648 = (state_17723[2]);var state_17723__$1 = state_17723;var statearr_17798_17861 = state_17723__$1;(statearr_17798_17861[2] = inst_17648);
(statearr_17798_17861[1] = 12);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 42))
{var state_17723__$1 = state_17723;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17723__$1,45,dchan);
} else
{if((state_val_17724 === 37))
{var inst_17682 = (state_17723[25]);var inst_17595 = (state_17723[10]);var inst_17691 = (state_17723[23]);var inst_17691__$1 = cljs.core.first.call(null,inst_17682);var inst_17692 = cljs.core.async.put_BANG_.call(null,inst_17691__$1,inst_17595,done);var state_17723__$1 = (function (){var statearr_17799 = state_17723;(statearr_17799[23] = inst_17691__$1);
return statearr_17799;
})();if(cljs.core.truth_(inst_17692))
{var statearr_17800_17862 = state_17723__$1;(statearr_17800_17862[1] = 39);
} else
{var statearr_17801_17863 = state_17723__$1;(statearr_17801_17863[1] = 40);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_17724 === 8))
{var inst_17606 = (state_17723[15]);var inst_17607 = (state_17723[17]);var inst_17609 = (inst_17607 < inst_17606);var inst_17610 = inst_17609;var state_17723__$1 = state_17723;if(cljs.core.truth_(inst_17610))
{var statearr_17802_17864 = state_17723__$1;(statearr_17802_17864[1] = 10);
} else
{var statearr_17803_17865 = state_17723__$1;(statearr_17803_17865[1] = 11);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___17811,cs,m,dchan,dctr,done))
;return ((function (switch__11347__auto__,c__11412__auto___17811,cs,m,dchan,dctr,done){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_17807 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_17807[0] = state_machine__11348__auto__);
(statearr_17807[1] = 1);
return statearr_17807;
});
var state_machine__11348__auto____1 = (function (state_17723){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_17723);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e17808){if((e17808 instanceof Object))
{var ex__11351__auto__ = e17808;var statearr_17809_17866 = state_17723;(statearr_17809_17866[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17723);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e17808;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__17867 = state_17723;
state_17723 = G__17867;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_17723){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_17723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___17811,cs,m,dchan,dctr,done))
})();var state__11414__auto__ = (function (){var statearr_17810 = f__11413__auto__.call(null);(statearr_17810[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___17811);
return statearr_17810;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___17811,cs,m,dchan,dctr,done))
);
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj17869 = {};return obj17869;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__7917__auto__ = m;if(and__7917__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__7917__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__8556__auto__ = (((m == null))?null:m);return (function (){var or__7929__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__7917__auto__ = m;if(and__7917__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__7917__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__8556__auto__ = (((m == null))?null:m);return (function (){var or__7929__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__7917__auto__ = m;if(and__7917__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__7917__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__8556__auto__ = (((m == null))?null:m);return (function (){var or__7929__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__7917__auto__ = m;if(and__7917__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__7917__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__8556__auto__ = (((m == null))?null:m);return (function (){var or__7929__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__7917__auto__ = m;if(and__7917__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__7917__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__8556__auto__ = (((m == null))?null:m);return (function (){var or__7929__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",1120344424),null,new cljs.core.Keyword(null,"mute","mute",1017267595),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",1017440337));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1017267595));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",1017440337),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",1120344424),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1123523302),solos,new cljs.core.Keyword(null,"mutes","mutes",1118168300),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1017267595),chs),new cljs.core.Keyword(null,"reads","reads",1122290959),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",1120344424))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t17989 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t17989 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta17990){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta17990 = meta17990;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t17989.cljs$lang$type = true;
cljs.core.async.t17989.cljs$lang$ctorStr = "cljs.core.async/t17989";
cljs.core.async.t17989.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t17989");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t17989.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t17989.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t17989.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t17989.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t17989.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t17989.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(("mode must be one of: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)))+"\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",-1162732933,null),new cljs.core.Symbol(null,"mode","mode",-1637174436,null)))))));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t17989.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t17989.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t17989.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17991){var self__ = this;
var _17991__$1 = this;return self__.meta17990;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t17989.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17991,meta17990__$1){var self__ = this;
var _17991__$1 = this;return (new cljs.core.async.t17989(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta17990__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t17989 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t17989(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta17990){return (new cljs.core.async.t17989(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta17990));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t17989(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,null));
})();var c__11412__auto___18108 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___18108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___18108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18061){var state_val_18062 = (state_18061[1]);if((state_val_18062 === 7))
{var inst_18005 = (state_18061[7]);var inst_18010 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18005);var state_18061__$1 = state_18061;var statearr_18063_18109 = state_18061__$1;(statearr_18063_18109[2] = inst_18010);
(statearr_18063_18109[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 20))
{var inst_18020 = (state_18061[8]);var state_18061__$1 = state_18061;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18061__$1,23,out,inst_18020);
} else
{if((state_val_18062 === 1))
{var inst_17995 = (state_18061[9]);var inst_17995__$1 = calc_state.call(null);var inst_17996 = cljs.core.seq_QMARK_.call(null,inst_17995__$1);var state_18061__$1 = (function (){var statearr_18064 = state_18061;(statearr_18064[9] = inst_17995__$1);
return statearr_18064;
})();if(inst_17996)
{var statearr_18065_18110 = state_18061__$1;(statearr_18065_18110[1] = 2);
} else
{var statearr_18066_18111 = state_18061__$1;(statearr_18066_18111[1] = 3);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 24))
{var inst_18013 = (state_18061[10]);var inst_18005 = inst_18013;var state_18061__$1 = (function (){var statearr_18067 = state_18061;(statearr_18067[7] = inst_18005);
return statearr_18067;
})();var statearr_18068_18112 = state_18061__$1;(statearr_18068_18112[2] = null);
(statearr_18068_18112[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 4))
{var inst_17995 = (state_18061[9]);var inst_18001 = (state_18061[2]);var inst_18002 = cljs.core.get.call(null,inst_18001,new cljs.core.Keyword(null,"reads","reads",1122290959));var inst_18003 = cljs.core.get.call(null,inst_18001,new cljs.core.Keyword(null,"mutes","mutes",1118168300));var inst_18004 = cljs.core.get.call(null,inst_18001,new cljs.core.Keyword(null,"solos","solos",1123523302));var inst_18005 = inst_17995;var state_18061__$1 = (function (){var statearr_18069 = state_18061;(statearr_18069[7] = inst_18005);
(statearr_18069[11] = inst_18004);
(statearr_18069[12] = inst_18002);
(statearr_18069[13] = inst_18003);
return statearr_18069;
})();var statearr_18070_18113 = state_18061__$1;(statearr_18070_18113[2] = null);
(statearr_18070_18113[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 15))
{var state_18061__$1 = state_18061;var statearr_18071_18114 = state_18061__$1;(statearr_18071_18114[2] = null);
(statearr_18071_18114[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 21))
{var inst_18013 = (state_18061[10]);var inst_18005 = inst_18013;var state_18061__$1 = (function (){var statearr_18072 = state_18061;(statearr_18072[7] = inst_18005);
return statearr_18072;
})();var statearr_18073_18115 = state_18061__$1;(statearr_18073_18115[2] = null);
(statearr_18073_18115[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 13))
{var inst_18057 = (state_18061[2]);var state_18061__$1 = state_18061;var statearr_18074_18116 = state_18061__$1;(statearr_18074_18116[2] = inst_18057);
(statearr_18074_18116[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 22))
{var inst_18055 = (state_18061[2]);var state_18061__$1 = state_18061;var statearr_18075_18117 = state_18061__$1;(statearr_18075_18117[2] = inst_18055);
(statearr_18075_18117[1] = 13);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 6))
{var inst_18059 = (state_18061[2]);var state_18061__$1 = state_18061;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18061__$1,inst_18059);
} else
{if((state_val_18062 === 25))
{var state_18061__$1 = state_18061;var statearr_18076_18118 = state_18061__$1;(statearr_18076_18118[2] = null);
(statearr_18076_18118[1] = 26);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 17))
{var inst_18035 = (state_18061[14]);var state_18061__$1 = state_18061;var statearr_18077_18119 = state_18061__$1;(statearr_18077_18119[2] = inst_18035);
(statearr_18077_18119[1] = 19);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 3))
{var inst_17995 = (state_18061[9]);var state_18061__$1 = state_18061;var statearr_18078_18120 = state_18061__$1;(statearr_18078_18120[2] = inst_17995);
(statearr_18078_18120[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 12))
{var inst_18035 = (state_18061[14]);var inst_18021 = (state_18061[15]);var inst_18016 = (state_18061[16]);var inst_18035__$1 = inst_18016.call(null,inst_18021);var state_18061__$1 = (function (){var statearr_18079 = state_18061;(statearr_18079[14] = inst_18035__$1);
return statearr_18079;
})();if(cljs.core.truth_(inst_18035__$1))
{var statearr_18080_18121 = state_18061__$1;(statearr_18080_18121[1] = 17);
} else
{var statearr_18081_18122 = state_18061__$1;(statearr_18081_18122[1] = 18);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 2))
{var inst_17995 = (state_18061[9]);var inst_17998 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17995);var state_18061__$1 = state_18061;var statearr_18082_18123 = state_18061__$1;(statearr_18082_18123[2] = inst_17998);
(statearr_18082_18123[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 23))
{var inst_18046 = (state_18061[2]);var state_18061__$1 = state_18061;if(cljs.core.truth_(inst_18046))
{var statearr_18083_18124 = state_18061__$1;(statearr_18083_18124[1] = 24);
} else
{var statearr_18084_18125 = state_18061__$1;(statearr_18084_18125[1] = 25);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 19))
{var inst_18043 = (state_18061[2]);var state_18061__$1 = state_18061;if(cljs.core.truth_(inst_18043))
{var statearr_18085_18126 = state_18061__$1;(statearr_18085_18126[1] = 20);
} else
{var statearr_18086_18127 = state_18061__$1;(statearr_18086_18127[1] = 21);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 11))
{var inst_18020 = (state_18061[8]);var inst_18026 = (inst_18020 == null);var state_18061__$1 = state_18061;if(cljs.core.truth_(inst_18026))
{var statearr_18087_18128 = state_18061__$1;(statearr_18087_18128[1] = 14);
} else
{var statearr_18088_18129 = state_18061__$1;(statearr_18088_18129[1] = 15);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 9))
{var inst_18013 = (state_18061[10]);var inst_18013__$1 = (state_18061[2]);var inst_18014 = cljs.core.get.call(null,inst_18013__$1,new cljs.core.Keyword(null,"reads","reads",1122290959));var inst_18015 = cljs.core.get.call(null,inst_18013__$1,new cljs.core.Keyword(null,"mutes","mutes",1118168300));var inst_18016 = cljs.core.get.call(null,inst_18013__$1,new cljs.core.Keyword(null,"solos","solos",1123523302));var state_18061__$1 = (function (){var statearr_18089 = state_18061;(statearr_18089[10] = inst_18013__$1);
(statearr_18089[17] = inst_18015);
(statearr_18089[16] = inst_18016);
return statearr_18089;
})();return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_18061__$1,10,inst_18014);
} else
{if((state_val_18062 === 5))
{var inst_18005 = (state_18061[7]);var inst_18008 = cljs.core.seq_QMARK_.call(null,inst_18005);var state_18061__$1 = state_18061;if(inst_18008)
{var statearr_18090_18130 = state_18061__$1;(statearr_18090_18130[1] = 7);
} else
{var statearr_18091_18131 = state_18061__$1;(statearr_18091_18131[1] = 8);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 14))
{var inst_18021 = (state_18061[15]);var inst_18028 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18021);var state_18061__$1 = state_18061;var statearr_18092_18132 = state_18061__$1;(statearr_18092_18132[2] = inst_18028);
(statearr_18092_18132[1] = 16);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 26))
{var inst_18051 = (state_18061[2]);var state_18061__$1 = state_18061;var statearr_18093_18133 = state_18061__$1;(statearr_18093_18133[2] = inst_18051);
(statearr_18093_18133[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 16))
{var inst_18031 = (state_18061[2]);var inst_18032 = calc_state.call(null);var inst_18005 = inst_18032;var state_18061__$1 = (function (){var statearr_18094 = state_18061;(statearr_18094[18] = inst_18031);
(statearr_18094[7] = inst_18005);
return statearr_18094;
})();var statearr_18095_18134 = state_18061__$1;(statearr_18095_18134[2] = null);
(statearr_18095_18134[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 10))
{var inst_18020 = (state_18061[8]);var inst_18021 = (state_18061[15]);var inst_18019 = (state_18061[2]);var inst_18020__$1 = cljs.core.nth.call(null,inst_18019,0,null);var inst_18021__$1 = cljs.core.nth.call(null,inst_18019,1,null);var inst_18022 = (inst_18020__$1 == null);var inst_18023 = cljs.core._EQ_.call(null,inst_18021__$1,change);var inst_18024 = (inst_18022) || (inst_18023);var state_18061__$1 = (function (){var statearr_18096 = state_18061;(statearr_18096[8] = inst_18020__$1);
(statearr_18096[15] = inst_18021__$1);
return statearr_18096;
})();if(cljs.core.truth_(inst_18024))
{var statearr_18097_18135 = state_18061__$1;(statearr_18097_18135[1] = 11);
} else
{var statearr_18098_18136 = state_18061__$1;(statearr_18098_18136[1] = 12);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 18))
{var inst_18015 = (state_18061[17]);var inst_18021 = (state_18061[15]);var inst_18016 = (state_18061[16]);var inst_18038 = cljs.core.empty_QMARK_.call(null,inst_18016);var inst_18039 = inst_18015.call(null,inst_18021);var inst_18040 = cljs.core.not.call(null,inst_18039);var inst_18041 = (inst_18038) && (inst_18040);var state_18061__$1 = state_18061;var statearr_18099_18137 = state_18061__$1;(statearr_18099_18137[2] = inst_18041);
(statearr_18099_18137[1] = 19);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18062 === 8))
{var inst_18005 = (state_18061[7]);var state_18061__$1 = state_18061;var statearr_18100_18138 = state_18061__$1;(statearr_18100_18138[2] = inst_18005);
(statearr_18100_18138[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___18108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;return ((function (switch__11347__auto__,c__11412__auto___18108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_18104 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_18104[0] = state_machine__11348__auto__);
(statearr_18104[1] = 1);
return statearr_18104;
});
var state_machine__11348__auto____1 = (function (state_18061){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_18061);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e18105){if((e18105 instanceof Object))
{var ex__11351__auto__ = e18105;var statearr_18106_18139 = state_18061;(statearr_18106_18139[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18061);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e18105;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__18140 = state_18061;
state_18061 = G__18140;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_18061){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_18061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___18108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();var state__11414__auto__ = (function (){var statearr_18107 = f__11413__auto__.call(null);(statearr_18107[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___18108);
return statearr_18107;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___18108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj18142 = {};return obj18142;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__7917__auto__ = p;if(and__7917__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__7917__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__8556__auto__ = (((p == null))?null:p);return (function (){var or__7929__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__7917__auto__ = p;if(and__7917__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__7917__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__8556__auto__ = (((p == null))?null:p);return (function (){var or__7929__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__7917__auto__ = p;if(and__7917__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__7917__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__8556__auto__ = (((p == null))?null:p);return (function (){var or__7929__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__7917__auto__ = p;if(and__7917__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__7917__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__8556__auto__ = (((p == null))?null:p);return (function (){var or__7929__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__7929__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__7929__auto__,mults){
return (function (p1__18143_SHARP_){if(cljs.core.truth_(p1__18143_SHARP_.call(null,topic)))
{return p1__18143_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__18143_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__7929__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t18258 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t18258 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta18259){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta18259 = meta18259;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t18258.cljs$lang$type = true;
cljs.core.async.t18258.cljs$lang$ctorStr = "cljs.core.async/t18258";
cljs.core.async.t18258.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"cljs.core.async/t18258");
});})(mults,ensure_mult))
;
cljs.core.async.t18258.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t18258.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t18258.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4126__auto__))
{var m = temp__4126__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t18258.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t18258.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t18258.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t18258.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t18258.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18260){var self__ = this;
var _18260__$1 = this;return self__.meta18259;
});})(mults,ensure_mult))
;
cljs.core.async.t18258.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18260,meta18259__$1){var self__ = this;
var _18260__$1 = this;return (new cljs.core.async.t18258(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta18259__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t18258 = ((function (mults,ensure_mult){
return (function __GT_t18258(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta18259){return (new cljs.core.async.t18258(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta18259));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t18258(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__11412__auto___18372 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___18372,mults,ensure_mult,p){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___18372,mults,ensure_mult,p){
return (function (state_18328){var state_val_18329 = (state_18328[1]);if((state_val_18329 === 7))
{var inst_18324 = (state_18328[2]);var state_18328__$1 = state_18328;var statearr_18330_18373 = state_18328__$1;(statearr_18330_18373[2] = inst_18324);
(statearr_18330_18373[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 20))
{var state_18328__$1 = state_18328;var statearr_18331_18374 = state_18328__$1;(statearr_18331_18374[2] = null);
(statearr_18331_18374[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 1))
{var state_18328__$1 = state_18328;var statearr_18332_18375 = state_18328__$1;(statearr_18332_18375[2] = null);
(statearr_18332_18375[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 4))
{var inst_18263 = (state_18328[7]);var inst_18263__$1 = (state_18328[2]);var inst_18264 = (inst_18263__$1 == null);var state_18328__$1 = (function (){var statearr_18333 = state_18328;(statearr_18333[7] = inst_18263__$1);
return statearr_18333;
})();if(cljs.core.truth_(inst_18264))
{var statearr_18334_18376 = state_18328__$1;(statearr_18334_18376[1] = 5);
} else
{var statearr_18335_18377 = state_18328__$1;(statearr_18335_18377[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 15))
{var inst_18305 = (state_18328[2]);var state_18328__$1 = state_18328;var statearr_18336_18378 = state_18328__$1;(statearr_18336_18378[2] = inst_18305);
(statearr_18336_18378[1] = 12);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 21))
{var inst_18311 = (state_18328[8]);var inst_18319 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_18311);var state_18328__$1 = state_18328;var statearr_18337_18379 = state_18328__$1;(statearr_18337_18379[2] = inst_18319);
(statearr_18337_18379[1] = 22);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 13))
{var inst_18287 = (state_18328[9]);var inst_18289 = cljs.core.chunked_seq_QMARK_.call(null,inst_18287);var state_18328__$1 = state_18328;if(inst_18289)
{var statearr_18338_18380 = state_18328__$1;(statearr_18338_18380[1] = 16);
} else
{var statearr_18339_18381 = state_18328__$1;(statearr_18339_18381[1] = 17);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 22))
{var inst_18321 = (state_18328[2]);var state_18328__$1 = (function (){var statearr_18340 = state_18328;(statearr_18340[10] = inst_18321);
return statearr_18340;
})();var statearr_18341_18382 = state_18328__$1;(statearr_18341_18382[2] = null);
(statearr_18341_18382[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 6))
{var inst_18263 = (state_18328[7]);var inst_18311 = (state_18328[8]);var inst_18311__$1 = topic_fn.call(null,inst_18263);var inst_18312 = cljs.core.deref.call(null,mults);var inst_18313 = cljs.core.get.call(null,inst_18312,inst_18311__$1);var inst_18314 = cljs.core.async.muxch_STAR_.call(null,inst_18313);var state_18328__$1 = (function (){var statearr_18342 = state_18328;(statearr_18342[8] = inst_18311__$1);
return statearr_18342;
})();return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18328__$1,19,inst_18314,inst_18263);
} else
{if((state_val_18329 === 17))
{var inst_18287 = (state_18328[9]);var inst_18296 = cljs.core.first.call(null,inst_18287);var inst_18297 = cljs.core.async.muxch_STAR_.call(null,inst_18296);var inst_18298 = cljs.core.async.close_BANG_.call(null,inst_18297);var inst_18299 = cljs.core.next.call(null,inst_18287);var inst_18273 = inst_18299;var inst_18274 = null;var inst_18275 = 0;var inst_18276 = 0;var state_18328__$1 = (function (){var statearr_18343 = state_18328;(statearr_18343[11] = inst_18276);
(statearr_18343[12] = inst_18298);
(statearr_18343[13] = inst_18273);
(statearr_18343[14] = inst_18274);
(statearr_18343[15] = inst_18275);
return statearr_18343;
})();var statearr_18344_18383 = state_18328__$1;(statearr_18344_18383[2] = null);
(statearr_18344_18383[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 3))
{var inst_18326 = (state_18328[2]);var state_18328__$1 = state_18328;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18328__$1,inst_18326);
} else
{if((state_val_18329 === 12))
{var inst_18307 = (state_18328[2]);var state_18328__$1 = state_18328;var statearr_18345_18384 = state_18328__$1;(statearr_18345_18384[2] = inst_18307);
(statearr_18345_18384[1] = 9);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 2))
{var state_18328__$1 = state_18328;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18328__$1,4,ch);
} else
{if((state_val_18329 === 19))
{var inst_18316 = (state_18328[2]);var state_18328__$1 = state_18328;if(cljs.core.truth_(inst_18316))
{var statearr_18346_18385 = state_18328__$1;(statearr_18346_18385[1] = 20);
} else
{var statearr_18347_18386 = state_18328__$1;(statearr_18347_18386[1] = 21);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 11))
{var inst_18287 = (state_18328[9]);var inst_18273 = (state_18328[13]);var inst_18287__$1 = cljs.core.seq.call(null,inst_18273);var state_18328__$1 = (function (){var statearr_18348 = state_18328;(statearr_18348[9] = inst_18287__$1);
return statearr_18348;
})();if(inst_18287__$1)
{var statearr_18349_18387 = state_18328__$1;(statearr_18349_18387[1] = 13);
} else
{var statearr_18350_18388 = state_18328__$1;(statearr_18350_18388[1] = 14);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 9))
{var inst_18309 = (state_18328[2]);var state_18328__$1 = state_18328;var statearr_18351_18389 = state_18328__$1;(statearr_18351_18389[2] = inst_18309);
(statearr_18351_18389[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 5))
{var inst_18270 = cljs.core.deref.call(null,mults);var inst_18271 = cljs.core.vals.call(null,inst_18270);var inst_18272 = cljs.core.seq.call(null,inst_18271);var inst_18273 = inst_18272;var inst_18274 = null;var inst_18275 = 0;var inst_18276 = 0;var state_18328__$1 = (function (){var statearr_18352 = state_18328;(statearr_18352[11] = inst_18276);
(statearr_18352[13] = inst_18273);
(statearr_18352[14] = inst_18274);
(statearr_18352[15] = inst_18275);
return statearr_18352;
})();var statearr_18353_18390 = state_18328__$1;(statearr_18353_18390[2] = null);
(statearr_18353_18390[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 14))
{var state_18328__$1 = state_18328;var statearr_18357_18391 = state_18328__$1;(statearr_18357_18391[2] = null);
(statearr_18357_18391[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 16))
{var inst_18287 = (state_18328[9]);var inst_18291 = cljs.core.chunk_first.call(null,inst_18287);var inst_18292 = cljs.core.chunk_rest.call(null,inst_18287);var inst_18293 = cljs.core.count.call(null,inst_18291);var inst_18273 = inst_18292;var inst_18274 = inst_18291;var inst_18275 = inst_18293;var inst_18276 = 0;var state_18328__$1 = (function (){var statearr_18358 = state_18328;(statearr_18358[11] = inst_18276);
(statearr_18358[13] = inst_18273);
(statearr_18358[14] = inst_18274);
(statearr_18358[15] = inst_18275);
return statearr_18358;
})();var statearr_18359_18392 = state_18328__$1;(statearr_18359_18392[2] = null);
(statearr_18359_18392[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 10))
{var inst_18276 = (state_18328[11]);var inst_18273 = (state_18328[13]);var inst_18274 = (state_18328[14]);var inst_18275 = (state_18328[15]);var inst_18281 = cljs.core._nth.call(null,inst_18274,inst_18276);var inst_18282 = cljs.core.async.muxch_STAR_.call(null,inst_18281);var inst_18283 = cljs.core.async.close_BANG_.call(null,inst_18282);var inst_18284 = (inst_18276 + 1);var tmp18354 = inst_18273;var tmp18355 = inst_18274;var tmp18356 = inst_18275;var inst_18273__$1 = tmp18354;var inst_18274__$1 = tmp18355;var inst_18275__$1 = tmp18356;var inst_18276__$1 = inst_18284;var state_18328__$1 = (function (){var statearr_18360 = state_18328;(statearr_18360[11] = inst_18276__$1);
(statearr_18360[16] = inst_18283);
(statearr_18360[13] = inst_18273__$1);
(statearr_18360[14] = inst_18274__$1);
(statearr_18360[15] = inst_18275__$1);
return statearr_18360;
})();var statearr_18361_18393 = state_18328__$1;(statearr_18361_18393[2] = null);
(statearr_18361_18393[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 18))
{var inst_18302 = (state_18328[2]);var state_18328__$1 = state_18328;var statearr_18362_18394 = state_18328__$1;(statearr_18362_18394[2] = inst_18302);
(statearr_18362_18394[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18329 === 8))
{var inst_18276 = (state_18328[11]);var inst_18275 = (state_18328[15]);var inst_18278 = (inst_18276 < inst_18275);var inst_18279 = inst_18278;var state_18328__$1 = state_18328;if(cljs.core.truth_(inst_18279))
{var statearr_18363_18395 = state_18328__$1;(statearr_18363_18395[1] = 10);
} else
{var statearr_18364_18396 = state_18328__$1;(statearr_18364_18396[1] = 11);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___18372,mults,ensure_mult,p))
;return ((function (switch__11347__auto__,c__11412__auto___18372,mults,ensure_mult,p){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_18368 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_18368[0] = state_machine__11348__auto__);
(statearr_18368[1] = 1);
return statearr_18368;
});
var state_machine__11348__auto____1 = (function (state_18328){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_18328);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e18369){if((e18369 instanceof Object))
{var ex__11351__auto__ = e18369;var statearr_18370_18397 = state_18328;(statearr_18370_18397[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18328);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e18369;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__18398 = state_18328;
state_18328 = G__18398;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_18328){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_18328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___18372,mults,ensure_mult,p))
})();var state__11414__auto__ = (function (){var statearr_18371 = f__11413__auto__.call(null);(statearr_18371[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___18372);
return statearr_18371;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___18372,mults,ensure_mult,p))
);
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,1);var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === 0))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice(0));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__11412__auto___18535 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___18535,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___18535,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18505){var state_val_18506 = (state_18505[1]);if((state_val_18506 === 7))
{var state_18505__$1 = state_18505;var statearr_18507_18536 = state_18505__$1;(statearr_18507_18536[2] = null);
(statearr_18507_18536[1] = 8);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 1))
{var state_18505__$1 = state_18505;var statearr_18508_18537 = state_18505__$1;(statearr_18508_18537[2] = null);
(statearr_18508_18537[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 4))
{var inst_18469 = (state_18505[7]);var inst_18471 = (inst_18469 < cnt);var state_18505__$1 = state_18505;if(cljs.core.truth_(inst_18471))
{var statearr_18509_18538 = state_18505__$1;(statearr_18509_18538[1] = 6);
} else
{var statearr_18510_18539 = state_18505__$1;(statearr_18510_18539[1] = 7);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 15))
{var inst_18501 = (state_18505[2]);var state_18505__$1 = state_18505;var statearr_18511_18540 = state_18505__$1;(statearr_18511_18540[2] = inst_18501);
(statearr_18511_18540[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 13))
{var inst_18494 = cljs.core.async.close_BANG_.call(null,out);var state_18505__$1 = state_18505;var statearr_18512_18541 = state_18505__$1;(statearr_18512_18541[2] = inst_18494);
(statearr_18512_18541[1] = 15);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 6))
{var state_18505__$1 = state_18505;var statearr_18513_18542 = state_18505__$1;(statearr_18513_18542[2] = null);
(statearr_18513_18542[1] = 11);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 3))
{var inst_18503 = (state_18505[2]);var state_18505__$1 = state_18505;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18505__$1,inst_18503);
} else
{if((state_val_18506 === 12))
{var inst_18491 = (state_18505[8]);var inst_18491__$1 = (state_18505[2]);var inst_18492 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_18491__$1);var state_18505__$1 = (function (){var statearr_18514 = state_18505;(statearr_18514[8] = inst_18491__$1);
return statearr_18514;
})();if(cljs.core.truth_(inst_18492))
{var statearr_18515_18543 = state_18505__$1;(statearr_18515_18543[1] = 13);
} else
{var statearr_18516_18544 = state_18505__$1;(statearr_18516_18544[1] = 14);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 2))
{var inst_18468 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_18469 = 0;var state_18505__$1 = (function (){var statearr_18517 = state_18505;(statearr_18517[7] = inst_18469);
(statearr_18517[9] = inst_18468);
return statearr_18517;
})();var statearr_18518_18545 = state_18505__$1;(statearr_18518_18545[2] = null);
(statearr_18518_18545[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 11))
{var inst_18469 = (state_18505[7]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_18505,10,Object,null,9);var inst_18478 = chs__$1.call(null,inst_18469);var inst_18479 = done.call(null,inst_18469);var inst_18480 = cljs.core.async.take_BANG_.call(null,inst_18478,inst_18479);var state_18505__$1 = state_18505;var statearr_18519_18546 = state_18505__$1;(statearr_18519_18546[2] = inst_18480);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18505__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 9))
{var inst_18469 = (state_18505[7]);var inst_18482 = (state_18505[2]);var inst_18483 = (inst_18469 + 1);var inst_18469__$1 = inst_18483;var state_18505__$1 = (function (){var statearr_18520 = state_18505;(statearr_18520[7] = inst_18469__$1);
(statearr_18520[10] = inst_18482);
return statearr_18520;
})();var statearr_18521_18547 = state_18505__$1;(statearr_18521_18547[2] = null);
(statearr_18521_18547[1] = 4);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 5))
{var inst_18489 = (state_18505[2]);var state_18505__$1 = (function (){var statearr_18522 = state_18505;(statearr_18522[11] = inst_18489);
return statearr_18522;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18505__$1,12,dchan);
} else
{if((state_val_18506 === 14))
{var inst_18491 = (state_18505[8]);var inst_18496 = cljs.core.apply.call(null,f,inst_18491);var state_18505__$1 = state_18505;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18505__$1,16,out,inst_18496);
} else
{if((state_val_18506 === 16))
{var inst_18498 = (state_18505[2]);var state_18505__$1 = (function (){var statearr_18523 = state_18505;(statearr_18523[12] = inst_18498);
return statearr_18523;
})();var statearr_18524_18548 = state_18505__$1;(statearr_18524_18548[2] = null);
(statearr_18524_18548[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 10))
{var inst_18473 = (state_18505[2]);var inst_18474 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_18505__$1 = (function (){var statearr_18525 = state_18505;(statearr_18525[13] = inst_18473);
return statearr_18525;
})();var statearr_18526_18549 = state_18505__$1;(statearr_18526_18549[2] = inst_18474);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18505__$1);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18506 === 8))
{var inst_18487 = (state_18505[2]);var state_18505__$1 = state_18505;var statearr_18527_18550 = state_18505__$1;(statearr_18527_18550[2] = inst_18487);
(statearr_18527_18550[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___18535,chs__$1,out,cnt,rets,dchan,dctr,done))
;return ((function (switch__11347__auto__,c__11412__auto___18535,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_18531 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_18531[0] = state_machine__11348__auto__);
(statearr_18531[1] = 1);
return statearr_18531;
});
var state_machine__11348__auto____1 = (function (state_18505){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_18505);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e18532){if((e18532 instanceof Object))
{var ex__11351__auto__ = e18532;var statearr_18533_18551 = state_18505;(statearr_18533_18551[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18505);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e18532;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__18552 = state_18505;
state_18505 = G__18552;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_18505){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_18505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___18535,chs__$1,out,cnt,rets,dchan,dctr,done))
})();var state__11414__auto__ = (function (){var statearr_18534 = f__11413__auto__.call(null);(statearr_18534[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___18535);
return statearr_18534;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___18535,chs__$1,out,cnt,rets,dchan,dctr,done))
);
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11412__auto___18660 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___18660,out){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___18660,out){
return (function (state_18636){var state_val_18637 = (state_18636[1]);if((state_val_18637 === 7))
{var inst_18615 = (state_18636[7]);var inst_18616 = (state_18636[8]);var inst_18615__$1 = (state_18636[2]);var inst_18616__$1 = cljs.core.nth.call(null,inst_18615__$1,0,null);var inst_18617 = cljs.core.nth.call(null,inst_18615__$1,1,null);var inst_18618 = (inst_18616__$1 == null);var state_18636__$1 = (function (){var statearr_18638 = state_18636;(statearr_18638[7] = inst_18615__$1);
(statearr_18638[8] = inst_18616__$1);
(statearr_18638[9] = inst_18617);
return statearr_18638;
})();if(cljs.core.truth_(inst_18618))
{var statearr_18639_18661 = state_18636__$1;(statearr_18639_18661[1] = 8);
} else
{var statearr_18640_18662 = state_18636__$1;(statearr_18640_18662[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18637 === 1))
{var inst_18607 = cljs.core.vec.call(null,chs);var inst_18608 = inst_18607;var state_18636__$1 = (function (){var statearr_18641 = state_18636;(statearr_18641[10] = inst_18608);
return statearr_18641;
})();var statearr_18642_18663 = state_18636__$1;(statearr_18642_18663[2] = null);
(statearr_18642_18663[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18637 === 4))
{var inst_18608 = (state_18636[10]);var state_18636__$1 = state_18636;return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_18636__$1,7,inst_18608);
} else
{if((state_val_18637 === 6))
{var inst_18632 = (state_18636[2]);var state_18636__$1 = state_18636;var statearr_18643_18664 = state_18636__$1;(statearr_18643_18664[2] = inst_18632);
(statearr_18643_18664[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18637 === 3))
{var inst_18634 = (state_18636[2]);var state_18636__$1 = state_18636;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18636__$1,inst_18634);
} else
{if((state_val_18637 === 2))
{var inst_18608 = (state_18636[10]);var inst_18610 = cljs.core.count.call(null,inst_18608);var inst_18611 = (inst_18610 > 0);var state_18636__$1 = state_18636;if(cljs.core.truth_(inst_18611))
{var statearr_18645_18665 = state_18636__$1;(statearr_18645_18665[1] = 4);
} else
{var statearr_18646_18666 = state_18636__$1;(statearr_18646_18666[1] = 5);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18637 === 11))
{var inst_18608 = (state_18636[10]);var inst_18625 = (state_18636[2]);var tmp18644 = inst_18608;var inst_18608__$1 = tmp18644;var state_18636__$1 = (function (){var statearr_18647 = state_18636;(statearr_18647[10] = inst_18608__$1);
(statearr_18647[11] = inst_18625);
return statearr_18647;
})();var statearr_18648_18667 = state_18636__$1;(statearr_18648_18667[2] = null);
(statearr_18648_18667[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18637 === 9))
{var inst_18616 = (state_18636[8]);var state_18636__$1 = state_18636;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18636__$1,11,out,inst_18616);
} else
{if((state_val_18637 === 5))
{var inst_18630 = cljs.core.async.close_BANG_.call(null,out);var state_18636__$1 = state_18636;var statearr_18649_18668 = state_18636__$1;(statearr_18649_18668[2] = inst_18630);
(statearr_18649_18668[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18637 === 10))
{var inst_18628 = (state_18636[2]);var state_18636__$1 = state_18636;var statearr_18650_18669 = state_18636__$1;(statearr_18650_18669[2] = inst_18628);
(statearr_18650_18669[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18637 === 8))
{var inst_18608 = (state_18636[10]);var inst_18615 = (state_18636[7]);var inst_18616 = (state_18636[8]);var inst_18617 = (state_18636[9]);var inst_18620 = (function (){var c = inst_18617;var v = inst_18616;var vec__18613 = inst_18615;var cs = inst_18608;return ((function (c,v,vec__18613,cs,inst_18608,inst_18615,inst_18616,inst_18617,state_val_18637,c__11412__auto___18660,out){
return (function (p1__18553_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__18553_SHARP_);
});
;})(c,v,vec__18613,cs,inst_18608,inst_18615,inst_18616,inst_18617,state_val_18637,c__11412__auto___18660,out))
})();var inst_18621 = cljs.core.filterv.call(null,inst_18620,inst_18608);var inst_18608__$1 = inst_18621;var state_18636__$1 = (function (){var statearr_18651 = state_18636;(statearr_18651[10] = inst_18608__$1);
return statearr_18651;
})();var statearr_18652_18670 = state_18636__$1;(statearr_18652_18670[2] = null);
(statearr_18652_18670[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___18660,out))
;return ((function (switch__11347__auto__,c__11412__auto___18660,out){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_18656 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_18656[0] = state_machine__11348__auto__);
(statearr_18656[1] = 1);
return statearr_18656;
});
var state_machine__11348__auto____1 = (function (state_18636){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_18636);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e18657){if((e18657 instanceof Object))
{var ex__11351__auto__ = e18657;var statearr_18658_18671 = state_18636;(statearr_18658_18671[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18636);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e18657;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__18672 = state_18636;
state_18636 = G__18672;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_18636){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_18636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___18660,out))
})();var state__11414__auto__ = (function (){var statearr_18659 = f__11413__auto__.call(null);(statearr_18659[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___18660);
return statearr_18659;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___18660,out))
);
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11412__auto___18765 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___18765,out){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___18765,out){
return (function (state_18742){var state_val_18743 = (state_18742[1]);if((state_val_18743 === 7))
{var inst_18724 = (state_18742[7]);var inst_18724__$1 = (state_18742[2]);var inst_18725 = (inst_18724__$1 == null);var inst_18726 = cljs.core.not.call(null,inst_18725);var state_18742__$1 = (function (){var statearr_18744 = state_18742;(statearr_18744[7] = inst_18724__$1);
return statearr_18744;
})();if(inst_18726)
{var statearr_18745_18766 = state_18742__$1;(statearr_18745_18766[1] = 8);
} else
{var statearr_18746_18767 = state_18742__$1;(statearr_18746_18767[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18743 === 1))
{var inst_18719 = 0;var state_18742__$1 = (function (){var statearr_18747 = state_18742;(statearr_18747[8] = inst_18719);
return statearr_18747;
})();var statearr_18748_18768 = state_18742__$1;(statearr_18748_18768[2] = null);
(statearr_18748_18768[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18743 === 4))
{var state_18742__$1 = state_18742;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18742__$1,7,ch);
} else
{if((state_val_18743 === 6))
{var inst_18737 = (state_18742[2]);var state_18742__$1 = state_18742;var statearr_18749_18769 = state_18742__$1;(statearr_18749_18769[2] = inst_18737);
(statearr_18749_18769[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18743 === 3))
{var inst_18739 = (state_18742[2]);var inst_18740 = cljs.core.async.close_BANG_.call(null,out);var state_18742__$1 = (function (){var statearr_18750 = state_18742;(statearr_18750[9] = inst_18739);
return statearr_18750;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18742__$1,inst_18740);
} else
{if((state_val_18743 === 2))
{var inst_18719 = (state_18742[8]);var inst_18721 = (inst_18719 < n);var state_18742__$1 = state_18742;if(cljs.core.truth_(inst_18721))
{var statearr_18751_18770 = state_18742__$1;(statearr_18751_18770[1] = 4);
} else
{var statearr_18752_18771 = state_18742__$1;(statearr_18752_18771[1] = 5);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18743 === 11))
{var inst_18719 = (state_18742[8]);var inst_18729 = (state_18742[2]);var inst_18730 = (inst_18719 + 1);var inst_18719__$1 = inst_18730;var state_18742__$1 = (function (){var statearr_18753 = state_18742;(statearr_18753[8] = inst_18719__$1);
(statearr_18753[10] = inst_18729);
return statearr_18753;
})();var statearr_18754_18772 = state_18742__$1;(statearr_18754_18772[2] = null);
(statearr_18754_18772[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18743 === 9))
{var state_18742__$1 = state_18742;var statearr_18755_18773 = state_18742__$1;(statearr_18755_18773[2] = null);
(statearr_18755_18773[1] = 10);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18743 === 5))
{var state_18742__$1 = state_18742;var statearr_18756_18774 = state_18742__$1;(statearr_18756_18774[2] = null);
(statearr_18756_18774[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18743 === 10))
{var inst_18734 = (state_18742[2]);var state_18742__$1 = state_18742;var statearr_18757_18775 = state_18742__$1;(statearr_18757_18775[2] = inst_18734);
(statearr_18757_18775[1] = 6);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18743 === 8))
{var inst_18724 = (state_18742[7]);var state_18742__$1 = state_18742;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18742__$1,11,out,inst_18724);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___18765,out))
;return ((function (switch__11347__auto__,c__11412__auto___18765,out){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_18761 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_18761[0] = state_machine__11348__auto__);
(statearr_18761[1] = 1);
return statearr_18761;
});
var state_machine__11348__auto____1 = (function (state_18742){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_18742);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e18762){if((e18762 instanceof Object))
{var ex__11351__auto__ = e18762;var statearr_18763_18776 = state_18742;(statearr_18763_18776[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18742);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e18762;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__18777 = state_18742;
state_18742 = G__18777;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_18742){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_18742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___18765,out))
})();var state__11414__auto__ = (function (){var statearr_18764 = f__11413__auto__.call(null);(statearr_18764[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___18765);
return statearr_18764;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___18765,out))
);
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Returns a channel that will contain values from ch. Consecutive duplicate
* values will be dropped.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11412__auto___18874 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___18874,out){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___18874,out){
return (function (state_18849){var state_val_18850 = (state_18849[1]);if((state_val_18850 === 7))
{var inst_18844 = (state_18849[2]);var state_18849__$1 = state_18849;var statearr_18851_18875 = state_18849__$1;(statearr_18851_18875[2] = inst_18844);
(statearr_18851_18875[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18850 === 1))
{var inst_18826 = null;var state_18849__$1 = (function (){var statearr_18852 = state_18849;(statearr_18852[7] = inst_18826);
return statearr_18852;
})();var statearr_18853_18876 = state_18849__$1;(statearr_18853_18876[2] = null);
(statearr_18853_18876[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18850 === 4))
{var inst_18829 = (state_18849[8]);var inst_18829__$1 = (state_18849[2]);var inst_18830 = (inst_18829__$1 == null);var inst_18831 = cljs.core.not.call(null,inst_18830);var state_18849__$1 = (function (){var statearr_18854 = state_18849;(statearr_18854[8] = inst_18829__$1);
return statearr_18854;
})();if(inst_18831)
{var statearr_18855_18877 = state_18849__$1;(statearr_18855_18877[1] = 5);
} else
{var statearr_18856_18878 = state_18849__$1;(statearr_18856_18878[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18850 === 6))
{var state_18849__$1 = state_18849;var statearr_18857_18879 = state_18849__$1;(statearr_18857_18879[2] = null);
(statearr_18857_18879[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18850 === 3))
{var inst_18846 = (state_18849[2]);var inst_18847 = cljs.core.async.close_BANG_.call(null,out);var state_18849__$1 = (function (){var statearr_18858 = state_18849;(statearr_18858[9] = inst_18846);
return statearr_18858;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18849__$1,inst_18847);
} else
{if((state_val_18850 === 2))
{var state_18849__$1 = state_18849;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18849__$1,4,ch);
} else
{if((state_val_18850 === 11))
{var inst_18829 = (state_18849[8]);var inst_18838 = (state_18849[2]);var inst_18826 = inst_18829;var state_18849__$1 = (function (){var statearr_18859 = state_18849;(statearr_18859[10] = inst_18838);
(statearr_18859[7] = inst_18826);
return statearr_18859;
})();var statearr_18860_18880 = state_18849__$1;(statearr_18860_18880[2] = null);
(statearr_18860_18880[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18850 === 9))
{var inst_18829 = (state_18849[8]);var state_18849__$1 = state_18849;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18849__$1,11,out,inst_18829);
} else
{if((state_val_18850 === 5))
{var inst_18829 = (state_18849[8]);var inst_18826 = (state_18849[7]);var inst_18833 = cljs.core._EQ_.call(null,inst_18829,inst_18826);var state_18849__$1 = state_18849;if(inst_18833)
{var statearr_18862_18881 = state_18849__$1;(statearr_18862_18881[1] = 8);
} else
{var statearr_18863_18882 = state_18849__$1;(statearr_18863_18882[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18850 === 10))
{var inst_18841 = (state_18849[2]);var state_18849__$1 = state_18849;var statearr_18864_18883 = state_18849__$1;(statearr_18864_18883[2] = inst_18841);
(statearr_18864_18883[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18850 === 8))
{var inst_18826 = (state_18849[7]);var tmp18861 = inst_18826;var inst_18826__$1 = tmp18861;var state_18849__$1 = (function (){var statearr_18865 = state_18849;(statearr_18865[7] = inst_18826__$1);
return statearr_18865;
})();var statearr_18866_18884 = state_18849__$1;(statearr_18866_18884[2] = null);
(statearr_18866_18884[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___18874,out))
;return ((function (switch__11347__auto__,c__11412__auto___18874,out){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_18870 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_18870[0] = state_machine__11348__auto__);
(statearr_18870[1] = 1);
return statearr_18870;
});
var state_machine__11348__auto____1 = (function (state_18849){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_18849);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e18871){if((e18871 instanceof Object))
{var ex__11351__auto__ = e18871;var statearr_18872_18885 = state_18849;(statearr_18872_18885[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18849);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e18871;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__18886 = state_18849;
state_18849 = G__18886;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_18849){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_18849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___18874,out))
})();var state__11414__auto__ = (function (){var statearr_18873 = f__11413__auto__.call(null);(statearr_18873[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___18874);
return statearr_18873;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___18874,out))
);
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Returns a channel that will contain vectors of n items taken from ch. The
* final vector in the return channel may be smaller than n if ch closed before
* the vector could be completely filled.
* 
* The output channel is unbuffered by default, unless buf-or-n is given
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11412__auto___19021 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___19021,out){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___19021,out){
return (function (state_18991){var state_val_18992 = (state_18991[1]);if((state_val_18992 === 7))
{var inst_18987 = (state_18991[2]);var state_18991__$1 = state_18991;var statearr_18993_19022 = state_18991__$1;(statearr_18993_19022[2] = inst_18987);
(statearr_18993_19022[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 1))
{var inst_18954 = (new Array(n));var inst_18955 = inst_18954;var inst_18956 = 0;var state_18991__$1 = (function (){var statearr_18994 = state_18991;(statearr_18994[7] = inst_18955);
(statearr_18994[8] = inst_18956);
return statearr_18994;
})();var statearr_18995_19023 = state_18991__$1;(statearr_18995_19023[2] = null);
(statearr_18995_19023[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 4))
{var inst_18959 = (state_18991[9]);var inst_18959__$1 = (state_18991[2]);var inst_18960 = (inst_18959__$1 == null);var inst_18961 = cljs.core.not.call(null,inst_18960);var state_18991__$1 = (function (){var statearr_18996 = state_18991;(statearr_18996[9] = inst_18959__$1);
return statearr_18996;
})();if(inst_18961)
{var statearr_18997_19024 = state_18991__$1;(statearr_18997_19024[1] = 5);
} else
{var statearr_18998_19025 = state_18991__$1;(statearr_18998_19025[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 15))
{var inst_18981 = (state_18991[2]);var state_18991__$1 = state_18991;var statearr_18999_19026 = state_18991__$1;(statearr_18999_19026[2] = inst_18981);
(statearr_18999_19026[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 13))
{var state_18991__$1 = state_18991;var statearr_19000_19027 = state_18991__$1;(statearr_19000_19027[2] = null);
(statearr_19000_19027[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 6))
{var inst_18956 = (state_18991[8]);var inst_18977 = (inst_18956 > 0);var state_18991__$1 = state_18991;if(cljs.core.truth_(inst_18977))
{var statearr_19001_19028 = state_18991__$1;(statearr_19001_19028[1] = 12);
} else
{var statearr_19002_19029 = state_18991__$1;(statearr_19002_19029[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 3))
{var inst_18989 = (state_18991[2]);var state_18991__$1 = state_18991;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18991__$1,inst_18989);
} else
{if((state_val_18992 === 12))
{var inst_18955 = (state_18991[7]);var inst_18979 = cljs.core.vec.call(null,inst_18955);var state_18991__$1 = state_18991;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18991__$1,15,out,inst_18979);
} else
{if((state_val_18992 === 2))
{var state_18991__$1 = state_18991;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18991__$1,4,ch);
} else
{if((state_val_18992 === 11))
{var inst_18971 = (state_18991[2]);var inst_18972 = (new Array(n));var inst_18955 = inst_18972;var inst_18956 = 0;var state_18991__$1 = (function (){var statearr_19003 = state_18991;(statearr_19003[7] = inst_18955);
(statearr_19003[10] = inst_18971);
(statearr_19003[8] = inst_18956);
return statearr_19003;
})();var statearr_19004_19030 = state_18991__$1;(statearr_19004_19030[2] = null);
(statearr_19004_19030[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 9))
{var inst_18955 = (state_18991[7]);var inst_18969 = cljs.core.vec.call(null,inst_18955);var state_18991__$1 = state_18991;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18991__$1,11,out,inst_18969);
} else
{if((state_val_18992 === 5))
{var inst_18964 = (state_18991[11]);var inst_18955 = (state_18991[7]);var inst_18959 = (state_18991[9]);var inst_18956 = (state_18991[8]);var inst_18963 = (inst_18955[inst_18956] = inst_18959);var inst_18964__$1 = (inst_18956 + 1);var inst_18965 = (inst_18964__$1 < n);var state_18991__$1 = (function (){var statearr_19005 = state_18991;(statearr_19005[11] = inst_18964__$1);
(statearr_19005[12] = inst_18963);
return statearr_19005;
})();if(cljs.core.truth_(inst_18965))
{var statearr_19006_19031 = state_18991__$1;(statearr_19006_19031[1] = 8);
} else
{var statearr_19007_19032 = state_18991__$1;(statearr_19007_19032[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 14))
{var inst_18984 = (state_18991[2]);var inst_18985 = cljs.core.async.close_BANG_.call(null,out);var state_18991__$1 = (function (){var statearr_19009 = state_18991;(statearr_19009[13] = inst_18984);
return statearr_19009;
})();var statearr_19010_19033 = state_18991__$1;(statearr_19010_19033[2] = inst_18985);
(statearr_19010_19033[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 10))
{var inst_18975 = (state_18991[2]);var state_18991__$1 = state_18991;var statearr_19011_19034 = state_18991__$1;(statearr_19011_19034[2] = inst_18975);
(statearr_19011_19034[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_18992 === 8))
{var inst_18964 = (state_18991[11]);var inst_18955 = (state_18991[7]);var tmp19008 = inst_18955;var inst_18955__$1 = tmp19008;var inst_18956 = inst_18964;var state_18991__$1 = (function (){var statearr_19012 = state_18991;(statearr_19012[7] = inst_18955__$1);
(statearr_19012[8] = inst_18956);
return statearr_19012;
})();var statearr_19013_19035 = state_18991__$1;(statearr_19013_19035[2] = null);
(statearr_19013_19035[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___19021,out))
;return ((function (switch__11347__auto__,c__11412__auto___19021,out){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_19017 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_19017[0] = state_machine__11348__auto__);
(statearr_19017[1] = 1);
return statearr_19017;
});
var state_machine__11348__auto____1 = (function (state_18991){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_18991);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e19018){if((e19018 instanceof Object))
{var ex__11351__auto__ = e19018;var statearr_19019_19036 = state_18991;(statearr_19019_19036[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18991);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e19018;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__19037 = state_18991;
state_18991 = G__19037;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_18991){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_18991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___19021,out))
})();var state__11414__auto__ = (function (){var statearr_19020 = f__11413__auto__.call(null);(statearr_19020[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___19021);
return statearr_19020;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___19021,out))
);
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Returns a channel that will contain vectors of items taken from ch. New
* vectors will be created whenever (f itm) returns a value that differs from
* the previous item's (f itm).
* 
* The output channel is unbuffered, unless buf-or-n is given
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11412__auto___19180 = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto___19180,out){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto___19180,out){
return (function (state_19150){var state_val_19151 = (state_19150[1]);if((state_val_19151 === 7))
{var inst_19146 = (state_19150[2]);var state_19150__$1 = state_19150;var statearr_19152_19181 = state_19150__$1;(statearr_19152_19181[2] = inst_19146);
(statearr_19152_19181[1] = 3);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 1))
{var inst_19109 = [];var inst_19110 = inst_19109;var inst_19111 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",4382193538);var state_19150__$1 = (function (){var statearr_19153 = state_19150;(statearr_19153[7] = inst_19110);
(statearr_19153[8] = inst_19111);
return statearr_19153;
})();var statearr_19154_19182 = state_19150__$1;(statearr_19154_19182[2] = null);
(statearr_19154_19182[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 4))
{var inst_19114 = (state_19150[9]);var inst_19114__$1 = (state_19150[2]);var inst_19115 = (inst_19114__$1 == null);var inst_19116 = cljs.core.not.call(null,inst_19115);var state_19150__$1 = (function (){var statearr_19155 = state_19150;(statearr_19155[9] = inst_19114__$1);
return statearr_19155;
})();if(inst_19116)
{var statearr_19156_19183 = state_19150__$1;(statearr_19156_19183[1] = 5);
} else
{var statearr_19157_19184 = state_19150__$1;(statearr_19157_19184[1] = 6);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 15))
{var inst_19140 = (state_19150[2]);var state_19150__$1 = state_19150;var statearr_19158_19185 = state_19150__$1;(statearr_19158_19185[2] = inst_19140);
(statearr_19158_19185[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 13))
{var state_19150__$1 = state_19150;var statearr_19159_19186 = state_19150__$1;(statearr_19159_19186[2] = null);
(statearr_19159_19186[1] = 14);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 6))
{var inst_19110 = (state_19150[7]);var inst_19135 = inst_19110.length;var inst_19136 = (inst_19135 > 0);var state_19150__$1 = state_19150;if(cljs.core.truth_(inst_19136))
{var statearr_19160_19187 = state_19150__$1;(statearr_19160_19187[1] = 12);
} else
{var statearr_19161_19188 = state_19150__$1;(statearr_19161_19188[1] = 13);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 3))
{var inst_19148 = (state_19150[2]);var state_19150__$1 = state_19150;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19150__$1,inst_19148);
} else
{if((state_val_19151 === 12))
{var inst_19110 = (state_19150[7]);var inst_19138 = cljs.core.vec.call(null,inst_19110);var state_19150__$1 = state_19150;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19150__$1,15,out,inst_19138);
} else
{if((state_val_19151 === 2))
{var state_19150__$1 = state_19150;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19150__$1,4,ch);
} else
{if((state_val_19151 === 11))
{var inst_19118 = (state_19150[10]);var inst_19114 = (state_19150[9]);var inst_19128 = (state_19150[2]);var inst_19129 = [];var inst_19130 = inst_19129.push(inst_19114);var inst_19110 = inst_19129;var inst_19111 = inst_19118;var state_19150__$1 = (function (){var statearr_19162 = state_19150;(statearr_19162[11] = inst_19130);
(statearr_19162[12] = inst_19128);
(statearr_19162[7] = inst_19110);
(statearr_19162[8] = inst_19111);
return statearr_19162;
})();var statearr_19163_19189 = state_19150__$1;(statearr_19163_19189[2] = null);
(statearr_19163_19189[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 9))
{var inst_19110 = (state_19150[7]);var inst_19126 = cljs.core.vec.call(null,inst_19110);var state_19150__$1 = state_19150;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19150__$1,11,out,inst_19126);
} else
{if((state_val_19151 === 5))
{var inst_19118 = (state_19150[10]);var inst_19111 = (state_19150[8]);var inst_19114 = (state_19150[9]);var inst_19118__$1 = f.call(null,inst_19114);var inst_19119 = cljs.core._EQ_.call(null,inst_19118__$1,inst_19111);var inst_19120 = cljs.core.keyword_identical_QMARK_.call(null,inst_19111,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",4382193538));var inst_19121 = (inst_19119) || (inst_19120);var state_19150__$1 = (function (){var statearr_19164 = state_19150;(statearr_19164[10] = inst_19118__$1);
return statearr_19164;
})();if(cljs.core.truth_(inst_19121))
{var statearr_19165_19190 = state_19150__$1;(statearr_19165_19190[1] = 8);
} else
{var statearr_19166_19191 = state_19150__$1;(statearr_19166_19191[1] = 9);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 14))
{var inst_19143 = (state_19150[2]);var inst_19144 = cljs.core.async.close_BANG_.call(null,out);var state_19150__$1 = (function (){var statearr_19168 = state_19150;(statearr_19168[13] = inst_19143);
return statearr_19168;
})();var statearr_19169_19192 = state_19150__$1;(statearr_19169_19192[2] = inst_19144);
(statearr_19169_19192[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 10))
{var inst_19133 = (state_19150[2]);var state_19150__$1 = state_19150;var statearr_19170_19193 = state_19150__$1;(statearr_19170_19193[2] = inst_19133);
(statearr_19170_19193[1] = 7);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_19151 === 8))
{var inst_19118 = (state_19150[10]);var inst_19110 = (state_19150[7]);var inst_19114 = (state_19150[9]);var inst_19123 = inst_19110.push(inst_19114);var tmp19167 = inst_19110;var inst_19110__$1 = tmp19167;var inst_19111 = inst_19118;var state_19150__$1 = (function (){var statearr_19171 = state_19150;(statearr_19171[7] = inst_19110__$1);
(statearr_19171[8] = inst_19111);
(statearr_19171[14] = inst_19123);
return statearr_19171;
})();var statearr_19172_19194 = state_19150__$1;(statearr_19172_19194[2] = null);
(statearr_19172_19194[1] = 2);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11412__auto___19180,out))
;return ((function (switch__11347__auto__,c__11412__auto___19180,out){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_19176 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_19176[0] = state_machine__11348__auto__);
(statearr_19176[1] = 1);
return statearr_19176;
});
var state_machine__11348__auto____1 = (function (state_19150){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_19150);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e19177){if((e19177 instanceof Object))
{var ex__11351__auto__ = e19177;var statearr_19178_19195 = state_19150;(statearr_19178_19195[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19150);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e19177;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__19196 = state_19150;
state_19150 = G__19196;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_19150){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_19150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto___19180,out))
})();var state__11414__auto__ = (function (){var statearr_19179 = f__11413__auto__.call(null);(statearr_19179[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto___19180);
return statearr_19179;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto___19180,out))
);
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;

//# sourceMappingURL=async.js.map