(ns leiningen.new.wisui
  (:require [leiningen.new.templates
             :refer
             [renderer name-to-path ->files
              sanitize sanitize-ns project-name]]
            [leiningen.core.main :as main]))

(def render (renderer "wisui"))

(defn jvm>8? []
  (try
    (> (Double/parseDouble (subs (System/getProperty "java.version") 0 3)) 1.8)
    (catch Exception _)))

(defn template-data [name]
  {:full-name name
   :name (project-name name)
   :jvm-opts-hook? (jvm>8?)
   :project-goog-module (sanitize (sanitize-ns name))
   :project-ns (sanitize-ns name)
   :sanitized (name-to-path name)})

(defn generate [name]
  (let [data (template-data name)]
    (->files
      data
      ["project.clj" (render "project.clj" data)]
      ["public/css/basic.css" (render "public/css/basic.css" data)]
      ["public/css/busi.css" (render "public/css/busi.css" data)]
      ["public/css/site.css" (render "public/css/site.css" data)]
      ["public/vendor/bootstrap-datetimepicker/bootstrap-datetimepicker.min.css"
       (render "public/vendor/bootstrap-datetimepicker/bootstrap-datetimepicker.min.css" data)]
      ["public/vendor/bootstrap-datetimepicker/bootstrap-datetimepicker.min.js"
       (render "public/vendor/bootstrap-datetimepicker/bootstrap-datetimepicker.min.js" data)]
      ["public/vendor/bootstrap-datetimepicker/bootstrap-datetimepicker.zh-CN.js"
       (render "public/vendor/bootstrap-datetimepicker/bootstrap-datetimepicker.zh-CN.js" data)]
      ["public/vendor/bootstrap-fileinput/fileinput.min.css" (render "public/vendor/bootstrap-fileinput/fileinput.min.css" data)]
      ["public/vendor/bootstrap-fileinput/fileinput.min.js" (render "public/vendor/bootstrap-fileinput/fileinput.min.js" data)]
      ["public/vendor/bootstrap-fileinput/zh.js" (render "public/vendor/bootstrap-fileinput/zh.js" data)]
      ["public/vendor/bootstrap-select/bootstrap-select.css" (render "public/vendor/bootstrap-select/bootstrap-select.css" data)]
      ["public/vendor/bootstrap-select/bootstrap-select.js" (render "public/vendor/bootstrap-select/bootstrap-select.js" data)]
      ["public/vendor/bootstrap-select/defaults-zh_CN.js" (render "public/vendor/bootstrap-select/defaults-zh_CN.js" data)]
      ["public/vendor/bootstrap-star-rating/star-rating.min.css" (render "public/vendor/bootstrap-star-rating/star-rating.min.css" data)]
      ["public/vendor/bootstrap-star-rating/star-rating.min.js" (render "public/vendor/bootstrap-star-rating/star-rating.min.js" data)]
      ["public/vendor/bootstrap-star-rating/zh.js" (render "public/vendor/bootstrap-star-rating/zh.js" data)]
      ["public/vendor/bootstrap-table/bootstrap-table.js" (render "public/vendor/bootstrap-table/bootstrap-table.js" data)]
      ["public/vendor/bootstrap-table/bootstrap-table.min.css" (render "public/vendor/bootstrap-table/bootstrap-table.min.css" data)]
      ["public/vendor/bootstrap-table/bootstrap-table-zh-CN.min.js" (render "public/vendor/bootstrap-table/bootstrap-table-zh-CN.min.js" data)]
      ["public/vendor/bootstrap-timepicker/bootstrap-timepicker.js" (render "public/vendor/bootstrap-timepicker/bootstrap-timepicker.js" data)]
      ["public/vendor/bootstrap-timepicker/timepicker.css" (render "public/vendor/bootstrap-timepicker/timepicker.css" data)]
      ["public/vendor/ystep/ystep.js" (render "public/vendor/ystep/ystep.js" data)]
      ["public/vendor/ystep/ystep.css" (render "public/vendor/ystep/ystep.css" data)]
      ["public/vendor/ystep/images/pointes_blue.png" (render "public/vendor/ystep/images/pointes_blue.png" data)]
      ["public/vendor/ystep/images/pointes_green.png" (render "public/vendor/ystep/images/pointes_green.png" data)]
      ["public/vendor/loading-control.js" (render "public/vendor/loading-control.js" data)]
      ["public/index.html" (render "public/index.html" data)]
      ["src/{{sanitized}}/core.cljs" (render "src/core.cljs" data)]
      ["src/{{sanitized}}/model/state.cljs" (render "src/model/state.cljs" data)]
      ["src/{{sanitized}}/routes/route.cljs" (render "src/routes/route.cljs" data)]
      ["src/{{sanitized}}/view/example.cljs" (render "src/view/example.cljs" data)]
      ["src/{{sanitized}}/view/home.cljs" (render "src/view/home.cljs" data)]
      ["env/dev/clj/user.clj" (render "env/dev/clj/user.clj" data)]
      ["env/dev/cljs/{{sanitized}}/dev.cljs" (render "env/dev/cljs/dev.cljs" data)]
      ["env/prod/cljs/{{sanitized}}/prod.cljs" (render "env/prod/cljs/prod.cljs" data)]
      ["LICENSE" (render "LICENSE" data)]
      ["README.md" (render "README.md" data)]
      [".gitignore" (render "gitignore" data)])))

(defn wisui [name]
  (main/info "Generating fresh 'lein new' wisui project.")
  (generate name))
