(ns leiningen.new.with-gorilla
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "with-gorilla"))

(defn with-gorilla
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["project.clj" (render "project.clj" data)]
["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)]
["src/{{sanitized}}/core.clj" (render "core.clj" data)]
)))