/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.bukkitlib.gui.implementation;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.function.BiConsumer;
import lombok.NonNull;
import net.suuft.bukkitlib.gui.EveryInventory;
import net.suuft.bukkitlib.gui.GuiItem;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public abstract class SimpleGui
implements EveryInventory {
    protected final Player viewer;
    private final String title;
    private final int rows;
    private final TIntObjectMap<GuiItem> slotItemMap = new TIntObjectHashMap();

    protected void setItem(int slot, @NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        this.slotItemMap.put(slot - 1, (Object)new GuiItem(itemStack));
    }

    protected void setItem(int slot, @NonNull ItemStack itemStack, @NonNull BiConsumer<Player, InventoryClickEvent> action) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.slotItemMap.put(slot - 1, (Object)new GuiItem(itemStack, action));
    }

    @Override
    public void open() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this.viewer, (int)(this.rows * 9), (String)this.title);
        this.slotItemMap.forEachEntry((slot, item) -> {
            inventory.setItem(slot, item.getStack());
            return true;
        });
        this.viewer.openInventory(inventory);
    }

    @Override
    public GuiItem getItem(int slot) {
        return (GuiItem)this.slotItemMap.get(slot);
    }

    @Override
    public int getSize() {
        return this.rows * 9;
    }

    @Override
    public Player getViewer() {
        return this.viewer;
    }

    public String getTitle() {
        return this.title;
    }

    public int getRows() {
        return this.rows;
    }

    public TIntObjectMap<GuiItem> getSlotItemMap() {
        return this.slotItemMap;
    }

    public SimpleGui(Player viewer, String title, int rows) {
        this.viewer = viewer;
        this.title = title;
        this.rows = rows;
    }
}

